/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts;

import com.alibaba.fastjson.JSON;
import com.github.abel533.echarts.Option;
import com.kingdee.bos.ctrl.common.util.FileUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.ResovlerHelper;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.color.ColorTemplateEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKds;
import com.kingdee.bos.ctrl.kds.io.kds.KDSBinaryBook;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.BrowserType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.IPageReady;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.util.ChartUtil;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChartDisplayPanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.JSEditorDialog;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsRenderType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.function.IChartReadyFunction;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.function.IEChartsClickEventHandler;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.handler.EChartHyperLinkHandler;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.node.CustomJSNodeList;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.node.JSNodeFunction;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferMapper;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.ChartImageUtil;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.util.backport.concurrent.CountDownLatch;
import com.kingdee.bos.util.backport.concurrent.TimeUnit;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.application.Platform;
import javax.imageio.ImageIO;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import netscape.javascript.JSObject;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class EChart
extends ChartRectEmbedment
implements INativeEmbedment {
    private KDPanel container;
    private EChartDisplayPanel displayPanel;
    private String xml;
    private boolean save4Snap = false;
    private CustomJSNodeList jsNodeList = new CustomJSNodeList();
    public static boolean DEBUGMODE = Boolean.parseBoolean(System.getProperty("EChartDebugMode", "false"));
    public static boolean DEMOPICMODE = Boolean.parseBoolean(System.getProperty("ext.chart.demopic.mode", "false"));
    private EChart main_echart;
    public static EChart CURRENT_ECHART;
    private Rectangle lastBounds = this.getBounds();
    private String lastExecutedScript;
    private boolean isTransitionChart;
    private EChartFunctionInitializer readyFunctionInitor = new EChartFunctionInitializer();
    private Area focusArea;
    private Rectangle transfRect;
    public static Rectangle transitionBounds;
    private Object[] splitArray;
    private EChart src;
    private static final long WAITCHARTINITED_TIME = 4000L;

    public EChart(Sheet sheet) {
        this(sheet, null, null);
    }

    public EChart(Sheet sheet, FlashChartModel model) {
        this(sheet, model, null);
    }

    public EChart(Sheet sheet, FlashChartModel m, IChartReadyFunction f) {
        super(sheet);
        this.model = m;
        this.readyFunctionInitor.addReadyFunction(f);
    }

    public static synchronized void setCurrentEChart(EChart e) {
        CURRENT_ECHART = e;
    }

    public void initFunctions(IExecutePanel browser) {
        if (!MiscUtil.isExecutedBook(this._sheet.getBook())) {
            this.displayPanel.getNativeComponent().addMouseListener(new EChartRightMouseClickListener());
        } else {
            this.displayPanel.registerClickHandler(new EChartHyperLinkHandler(ResovlerHelper.getCurrentEchartSpreadContext(this)));
        }
    }

    @Override
    public Component getPhysicalUI() {
        if (this.container == null) {
            this.container = new KDPanel((LayoutManager)new BorderLayout());
            if (!SwingUtilities.isEventDispatchThread()) {
                Runnable t = new Runnable(){

                    @Override
                    public void run() {
                        if (null == EChart.this.displayPanel) {
                            EChart.this.addDisplayPanel();
                        }
                    }
                };
                SwingUtilities.invokeLater(t);
            } else if (null == this.displayPanel) {
                this.addDisplayPanel();
            }
        }
        return this.container;
    }

    public void resize(int width, int height) {
        this.displayPanel.chartResize(width, height);
    }

    public void addDisplayPanel() {
        EChartDisplayPanel.EChartDisPlayPanelBuidler builder = EChartDisplayPanel.getBuidler();
        this.displayPanel = builder.browserType(BrowserType.WEBVIEW).charReadyFunction(this.readyFunctionInitor).renderType(EChartsRenderType.SVG).panelDebug(DEBUGMODE).pageMode(false).build();
        this.container.add((Component)this.displayPanel.getDisplayPanel(), (Object)"Center");
    }

    @Override
    public void setUIPhysical(boolean physical) {
    }

    @Override
    public void paintData(Graphics g) {
        if (this.displayPanel == null) {
            return;
        }
        Color old = g.getColor();
        g.setColor(Color.LIGHT_GRAY);
        g.setColor(old);
        Rectangle bounds = this.getBounds();
        AbstractFusionBean bean = this.model.getBean();
        FusionChartDataNode dataNode = this.model.getDataNode();
        bean.setContainerWidth(bounds.width, dataNode);
        bean.setContainerHeight(bounds.height, dataNode);
        if (!this.displayPanel.isChartInited()) {
            return;
        }
        List<String> script = TransferMapper.transfer2ExecuteScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook()));
        String lastScript = this.getStr(script);
        if (!script.isEmpty() && !lastScript.equals(this.lastExecutedScript)) {
            this.lastExecutedScript = lastScript;
            this.execute(script);
        }
    }

    @Override
    public void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        int x = (int)((RectangularShape)bounds).getX();
        int y = (int)((RectangularShape)bounds).getY();
        int w = (int)((RectangularShape)bounds).getWidth();
        int h = (int)((RectangularShape)bounds).getHeight();
        int outArc = 12;
        int innerArc = 18;
        int distance = 6;
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double();
        ((RoundRectangle2D)rr).setRoundRect(x - distance, y - distance, w + 2 * distance, h + 2 * distance, w > outArc * 2 ? (double)outArc : (double)(w / 2), h > outArc * 2 ? (double)outArc : (double)(h / 2));
        RoundRectangle2D.Double innerRR = new RoundRectangle2D.Double();
        ((RoundRectangle2D)innerRR).setRoundRect(x, y, w, h, w > innerArc * 2 ? (double)innerArc : (double)(w / 2), h > innerArc * 2 ? (double)innerArc : (double)(h / 2));
        Graphics2D g2dd = (Graphics2D)g2d.create();
        this.focusArea = new Area(rr);
        this.focusArea.subtract(new Area(innerRR));
        g2dd.setColor(Color.gray);
        g2dd.draw(rr);
        Composite cps = g2d.getComposite();
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g2dd.setColor(Color.cyan);
        g2dd.fill(this.focusArea);
        g2dd.setComposite(cps);
        this.paintTransformButton(g2dd, rr);
        this.paintHotSpot(g2dd, distance, x, y, w, h);
    }

    public Area getFocusArea() {
        return this.focusArea;
    }

    private void paintHotSpot(Graphics2D g2dd, int distance, int x, int y, int w, int h) {
        g2dd.setColor(Color.black);
        int ptDistance = distance / 2;
        int ptx = x - ptDistance;
        int pty = y - ptDistance;
        int ptx2 = x + w - 1 + ptDistance;
        int pty2 = y + h - 1 + ptDistance;
        g2dd.drawOval(ptx, pty, 1, 1);
        g2dd.drawOval(ptx + ++ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx, pty + ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
        g2dd.drawOval(ptx2, pty2, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx2, pty2 - ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2, 1, 1);
        g2dd.drawOval(ptx + ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
    }

    public Rectangle getTransformRect() {
        return this.transfRect;
    }

    public void execute(Option p, boolean refresh) {
        if (null == p) {
            return;
        }
        this.displayPanel.execute(p, refresh);
    }

    private void execute(List<String> script) {
        for (String s : script) {
            this.execute(s);
        }
    }

    @Override
    public void execute(String script) {
        this.imageData = null;
        this.displayPanel.execute(script);
    }

    private void paintTransformButton(Graphics2D g2dd, RoundRectangle2D rr) {
        EmbedhLayer layer = this.model.getDataNode().getSheet().getEmbedments(false);
        if (layer != null && layer.selectionSize() > 1) {
            return;
        }
        if (!MiscUtil.isExecutedBook(this.model.getDataNode().getSheet().getBook()) || StringUtil.isEmptyString((String)this.model.getBean().getTransformable_chart())) {
            return;
        }
        int x = (int)rr.getX();
        int y = (int)rr.getY();
        this.transfRect = new Rectangle(x, y - 20, 80, 20);
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g2dd.fillRect(this.transfRect.x, this.transfRect.y, this.transfRect.width, this.transfRect.height);
        g2dd.setColor(Color.black);
        g2dd.setFont(new Font(null, 0, 12));
        g2dd.drawString("\u5207\u6362\u56fe\u8868", x + 10, y - 6);
        int centerX = x + 70;
        int startY = y - 13;
        Polygon triangle = new Polygon();
        triangle.addPoint(centerX - 5, startY);
        triangle.addPoint(centerX + 5, startY);
        triangle.addPoint(centerX, startY + 5);
        g2dd.fill(triangle);
    }

    public boolean executeAndWait(long time, TimeUnit unit) {
        CountDownLatch latch = new CountDownLatch(1);
        this.executeRefresh();
        Platform.runLater(() -> this.exportToBufferedImage());
        Platform.runLater(() -> latch.countDown());
        try {
            return latch.await(time, unit);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    protected void loadCustom(byte[] str) {
        try {
            byte id;
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            this.model = new FlashChartModel();
            FusionChartDataNode data = new FusionChartDataNode(this._sheet);
            this.model.setDataNode(data);
            is.readString();
            FusionChartDataNode dn = this.model.getDataNode();
            block33: while ((id = is.readByte()) != 0) {
                switch (id) {
                    case 1: {
                        FlashChartType type = FlashChartType.getChartType(is.readString());
                        this.model.setChartType(type);
                        this.model.setBean(AbstractFusionBean.createBean(type));
                        this.model.getBean().setChartType(type);
                        this.model.getBean().setContainerWidth(this.getBounds().width, this.model.getDataNode());
                        this.model.getBean().setContainerHeight(this.getBounds().height, this.model.getDataNode());
                        dn.setChartType(this.model.getChartType());
                        continue block33;
                    }
                    case 2: {
                        dn.setDataFormula(is.readString());
                        continue block33;
                    }
                    case 3: {
                        dn.setGroupFormula(is.readString());
                        continue block33;
                    }
                    case 16: {
                        FusionChartDataNode data2 = this.model.getDataNode();
                        data2.setSeriesKeysFormula(is.readString());
                        continue block33;
                    }
                    case 5: {
                        dn.setChartTitleFormula(is.readString());
                        continue block33;
                    }
                    case 6: {
                        dn.setCategoryAxisTitleFormula(is.readString());
                        continue block33;
                    }
                    case 7: {
                        dn.setValueAxisTitleFormula(is.readString());
                        continue block33;
                    }
                    case 8: {
                        dn.setAngle(is.readInt());
                        continue block33;
                    }
                    case 9: {
                        dn.setSerialByCol(is.readBoolean());
                        continue block33;
                    }
                    case 11: {
                        dn.setDateFormat(is.readBoolean());
                        continue block33;
                    }
                    case 10: {
                        byte next = is.readByte();
                        dn.setExprTag(is.readLong());
                        next = is.readByte();
                        int i = 0;
                        while (next != 10) {
                            switch (next) {
                                case 12: {
                                    dn.setFormula(is.readString(), i++);
                                    break;
                                }
                                case 13: {
                                    String[] datas = this.readArray(is, is.readInt());
                                    AbstractChartPanel.repairUnSafeChar(datas);
                                    dn.setFormula(datas, i++);
                                    break;
                                }
                                case 14: {
                                    dn.setFormula((String)null, i++);
                                    break;
                                }
                            }
                            next = is.readByte();
                        }
                        continue block33;
                    }
                    case 17: {
                        this.xml = is.readString();
                        if (StringUtil.isEmptyString((String)this.xml)) continue block33;
                        this.save4Snap = true;
                        continue block33;
                    }
                    case 18: {
                        this.save4Snap = is.readBoolean();
                        continue block33;
                    }
                    case 19: {
                        String xml = is.readString();
                        if (ColorTemplateEditor.getBussinessSteadyTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getElegantFacialTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getNobleElegantTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getPureSimpleTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getSystemFusionchartsTemplate().equalsIgnoreCase(xml) || ColorTemplateEditor.getSystemTemplate().equalsIgnoreCase(xml)) {
                            dn.setColorXML(ColorTemplateEditor.getSystemSchemeDefault());
                        } else {
                            dn.setColorXML(xml);
                        }
                        this.model.getBean().getChartColorTemplate().setXmlValue(dn.getColorXML());
                        continue block33;
                    }
                    case 20: {
                        dn.setNumberFormatXML(is.readString());
                        this.model.getBean().getChartNumberFormat().setXmlValue(dn.getNumberFormatXML());
                        continue block33;
                    }
                    case 21: {
                        dn.setXyRestrictionXML(is.readString());
                        continue block33;
                    }
                    case 22: {
                        this.model.getBean().setLastSelectedIndex(is.readInt());
                        continue block33;
                    }
                    case 23: {
                        this.model.getBean().setTransformable_chart(is.readString());
                        continue block33;
                    }
                    case 24: {
                        String dataFrom = is.readString();
                        this.model.setDataFrom(dataFrom);
                        dn.setDataFrom(dataFrom);
                        if (!"dataset".equals(dataFrom)) continue block33;
                        try {
                            Element element = XmlUtil.loadXmlBytes((byte[])is.readLengthBytes());
                            dn.setFromDataset(ChartUtil.parseXml(element, this.model.getChartType()));
                        }
                        catch (JDOMException e) {
                            if (!MiscUtil.shouldLog()) continue block33;
                            MiscUtil.log(e);
                        }
                        continue block33;
                    }
                    case 25: {
                        ETTargets targets = KDSBinaryBook.readTransitionTarget(is, this._sheet, dn, -1);
                        this.model.setExtTargets(targets);
                        continue block33;
                    }
                    case 26: {
                        InnerLinkTargets innerTargets = KDSBinaryBook.readInnerTransitionTarget(is, this._sheet, dn);
                        this.model.setInnerTargets(innerTargets);
                        continue block33;
                    }
                    case 27: {
                        this.jsNodeList = (CustomJSNodeList)JSON.parseObject((String)is.readString(), CustomJSNodeList.class);
                        continue block33;
                    }
                }
            }
            is.close();
            this.model.getBean().setChartName(this.getName());
            this.model.setFrameWorkType(ChartFrameWorkType.ECHART);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            FusionChartDataNode dn;
            out.writeString("1.1");
            String str = this.model.getChartType().getName();
            if (!StringUtil.isEmptyString((String)str)) {
                out.writeByte(1);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = (dn = this.model.getDataNode()).getDataFormula()))) {
                out.writeByte(2);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getGroupFormula()))) {
                out.writeByte(3);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getDataNode().getSeriesKeysFormula()))) {
                out.writeByte(16);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getChartTitleFormula()))) {
                out.writeByte(5);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getCategoryAxisTitleFormula()))) {
                out.writeByte(6);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getValueAxisTitleFormula()))) {
                out.writeByte(7);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = this.model.getBean().getTransformable_chart()))) {
                out.writeByte(23);
                out.writeString(str);
            }
            if (null != this.jsNodeList && !this.jsNodeList.getJsList().isEmpty()) {
                out.writeByte(27);
                out.writeString(JSON.toJSONString((Object)this.jsNodeList));
            }
            out.writeByte(11);
            out.writeBoolean(dn.getDateFormat());
            out.writeByte(19);
            out.writeString(dn.getColorXML());
            out.writeByte(20);
            out.writeString(dn.getNumberFormatXML());
            out.writeByte(21);
            out.writeString(dn.getXyRestrictionXML());
            out.writeByte(22);
            out.writeInt(this.model.getBean().getLastSelectedIndex());
            out.writeByte(10);
            out.writeByte(15);
            out.writeLong(dn.getExprTag());
            int size = dn.getFormulaSize();
            for (int i = 0; i < size; ++i) {
                Object formulas = dn.getFormula(i);
                if (formulas instanceof String) {
                    out.writeByte(12);
                    out.writeString((String)formulas);
                    continue;
                }
                if (formulas instanceof String[]) {
                    out.writeByte(13);
                    this.writeArray(out, (String[])formulas);
                    continue;
                }
                if (formulas != null) continue;
                out.writeByte(14);
            }
            out.writeByte(10);
            out.writeByte(17);
            if (this.save4Snap) {
                this.xml = FlashChartModel.removeLinkProp(this.xml);
            }
            out.writeString(this.xml);
            out.writeByte(18);
            out.writeBoolean(this.save4Snap);
            out.writeByte(8);
            out.writeInt(dn.getAngle());
            out.writeByte(9);
            out.writeBoolean(dn.isSerialByCol());
            DataFromDataset fromDataset = dn.getFromDataset();
            if (fromDataset != null) {
                out.writeByte(24);
                out.writeString(this.model.getDataFrom());
                if ("dataset".equals(this.model.getDataFrom())) {
                    Element element = ChartUtil.toXml(fromDataset, this.model.getChartType());
                    byte[] xmlByte = XmlUtil.saveXmlBytes((Element)element);
                    out.writeLengthBytes(xmlByte);
                }
            }
            ExprContext ctx = this._sheet.getDeps().getExprContext();
            ETTargets targets = this.model.getExtTargets();
            BookToKds.writeTransitionTarget((byte)25, targets, out, ctx, dn);
            InnerLinkTargets innerTargets = this.model.getInnerTargets();
            BookToKds.writeInnerTransitionTarget((byte)26, innerTargets, out, ctx, dn);
            out.writeByte(0);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bs.toByteArray();
    }

    private String[] readArray(KDSDataInputStream in, int len) throws IOException {
        String[] arr = new String[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = in.readString();
        }
        return arr;
    }

    private void writeArray(KDSDataOutputStream out, String[] arr) throws IOException {
        if (arr == null) {
            out.writeInt(0);
            return;
        }
        int len = arr.length;
        out.writeInt(len);
        for (int i = 0; i < len; ++i) {
            out.writeString(arr[i]);
        }
    }

    @Override
    public boolean setBounds(int x, int y, int w, int h, boolean updateAnchor) {
        EChart.transitionBounds.x = x;
        EChart.transitionBounds.y = y;
        EChart.transitionBounds.width = w;
        EChart.transitionBounds.height = h;
        if (this.splitArray != null) {
            int len = this.splitArray.length / 2;
            for (int i = 0; i < len; ++i) {
                if (this.splitArray[i * 2] == null || this.splitArray[2 * i + 1] == null) continue;
                ((EChart)this.splitArray[2 * i + 1]).setBounds(x, y, w, h, updateAnchor);
                ((EChart)this.splitArray[2 * i + 1]).getPhysicalUI().setBounds(x, y, w, h);
                ((SpreadView)this.splitArray[i * 2]).revalidate();
                ((SpreadView)this.splitArray[i * 2]).doLayout();
            }
        }
        return super.setBounds(x, y, w, h, updateAnchor);
    }

    @Override
    public void split(final SpreadView[] splitViews, final SpreadContext.PhysicalEmbedXListener listener) {
        if (splitViews == null || this.splitArray != null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int len = splitViews.length;
                if (EChart.this.splitArray == null || EChart.this.splitArray.length == 0) {
                    EChart.access$302(EChart.this, new Object[2 * len]);
                }
                Rectangle bounds = EChart.this.getBounds();
                for (int i = 0; i < len; ++i) {
                    EChart newChart = new EChart(EChart.this.getSheet(), EChart.this.getModel());
                    newChart.main_echart = EChart.this;
                    newChart.setBounds(bounds);
                    Component physicUI = newChart.getPhysicalUI();
                    physicUI.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                    if (splitViews[i] == null) continue;
                    splitViews[i].add(physicUI);
                    splitViews[i].revalidate();
                    if (null != listener) {
                        newChart.getNativeComponent().addMouseListener(listener);
                        newChart.getNativeComponent().addKeyListener(listener);
                    }
                    newChart.lastBounds = bounds;
                    ((EChart)EChart.this).splitArray[i * 2] = splitViews[i];
                    ((EChart)EChart.this).splitArray[i * 2 + 1] = newChart;
                }
            }
        });
    }

    @Override
    public void merge() {
        if (this.splitArray == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int len = EChart.this.splitArray.length / 2;
                for (int i = 0; i < len; ++i) {
                    if (EChart.this.splitArray[i * 2] == null || EChart.this.splitArray[i * 2 + 1] == null) continue;
                    ((SpreadView)EChart.this.splitArray[i * 2]).remove(((EChart)EChart.this.splitArray[i * 2 + 1]).getPhysicalUI());
                    ((SpreadView)EChart.this.splitArray[i * 2]).revalidate();
                    ((SpreadView)EChart.this.splitArray[i * 2]).repaint();
                }
                EChart.access$302(EChart.this, null);
            }
        });
    }

    @Override
    public Component getNativeComponent() {
        return this.displayPanel.getNativeComponent();
    }

    @Override
    public void executeRefresh() {
        this.model.getDataNode().setDirty(true);
        List<String> script = TransferMapper.transfer2ExecuteScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook()));
        this.execute(script);
        this.lastExecutedScript = this.getStr(script);
    }

    private String getStr(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s).append("//--\n");
        }
        return sb.toString();
    }

    @Override
    public BufferedImage exportToBufferedImage() {
        if (this.imageData != null) {
            return this.imageData;
        }
        try {
            for (int count = 0; !this.displayPanel.isChartFinished() || count < 1; ++count) {
                Thread.sleep(4000L);
            }
            Rectangle rect = this.getNativeComponent().getBounds();
            this.imageData = new BufferedImage(rect.width, rect.height, 2);
            Graphics g = this.imageData.getGraphics();
            this.getNativeComponent().paint(g);
            if (this.src != null) {
                this.src.setCachedImg(this.imageData);
            }
            return this.imageData;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return this.getErrorImage();
        }
    }

    public BufferedImage getErrorImage() {
        BufferedImage ret = ChartImageUtil.getErrorImage();
        if (ret != null) {
            Rectangle rect = this.getBounds();
            this.setBounds(rect.x, rect.y, ret.getWidth(), ret.getHeight());
        }
        return ret;
    }

    public void setSrc(EChart c) {
        this.src = c;
    }

    public void setTransitionChart(boolean isTransitionChart) {
        this.isTransitionChart = isTransitionChart;
    }

    public boolean isTransitionChart() {
        return this.isTransitionChart;
    }

    public void enableExport4Snap() {
        if (this.save4Snap) {
            return;
        }
        this.save4Snap = true;
        this.model.getDataNode().setDirty(true);
    }

    public EChartDisplayPanel getDisplayPanel() {
        return this.displayPanel;
    }

    public void registerClickHandler(IEChartsClickEventHandler handler) {
        this.displayPanel.registerClickHandler(handler);
    }

    public void removeClickHandler(IEChartsClickEventHandler handler) {
        this.displayPanel.removeClickHandler(handler);
    }

    public String getLastExecutedScript() {
        if (StringUtil.isEmptyString((String)this.lastExecutedScript)) {
            return this.getStr(TransferMapper.transfer2ExecuteScript(this.model, !MiscUtil.isExecutedBook(this._sheet.getBook())));
        }
        return this.lastExecutedScript;
    }

    @Override
    public void destory() {
        if (null != this.displayPanel) {
            this.displayPanel.close();
        }
    }

    static /* synthetic */ Object[] access$302(EChart x0, Object[] x1) {
        x0.splitArray = x1;
        return x1;
    }

    static {
        transitionBounds = new Rectangle();
    }

    private class EChartRightMouseClickListener
    extends MouseAdapter {
        private KDPopupMenu popMenu = new KDPopupMenu();

        public EChartRightMouseClickListener() {
            KDMenuItem menuItem = new KDMenuItem("\u8bbe\u7f6e\u56fe\u8868\u5c5e\u6027");
            menuItem.addActionListener(e -> {
                SpreadContext context = ResovlerHelper.getCurrentEchartSpreadContext(EChart.this);
                ResovlerHelper.showStepWizzard(context, EChart.this, "chartSettings");
            });
            this.popMenu.add((JMenuItem)menuItem);
            if (DEBUGMODE) {
                KDMenuItem jsItem = new KDMenuItem("\u8bbe\u7f6e\u6269\u5c55JS");
                jsItem.addActionListener(e -> {
                    KDDialog d = this.createJSEditorDialog(ResovlerHelper.getCurrentEchartSpreadContext(EChart.this));
                    d.show();
                });
                this.popMenu.add((JMenuItem)jsItem);
            }
            if (DEMOPICMODE) {
                KDMenuItem picItem = new KDMenuItem("\u53e6\u5b58\u4e3a\u56fe\u7247");
                picItem.addActionListener(e -> {
                    EChart.this.executeAndWait(10L, TimeUnit.SECONDS);
                    KDFileChooser chooser = new KDFileChooser();
                    Window w = SwingUtilities.getWindowAncestor((Component)((Object)ResovlerHelper.getCurrentEchartSpreadContext(EChart.this)));
                    chooser.setSelectedFile(new File(EChart.this.getModel().getChartType().getAlias() + ".png"));
                    int option = chooser.showSaveDialog((Component)w);
                    if (option == 0) {
                        File f = chooser.getSelectedFile();
                        try {
                            String path = f.getCanonicalPath();
                            if (!path.toLowerCase(Locale.CHINA).endsWith(".png")) {
                                path = path + ".png";
                            }
                            f = FileUtil.createFile((String)path);
                            this.saveImageToFile(f);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                this.popMenu.add((JMenuItem)picItem);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3 && !this.popMenu.isVisible()) {
                this.showMenu(e.getX(), e.getY());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean saveImageToFile(File f) {
            BufferedImage image = EChart.this.exportToBufferedImage();
            FileOutputStream fos = null;
            boolean flag = false;
            try {
                fos = new FileOutputStream(f);
                flag = ImageIO.write((RenderedImage)image, ".png".substring(1), fos);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtil.closeCloseable(fos);
                    throw throwable;
                }
                StreamUtil.closeCloseable((Closeable)fos);
            }
            StreamUtil.closeCloseable((Closeable)fos);
            return flag;
        }

        private KDDialog createJSEditorDialog(SpreadContext context) {
            JSEditorDialog d;
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)context));
            IPageReady ready = p -> {
                JSObject window = JSUtils.getWindow(p);
                window.setMember("jsNode", new JSNodeFunction(EChart.this.jsNodeList, EChart.this.displayPanel));
                StringBuilder sb = new StringBuilder();
                if (!EChart.this.jsNodeList.getJsList().isEmpty()) {
                    EChart.this.jsNodeList.getJsList().forEach(n -> sb.append(n.getJs()));
                } else {
                    sb.append("//please write your js code here.");
                }
                String b64Encode = Base64.encodeBytes((byte[])sb.toString().getBytes(StandardCharsets.UTF_8), (boolean)false);
                p.execute(String.format("console.log('\u6267\u884c\u81ea\u5b9a\u4e49js'); var textValue = \"%s\";var b64coder = new KDBase64(); try {textValue = b64coder.decode(textValue);}catch(err){console.error(err.message);} if(editor){editor.setValue(textValue);}", b64Encode));
            };
            String title = "\u56fe\u8868JS\u811a\u672c\u7f16\u8f91";
            if (w instanceof Dialog) {
                d = new JSEditorDialog(ready, (Dialog)w, title, true);
            } else if (w instanceof Frame) {
                d = new JSEditorDialog(ready, (Frame)w, title, true);
            } else {
                d = new JSEditorDialog(ready);
                d.setModal(true);
            }
            d.setLocationRelativeTo(w);
            return d;
        }

        public void showMenu(int x, int y) {
            this.popMenu.show(EChart.this.getNativeComponent(), x, y);
        }
    }

    private class EChartFunctionInitializer
    implements IChartReadyFunction {
        private List<IChartReadyFunction> functions = new ArrayList<IChartReadyFunction>();

        private EChartFunctionInitializer() {
        }

        @Override
        public void onReady(IExecutePanel browser) {
            EChart.this.initFunctions(browser);
            EChart.setCurrentEChart(EChart.this);
            for (IChartReadyFunction f : this.functions) {
                f.onReady(browser);
            }
            EChart.this.executeRefresh();
            EChart.this.jsNodeList.getJsList().forEach(n -> EChart.this.execute(n.getJs()));
        }

        public void addReadyFunction(IChartReadyFunction f) {
            if (null != f) {
                this.functions.add(f);
            }
        }
    }
}

