/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.Axis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.Orient;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.code.X;
import com.github.abel533.echarts.code.Y;
import com.github.abel533.echarts.json.Var;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.Series;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractTransferImpl;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Array;
import java.util.List;

public abstract class ConfigurableAbstractTransferImpl<B extends AbstractFusionBean>
extends AbstractTransferImpl<B> {
    public ConfigurableAbstractTransferImpl(EChartsType type, String desc) {
        super(type, desc);
    }

    @Override
    public Option transfer2Opiton(B b, FusionChartDataNode d) {
        Option p = super.transfer2Opiton(b, d);
        Chart chart = ((AbstractFusionBean)b).getChart();
        String[] chartCaptions = ((AbstractFusionBean)b).buildChartCaptions1(d);
        this.configureBase(b, p, chart, chartCaptions);
        this.configureGridBorder(p, chartCaptions);
        this.configureLegend(p, chart);
        return p;
    }

    private void configureBase(B b, Option p, Chart chart, String[] chartCaptions) {
        p.color((Object)new Var("colors"));
        p.textStyle().fontFamily(TransferUtils.getENFontName(chart.baseFont));
        if (null != chart.baseFontSize) {
            p.textStyle().fontSize(Integer.valueOf(Integer.parseInt(chart.baseFontSize)));
        }
        p.title().left((Object)"center");
        int totalFontWidth = ((AbstractFusionBean)b).getChartWidth();
        int fontSize = chartCaptions.length >= 31 ? Integer.parseInt(chartCaptions[30]) : 24;
        int count = totalFontWidth / fontSize;
        String text = chart.caption;
        text = this.getNewlineStr(text, count);
        int subFontSize = chartCaptions.length >= 32 ? Integer.parseInt(chartCaptions[31]) : 16;
        String subText = chart.subCaption;
        int subCount = totalFontWidth / subFontSize;
        subText = this.getNewlineStr(subText, subCount);
        p.title().setText(text);
        p.title().textStyle().setFontSize(Integer.valueOf(fontSize));
        p.title().subtext(subText);
        p.title().subtextStyle().setFontSize(Integer.valueOf(subFontSize));
        p.setBackgroundColor((Object)(chartCaptions.length >= 40 ? chartCaptions[39] : TransferUtils.toCSSRGBAString(((AbstractFusionBean)b).getChart_bgColor().getColorValue())));
        p.grid().left((Object)chart.chartLeftMargin);
        p.grid().right((Object)chart.chartRightMargin);
        p.grid().top((Object)chart.chartTopMargin);
        p.grid().bottom((Object)chart.chartBottomMargin);
        if ("1".equals(chart.showLabels)) {
            p.tooltip().trigger(Trigger.item);
            p.tooltip().textStyle().fontFamily(TransferUtils.getENFontName(chart.baseFont));
            p.tooltip().textStyle().fontSize(Integer.valueOf(Integer.parseInt(chart.baseFontSize)));
        }
    }

    public String getNewlineStr(String text, int count) {
        if (!StringUtils.isEmpty((String)text)) {
            StringBuilder sb = new StringBuilder();
            int row = text.length() / count;
            for (int i = 0; i <= row; ++i) {
                if (text.length() == count || i == row) {
                    sb.append(text.substring(i * count, text.length()));
                    continue;
                }
                sb.append(text.substring(i * count, (i + 1) * count)).append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    protected void configureGridBorder(Option p, String[] chartCaptions) {
        if (chartCaptions.length >= 26 && "1".equals(chartCaptions[25])) {
            p.grid().show(Boolean.valueOf(true));
            p.grid().borderColor("rgb(0, 0, 0)");
            if (chartCaptions.length >= 27) {
                p.grid().show(Boolean.valueOf(true));
                p.grid().shadowColor("rgb(0, 0, 0)");
                p.grid().borderWidth(Integer.valueOf(Integer.parseInt(chartCaptions[26])));
            }
        }
    }

    protected void configureLegend(Option p, Chart chart) {
        if ("1".equals(chart.showLegend)) {
            p.legend();
            if ("left".equals(chart.legendPosition)) {
                p.legend().left(X.left);
                p.legend().orient(Orient.vertical);
                p.legend().y((Object)X.center);
            } else if ("right".equals(chart.legendPosition)) {
                p.legend().orient(Orient.vertical);
                p.legend().y((Object)X.center);
                p.legend().right((Object)X.right);
            } else if ("bottom".equals(chart.legendPosition)) {
                p.legend().bottom((Object)Y.bottom);
                p.legend().x(X.center);
            } else if ("top".equals(chart.legendPosition)) {
                p.legend().x(X.center);
                p.legend().top(Y.top);
            }
        }
    }

    @Override
    public String afterScript(B b, FusionChartDataNode data, Option p) {
        Chart chart = ((AbstractFusionBean)b).getChart();
        this.configureAxisFont(b, p, data);
        this.configureTooltipFormatter(data, p);
        this.configurePlotGradientColor(p, chart);
        this.configureGridColor(p, chart);
        String[] chartCaptions = ((AbstractFusionBean)b).buildChartCaptions1(data);
        this.configureNumberFormat(p, chartCaptions, data);
        this.configureBorder(p, chart);
        if (!this.checkSeriesSize(p.getSeries())) {
            throw new IllegalArgumentException(String.format("series exceed %d limits.", 50));
        }
        if (!this.checkDataSize(p.getSeries())) {
            throw new IllegalArgumentException(String.format("serie's data exceeds %d limits.", 100));
        }
        return super.afterScript(b, data, p);
    }

    protected boolean checkSeriesSize(List<Series> series) {
        if (null != series) {
            return series.size() < 50;
        }
        return true;
    }

    protected boolean checkDataSize(List<Series> series) {
        if (null != series) {
            for (Series s : series) {
                if (null == s.getData() || s.getData().size() <= 100) continue;
                return false;
            }
        }
        return true;
    }

    protected void configureBorder(Option p, Chart chart) {
        for (int i = 0; i < p.getSeries().size(); ++i) {
            Series s = (Series)p.getSeries().get(i);
            if (!"1".equals(chart.showPlotBorder)) continue;
            if (s instanceof Line && null != ((Line)s).getAreaStyle()) {
                ((Line)s).lineStyle().color((Object)"#000");
                continue;
            }
            s.itemStyle().normal().borderColor("#000");
        }
    }

    protected void configureGridColor(Option p, Chart chart) {
        if ("1".equals(chart.canvasBorderAlpha) && null != p.getGrid()) {
            p.grid().show(Boolean.valueOf(true));
            p.grid().backgroundColor("rgba(213,212,212,0.85)");
        }
    }

    protected void configurePlotGradientColor(Option p, Chart chart) {
        if ("1".equals(chart.plotGradientColor)) {
            p.color((Object)new Var("plotGradientColors"));
        }
    }

    protected void configureTooltipFormatter(FusionChartDataNode data, Option p) {
        if (null != p.getTooltip()) {
            Object formatter = p.getTooltip().formatter();
            Var f = null;
            f = null != p.getRadar() ? JSUtils.getRadarTooltipNumberFormatFunctionVar(true, formatter) : (Trigger.axis == p.getTooltip().getTrigger() ? JSUtils.getTooltipFormatterVar(true, true, true, formatter) : JSUtils.getTooltipFormatterVar(true, true, false, formatter));
            if (null != f && !StringUtil.isEmptyString((String)f.getStr())) {
                p.getTooltip().formatter((Object)f);
            }
        }
    }

    protected void configureAxisFont(B b, Option p, FusionChartDataNode data) {
        Chart chart = ((AbstractFusionBean)b).getChart();
        if (null != p.getxAxis()) {
            for (Axis s : p.getxAxis()) {
                s.axisLabel().textStyle().fontFamily(TransferUtils.getENFontName(chart.baseFont));
                s.axisLabel().textStyle().fontSize(Integer.valueOf(Integer.parseInt(chart.baseFontSize)));
            }
        }
        if (null != p.getyAxis()) {
            for (Axis s : p.getyAxis()) {
                s.axisLabel().textStyle().fontFamily(TransferUtils.getENFontName(chart.baseFont));
                s.axisLabel().textStyle().fontSize(Integer.valueOf(Integer.parseInt(chart.baseFontSize)));
            }
        }
    }

    protected void configureNumberFormat(Option p, String[] chartCaptions, FusionChartDataNode data) {
        this.setValueAxisLabelFormatter(p.getxAxis());
        this.setValueAxisLabelFormatter(p.getyAxis());
        this.setSeriesNumberFormat(p, chartCaptions);
    }

    protected void setSeriesNumberFormat(Option p, String[] chartCaptions) {
        if (TransferUtils.isShowNumber(chartCaptions) && null != p.getSeries()) {
            for (Series s : p.getSeries()) {
                Var leftFormat = null;
                Var rightFormat = null;
                if (null != s.getLabel() && null != s.getLabel().getNormal()) {
                    Object templateFormatter = s.getLabel().getNormal().formatter();
                    leftFormat = JSUtils.getSeriesNumberFormatFunctionVar(true, templateFormatter);
                    rightFormat = JSUtils.getSeriesNumberFormatFunctionVar(false, templateFormatter);
                } else {
                    leftFormat = JSUtils.getSeriesNumberFormatFunctionVar(true, null);
                    rightFormat = JSUtils.getSeriesNumberFormatFunctionVar(false, null);
                }
                this.setSeriesFormat(s, leftFormat, rightFormat);
                s.label().normal().color((Object)"#000");
            }
        }
    }

    protected void setSeriesFormat(Series<?> s, Var leftFormat, Var rightFormat) {
        if (null != s.getYAxisIndex() && 1 == s.getYAxisIndex() && !StringUtil.isEmptyString((String)rightFormat.getStr())) {
            s.label().normal().formatter((Object)rightFormat);
        } else if (!StringUtil.isEmptyString((String)leftFormat.getStr())) {
            s.label().normal().formatter((Object)leftFormat);
        }
    }

    protected void setAxisLabelDisplayMode(Option p, String type) {
        if (null != p.getxAxis() && !p.getxAxis().isEmpty()) {
            List axisList = p.getxAxis();
            if ("stagger".equals(type)) {
                TransferUtils.setAxisLabelFormatter(axisList, new String[]{"function(value, index){ if(index % 2 == 0) {return '\n' + value;} return value;}"}, AxisType.category);
                TransferUtils.setAxisLabelInterval(axisList, 0, AxisType.category);
            } else if ("rotate".equals(type)) {
                TransferUtils.setAxisLabelRotate(axisList, 45, AxisType.category);
            } else {
                TransferUtils.setAxisFormatter(axisList, "xAxisAxislabelFormatter", AxisType.category, 25);
            }
        }
        if (null != p.getyAxis() && !p.getyAxis().isEmpty()) {
            List yaxisList = p.getyAxis();
            if ("stagger".equals(type)) {
                TransferUtils.setAxisLabelFormatter(yaxisList, new String[]{"function(value, index){ if(index % 2 == 0) {return '\n' + value;} return value;}"}, AxisType.category);
                TransferUtils.setAxisLabelInterval(yaxisList, 0, AxisType.category);
            } else if ("rotate".equals(type)) {
                TransferUtils.setAxisLabelRotate(yaxisList, 45, AxisType.category);
            } else {
                TransferUtils.setAxisFormatter(yaxisList, "yAxisAxislabelFormatter", AxisType.category, 25);
            }
        }
    }

    protected void setValueAxisLabelFormatter(List<Axis> axis) {
        if (null != axis) {
            for (Axis a : axis) {
                Var f;
                if (a.getType() != AxisType.value) continue;
                Object formatter = null;
                if (null != a.getAxisLabel()) {
                    formatter = a.getAxisLabel().getFormatter();
                }
                if (StringUtil.isEmptyString((String)(f = JSUtils.getValueAxisNumberFormatFunctionVar(Position.right != a.getPosition(), formatter)).getStr())) continue;
                a.axisLabel().formatter((Object)f);
            }
        }
    }

    @Override
    public Option mockOption(B bean) {
        Option p = super.mockOption(bean);
        p.color((Object)new Var("colors"));
        return p;
    }

    public String[] getChartCaptions(FusionChartDataNode dataNode) {
        String[] chartCaptions = null;
        Object obj = dataNode.getData(FusionChartDataNode.CHART_CAPTION);
        if (obj != null) {
            int len = Array.getLength(obj);
            chartCaptions = new String[len];
            for (int i = 0; i < len; ++i) {
                Variant[][] val = (Variant[][])Array.get(obj, i);
                if (val == null) continue;
                chartCaptions[i] = val[0][0].toString();
            }
        }
        return chartCaptions;
    }
}

