/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.PictorialBar;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.column.MSColumn3DBean;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartConstants;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;

public class MSColumn3DBeanTransferImpl
extends AbstractColumnTransfer<MSColumn3DBean> {
    public MSColumn3DBeanTransferImpl() {
        super(EChartsType.BAR3D, "\u591a\u5e8f\u52173d\u67f1\u5f62\u56fe");
    }

    @Override
    public String initScript(MSColumn3DBean bean, FusionChartDataNode dataNode) {
        double[][] data = (double[][])dataNode.getData();
        return super.initScript(bean, dataNode) + this.buildColorStopsLeft(data.length);
    }

    @Override
    public Option transfer2Opiton(MSColumn3DBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        String[] labels = dataNode.getGroupKeys();
        double[][] data = (double[][])dataNode.getData();
        if (null == labels || null == data) {
            return null;
        }
        Object[] series = (String[])dataNode.getSeriesKeys();
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        ValueAxis valueAxis = new ValueAxis();
        p.yAxis().add(valueAxis);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String label : labels) {
            caxis.data().add(label);
        }
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.name((String)series[i]);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            bar.barGap("20%");
            PictorialBar p2 = new PictorialBar();
            p2.name((String)series[i]);
            p2.z(Integer.valueOf(3));
            p2.tooltip().trigger(Trigger.none);
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)(TransferUtils.calOffset(series.length, i) + "%"), (Object)"-50%");
            p2.symbolSize((Object)new String[]{TransferUtils.calSize(series.length, 20.0) + "%", "15%"});
            p2.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
            p2.setSymbolPosition((Object)"end");
            for (int j = 0; j < data[i].length; ++j) {
                bar.data().add(data[i][j]);
                p2.data().add(data[i][j]);
            }
            p.series().add(bar);
            p.series().add(p2);
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public Option mockOption(MSColumn3DBean bean) {
        return null;
    }

    @Override
    public String initMockScript(MSColumn3DBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(5) + TransferUtils.getResourceAsString(this.getClass(), "MSColumn3DBeanTransferImpl.json", EChartConstants.DEMOFILE_ENCODING);
    }

    @Override
    public String afterMockScript(MSColumn3DBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(MSColumn3DBean b, FusionChartDataNode data, Option p) {
        String script = super.afterScript(b, data, p);
        TransferUtils.rewriteYAxis(p);
        return script + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

