/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.column;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.PictorialBar;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.column.StackedColumn3DBean;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartConstants;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractStackedTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;

public class StackedColumn3DBeanTransferImpl
extends AbstractStackedTransfer<StackedColumn3DBean> {
    public StackedColumn3DBeanTransferImpl() {
        super(EChartsType.BAR3D, "\u5806\u79ef3D\u67f1\u72b6\u56fe");
    }

    @Override
    public String initScript(StackedColumn3DBean bean, FusionChartDataNode dataNode) {
        double[][] data = (double[][])dataNode.getData();
        return super.initScript(bean, dataNode) + this.buildColorStopsLeft(data.length);
    }

    @Override
    public Option transfer2Opiton(StackedColumn3DBean bean, FusionChartDataNode dataNode) {
        double[][] data = (double[][])dataNode.getData();
        if (null == this.groups || null == data) {
            return null;
        }
        Object[] series = (String[])dataNode.getSeriesKeys();
        ValueAxis valueAxis = new ValueAxis();
        Option p = super.transfer2Opiton(bean, dataNode);
        p.yAxis().add(valueAxis);
        if (null != p.getLegend()) {
            p.legend().data(series);
        }
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        double[] proportion = TransferUtils.getStackedDiamondProportion(data);
        for (int i = 0; i < data.length; ++i) {
            Bar bar = new Bar();
            bar.name((String)series[i]);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            PictorialBar p2 = new PictorialBar();
            p2.name((String)series[i]);
            p2.z(Integer.valueOf(3));
            p2.tooltip().trigger(Trigger.none);
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)0, (Object)"-50%");
            p2.itemStyle().normal().color((Object)"function(index){return colors[((index.seriesIndex + 1) / 2 -1)  % colors.length];}");
            p2.symbolSize((Object)new String[]{"100%", proportion[i] * 30.0 + "%"});
            p2.setSymbolPosition((Object)"end");
            for (int j = 0; j < data[i].length; ++j) {
                bar.stack(this.groups[j]);
                bar.data().add(data[i][j]);
                p2.data().add(TransferUtils.stackValueGroupByNeg(data, j, i, data[i][j] < 0.0));
            }
            p.series().add(bar);
            p.series().add(p2);
        }
        p.xAxis().add(caxis);
        return p;
    }

    @Override
    public String initMockScript(StackedColumn3DBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(7) + TransferUtils.getResourceAsString(this.getClass(), "StackedColumn3DBeanTransferImpl.json", EChartConstants.DEMOFILE_ENCODING);
    }

    @Override
    public Option mockOption(StackedColumn3DBean bean) {
        return null;
    }

    @Override
    public String afterMockScript(StackedColumn3DBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(StackedColumn3DBean b, FusionChartDataNode data, Option p) {
        String script = super.afterScript(b, data, p);
        return script + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

