/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.filter;

import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.model.struct.filter.ISheetFilter;
import java.util.ArrayList;

public class SheetAdvancedFilter
implements ISheetFilter {
    public static final int OP_EQUAL = 0;
    public static final int OP_NOT_EQUAL = 1;
    public static final int OP_GREATER = 2;
    public static final int OP_LESSER = 3;
    public static final int OP_GREATER_OR_EQUAL = 4;
    public static final int OP_LESSER_OR_EQUAL = 5;
    private Sheet sheet;
    public ArrayList filterItems = new ArrayList();

    public SheetAdvancedFilter(Sheet sheet) {
        this.sheet = sheet;
    }

    public void add(AdvancedFilterItem item) {
        this.filterItems.add(item);
    }

    public void remove(AdvancedFilterItem item) {
        this.filterItems.remove(item);
    }

    @Override
    public void exec() {
        Book book = this.sheet.getBook();
        CellBlock cb = this.sheet.getAdvancedFilterArea();
        if (cb == null) {
            return;
        }
        book.getUndoManager().startGroup();
        int[] securityRows = this.sheet.getSecHidedRows();
        for (int j = cb.getRow() + 1; j <= cb.getRow2(); ++j) {
            if (AlgorithmUtil.contain(securityRows, j)) continue;
            boolean shouldShow = true;
            for (int i = 0; i < this.filterItems.size(); ++i) {
                if (((AdvancedFilterItem)this.filterItems.get(i)).exec(j)) continue;
                shouldShow = false;
                break;
            }
            if (!shouldShow) continue;
            this.sheet.getRowRange(j, j).setHidden(false, true);
        }
        book.getUndoManager().endGroup();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.filterItems.size(); ++i) {
            sb.append(this.filterItems.get(i).toString() + " ");
        }
        return sb.toString();
    }

    public ArrayList getFilterItems() {
        return this.filterItems;
    }

    public class AdvancedFilterItem {
        private Variant value;
        private int operator;
        private int colIndex;

        public AdvancedFilterItem(Variant value, int operator, int colIndex) {
            this.value = value;
            this.operator = operator;
            this.colIndex = colIndex;
        }

        public boolean exec(int rowIndex) {
            Cell cell = SheetAdvancedFilter.this.sheet.getCell(rowIndex, this.colIndex, false);
            if (cell == null) {
                return false;
            }
            Variant cellValue = cell.getValue();
            try {
                switch (this.operator) {
                    case 1: {
                        if (cellValue.compareTo(this.value) == 0) {
                            return false;
                        }
                        break;
                    }
                    case 2: {
                        if (cellValue.compareTo(this.value) <= 0) {
                            return false;
                        }
                        break;
                    }
                    case 3: {
                        if (cellValue.compareTo(this.value) >= 0) {
                            return false;
                        }
                        break;
                    }
                    case 4: {
                        if (cellValue.compareTo(this.value) < 0) {
                            return false;
                        }
                        break;
                    }
                    case 5: {
                        if (cellValue.compareTo(this.value) > 0) {
                            return false;
                        }
                        break;
                    }
                    default: {
                        if (cellValue.compareTo(this.value) != 0) {
                            return false;
                        }
                    }
                }
            }
            catch (SyntaxErrorException e) {
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            switch (this.operator) {
                case 1: {
                    sb.append("OP_NOT_EQUAL");
                    break;
                }
                case 2: {
                    sb.append("OP_GREATER");
                    break;
                }
                case 3: {
                    sb.append("OP_LESSER");
                    break;
                }
                case 4: {
                    sb.append("OP_GREATER_OR_EQUAL");
                    break;
                }
                case 5: {
                    sb.append("OP_LESSER_OR_EQUAL");
                    break;
                }
                default: {
                    sb.append("OP_EQUAL");
                }
            }
            sb.append(" ");
            sb.append(this.value);
            sb.append("]");
            return sb.toString();
        }

        public Variant getValue() {
            return this.value;
        }

        public int getOperator() {
            return this.operator;
        }

        public int getColIndex() {
            return this.colIndex;
        }
    }
}

