/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.filter;

import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AutoFilterConstants;
import com.kingdee.bos.ctrl.kds.model.struct.filter.CellValueModel;
import com.kingdee.bos.ctrl.kds.model.struct.filter.ISheetAutoFilter;
import com.kingdee.bos.ctrl.kds.model.struct.filter.SheetCustomAutoFilter;
import java.util.Calendar;
import java.util.Date;

public class SheetDynamicAutoFilter
extends SheetCustomAutoFilter {
    private byte type;

    public SheetDynamicAutoFilter(Sheet sheet, int colIndex, byte type) {
        super(sheet, colIndex);
        this.type = type;
    }

    @Override
    public ISheetAutoFilter changedColIndex(int colIndex) {
        return new SheetDynamicAutoFilter(this.sheet, colIndex, this.type);
    }

    @Override
    protected void beforeDoFilter() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if (AutoFilterConstants.CUSTOM_TYPE_ABove_Average == this.type || AutoFilterConstants.CUSTOM_TYPE_Below_Average == this.type) {
            this.operator1 = AutoFilterConstants.CUSTOM_TYPE_ABove_Average == this.type ? AutoFilterConstants.O_GREATER_THAN : AutoFilterConstants.O_LESS_THAN;
            this.link = 1;
            int n = 0;
            Variant sum = new Variant();
            sum.setVariant(Variant.zeroVariant);
            CellBlock cb = this.sheet.getAutoFilterArea();
            for (int i = cb.getRow() + 1; i <= cb.getRow2(); ++i) {
                Cell cell = this.sheet.getCell(i, this.colIndex, false);
                int vt = SheetBaseMath.getCellValueType(cell);
                if (vt != SheetBaseMath.DataType_Number) continue;
                try {
                    sum.add(cell.getValue());
                    ++n;
                    continue;
                }
                catch (SyntaxErrorException syntaxErrorException) {
                    // empty catch block
                }
            }
            if (n == 0) {
                this.value1 = "";
            } else {
                try {
                    this.value1 = sum.doubleValue() / (double)n + "";
                }
                catch (SyntaxErrorException e) {
                    this.value1 = "";
                }
            }
        } else if (AutoFilterConstants.CUSTOM_TYPE_MONTH_1 <= this.type && AutoFilterConstants.CUSTOM_TYPE_MONTH_12 >= this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_EQUAL;
            this.value1 = this.type - AutoFilterConstants.CUSTOM_TYPE_MONTH_1 + 1 + "";
        } else if (AutoFilterConstants.CUSTOM_TYPE_SEASON_1 <= this.type && AutoFilterConstants.CUSTOM_TYPE_SEASON_4 >= this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_EQUAL;
            this.value1 = this.type - AutoFilterConstants.CUSTOM_TYPE_SEASON_1 + 1 + "";
        } else if (AutoFilterConstants.CUSTOM_TYPE_LAST_DAY == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            int DD = calendar.get(5);
            calendar.clear();
            calendar.set(YY, MM, DD);
            calendar.add(5, -1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(5, 1);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_THIS_DAY == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            int DD = calendar.get(5);
            calendar.clear();
            calendar.set(YY, MM, DD);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(5, 1);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_NEXT_DAY == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            int DD = calendar.get(5);
            calendar.clear();
            calendar.set(YY, MM, DD);
            calendar.add(5, 1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(5, 1);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_LAST_WEEK == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            int DD = calendar.get(5);
            int WW = calendar.get(7);
            calendar.clear();
            calendar.set(YY, MM, DD);
            calendar.add(5, -7 - WW + 1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(5, 7);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_THIS_WEEK == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            int DD = calendar.get(5);
            int WW = calendar.get(7);
            calendar.clear();
            calendar.set(YY, MM, DD);
            calendar.add(5, -WW + 1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(5, 7);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_NEXT_WEEK == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            int DD = calendar.get(5);
            int WW = calendar.get(7);
            calendar.clear();
            calendar.set(YY, MM, DD);
            calendar.add(5, -WW + 1 + 7);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(5, 7);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_LAST_MONTH == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            calendar.clear();
            calendar.set(YY, MM, 1);
            calendar.add(2, -1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(2, 1);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_THIS_MONTH == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            calendar.clear();
            calendar.set(YY, MM, 1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(2, 1);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_NEXT_MONTH == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            calendar.clear();
            calendar.set(YY, MM, 1);
            calendar.add(2, 1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(2, 1);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_LAST_SEASON == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            int Season = MM / 3 + 1;
            calendar.clear();
            calendar.set(YY, (Season - 1) * 3, 1);
            calendar.add(2, -3);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(2, 3);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_THIS_SEASON == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            int Season = MM / 3 + 1;
            calendar.clear();
            calendar.set(YY, (Season - 1) * 3, 1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(2, 3);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_NEXT_SEASON == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            int MM = calendar.get(2);
            int Season = MM / 3 + 1;
            calendar.clear();
            calendar.set(YY, (Season - 1) * 3, 1);
            calendar.add(2, 3);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(2, 3);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_LAST_YEAR == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            calendar.clear();
            calendar.set(YY, 0, 1);
            calendar.add(1, -1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(1, 1);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_THIS_YEAR == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            calendar.clear();
            calendar.set(YY, 0, 1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(1, 1);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_NEXT_YEAR == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN;
            int YY = calendar.get(1);
            calendar.clear();
            calendar.set(YY, 0, 1);
            calendar.add(1, 1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.add(1, 1);
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        } else if (AutoFilterConstants.CUSTOM_TYPE_THIS_YEAR_TO_NOW == this.type) {
            this.link = 1;
            this.operator1 = AutoFilterConstants.O_GREATER_THAN_OR_EQUAL;
            this.operator2 = AutoFilterConstants.O_LESS_THAN_OR_EQUAL;
            int YY = calendar.get(1);
            calendar.clear();
            calendar.set(YY, 0, 1);
            this.value1 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
            calendar.clear();
            calendar.setTime(new Date());
            this.value2 = AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(calendar.getTime());
        }
        super.beforeDoFilter();
    }

    @Override
    protected CellValueModel preValue(Cell cell) {
        Variant value;
        String text = null;
        if (cell == null || cell.isEmptyContent2()) {
            value = Variant.emptyVariant;
            text = "";
        } else if (this.type >= AutoFilterConstants.CUSTOM_TYPE_MONTH_1 && this.type <= AutoFilterConstants.CUSTOM_TYPE_MONTH_12) {
            value = cell.getValue();
            if (value.isDate()) {
                Object oValue = value.getValue();
                Date date = null;
                if (oValue instanceof Date) {
                    date = (Date)oValue;
                } else if (oValue instanceof Calendar) {
                    date = Variant.calendarToGMTDate((Calendar)oValue);
                }
                if (null != date) {
                    int month = date.getMonth() + 1;
                    text = month + "";
                    value = new Variant(month);
                }
            } else {
                value = Variant.emptyVariant;
                text = "";
            }
        } else if (this.type >= AutoFilterConstants.CUSTOM_TYPE_SEASON_1 && this.type <= AutoFilterConstants.CUSTOM_TYPE_SEASON_4) {
            value = cell.getValue();
            if (value.isDate()) {
                Object oValue = value.getValue();
                Date date = null;
                if (oValue instanceof Date) {
                    date = (Date)oValue;
                } else if (oValue instanceof Calendar) {
                    date = Variant.calendarToGMTDate((Calendar)oValue);
                }
                if (null != date) {
                    int s = date.getMonth() / 3 + 1;
                    text = s + "";
                    value = new Variant(s);
                }
            } else {
                value = Variant.emptyVariant;
                text = "";
            }
        } else {
            value = cell.getValue();
            if (value.isDate()) {
                Object oValue = value.getValue();
                Date date = null;
                if (oValue instanceof Date) {
                    date = (Date)oValue;
                } else if (oValue instanceof Calendar) {
                    date = Variant.calendarToGMTDate((Calendar)oValue);
                }
                text = this.dataItemModel.getDataType() == 2 ? AlgorithmUtil.sd_yyyy_MM_dd_HH_mm_ss.format(date) : AlgorithmUtil.sd_yyyy_MM_dd.format(date);
            } else {
                text = cell.getText();
            }
        }
        return new CellValueModel(value, text);
    }

    @Override
    public byte getCustomType() {
        return this.type;
    }

    @Override
    public int getAutoFilterType() {
        return 6;
    }
}

