/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.print;

import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.print.MultiPrintJobProvider;
import com.kingdee.bos.ctrl.kds.print.PrintBookTrans;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.KDPrinter;
import com.kingdee.bos.ctrl.print.extend.IMultiPrintJobProvider;
import com.kingdee.bos.ctrl.print.extend.KDImagePrinter;
import com.kingdee.bos.ctrl.print.extend.MultiPrintJobManager;
import java.awt.Image;
import org.jdom2.Element;
import org.jfree.chart.JFreeChart;

public class PrintManager {
    MultiPrintJobManager printManager;
    MultiPrintJobProvider jobProvider;
    KDImagePrinter imagePrinter;

    public PrintManager(MultiPrintJobProvider jobProvider) {
        this.jobProvider = jobProvider;
        this.printManager = new MultiPrintJobManager((IMultiPrintJobProvider)jobProvider);
    }

    public MultiPrintJobManager getMultiPrintManager() {
        return this.printManager;
    }

    public KDImagePrinter getImagePrinter() {
        if (this.imagePrinter == null) {
            this.imagePrinter = new KDImagePrinter();
        }
        return this.imagePrinter;
    }

    public boolean printImageOnly() {
        Image image = this.getPrintImage();
        if (image != null) {
            KDImagePrinter imgPrinter = this.getImagePrinter();
            imgPrinter.setData(new Image[]{image});
            imgPrinter.setParent(this.jobProvider.getParentWindow());
            return true;
        }
        return false;
    }

    private Image getPrintImage() {
        EmbedObject eo;
        EmbedhLayer el;
        Sheet sheet = this.jobProvider.getBook().getActiveSheet();
        if (sheet != null && (el = sheet.getEmbedments(false)) != null && el.selectionSize() == 1 && (eo = el.getActiveSelectedEmbed()) instanceof Chart) {
            return this.getImageFromChart((Chart)eo);
        }
        return null;
    }

    private Image getImageFromChart(Chart chart) {
        JFreeChart jfChart = chart.getModel().getJFreeChart();
        return jfChart.createBufferedImage(chart.getWidth(), chart.getHeight());
    }

    public KDPrinter getPrinter() {
        return this.printManager.getPrinter();
    }

    public void pageDialog() {
        if (this.printImageOnly()) {
            this.getImagePrinter().pageDialog();
            return;
        }
        this.reloadPrintJob();
        this.printManager.pageDialog();
    }

    public void printPreview() {
        if (this.printImageOnly()) {
            this.getImagePrinter().printPreview();
            return;
        }
        this.reloadPrintJob();
        this.printManager.printPreview();
        this.printManager.clear();
    }

    public int print() {
        if (this.printImageOnly()) {
            return this.getImagePrinter().print();
        }
        return this.print(true);
    }

    public int print(boolean isClear) {
        this.reloadPrintJob();
        int ret = this.printManager.print();
        if (isClear) {
            this.printManager.clear();
        }
        return ret;
    }

    public void clear() {
        this.printManager.clear();
    }

    public void reloadPrintJob() {
        this.printManager.clear();
        PrintBookTrans.loadFromBook(this.printManager, this.jobProvider.getBook());
    }

    public void addConfigChangeListener(IConfigChangeListener lisener) {
        this.printManager.getPrinter().addConfigChangeListener(lisener);
    }

    public void createAllPrintJobs() {
        this.printManager.createAllPrintJobs();
    }

    public void setHeadFootUI(Class ui) {
        this.printManager.setHeadFootUI(ui);
    }

    public void printDirect() {
        this.printManager.printDirect();
    }

    public void fromXmlElement(Element tablesPrintConfigElement) {
        this.printManager.fromXmlElement(tablesPrintConfigElement);
    }
}

