/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.print;

import com.kingdee.bos.ctrl.ext.rd.celltree.CellTreeRenderModel4Print;
import com.kingdee.bos.ctrl.ext.rd.celltree.CellTreeRenderModel4UI;
import com.kingdee.bos.ctrl.ext.rd.celltree.CellTreeSpreadCellTextRender;
import com.kingdee.bos.ctrl.ext.rd.celltree.ICellTreeRenderModel;
import com.kingdee.bos.ctrl.kdf.util.render.CurrencyEditorRenderer;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kds.core.RenderUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.EChartDisplayPanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.ChartImageUtil;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.bos.ctrl.kds.print.SheetPrintJobImp;
import com.kingdee.bos.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.bos.ctrl.print.config.extendui.TablePrintSetupModel;
import com.kingdee.bos.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.ctrl.print.printjob.table.TablePrintPagination;
import com.kingdee.bos.ctrl.print.ui.component.Canvas;
import com.kingdee.bos.ctrl.print.ui.component.CurrencyCell;
import com.kingdee.bos.ctrl.print.ui.component.IDecorate;
import com.kingdee.bos.ctrl.print.ui.component.ImageCell;
import com.kingdee.bos.ctrl.print.ui.component.LineCell;
import com.kingdee.bos.ctrl.print.ui.component.MergeCell;
import com.kingdee.bos.ctrl.print.ui.component.StyleCell;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.JFreeChart;

public class SheetPrintPagination
extends TablePrintPagination {
    private List images = new ArrayList();

    public SheetPrintPagination(ITableForPrint sheet, PrintConfigModel printmode, TablePageSetupModel configmodel) {
        this.sheet = sheet;
        this.printmode = printmode;
        this.configmodel = configmodel;
        this.addPageScope(-1, new TablePrintPagination.SheetPoint((TablePrintPagination)this, -1, -1), new TablePrintPagination.SheetPoint((TablePrintPagination)this, -1, -1));
    }

    public void initCofigModel() {
        TablePrintPagination.SheetPoint p1 = new TablePrintPagination.SheetPoint((TablePrintPagination)this);
        TablePrintPagination.SheetPoint p2 = new TablePrintPagination.SheetPoint((TablePrintPagination)this);
        if (this.pageIndex == 0) {
            this.currentBlockIndex = 0;
        }
        if (!this.getPageScope(0, p1, p2)) {
            this.scopeStart = new TablePrintPagination.SheetPoint((TablePrintPagination)this, 0, 0);
            this.scopeEnd = new TablePrintPagination.SheetPoint((TablePrintPagination)this);
            this.scopeEnd.x = this.sheet.getMaxRowIndex();
            this.scopeEnd.y = this.sheet.getMaxColIndex();
            this.addEmbedmentScope(this.scopeEnd);
            if (this.configmodel.getOrder()) {
                p1 = new TablePrintPagination.SheetPoint((TablePrintPagination)this, -1, 0);
                p2 = new TablePrintPagination.SheetPoint((TablePrintPagination)this, -1, 0);
            } else {
                p1 = new TablePrintPagination.SheetPoint((TablePrintPagination)this, 0, -1);
                p2 = new TablePrintPagination.SheetPoint((TablePrintPagination)this, 0, -1);
            }
            this.addPageScope(-1, p1, p2);
            if (this.printmode != null && this.printmode instanceof TablePrintSetupModel && ((TablePrintSetupModel)this.printmode).getPrintContentType() == 0 || this.configmodel.getPrintAreas() != null) {
                if (this.printmode instanceof TablePrintSetupModel && ((TablePrintSetupModel)this.printmode).getPrintContentType() == 0) {
                    Iterator iter = this.sheet.getSelectIterator(true);
                    ArrayList theselectBlocks = new ArrayList(5);
                    while (iter.hasNext()) {
                        theselectBlocks.add(iter.next());
                    }
                    this.selectBlocks = theselectBlocks;
                } else if (this.configmodel.getPrintAreas() != null) {
                    this.selectBlocks = this.configmodel.printAreasToList();
                }
            }
        }
    }

    public TablePrintPagination.SheetPoint addEmbedmentScope(TablePrintPagination.SheetPoint scopeEnd) {
        SheetPrintJobImp sheetJobImp;
        Sheet sheet1;
        EmbedhLayer gl;
        if (this.sheet instanceof SheetPrintJobImp && (gl = (sheet1 = (Sheet)(sheetJobImp = (SheetPrintJobImp)this.sheet).getTable()).getEmbedments(false)) != null) {
            int enbedmentNum = gl.size();
            int endX = 0;
            int endY = 0;
            for (int i = 0; i < enbedmentNum; ++i) {
                EmbedObject gr = gl.getEmbed(i);
                int tempEndX = 0;
                int tempEndY = 0;
                Point temp = new Point();
                temp.x = gr.getX() + gr.getWidth();
                temp.y = gr.getY() + gr.getHeight();
                tempEndX = SheetBaseMath.rowAtPoint(sheet1, temp);
                tempEndY = SheetBaseMath.colAtPoint(sheet1, temp);
                if (scopeEnd.x < tempEndX && endX < tempEndX) {
                    endX = tempEndX;
                }
                if (scopeEnd.y < tempEndY && endY < tempEndY) {
                    endY = tempEndY;
                }
                if (gr instanceof Chart) {
                    this.addFreeChartImage((Chart)gr);
                    continue;
                }
                if (gr instanceof ChartRectEmbedment) {
                    this.addFusionChartImage((ChartRectEmbedment)gr);
                    continue;
                }
                if (gr instanceof EmbedImage) {
                    this.addEmbedImage((EmbedImage)gr);
                    continue;
                }
                this.addNullImage(gr);
            }
            if (endX != 0) {
                scopeEnd.x = endX;
            }
            if (endY != 0) {
                scopeEnd.y = endY;
            }
        }
        return scopeEnd;
    }

    private void addNullImage(EmbedObject embedObj) {
        int cWidth = embedObj.getWidth();
        int cHeight = embedObj.getHeight();
        if (cWidth <= 0 || cHeight <= 0) {
            return;
        }
        BufferedImage image = new BufferedImage(cWidth, cHeight, 2);
        Graphics g = image.getGraphics();
        g.translate(-embedObj.getX(), -embedObj.getY());
        embedObj.paintData(g);
        ImageInfo imageInfo = new ImageInfo(image, embedObj.getX(), embedObj.getY(), embedObj.getWidth(), embedObj.getHeight());
        this.images.add(imageInfo);
    }

    private void addEmbedImage(EmbedImage embedimage) {
        int cWidth = embedimage.getWidth();
        int cHeight = embedimage.getHeight();
        if (cWidth <= 0 || cHeight <= 0) {
            return;
        }
        BufferedImage image = new BufferedImage(cWidth, cHeight, 2);
        Graphics g = image.getGraphics();
        g.translate(-embedimage.getX(), -embedimage.getY());
        embedimage.paintData(g);
        ImageInfo imageInfo = new ImageInfo(image, embedimage.getX(), embedimage.getY(), embedimage.getWidth(), embedimage.getHeight());
        this.images.add(imageInfo);
    }

    private void addFusionChartImage(ChartRectEmbedment chart) {
        BufferedImage image;
        Object component = null;
        if (chart instanceof FlashChart) {
            component = ((FlashChart)chart).getNativeComponent();
        } else {
            EChartDisplayPanel panel = ((EChart)chart).getDisplayPanel();
            if (null != panel) {
                component = ((EChart)chart).getNativeComponent();
            }
        }
        if (component == null) {
            image = ChartImageUtil.getErrorImage();
        } else {
            int cWidth = component.getWidth();
            int cHeight = component.getHeight();
            if (cWidth <= 0 || cHeight <= 0) {
                return;
            }
            image = chart.getCachedImg();
        }
        if (image == null) {
            image = chart.exportToBufferedImage();
        }
        int dragInsetsLeftOffset = 3;
        int cutoff = dragInsetsLeftOffset << 1;
        ImageInfo imageInfo = new ImageInfo(image, chart.getX() + dragInsetsLeftOffset, chart.getY() + dragInsetsLeftOffset, chart.getWidth() - cutoff, chart.getHeight() - cutoff);
        this.images.add(imageInfo);
    }

    private void addFreeChartImage(Chart chart) {
        JFreeChart jfChart = chart.getModel().getJFreeChart();
        BufferedImage image = jfChart.createBufferedImage(chart.getWidth(), chart.getHeight());
        ImageInfo imageInfo = new ImageInfo(image, chart.getX(), chart.getY(), chart.getWidth(), chart.getHeight());
        this.images.add(imageInfo);
    }

    public Canvas createPrintBody(ITableForPrint sheet, TablePrintPagination.SheetPoint pStart, TablePrintPagination.SheetPoint pEnd, boolean isPaintgrid, boolean hasLineBorder) {
        System.out.println("enter createPrintBody()");
        HashSet<ITableForPrint.IBlock> theMergeBlocks = new HashSet<ITableForPrint.IBlock>();
        Canvas canvas = new Canvas();
        if (isPaintgrid || hasLineBorder) {
            canvas.setDecorate((IDecorate)this.linnBorder);
        }
        int x = 0;
        int y = 0;
        ArrayList<Object> cellList = new ArrayList<Object>();
        int rowSpace = sheet.getRowSpacing();
        int columnSpace = sheet.getColumnSpacing();
        for (int i = pStart.x; i <= pEnd.x; ++i) {
            int height = sheet.getRowHeight(i);
            if (height < 0) continue;
            x = 0;
            for (int j = pStart.y; j <= pEnd.y; ++j) {
                int j2 = j;
                int width = sheet.getColumnWidth(j);
                if (width <= -1) continue;
                Style style = sheet.getCellStyle(i, j);
                ITableForPrint.ICell cell = sheet.getCell(i, j, false);
                ITableForPrint.IBlock cellMerge = sheet.getMergerBlock(i, j);
                if (cellMerge != null) {
                    Iterator iter = theMergeBlocks.iterator();
                    boolean hasMerge = false;
                    while (iter.hasNext()) {
                        ITableForPrint.IBlock m = (ITableForPrint.IBlock)iter.next();
                        if (!m.equals(cellMerge)) continue;
                        hasMerge = true;
                        break;
                    }
                    if (!hasMerge) {
                        theMergeBlocks.add(cellMerge);
                    }
                }
                if (this.isNeedCell(cell, style) && cellMerge == null || this.isHasBorder(cell, style) && cellMerge == null) {
                    CurrencyCell cCell;
                    CurrencyEditorRenderer.Body cRender;
                    Object render;
                    Object object = render = cell == null ? null : cell.getRender();
                    if (render instanceof CurrencyEditorRenderer.Body) {
                        cRender = (CurrencyEditorRenderer.Body)render;
                        cCell = new CurrencyCell();
                        cCell.setTitle(false);
                        cCell.setValue(cell.getValue());
                        cCell.setIntegerDigitCount(cRender.getIntegerDigitCount());
                        cCell.setDecimalDigitCount(cRender.getDecimalDigitCount());
                        cCell.setPainterBounds((float)x, (float)y, (float)(width + 2), (float)(height + 2));
                        cellList.add(cCell);
                    } else if (render instanceof CurrencyEditorRenderer.Title) {
                        cRender = (CurrencyEditorRenderer.Title)render;
                        cCell = new CurrencyCell();
                        cCell.setTitle(true);
                        cCell.setValue(cell.getValue());
                        cCell.setIntegerDigitCount(cRender.getIntegerDigitCount());
                        cCell.setDecimalDigitCount(cRender.getDecimalDigitCount());
                        cCell.setPainterBounds((float)x, (float)y, (float)(width + 2), (float)(height + 2));
                        cellList.add(cCell);
                    } else {
                        StyleCell borderCell = this.createStyleCell(sheet, cell, x, y, width, height, i, j, cellMerge, pEnd);
                        if (hasLineBorder) {
                            borderCell.setDecorate((IDecorate)this.linnBorder);
                        }
                        cellList.add(borderCell);
                    }
                } else if (cellMerge != null) {
                    j2 = pEnd.y > cellMerge.getCol2() ? cellMerge.getCol2() : pEnd.y;
                }
                for (int mj = j2; mj >= j; --mj) {
                    width = sheet.getColumnWidth(mj);
                    x = x + width + rowSpace;
                }
                j = j2;
            }
            y = y + height + columnSpace;
        }
        int bodyWidth = x + columnSpace;
        int bodyHeight = y + columnSpace;
        x = 0;
        y = 0;
        ArrayList<LineCell> gridList = new ArrayList<LineCell>();
        if (isPaintgrid) {
            Color gridColor = Color.BLACK;
            if (!this.configmodel.isSingleColor()) {
                gridColor = this.sheet.getGridColor();
            }
            if (sheet.isHorizonGridLineVisible()) {
                for (int i = pStart.x; i <= pEnd.x + 1; ++i) {
                    LineCell horizon_line = new LineCell((float)x, (float)y, (float)(x + bodyWidth - 1), (float)y);
                    horizon_line.setColor(gridColor);
                    gridList.add(horizon_line);
                    if (i >= pEnd.x + 1) continue;
                    int height = sheet.getRowHeight(i);
                    y = y + height + rowSpace;
                }
            }
            x = 0;
            y = 0;
            if (sheet.isVerticalGridLineVisible()) {
                for (int j = pStart.y; j <= pEnd.y + 1; ++j) {
                    LineCell ver_line = new LineCell((float)x, (float)y, (float)x, (float)(y + bodyHeight - 1));
                    ver_line.setColor(gridColor);
                    gridList.add(ver_line);
                    if (j >= pEnd.y + 1) continue;
                    int width = sheet.getColumnWidth(j);
                    x = x + width + columnSpace;
                }
            }
        }
        int count = theMergeBlocks.size();
        ArrayList<StyleCell> mergBlockCells = new ArrayList<StyleCell>();
        ArrayList<LineCell> mergGridBrushCells = new ArrayList<LineCell>();
        Iterator iter = theMergeBlocks.iterator();
        for (int i = count - 1; i >= 0; --i) {
            ITableForPrint.IBlock mergeBlock = (ITableForPrint.IBlock)iter.next();
            int row = mergeBlock.getRow();
            int col = mergeBlock.getCol();
            Style style = sheet.getCellStyle(row, col);
            ITableForPrint.ICell cell = sheet.getCell(row, col, false);
            Rectangle2D mergeRect = this.getBlockRect(sheet, pStart, pEnd, mergeBlock);
            int mx = (int)mergeRect.getX();
            int my = (int)mergeRect.getY();
            int width = (int)mergeRect.getWidth();
            int height = (int)mergeRect.getHeight();
            int toRow = mergeBlock.getRow2();
            int toCol = mergeBlock.getCol2();
            StyleCell sCell = this.createStyleCell(sheet, cell, mx, my, width, height, row, col, mergeBlock, pEnd);
            if (sCell instanceof MergeCell) {
                ((MergeCell)sCell).setPageStartCol(pStart.y);
                ((MergeCell)sCell).setPageStartRow(pStart.x);
                ((MergeCell)sCell).setPageEndCol(pEnd.y);
                ((MergeCell)sCell).setPageEndRow(pEnd.x);
                if (null == sCell.getBackGround() && style.getBackground().equals(new Color(255, 255, 255, 0))) {
                    ((MergeCell)sCell).setBackGround(Color.white);
                } else {
                    ((MergeCell)sCell).setBackGround(style.getBackground());
                }
            }
            sCell.setStyle(style);
            if (hasLineBorder) {
                sCell.setDecorate((IDecorate)this.linnBorder);
            }
            mergBlockCells.add(sCell);
            int bx = mx;
            int by = my;
            for (int ir = mergeBlock.getRow(); ir < toRow; ++ir) {
                by = by + sheet.getRowHeight(ir) + 1;
                bx = mx;
                for (int ic = mergeBlock.getCol(); ic <= toCol; ++ic) {
                    bx = bx + sheet.getColumnWidth(ic) + 1;
                }
                if (ir < toRow && sheet.getRowHeight(ir + 1) <= 0) continue;
                LineCell horizon_line = new LineCell((float)(mx + 1), (float)by, (float)(bx - 1), (float)by);
                horizon_line.setColor(Color.WHITE);
                mergGridBrushCells.add(horizon_line);
            }
            bx = mx;
            by = my;
            for (int ic = mergeBlock.getCol(); ic < toCol; ++ic) {
                bx = bx + sheet.getColumnWidth(ic) + 1;
                by = my;
                for (int ir = mergeBlock.getRow(); ir <= toRow; ++ir) {
                    by = by + sheet.getRowHeight(ir) + 1;
                }
                if (ic < toCol && sheet.getColumnWidth(ic + 1) <= 0) continue;
                LineCell horizon_line = new LineCell((float)bx, (float)(my + 1), (float)bx, (float)(by - 1));
                horizon_line.setColor(Color.WHITE);
                mergGridBrushCells.add(horizon_line);
            }
        }
        List imageList = this.cutPageByImage(pStart, pEnd);
        this.addToCanvas(gridList, canvas);
        this.addToCanvas(mergGridBrushCells, canvas);
        this.addToCanvas(cellList, canvas);
        this.addToCanvas(mergBlockCells, canvas);
        this.addToCanvas(imageList, canvas);
        canvas.setPainterSize((float)bodyWidth, (float)bodyHeight);
        return canvas;
    }

    protected Rectangle2D getBlockRect(ITableForPrint asheet, TablePrintPagination.SheetPoint start, TablePrintPagination.SheetPoint end, ITableForPrint.IBlock mergeBlock) {
        int width;
        int height;
        int i;
        Rectangle2D ret = this.getBlockRect(asheet, start, mergeBlock);
        int rowSpace = asheet.getRowSpacing();
        int columnSpace = asheet.getColumnSpacing();
        int x = (int)ret.getX();
        int y = (int)ret.getY();
        float mWidth = (float)ret.getWidth();
        float mHeight = (float)ret.getHeight();
        for (i = mergeBlock.getRow2(); i > end.x; --i) {
            height = asheet.getRowHeight(i);
            if (height <= 0) continue;
            mHeight -= (float)(height + columnSpace);
        }
        for (i = end.y; i < mergeBlock.getCol2(); ++i) {
            width = asheet.getColumnWidth(i);
            if (width <= 0) continue;
            mWidth -= (float)(width + rowSpace);
        }
        for (i = mergeBlock.getRow(); i < start.x; ++i) {
            height = asheet.getRowHeight(i);
            if (height <= 0) continue;
            y += height + columnSpace;
            mHeight -= (float)(height + columnSpace);
        }
        for (i = mergeBlock.getCol(); i < start.y; ++i) {
            width = asheet.getColumnWidth(i);
            if (width <= 0) continue;
            x += width + rowSpace;
            mWidth -= (float)(width + rowSpace);
        }
        return new Rectangle2D.Float(x, y, mWidth, mHeight);
    }

    protected Rectangle2D getBlockRect(ITableForPrint asheet, TablePrintPagination.SheetPoint start, ITableForPrint.IBlock mergeBlock) {
        int i;
        int i2;
        int height;
        int i3;
        int rowSpace = asheet.getRowSpacing();
        int columnSpace = asheet.getColumnSpacing();
        int fromRow = 0;
        int toRow = 0;
        int y = 0;
        if (start.x < mergeBlock.getRow()) {
            fromRow = start.x;
            toRow = mergeBlock.getRow();
            for (i3 = fromRow; i3 < toRow; ++i3) {
                height = asheet.getRowHeight(i3);
                y = y + height + columnSpace;
            }
        } else if (start.x > mergeBlock.getRow()) {
            fromRow = mergeBlock.getRow();
            toRow = start.x;
            for (i3 = fromRow; i3 < toRow; ++i3) {
                height = asheet.getRowHeight(i3);
                y = y - height - columnSpace;
            }
        }
        int fromCol = 0;
        int toCol = 0;
        int x = 0;
        if (start.y < mergeBlock.getCol()) {
            fromCol = start.y;
            toCol = mergeBlock.getCol();
            for (i2 = fromCol; i2 < toCol; ++i2) {
                int getColumnWidth = asheet.getColumnWidth(i2);
                x = x + getColumnWidth + rowSpace;
            }
        } else if (start.y > mergeBlock.getCol()) {
            fromCol = mergeBlock.getCol();
            toCol = start.y;
            for (i2 = fromCol; i2 < toCol; ++i2) {
                int width = asheet.getColumnWidth(i2);
                x = x - width - rowSpace;
            }
        }
        float mWidth = 0.0f;
        float mHeight = 0.0f;
        for (i = mergeBlock.getRow(); i <= mergeBlock.getRow2(); ++i) {
            int height2 = asheet.getRowHeight(i);
            if (height2 <= 0) continue;
            mHeight = mHeight + (float)height2 + (float)columnSpace;
        }
        mHeight -= (float)columnSpace;
        for (i = mergeBlock.getCol(); i <= mergeBlock.getCol2(); ++i) {
            int width = asheet.getColumnWidth(i);
            if (width <= 0) continue;
            mWidth = mWidth + (float)width + (float)rowSpace;
        }
        Rectangle2D.Float rect = new Rectangle2D.Float(x, y, mWidth -= (float)rowSpace, mHeight);
        return rect;
    }

    private boolean isInPage(ImageInfo imageInfo, TablePrintPagination.SheetPoint pageStart, TablePrintPagination.SheetPoint pageEnd) {
        int startX = imageInfo.getX();
        int startY = imageInfo.getY();
        int endX = imageInfo.getX() + imageInfo.getWidth();
        int endY = imageInfo.getY() + imageInfo.getHeight();
        boolean colCross = false;
        boolean rowCross = false;
        if (startX < pageEnd.x && endX > pageStart.x) {
            colCross = true;
        }
        if (startY < pageEnd.y && endY > pageStart.y) {
            rowCross = true;
        }
        return colCross && rowCross;
    }

    private boolean isEnd(ImageInfo imageInfo, TablePrintPagination.SheetPoint pageEnd) {
        int endX = imageInfo.getX() + imageInfo.getWidth();
        int endY = imageInfo.getY() + imageInfo.getHeight();
        return endX < pageEnd.x && endY < pageEnd.y;
    }

    private List cutPageByImage(TablePrintPagination.SheetPoint pageStart, TablePrintPagination.SheetPoint pageEnd) {
        ArrayList<ImageCell> imageCellList = new ArrayList<ImageCell>();
        SheetPrintJobImp sheetJobImp = (SheetPrintJobImp)this.sheet;
        Sheet sheet1 = (Sheet)sheetJobImp.getTable();
        TablePrintPagination.SheetPoint pStart = new TablePrintPagination.SheetPoint((TablePrintPagination)this);
        TablePrintPagination.SheetPoint pEnd = new TablePrintPagination.SheetPoint((TablePrintPagination)this);
        pStart.x = SheetBaseMath.getColX(sheet1, pageStart.y);
        pStart.y = SheetBaseMath.getRowY(sheet1, pageStart.x);
        pEnd.x = SheetBaseMath.getColX(sheet1, pageEnd.y + 1);
        pEnd.y = SheetBaseMath.getRowY(sheet1, pageEnd.x + 1);
        for (int i = 0; i < this.images.size(); ++i) {
            ImageInfo imageInfo = (ImageInfo)this.images.get(i);
            if (!this.isInPage(imageInfo, pStart, pEnd)) continue;
            int dx1 = 0;
            int dy1 = 0;
            int dx2 = 0;
            int dy2 = 0;
            int sx1 = 0;
            int sy1 = 0;
            boolean sx2 = false;
            boolean sy2 = false;
            if (imageInfo.getX() + imageInfo.getWidth() > pStart.x) {
                if (imageInfo.getX() > pStart.x) {
                    dx1 = imageInfo.getX();
                    sx1 = 0;
                } else {
                    dx1 = pStart.x;
                    sx1 = pStart.x - imageInfo.getX();
                }
            }
            if (imageInfo.getY() + imageInfo.getHeight() > pStart.y) {
                if (imageInfo.getY() > pStart.y) {
                    dy1 = imageInfo.getY();
                    sy1 = 0;
                } else {
                    dy1 = pStart.y;
                    sy1 = pStart.y - imageInfo.getY();
                }
            }
            dx2 = imageInfo.getX() + imageInfo.getWidth() > pEnd.x ? pEnd.x : imageInfo.getX() + imageInfo.getWidth();
            dy2 = imageInfo.getY() + imageInfo.getHeight() > pEnd.y ? pEnd.y : imageInfo.getY() + imageInfo.getHeight();
            int sWidth = dx2 - dx1;
            int sHeight = dy2 - dy1;
            BufferedImage newimage = new BufferedImage(sWidth, sHeight, 2);
            newimage.getGraphics().drawImage(imageInfo.getImage(), 0, 0, sWidth, sHeight, sx1, sy1, sx1 + sWidth, sy1 + sHeight, null);
            ImageCell cell = new ImageCell((Image)newimage);
            imageCellList.add(cell);
            cell.setPainterBounds((float)(dx1 - pStart.x), (float)(dy1 - pStart.y), (float)sWidth, (float)sHeight);
        }
        return imageCellList;
    }

    private Image getPageByImage(int n, int i, int width, int height) {
        Image image = (Image)this.images.get(i);
        int count = this.imageCutCount(image, width, height);
        if (count == 1) {
            return image;
        }
        int iWidth = image.getWidth(null);
        int iHeight = image.getHeight(null);
        int wCount = (int)Math.ceil((float)iWidth / (float)width);
        int hCount = (int)Math.ceil((float)iHeight / (float)height);
        int x = 0;
        int y = 0;
        int sWidth = 0;
        int sHeight = 0;
        int index = 0;
        for (int m = 0; m < hCount; ++m) {
            boolean isFound = false;
            for (int h = 0; h < wCount; ++h) {
                if (n == index) {
                    sWidth = x + width + 1 > iWidth ? iWidth - x : width;
                    sHeight = y + height + 1 > iHeight ? iHeight - y : height;
                    isFound = true;
                    break;
                }
                ++index;
                x += width;
            }
            if (isFound) break;
            x = 0;
            y += height;
        }
        BufferedImage newimage = new BufferedImage(sWidth, sHeight, 1);
        newimage.getGraphics().drawImage(image, 0, 0, sWidth, sHeight, x, y, x + sWidth, y + sHeight, null);
        return newimage;
    }

    private int imageCutCount(Image image, float width, float height) {
        int iWidth = image.getWidth(null);
        int iHeight = image.getHeight(null);
        int wCount = (int)Math.ceil((float)iWidth / width);
        int hCount = (int)Math.ceil((float)iHeight / height);
        return wCount * hCount;
    }

    protected StyleCell createStyleCell(ITableForPrint asheet, ITableForPrint.ICell theCell, int x, int y, int width, int height, int row, int col, ITableForPrint.IBlock mb, TablePrintPagination.SheetPoint pEnd) {
        StyleCell styleCell = super.createStyleCell(asheet, theCell, x, y, width, height, row, col, mb, pEnd);
        if (theCell instanceof SheetPrintJobImp.SheetCell) {
            this.createStyleCellCustom(((SheetPrintJobImp.SheetCell)theCell).getCell(), styleCell);
        }
        return styleCell;
    }

    private void createStyleCellCustom(Cell theCell, StyleCell styleCell) {
        CellTreeRenderModel4UI model4ui = new CellTreeRenderModel4UI(theCell);
        if (model4ui.isRowXorColumnCellTreeDisplay() && model4ui.hasNode()) {
            CellTreeRenderModel4Print model4print = new CellTreeRenderModel4Print(model4ui.isColCellDisplay(), model4ui.isRowCellDisplay(), model4ui.hasNode());
            CustomRenderWrapper renderWrapper = new CustomRenderWrapper();
            model4print.setFront(model4ui.isFront());
            model4print.setLevel(model4ui.getLevel());
            model4print.setLevelModel(model4ui.getLevelModel());
            model4print.setNodeType(model4ui.getNodeType());
            renderWrapper.setRenderModel(model4print);
            styleCell.addCustomRender((StyleCell.AbstractCustomRenderWrapper)renderWrapper);
        }
    }

    public class CustomRenderWrapper
    extends StyleCell.AbstractCustomRenderWrapper {
        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            CellTreeSpreadCellTextRender render = new CellTreeSpreadCellTextRender();
            render.setDrawModel((ICellTreeRenderModel)this._model);
            render.draw(graphics, clip, object, cellStyle, RenderUtil.PaintCell_Clip);
        }
    }

    class ImageInfo {
        private Image image;
        int x;
        int y;
        int width;
        int height;

        public ImageInfo(Image image, int x, int y, int width, int height) {
            this.image = image;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Image getImage() {
            return this.image;
        }
    }
}

