/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.util;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.ext.util.VerifyUserService;
import com.kingdee.bos.ctrl.kds.util.KDFunctionModel;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class KDHideFunctionDialog {
    private JComponent own;
    private Component parentGlassPane;
    private RootPaneContainer rootPane;
    private JPanel glassPane;
    private KDDialog dialog;
    private int width = 600;
    private int height = 450;
    private KeyStroke ctrlAltH = KeyStroke.getKeyStroke("control shift Q");
    private KDTree functionTree;
    private KDTreeView treeView;
    private KDWorkButton exeButton;
    private KDTextArea explainText;
    private KDSplitPane splitPane;

    public KDHideFunctionDialog(JComponent owner) {
        this.own = owner;
        this.init();
        this.registedKeyEvent();
    }

    private void init() {
        this.explainText = new KDTextArea();
        this.explainText.setText("\u9690\u85cf\u529f\u80fd\u8c03\u7528\u96c6\u5408");
        this.explainText.setEnabled(false);
        this.exeButton = new KDWorkButton("\u542f\u7528");
        this.exeButton.setEnabled(false);
        this.exeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDHideFunctionDialog.this.dialog.dispose();
                if (KDHideFunctionDialog.this.glassPane != null) {
                    KDHideFunctionDialog.this.glassPane.setVisible(false);
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)KDHideFunctionDialog.this.functionTree.getSelectionPath().getLastPathComponent();
                KDFunctionModel model = (KDFunctionModel)node.getUserObject();
                model.actionPerformed(e);
            }
        });
        this.functionTree = new KDTree();
        this.treeView = new KDTreeView(this.functionTree);
        this.treeView.setShowButton(false);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"/");
        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
        treeModel.setAsksAllowsChildren(true);
        this.functionTree.setModel((TreeModel)treeModel);
        this.functionTree.setShowsRootHandles(true);
        this.functionTree.setRootVisible(false);
        this.functionTree.getSelectionModel().setSelectionMode(2);
        this.functionTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = KDHideFunctionDialog.this.functionTree.getSelectionPath();
                DefaultKingdeeTreeNode node = null;
                if (path != null) {
                    node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                }
                if (node != null && node.getUserObject() instanceof KDFunctionModel) {
                    KDFunctionModel model = (KDFunctionModel)node.getUserObject();
                    KDHideFunctionDialog.this.explainText.setText(model.getExplainText());
                    KDHideFunctionDialog.this.exeButton.setEnabled(model.getEnable());
                } else {
                    KDHideFunctionDialog.this.explainText.setText("\u9690\u85cf\u529f\u80fd\u8c03\u7528\u96c6\u5408");
                    KDHideFunctionDialog.this.exeButton.setEnabled(false);
                }
            }
        });
        this.functionTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    KDHideFunctionDialog.this.exeButton.doClick();
                }
            }
        });
        TableLayout2 layout = new TableLayout2(2, 1);
        layout.setRowSpacing(0, 5);
        layout.setRatableHeight(0, 1);
        layout.setFixedHeight(1, 30);
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)layout);
        panel.add((Component)this.explainText, (Object)TableLayout2.param((int)0, (int)0));
        panel.add((Component)this.exeButton, (Object)TableLayout2.param((int)1, (int)0));
        this.splitPane = new KDSplitPane(1);
        this.splitPane.setCustomInsets(new Insets(5, 5, 5, 5));
        this.splitPane.setDividerLocation(0.5);
        this.splitPane.setLeftComponent((Component)this.treeView);
        this.splitPane.setRightComponent((Component)panel);
    }

    public DefaultKingdeeTreeNode getTreeRoot() {
        return (DefaultKingdeeTreeNode)this.functionTree.getModel().getRoot();
    }

    public void addFunctionNode(KDFunctionModel function, String functionName, DefaultKingdeeTreeNode parent) {
        if (function.isOnlyInside() && !VerifyUserService.isInsideNet()) {
            return;
        }
        DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode((Object)functionName);
        child.setAllowsChildren(false);
        child.setUserObject((Object)function);
        this.functionTree.addNodeInto((MutableTreeNode)child, (MutableTreeNode)parent);
        this.functionTree.expandAllNodes(true, (TreeNode)parent);
    }

    public DefaultKingdeeTreeNode addGroupNode(String groupName, boolean isOnlyInside, DefaultKingdeeTreeNode parent) {
        DefaultKingdeeTreeNode child = new DefaultKingdeeTreeNode((Object)groupName);
        if (!isOnlyInside || VerifyUserService.isInsideNet()) {
            this.functionTree.addNodeInto((MutableTreeNode)child, (MutableTreeNode)parent);
        }
        return child;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setKeyStroke(KeyStroke key) {
        this.ctrlAltH = key;
    }

    private void registedKeyEvent() {
        if (this.own == null) {
            throw new IllegalArgumentException("null owner window");
        }
        this.own.getInputMap(1).put(this.ctrlAltH, "ShowHideFunctionUI");
        this.own.getActionMap().put("ShowHideFunctionUI", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (KDHideFunctionDialog.this.dialog == null) {
                    Window w = SwingUtilities.getWindowAncestor(KDHideFunctionDialog.this.own);
                    if (w instanceof RootPaneContainer) {
                        KDHideFunctionDialog.this.rootPane = (RootPaneContainer)((Object)w);
                        KDHideFunctionDialog.this.parentGlassPane = KDHideFunctionDialog.this.rootPane.getGlassPane();
                    }
                    Container c = KDHideFunctionDialog.this.own;
                    boolean is = true;
                    Frame p = null;
                    while (is) {
                        if (c.getParent() instanceof Frame) {
                            is = false;
                            p = (Frame)c.getParent();
                            continue;
                        }
                        c = c.getParent();
                    }
                    KDHideFunctionDialog.this.dialog = new KDDialog(p);
                    KDHideFunctionDialog.this.dialog.setTitle("\u9690\u85cf\u529f\u80fd");
                    KDHideFunctionDialog.this.dialog.setSize(KDHideFunctionDialog.this.width, KDHideFunctionDialog.this.height);
                    KDHideFunctionDialog.this.dialog.setModal(true);
                    KDHideFunctionDialog.this.dialog.addWindowListener((WindowListener)new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            if (KDHideFunctionDialog.this.glassPane != null) {
                                KDHideFunctionDialog.this.glassPane.setVisible(false);
                            }
                        }
                    });
                    KDHideFunctionDialog.this.dialog.getContentPane().add((Component)KDHideFunctionDialog.this.splitPane);
                    CtrlSwingUtilities.makeAlignBounds((boolean)true, (boolean)true, (Component)KDHideFunctionDialog.this.dialog);
                }
                if (KDHideFunctionDialog.this.rootPane != null) {
                    KDHideFunctionDialog.this.rootPane.setGlassPane(KDHideFunctionDialog.this.getGlassPanel());
                    KDHideFunctionDialog.this.rootPane.getGlassPane().setVisible(true);
                    KDHideFunctionDialog.this.dialog.show();
                }
            }
        });
    }

    private JPanel getGlassPanel() {
        if (this.glassPane != null) {
            return this.glassPane;
        }
        this.glassPane = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                g.setColor(new Color(255, 255, 255, 150));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
        };
        this.glassPane.setOpaque(false);
        return this.glassPane;
    }
}

