//多序列格式化，对于联合图有多个序列，会每个序列调用单序列格式化最后拼接
function mutilSeriesFormatter(ps, left, f, showMarker, showSeries) {
    var ret = '';
    var picorialMarkers = [];
    var bars = [];
    var otherSeries = [];
    var params = [];
    if (Array.isArray(ps)) {
        for (var i = 0; i < ps.length; i++) {
            var p = ps[i];
            if ('pictorialBar' == p.seriesType) {
                picorialMarkers.push(p.marker);
            }
            params.push(p);
        }
    } else {
        params.push(ps);
    }
    for (var a = 0; a < params.length; a++) {
        var p = params[a];
        if ('pictorialBar' == p.seriesType) {
            continue;
        }
        var value = p.value;
        var op = myChart.getOption();
        var l = left;
        var yIndex = op.series[p.seriesIndex].yAxisIndex;
        if (yIndex && op.yAxis[yIndex].position == 'right')
            l = false;
        var text = seriesNumberFormatter(p, l, f);
        if (f == '' && showSeries) {
            text = p.seriesName + ' ' + text;
        }
        if (showMarker) {
            var marker = p.marker;
			//如果是3d柱形图取其抽象图的marker
            if ('bar' == p.seriesType && picorialMarkers.length != 0)
                marker = picorialMarkers[a / 2];
            text = marker + text;
        }
        ret = ret + text;
        if (a < params.length - 1)
            ret = ret + '</br>';
    }
    if (f != '') {
        return ret
    } else {
        return params[0].name + '<br />' + ret;
    }
}
