/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.excel.ui;

import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.ui.CloseHook;
import com.kingdee.bos.ctrl.kdf.excel.ui.Excel2007ExportController;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportConfigPane;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportListener;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportProgressPane;
import com.kingdee.bos.ctrl.kdf.excel.ui.StartHook;
import com.kingdee.bos.ctrl.swing.KDDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;

class ExportDialog
extends KDDialog
implements CloseHook,
StartHook,
ExportListener {
    ExportProgressPane progressPane;
    ExportConfigPane configPane;
    Object trayIcon;
    Thread exportThread;
    AbstractDataWrapper datas;

    ExportDialog(boolean isModal, Frame frame) {
        super(frame);
        this.init(isModal);
        this.setLocationRelativeTo(frame);
    }

    ExportDialog(boolean isModal, Dialog dialog) {
        super(dialog);
        this.init(isModal);
        this.setLocationRelativeTo(dialog);
    }

    private void init(boolean isModal) {
        this.setSize(360, 120);
        this.setUndecorated(true);
        this.setDefaultCloseOperation(2);
        this.initProgressPane();
        this.initConfigPane();
        this.setModal(isModal);
    }

    private void initProgressPane() {
        this.progressPane = new ExportProgressPane();
        this.progressPane.hook = this;
    }

    private void initConfigPane() {
        this.configPane = new ExportConfigPane();
        this.configPane.hook = this;
        this.add((Component)((Object)this.configPane));
    }

    @Override
    public void close() {
        this.setVisible(false);
        this.dispose();
        Excel2007ExportController.removeSystemTray(this);
    }

    @Override
    public void start() {
        this.remove((Component)((Object)this.configPane));
        this.add((Component)((Object)this.progressPane));
        this.validate();
        this.datas.setShowValue(this.configPane.showValue.isSelected());
        this.datas.setExportSelect(this.configPane.exportSelect.isSelected());
        this.datas.setExportMergeBlocks(this.configPane.exportMergeBlocks.isSelected());
        this.datas.setExportHideRows(this.configPane.exportHideRows.isSelected());
        this.datas.setExportHideCols(this.configPane.exportHideCols.isSelected());
        this.datas.setExportFormula(this.configPane.exportFormula.isSelected());
        this.datas.setExportCustomerFomulas(this.configPane.exportCustomFormulas.isSelected());
        this.datas.setCurrentSheetIndex(0);
        this.exportThread.start();
    }

    @Override
    public void complete(ExportEvent e) {
        this.toFront();
        this.progressPane.complete(e);
    }

    @Override
    public void delEvent(ExportEvent e) {
        this.progressPane.update(e._stepName, e._message, e._stepComsuming);
    }
}

