/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.form.Form;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.form.PageCollection;
import com.kingdee.bos.ctrl.kdf.formbrowser2.ClientForm;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ClientFormPages;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ContextOfBrowser;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.KDFWapper;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.PhysicalPageManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.PageObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.util.FormBrowserConfManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.util.FormBrowserConfig;
import com.kingdee.bos.ctrl.kdf.printprovider.KDPrintService;
import com.kingdee.bos.ctrl.kdf.printprovider.PrintInfoParsingException;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterNotFoundException;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.KDFHeaderFooterPainter;
import com.kingdee.bos.ctrl.kdf.printprovider.resources.Resources;
import com.kingdee.bos.ctrl.kdf.server.FormPageInfo;
import com.kingdee.bos.ctrl.kdf.server.FormProxy;
import com.kingdee.bos.ctrl.kdf.server.IFormFactory;
import com.kingdee.bos.ctrl.kdf.server.IServerPluginParam;
import com.kingdee.bos.ctrl.kdf.server.IVariantDataListener;
import com.kingdee.bos.ctrl.kdf.server.PageEvent;
import com.kingdee.bos.ctrl.kdf.server.PageEventListener;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import java.awt.Dimension;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.log4j.Logger;

public class DefaultFormPageRetriver
implements PageEventListener,
Runnable,
Serviceable,
Configurable {
    private static Logger logger = LogUtil.getPackageLogger(DefaultFormPageRetriver.class);
    public static final String LOCAL_SERVER = "local_server";
    public static final String ORM_SERVER = "orm_server";
    private ServiceManager compMgr;
    private int index;
    private PageCollection list = new PageCollection();
    private FormProxy formProxy;
    private KDFWapper kdfWapper;
    private Form form;
    private IServerPluginParam[] kdfparams;
    private IVariantDataListener vdataListener;
    private Object userFuncObj;
    private HashMap rptparams;
    private FormPageInfo info = new FormPageInfo();
    private Thread worker;
    String tcpUrl;
    IFormFactory userFormFactory;
    private KDPrintService printserv;
    private ContextOfBrowser context;
    private PhysicalPageManager previewpageCollector;
    private ClientFormPages cformPages;
    private PhysicalPageManager virtualPageManager;

    private boolean RetriveRawPagesFromSnapshot(KDFWapper kdfWapper) {
        try {
            this.setupFormProxy();
            this.printserv = (KDPrintService)this.compMgr.lookup("PrintService");
            this.printserv.getPrinterAttrManager().restore(kdfWapper.getKDF().getPrintInfo());
            Dimension dim = kdfWapper.getKDF().getDesignPrintableArea();
            this.info.setPageHeight(dim.height);
            this.info.setPageWidth(dim.width);
            this.context.virtualPrinterAttrMgr.setDesignPrintableArea(dim);
            this.form = (Form)kdfWapper.getKDF().getForms().iterator().next();
            if (this.form == null) {
                ClientForm.logger.error((Object)"\u65e0\u6cd5\u4eceKDF\u83b7\u53d6Form\u5bf9\u8c61");
                return false;
            }
            KDFHeaderFooterPainter hfpainter = new KDFHeaderFooterPainter(kdfWapper.getKDF(), this.form.getHeaderID(), this.form.getFooterID(), this.printserv.getPrinterAttrManager());
            this.printserv.setHeaderFooterPainter(hfpainter, kdfWapper.getKDF().getPrintInfo().getHeaderMargin(), kdfWapper.getKDF().getPrintInfo().getFooterMargin(), kdfWapper.getKDF());
            this.context.beginDataUpdate();
            this.form.syncSnapshotOutput();
            this.form.getOutputPages().clear();
            PageCollection pc = this.form.getPages();
            for (int i = 0; i < pc.size(); ++i) {
                PageEvent pe = new PageEvent(this, this.index++, pc.get(i));
                this.doObtainPage(pe);
            }
            this.endOutput();
            return true;
        }
        catch (ServiceException e1) {
            logger.error((Object)"Exception occurred.", (Throwable)e1);
        }
        catch (PrintInfoParsingException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
        catch (PrinterNotFoundException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
            KDPrintService.logger.error((Object)" Printer Not Found ");
            WindowUtil.msgboxError((Object)Resources.LOCAL_STR("PrinterNotFound"), (String)"\u8868\u5355\u6d4f\u89c8", null);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread RequestRawPagesAsync(String kdftemplate) throws FileNotFoundException {
        Thread thread;
        FileInputStream is = null;
        try {
            is = new FileInputStream(new File(kdftemplate));
            thread = this.RequestRawPagesAsync(is);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{is});
        return thread;
    }

    public Thread RequestRawPagesAsync(KDF templateKDF) {
        this.setupFormProxy();
        if (templateKDF == null) {
            ClientForm.logger.error((Object)"KDF\u6587\u4ef6/\u6d41\u672a\u8bbe\u7f6e");
            return null;
        }
        this.kdfWapper = new KDFWapper(templateKDF);
        if (this.kdfWapper.getKDF().getPrintInfo().isSnapShot()) {
            this.RetriveRawPagesFromSnapshot(this.kdfWapper);
            return null;
        }
        return this.RequestRawPagesAsync(this.kdfWapper);
    }

    public Thread RequestRawPagesAsync(InputStream kdftemplateStream) {
        this.setupFormProxy();
        if (kdftemplateStream == null) {
            ClientForm.logger.error((Object)"KDF\u6587\u4ef6/\u6d41\u672a\u8bbe\u7f6e");
            return null;
        }
        this.kdfWapper = new KDFWapper(kdftemplateStream, 10000000);
        if (this.kdfWapper.getKDF().getPrintInfo().isSnapShot()) {
            this.RetriveRawPagesFromSnapshot(this.kdfWapper);
            return null;
        }
        return this.RequestRawPagesAsync(this.kdfWapper);
    }

    private Thread RequestRawPagesAsync(KDFWapper kdfWapper) {
        try {
            this.formProxy.addPageEventListener(this);
            this.printserv = (KDPrintService)this.compMgr.lookup("PrintService");
            try {
                logger.debug((Object)"restore print info ...");
                this.printserv.getPrinterAttrManager().restore(kdfWapper.getKDF().getPrintInfo());
            }
            catch (PrinterNotFoundException e) {
                KDPrintService.logger.error((Object)" Printer Not Found ");
                logger.error((Object)"Exception occurred.", (Throwable)e);
                WindowUtil.msgboxError((Object)Resources.LOCAL_STR("PrinterNotFound"), (String)"\u8868\u5355\u6d4f\u89c8", null);
            }
            Dimension dim = kdfWapper.getKDF().getDesignPrintableArea();
            this.info.setPageHeight(dim.height);
            this.info.setPageWidth(dim.width);
            this.context.virtualPrinterAttrMgr.setDesignPrintableArea(dim);
            this.form = (Form)kdfWapper.getKDF().getForms().iterator().next();
            if (this.form == null) {
                ClientForm.logger.error((Object)"\u65e0\u6cd5\u4eceKDF\u83b7\u53d6Form\u5bf9\u8c61");
                return null;
            }
            KDFHeaderFooterPainter hfpainter = new KDFHeaderFooterPainter(kdfWapper.getKDF(), this.form.getHeaderID(), this.form.getFooterID(), this.printserv.getPrinterAttrManager());
            this.printserv.setHeaderFooterPainter(hfpainter, kdfWapper.getKDF().getPrintInfo().getHeaderMargin(), kdfWapper.getKDF().getPrintInfo().getFooterMargin(), kdfWapper.getKDF());
            this.worker = new Thread(this);
            this.worker.setPriority(1);
            this.worker.start();
            return this.worker;
        }
        catch (ServiceException e1) {
            logger.error((Object)"Exception occurred.", (Throwable)e1);
        }
        catch (PrintInfoParsingException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
        return null;
    }

    private void setupFormProxy() {
        FormBrowserConfig config;
        this.formProxy = this.userFormFactory != null ? FormProxy.getUserInstance(this.userFormFactory.getForm()) : ((config = FormBrowserConfManager.getDefaultInstance().getConf()).isRemoteMode() ? FormProxy.getRemoteInstance(config.getTcpUrl()) : FormProxy.getLocalInstance());
    }

    @Override
    public void run() {
        block3: {
            this.context.beginDataUpdate();
            try {
                this.formProxy.setReportParams(this.rptparams);
                this.formProxy.setVariantDataListener(this.vdataListener);
                this.formProxy.setUserFunctionProvider(this.userFuncObj);
                this.formProxy.makeForm(this.info, this.kdfWapper.getKDFData(), this.kdfparams);
                if (Thread.currentThread().isInterrupted()) {
                    this.endOutput();
                    return;
                }
            }
            catch (RuntimeException e) {
                logger.error((Object)"Exception occurred.", (Throwable)e);
                this.context.finishDataUpdate();
                if (0 != JOptionPane.showOptionDialog(this.printserv.getBaseComponent(), Resources.LOCAL_STR("DataRetrivingError"), "Error ", 0, 1, null, null, null)) break block3;
                this.context.closeDocument();
            }
        }
    }

    public void saveSnapShot(OutputStream outStream) {
        this.kdfWapper.getKDF().clearDataSources();
        this.kdfWapper.getKDF().clearForms();
        this.form.syncTemplatePageFromOutput();
        this.form.setUserObject(null);
        this.kdfWapper.getKDF().addForm(this.form);
        this.printserv.getPrinterAttrManager().store(this.kdfWapper.getKDF().getPrintInfo());
        this.kdfWapper.getKDF().getPrintInfo().setSnapShot(true);
        this.kdfWapper.getKDF().save(outStream);
    }

    public Form getForm() {
        return this.form;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doObtainPage(PageEvent e) {
        Page page = e.getPage();
        Object object = this;
        synchronized (object) {
            this.list.add(page);
        }
        object = this.form;
        synchronized (object) {
            this.form.getOutputPages().add(page);
        }
        PageObject pageObj = this.cformPages.appendRawPage(page);
        if (this.context.getViewMode() == 1) {
            this.previewpageCollector.SetupHostPage(pageObj);
        } else {
            this.virtualPageManager.SetupHostPage(pageObj);
        }
        this.context.virtualPrinterAttrMgr.setFormPageHeight(pageObj.height);
        this.context.virtualPrinterAttrMgr.setFormPageWidth(pageObj.width);
        this.context.setDataUpdated(true);
    }

    @Override
    public void endOutput() {
        this.context.finishDataUpdate();
    }

    public PageCollection getRawPages() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getRawPage(int index) {
        DefaultFormPageRetriver defaultFormPageRetriver = this;
        synchronized (defaultFormPageRetriver) {
            return this.list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRawPageCount() {
        DefaultFormPageRetriver defaultFormPageRetriver = this;
        synchronized (defaultFormPageRetriver) {
            return this.list.size();
        }
    }

    public void clear() {
        this.list.clear();
        this.index = 0;
        this.kdfWapper = null;
        this.previewpageCollector.clear();
        this.cformPages.clear();
        this.cformPages.clear();
    }

    public void service(ServiceManager manager) throws ServiceException {
        if (manager == null) {
            throw new ServiceException("FormPageRetriver", "manager is null");
        }
        this.compMgr = manager;
        this.previewpageCollector = (PhysicalPageManager)this.compMgr.lookup("PhysicalPageManager");
        this.context = (ContextOfBrowser)this.compMgr.lookup("ContextOfBrowser");
        this.cformPages = (ClientFormPages)this.compMgr.lookup("ClientFormPages");
        this.virtualPageManager = (PhysicalPageManager)this.compMgr.lookup("VirtualPageManager");
    }

    public void configure(Configuration conf) throws ConfigurationException {
        if (conf == null) {
            throw new ConfigurationException("conf is null");
        }
        String confval = conf.getAttribute("SERVER_TYPE");
        if (confval != null && confval.length() > 0) {
            if (confval.equals(ORM_SERVER)) {
                this.tcpUrl = conf.getAttribute("SERVER_TCPURL");
                if (this.tcpUrl == null || this.tcpUrl.length() == 0) {
                    throw new ConfigurationException("conf is invalid :\u7f3a\u5c11\u670d\u52a1\u5668TCPURL");
                }
            } else if (confval.equals(LOCAL_SERVER)) {
                this.tcpUrl = null;
            } else {
                throw new ConfigurationException("conf is unreconizable");
            }
        }
    }

    public void setKdfPlugins(IServerPluginParam[] params) {
        this.kdfparams = params;
    }

    public void setKdfVariantDataListener(IVariantDataListener listener) {
        this.vdataListener = listener;
    }

    public void setKdfReportParams(HashMap params) {
        this.rptparams = params;
    }

    public void setKdfUserFunctionProvider(Object obj) {
        this.userFuncObj = obj;
    }

    public Thread getWorker() {
        return this.worker;
    }

    public void cancelJob(Thread worker) {
        this.formProxy.cancelJob(worker);
    }

    public KDFWapper getKdfWapper() {
        return this.kdfWapper;
    }

    public void setUserFormFactory(IFormFactory factory) {
        this.userFormFactory = factory;
    }
}

