/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.ContextOfBrowser;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.LayerManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.PhysicalPage;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.PhysicalPageManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.clientcore.VisibleManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormContainerObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.FormObject;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.render.ObjectRender;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.render.RenderNotFoundException;
import com.kingdee.bos.ctrl.kdf.formbrowser2.formobjects.render.RenderUtilManager;
import com.kingdee.bos.ctrl.kdf.formbrowser2.gui.DefaultSelectionRegion;
import com.kingdee.bos.ctrl.kdf.formbrowser2.gui.ISelectionRegion;
import com.kingdee.bos.ctrl.kdf.printprovider.IPainter;
import com.kingdee.bos.ctrl.kdf.printprovider.PrinterAttrManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class FormPainter
implements IPainter {
    private static Logger logger = LogUtil.getPackageLogger(FormPainter.class);
    private PhysicalPageManager phyPageMgr;
    private LayerManager layermgr;
    private RenderUtilManager renderUtilMgr;
    private VisibleManager visibleMgr;
    private boolean enableBackground = true;
    private boolean enableForeground = true;
    private boolean enableContent = true;
    private boolean enableBorder = true;
    ContextOfBrowser contextOfBrowser;

    public FormPainter(ContextOfBrowser cob, LayerManager layermgr, VisibleManager visibleMgr) {
        this.contextOfBrowser = cob;
        this.layermgr = layermgr;
        this.visibleMgr = visibleMgr;
        this.renderUtilMgr = RenderUtilManager.getInstance();
    }

    public boolean isAvailable() {
        return this.phyPageMgr != null;
    }

    public void setAvailable(PhysicalPageManager ppc) {
        this.phyPageMgr = ppc != null ? ppc : null;
    }

    public void drawPhysicsPage(PhysicalPage phypage, Graphics2D g2) {
        try {
            Shape savedClip = g2.getClip();
            PrinterAttrManager attrmgr = this.contextOfBrowser.getPrinterAttrMgr();
            Rectangle clip = new Rectangle((int)attrmgr.getBodyX(), (int)attrmgr.getBodyY(), (int)attrmgr.getBodyW() + 4, phypage.getAdjustedHeight() + 2);
            g2.setClip(clip.intersection(savedClip.getBounds()));
            if (phypage.size() > 0) {
                this.drawObject(phypage.get(0), phypage, g2);
            }
            g2.setClip(savedClip);
        }
        catch (RenderNotFoundException e) {
            logger.error((Object)"Exception occurred.", (Throwable)e);
        }
    }

    public void drawObject(FormObject formObj, PhysicalPage phypage, Graphics2D g2) throws RenderNotFoundException {
        boolean isVisible = this.isObjVisible(formObj);
        if (isVisible) {
            ObjectRender render = this.renderUtilMgr.getRenderForClass(formObj.getClass());
            PhysicalPage nextPage = phypage.get(0).getFirstOwnerPage();
            int sumHeight = 0;
            int pageIdxY = -1;
            while (nextPage.pageIdxY != phypage.pageIdxY) {
                if (nextPage.pageIdxY == pageIdxY) {
                    nextPage = (PhysicalPage)nextPage.next();
                    continue;
                }
                pageIdxY = nextPage.pageIdxY;
                sumHeight += nextPage.getAdjustedHeight();
                nextPage = (PhysicalPage)nextPage.next();
            }
            PrinterAttrManager attrmgr = this.contextOfBrowser.getPrinterAttrMgr();
            int xoff = -((int)((float)(-(nextPage.getAdjustedWidth() * phypage.pageIdxX)) + attrmgr.getBodyX()));
            int yoff = -(-sumHeight + (int)attrmgr.getBodyY());
            if (this.enableBackground) {
                render.drawBackground(g2, formObj, xoff, yoff, 1.0f);
            }
            if (this.enableForeground) {
                render.drawForeground(g2, formObj, xoff, yoff, 1.0f);
            }
            if (this.enableContent) {
                render.drawObject(g2, formObj, xoff, yoff, 1.0f);
            }
            if (this.enableBorder) {
                render.drawBorder(g2, formObj, xoff, yoff, 1.0f);
            }
            ISelectionRegion selRegion = null;
            if (phypage.selectionRegoins.containsKey(formObj)) {
                selRegion = (ISelectionRegion)phypage.selectionRegoins.get(formObj);
                selRegion.setRect(formObj.getZoomedDim(formObj.x) - xoff, formObj.getZoomedDim(formObj.y) - yoff, formObj.getZoomedDim(formObj.width), formObj.getZoomedDim(formObj.height));
            } else {
                phypage.selectionRegoins.put(formObj, new DefaultSelectionRegion(formObj.getZoomedDim(formObj.x) - xoff, formObj.getZoomedDim(formObj.y) - yoff, formObj.getZoomedDim(formObj.width), formObj.getZoomedDim(formObj.height), formObj, phypage));
            }
        }
        if (formObj instanceof FormContainerObject) {
            Iterator itr = ((FormContainerObject)formObj).getChildren().iterator();
            while (itr.hasNext()) {
                this.drawObject((FormObject)itr.next(), phypage, g2);
            }
        }
    }

    private boolean isObjVisible(FormObject formObj) {
        boolean isVisible = true;
        if (!"".equals(formObj.getLayer()) && !this.layermgr.isLayerOn(formObj.getLayer())) {
            isVisible = false;
        }
        if (!this.visibleMgr.isFormObjectVisible(formObj)) {
            isVisible = false;
        }
        return isVisible;
    }

    public boolean isObjectOnPage(FormObject formObj, PhysicalPage page) {
        int sumHeight = 0;
        int size = this.phyPageMgr.count();
        for (int i = 0; i < size; ++i) {
            sumHeight += ((PhysicalPage)this.phyPageMgr.get(i)).getAdjustedHeight();
            if (this.phyPageMgr.get(i) == page) break;
        }
        return false;
    }

    @Override
    public int paintBody(Graphics2D g2, int index) {
        if (!this.isAvailable()) {
            return 1;
        }
        if (index > this.phyPageMgr.count() - 1 || index < 0) {
            return 1;
        }
        PrinterAttrManager attrmgr = this.contextOfBrowser.getPrinterAttrMgr();
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, attrmgr.getPaperWidth(), attrmgr.getPaperHeight()));
        Shape saveClip = g2.getClip();
        Rectangle2D.Float clip = new Rectangle2D.Float(attrmgr.getBodyX() - 1.0f, attrmgr.getBodyY() - 1.0f, attrmgr.getBodyW() + 4.0f, attrmgr.getBodyH() + 2.0f);
        g2.setClip(clip);
        PhysicalPage phypage = (PhysicalPage)this.phyPageMgr.get(index);
        this.drawPhysicsPage(phypage, g2);
        g2.setClip(saveClip);
        return 0;
    }

    @Override
    public int paintFooter(Graphics2D g2, int index) {
        return 0;
    }

    @Override
    public int paintHeader(Graphics2D g2, int index) {
        return 0;
    }

    public boolean isEnableBackground() {
        return this.enableBackground;
    }

    public boolean isEnableBorder() {
        return this.enableBorder;
    }

    public boolean isEnableContent() {
        return this.enableContent;
    }

    public boolean isEnableForeground() {
        return this.enableForeground;
    }

    public void setEnableBackground(boolean b) {
        this.enableBackground = b;
    }

    public void setEnableBorder(boolean b) {
        this.enableBorder = b;
    }

    public void setEnableContent(boolean b) {
        this.enableContent = b;
    }

    public void setEnableForeground(boolean b) {
        this.enableForeground = b;
    }
}

