/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.kdprint;

import com.kingdee.bos.ctrl.kdf.kdprint.KDPrintable;
import com.kingdee.bos.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.bos.ctrl.kdf.kdprint.MyGraphics2D;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import org.jfree.pixie.g2recorder.G2Recorder;

public class PageGraphicsProxy
implements Printable {
    int cacheSize = 40;
    ArrayList recorderList = new ArrayList(this.cacheSize);
    int startAtPage = 0;
    protected KDPrintable printable;
    protected KDPrintbase base;
    boolean detectingGraphics = false;
    FontRenderContext fontRenderContext = null;
    ArrayList g2Recorders = new ArrayList(this.cacheSize);
    protected static final int PAINT_MODE_MM = 1;
    protected static final int PAINT_MODE_INCH_DIV_72 = 2;
    protected int paintUnitMode = 2;

    protected PageGraphicsProxy(KDPrintable kdprintable, KDPrintbase printbase) {
        this.printable = kdprintable;
        this.base = printbase;
    }

    G2Recorder getPageGraphics(int index) {
        if (index >= this.startAtPage && index < this.startAtPage + this.cacheSize) {
            return (G2Recorder)this.recorderList.get(index - this.startAtPage);
        }
        return null;
    }

    private int print1(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Rectangle area = new Rectangle((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        KDPrintable.AreaInfo areaInfo = new KDPrintable.AreaInfo();
        areaInfo.area = area;
        int result = this.printable.print(graphics, areaInfo, pageIndex);
        return result;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.detectingGraphics) {
            this.fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
            return 1;
        }
        if (this.getPaintUnitMode() == 2) {
            int result = this.print1(graphics, pageFormat, pageIndex);
            return result;
        }
        return this.printInMM(graphics, null, pageIndex);
    }

    public int printInMM(Graphics graphics, KDPrintable.AreaInfo areaInfo, int pageIndex) {
        G2Recorder recorder;
        int result = 0;
        double scale = 2.834645669291339;
        G2Recorder g2Recorder = recorder = this.g2Recorders.size() > pageIndex ? (G2Recorder)this.g2Recorders.get(pageIndex) : null;
        if (recorder == null) {
            recorder = new G2Recorder();
            try {
                KDPrintable.AreaInfo areaI = new KDPrintable.AreaInfo();
                areaI.area.x = (int)this.base.getPrintPage().getLeftEdge();
                areaI.area.y = (int)this.base.getPrintPage().getTopEdge();
                areaI.area.width = (int)this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaW();
                areaI.area.height = (int)this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaH();
                result = this.printable.print((Graphics)recorder, areaI, pageIndex);
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
            this.g2Recorders.add(pageIndex, recorder);
        }
        scale = this.base.getPageLayoutManager().getScale() * 72.0 / 25.4;
        int posIndex = pageIndex % (this.base.getPageLayoutManager().getPageCols() * this.base.getPageLayoutManager().getPageRows());
        ((Graphics2D)graphics).translate((int)this.base.getPageLayoutManager().getPosOfPages()[posIndex].getX(), (int)this.base.getPageLayoutManager().getPosOfPages()[posIndex].getY());
        ((Graphics2D)graphics).scale(scale, scale);
        MyGraphics2D myg2 = new MyGraphics2D((Graphics2D)graphics);
        recorder.getStore().draw((Graphics2D)myg2, null);
        ((Graphics2D)graphics).scale(1.0 / scale, 1.0 / scale);
        ((Graphics2D)graphics).translate(-((int)this.base.getPageLayoutManager().getPosOfPages()[posIndex].getX()), -((int)this.base.getPageLayoutManager().getPosOfPages()[posIndex].getY()));
        return result;
    }

    protected void print4Preview(Graphics graphics, KDPrintable.AreaInfo areaInfo, int pageIndex, double previewScale) {
        G2Recorder recorder;
        if (this.getPaintUnitMode() == 1) {
            this.printInMM(graphics, areaInfo, pageIndex);
            return;
        }
        double scale = previewScale * (double)areaInfo.area.height / ((double)(this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaH() * 72.0f) / 25.4);
        G2Recorder g2Recorder = recorder = this.g2Recorders.size() > pageIndex ? (G2Recorder)this.g2Recorders.get(pageIndex) : null;
        if (recorder != null) {
            System.out.print(" **** Reuse last Graphics **** ");
        } else {
            System.out.print(" **** Draw new Graphics **** ");
            recorder = new G2Recorder();
            try {
                KDPrintable.AreaInfo areaI = new KDPrintable.AreaInfo();
                areaI.area.x = areaInfo.area.x;
                areaI.area.y = areaInfo.area.y;
                areaI.area.width = (int)((double)(this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaW() * 72.0f) / 25.4);
                areaI.area.height = (int)((double)(this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaH() * 72.0f) / 25.4);
                this.printable.print((Graphics)recorder, areaI, pageIndex);
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
            this.g2Recorders.add(pageIndex, recorder);
        }
        ((Graphics2D)graphics).scale(scale, scale);
        MyGraphics2D myg2 = new MyGraphics2D((Graphics2D)graphics);
        recorder.getStore().draw((Graphics2D)myg2, null);
        ((Graphics2D)graphics).scale(1.0 / scale, 1.0 / scale);
    }

    protected void print4Preview2(Graphics graphics, KDPrintable.AreaInfo areaInfo, int pageIndex, double previewScale) {
        G2Recorder recorder;
        if (this.getPaintUnitMode() == 1) {
            this.printInMM(graphics, areaInfo, pageIndex);
            return;
        }
        double scale = previewScale * (double)areaInfo.area.height / ((double)(this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaH() * 72.0f) / 25.4);
        G2Recorder g2Recorder = recorder = this.g2Recorders.size() > pageIndex ? (G2Recorder)this.g2Recorders.get(pageIndex) : null;
        if (recorder != null) {
            System.out.print(" **** Reuse last Graphics **** ");
        } else {
            System.out.print(" **** Draw new Graphics **** ");
            recorder = new G2Recorder();
            try {
                KDPrintable.AreaInfo areaI = new KDPrintable.AreaInfo();
                areaI.area.x = areaInfo.area.x;
                areaI.area.y = areaInfo.area.y;
                areaI.area.width = (int)((double)(this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaW() * 72.0f) / 25.4);
                areaI.area.height = (int)((double)(this.base.getPrinterAttrManager().getPrintPage().getPrintableAreaH() * 72.0f) / 25.4);
                this.printable.print((Graphics)recorder, areaI, pageIndex);
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
            this.g2Recorders.add(pageIndex, recorder);
        }
        ((Graphics2D)graphics).scale(scale, scale);
        MyGraphics2D myg2 = new MyGraphics2D((Graphics2D)graphics);
        recorder.getStore().draw((Graphics2D)myg2, null);
        ((Graphics2D)graphics).scale(1.0 / scale, 1.0 / scale);
    }

    protected void FlushPageGraphics() {
        for (int i = 0; i < this.g2Recorders.size(); ++i) {
            this.g2Recorders.set(i, null);
        }
    }

    protected KDPrintable getPrintable() {
        return this.printable;
    }

    public int getPaintUnitMode() {
        return this.paintUnitMode;
    }

    public void setPaintUnitMode(int i) {
        this.paintUnitMode = i;
    }

    public FontRenderContext getFontRenderContext() {
        DocPrintJob pj = this.base.selServ.createPrintJob();
        this.detectingGraphics = true;
        try {
            SimpleDoc doc = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            pj.print(doc, null);
        }
        catch (PrintException printException) {
            // empty catch block
        }
        this.detectingGraphics = false;
        return this.fontRenderContext;
    }
}

