/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.core;

import com.kingdee.bos.ctrl.excel.core.ColHeader;
import com.kingdee.bos.ctrl.excel.core.Corner;
import com.kingdee.bos.ctrl.excel.core.IActionLoader;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.core.OutlineGroupColHeader;
import com.kingdee.bos.ctrl.excel.core.OutlineGroupColTagBar;
import com.kingdee.bos.ctrl.excel.core.OutlineGroupCorner;
import com.kingdee.bos.ctrl.excel.core.OutlineGroupRowHeader;
import com.kingdee.bos.ctrl.excel.core.OutlineGroupRowTagBar;
import com.kingdee.bos.ctrl.excel.core.RowHeader;
import com.kingdee.bos.ctrl.excel.core.SpreadAutoTestProxy;
import com.kingdee.bos.ctrl.excel.core.SpreadUI;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.core.TabbedBar;
import com.kingdee.bos.ctrl.excel.core.Table;
import com.kingdee.bos.ctrl.excel.core.event.KDSPositionChangeEvent;
import com.kingdee.bos.ctrl.excel.core.event.KDSPositionChangeListener;
import com.kingdee.bos.ctrl.excel.frame.LayoutCell;
import com.kingdee.bos.ctrl.excel.frame.MultiViewPane;
import com.kingdee.bos.ctrl.excel.frame.MvpLayoutInfoManager;
import com.kingdee.bos.ctrl.excel.frame.MvpViewController;
import com.kingdee.bos.ctrl.excel.impl.facade.PopupListButton;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedSpanArray;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.im.InputMethodRequests;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import sun.awt.im.InputMethodContext;

public final class KDSpread
extends MultiViewPane {
    public static final int VIEW_CORNER = 0;
    public static final int VIEW_COLHEADER = 1;
    public static final int VIEW_ROWHEADER = 2;
    public static final int VIEW_TABLE = 3;
    public static final int VIEW_OUTLINEGROUP_COLHEADER = 4;
    public static final int VIEW_OUTLINEGROUP_ROWHEADER = 5;
    public static final int VIEW_OUTLINEGROUP_COLTAGBAR = 6;
    public static final int VIEW_OUTLINEGROUP_ROWTAGBAR = 7;
    public static final int VIEW_OUTLINEGROUP_CORNER = 8;
    private Book _book;
    private IActionLoader _actionLoader;
    private ICellDisplayProvider _cellDisplayProvider;
    private IExtRender[] _renders;
    private IMouseController[] _mctrls;
    private int _activeVIndex;
    private int _activeHIndex;
    private TabbedBar _tabbedBar;
    private KDSInnerChangeHandler _listener;
    private boolean _focusLockedCells;
    private boolean editable = true;
    private int screenHeight;
    private int screenWidth;
    private SpreadAutoTestProxy _atProxy;

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public KDSpread() {
        this.screenHeight = GraphicsEnvironment.isHeadless() ? 1080 : Toolkit.getDefaultToolkit().getScreenSize().height;
        this.screenWidth = GraphicsEnvironment.isHeadless() ? 1920 : Toolkit.getDefaultToolkit().getScreenSize().width;
        this.init();
    }

    public KDSpread(Book book) {
        this.screenHeight = GraphicsEnvironment.isHeadless() ? 1080 : Toolkit.getDefaultToolkit().getScreenSize().height;
        this.screenWidth = GraphicsEnvironment.isHeadless() ? 1920 : Toolkit.getDefaultToolkit().getScreenSize().width;
        this.init();
        this.setBook(book);
    }

    private void init() {
        this._listener = new KDSInnerChangeHandler();
        this._tabbedBar = new TabbedBar(this);
        this.setViewController(new SpreadViewController(this));
        this.addPositionChangeListener(new KDSPositionChangeHandler());
        this._mctrls = new IMouseController[9];
        this._renders = new IExtRender[9];
        this.setPreferredSize(new Dimension(200, 183));
    }

    @Override
    public void updateUI() {
        this.setUI(SpreadUI.createUI(this));
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return new InputMethodContext();
    }

    public void setFoucsLockedCells(boolean b) {
        this._focusLockedCells = b;
    }

    public boolean isFoucsLockedCells() {
        return this._focusLockedCells;
    }

    public void setCellDisplayProvider(ICellDisplayProvider cellValueProvider) {
        this._cellDisplayProvider = cellValueProvider;
    }

    public ICellDisplayProvider getCellDisplayProvider() {
        return this._cellDisplayProvider;
    }

    public IActionLoader getActionLoader() {
        return this._actionLoader;
    }

    public void setActionLoader(IActionLoader actionLoader) {
        this._actionLoader = actionLoader;
    }

    public void setMouseController(int viewType, IMouseController mouseCtrl) {
        this._mctrls[viewType] = mouseCtrl;
    }

    public IMouseController getMouseController(int viewType) {
        if (viewType == 8) {
            return this._mctrls[0];
        }
        return this._mctrls[viewType];
    }

    public IExtRender getExtRender(int viewType) {
        return this._renders[viewType];
    }

    public void setExtRender(int viewType, IExtRender render) {
        this._renders[viewType] = render;
    }

    public Book getBook() {
        return this._book;
    }

    public void setBook(Book newbook) {
        if (newbook != this._book) {
            if (this._book != null) {
                this._book.removeSheetChangeListener(this._listener);
                this._book.removeBookChangeListener(this._listener);
                this._book.removeSheetPropertyChangeListener(this._listener);
                this._book.removeBookPropertyChangeListener(this._listener);
                this._book.removeGraphChangeListener(this._listener);
            }
            this._book = newbook;
            if (this._book != null) {
                this._book.addSheetChangeListener(this._listener);
                this._book.addBookChangeListener(this._listener);
                this._book.addSheetPropertyChangeListener(this._listener);
                this._book.addBookPropertyChangeListener(this._listener);
                this._book.addGraphChangeListener(this._listener);
                int count = this._book.getSheetCount();
                if (count <= 0) {
                    return;
                }
                this.loadViewInfo();
            }
        }
    }

    public void setActiveView(SpreadView activeView) {
        if (activeView != null) {
            this.setActiveView(KDSpread.getComponentIndex(activeView, "VViewIndex"), KDSpread.getComponentIndex(activeView, "HViewIndex"));
        }
    }

    private void setActiveView(int vIndex, int hIndex) {
        this._activeVIndex = Math.max(2, vIndex);
        this._activeHIndex = Math.max(2, hIndex);
        this._activeVIndex = Math.min(this.getVerticalCount() - 1, this._activeVIndex);
        this._activeHIndex = Math.min(this.getHorizonCount() - 1, this._activeHIndex);
        this._book.getActiveSheet().getSheetOption().getViewSplitInfo().setActivePane(this.convertToPaneIndex(this._activeVIndex, this._activeHIndex));
        this.requestFocus();
    }

    public SpreadView getActiveView() {
        return (SpreadView)this.getView(this._activeVIndex, this._activeHIndex);
    }

    public SpreadView getActiveNextHView() {
        return (SpreadView)this.getView(this._activeVIndex, this._activeHIndex + 1);
    }

    public void autoResize() {
        SpreadView view;
        int vCount = this.getVerticalCount();
        int hCount = this.getHorizonCount();
        boolean needReloadView = false;
        for (int vIndex = 0; vIndex < vCount; ++vIndex) {
            for (int hIndex = 0; hIndex < hCount; ++hIndex) {
                SpreadView view2 = (SpreadView)this.getView(vIndex, hIndex);
                Dimension d = view2.getPreferredSize();
                if (d.equals(view2.getSize())) continue;
                view2.setSize(d);
                if (vIndex >= 2 || hIndex >= 2) continue;
                needReloadView = true;
            }
        }
        int vFix = this.getFixVerticalCount();
        int hFix = this.getFixHorizonCount();
        for (int vIndex = vFix; vIndex < vCount; ++vIndex) {
            view = (SpreadView)this.getView(vIndex, 0);
            int row = view.getFirstRow();
            this.setViewRow(view, row);
        }
        for (int hIndex = hFix; hIndex < hCount; ++hIndex) {
            view = (SpreadView)this.getView(0, hIndex);
            int col = view.getFirstCol();
            this.setViewCol(view, col);
        }
        if (this.isFreezed() && needReloadView) {
            this.loadViewInfo();
        }
        this.repaint();
    }

    public void repaintPartial(Sheet sheet, SortedCellBlockArray blocks, boolean hasSel, boolean hasActive) {
        this._listener.doPartRepaint(sheet, blocks, hasSel, hasActive);
    }

    void addPositionChangeListener(KDSPositionChangeListener l) {
        this.listenerList.add(KDSPositionChangeListener.class, l);
    }

    void removePositionChangeListener(KDSPositionChangeListener l) {
        this.listenerList.remove(KDSPositionChangeListener.class, l);
    }

    public void setViewRowCol(SpreadView view, int row, int col) {
        this.setViewCol(view, col);
        this.setViewRow(view, row);
    }

    public void setViewCol(SpreadView view, int col) {
        int hIndex = KDSpread.getComponentIndex(view, "HViewIndex");
        if (this.isFreezed(0) && hIndex == this.getFixHorizonCount()) {
            return;
        }
        Sheet sheet = this._book.getActiveSheet();
        int value = SheetBaseMath.getColX(sheet, col);
        this.setViewPosition(0, hIndex, value);
    }

    public void setViewRow(SpreadView view, int row) {
        int vIndex = KDSpread.getComponentIndex(view, "VViewIndex");
        if (this.isFreezed(1) && vIndex == this.getFixVerticalCount()) {
            return;
        }
        Sheet sheet = this._book.getActiveSheet();
        int value = SheetBaseMath.getRowY(sheet, row);
        this.setViewPosition(1, vIndex, value);
    }

    public TabbedBar getTabbedBar() {
        return this._tabbedBar;
    }

    public void scrollActiveCellVisible() {
        Sheet sheet = this._book.getActiveSheet();
        this.getActiveView().scrollCellVisible(sheet.getActiveRow(), sheet.getActiveCol());
    }

    public void scrollCellVisible(int row, int col) {
        this.getActiveView().scrollCellVisible(row, col);
    }

    public void setTabbedBarSelectMode(byte mode) {
        this._tabbedBar.setSelectMode(mode);
    }

    @Override
    protected void setViewPosition(int orientation, int index, int newValue) {
        if (orientation == 0) {
            SpreadView view = (SpreadView)this.getViewManager().getView(0, index);
            int oldCol = view.getFirstCol();
            super.setViewPosition(0, index, newValue);
            int col = view.getFirstCol();
            if (oldCol != col) {
                this.firePositionChange(orientation, index, oldCol, col);
            }
        } else {
            SpreadView view = (SpreadView)this.getViewManager().getView(index, 0);
            int oldRow = view.getFirstRow();
            super.setViewPosition(1, index, newValue);
            int row = view.getFirstRow();
            if (oldRow != row) {
                this.firePositionChange(orientation, index, oldRow, row);
            }
        }
    }

    private void updateActiveViewAfterSplit() {
        Sheet sheet = this._book.getActiveSheet();
        int row = sheet.getActiveRow();
        int col = sheet.getActiveCol();
        ViewSplitInfo vi = sheet.getSheetOption().getViewSplitInfo();
        int newVIndex = this._activeVIndex;
        int newHIndex = this._activeHIndex;
        if (this.isFreezed(1)) {
            newVIndex = row >= vi.getRowSplit() ? this.getVerticalCount() - 1 : this.getVerticalCount() - 2;
        }
        if (this.isFreezed(0)) {
            newHIndex = col >= vi.getColSplit() ? this.getHorizonCount() - 1 : this.getHorizonCount() - 2;
        }
        this.setActiveView(newVIndex, newHIndex);
    }

    private void loadViewInfo() {
        int screenY;
        this.removeAll();
        Sheet sheet = this._book.getActiveSheet();
        ViewSplitInfo vs = sheet.getSheetOption().getViewSplitInfo();
        sheet.setSpilteActiveRow(vs.getRowSplit());
        sheet.setSpilteActiveCol(vs.getColSplit());
        int fr = vs.getFirstRow();
        int fc = vs.getFirstCol();
        int fr2 = vs.getFirstRow2();
        int fc2 = vs.getFirstCol2();
        this.reset();
        this.setVerticalCount(3);
        this.setHorizonCount(3);
        this.loadComps();
        this.loadOriginalViewPosition(fr, fc);
        boolean isFreeze = vs.isFreezed();
        int rowSplit = vs.getRowSplit();
        int colSplit = vs.getColSplit();
        if (isFreeze && rowSplit > 0) {
            rowSplit = ((SpreadViewController)this.getViewController()).convertPosition(SheetBaseMath.getRowY(sheet, rowSplit), 1, true);
        }
        if (isFreeze && colSplit > 0) {
            colSplit = ((SpreadViewController)this.getViewController()).convertPosition(SheetBaseMath.getColX(sheet, colSplit), 0, true);
        }
        boolean unFreeze = true;
        SpreadViewController svc = (SpreadViewController)this.getViewController();
        int screenX = this.isShowing() ? this.getLocationOnScreen().x : 0;
        int n = screenY = this.isShowing() ? this.getLocationOnScreen().y : 120;
        if (rowSplit > 0 && rowSplit < this.screenHeight - screenY - sheet.getColHeaderHeight() - 65) {
            svc.splitImpl(1, this.getFixVerticalCount(), rowSplit, isFreeze);
            unFreeze = false;
        }
        if (colSplit > 0 && colSplit < this.screenWidth - screenX - sheet.getRowHeaderWidth() - 5) {
            svc.splitImpl(0, this.getFixHorizonCount(), colSplit, isFreeze);
            unFreeze = false;
        }
        if (unFreeze) {
            this.unFreeze();
        }
        MvpLayoutInfoManager lim = this.getLayoutInfoManager();
        lim.setHSplitButtonVisible(!this.isFreezed() && !this.isSplited(0, 1));
        lim.setVSplitButtonVisible(!this.isFreezed() && !this.isSplited(1, 1));
        this.loadSplitViewPosition(fr2, fc2);
        int paneIndex = vs.getActivePane();
        this.setActiveView(this.convertToVIndex(paneIndex), this.convertToHIndex(paneIndex));
        this.validate();
    }

    private void loadOriginalViewPosition(int fr, int fc) {
        Point p;
        JViewport vp;
        int i;
        Sheet sheet = this._book.getActiveSheet();
        int x = SheetBaseMath.getColX(sheet, fc);
        int y = SheetBaseMath.getRowY(sheet, fr);
        int hCount = this.getHorizonCount();
        int vCount = this.getVerticalCount();
        int hFix = this.getFixHorizonCount();
        int vFix = this.getFixVerticalCount();
        for (i = 0; i < hCount; ++i) {
            vp = this.getViewManager().getViewport(vFix, i);
            p = vp.getViewPosition();
            p.y = y;
            vp.setViewPosition(p);
        }
        for (i = 0; i < vCount; ++i) {
            vp = this.getViewManager().getViewport(i, hFix);
            p = vp.getViewPosition();
            p.x = x;
            vp.setViewPosition(p);
        }
    }

    private void loadSplitViewPosition(int fr2, int fc2) {
        int vCount = this.getVerticalCount();
        int hCount = this.getHorizonCount();
        int hMax = this.getMaxHoriCount();
        int vMax = this.getMaxVertCount();
        if (vCount == vMax) {
            this.setViewRow((SpreadView)this.getView(vMax - 1, 0), fr2);
        }
        if (hCount == hMax) {
            this.setViewCol((SpreadView)this.getView(0, hMax - 1), fc2);
        }
    }

    private int convertToHIndex(int paneIndex) {
        int index = paneIndex < 2 ? 3 : 2;
        return index;
    }

    private int convertToVIndex(int paneIndex) {
        int index = paneIndex % 2 == 1 ? 2 : 3;
        return index;
    }

    private int convertToPaneIndex(int vIndex, int hIndex) {
        return 9 - 2 * hIndex - vIndex;
    }

    private void firePositionChange(int orientation, int viewIndex, int oldValue, int newValue) {
        EventListener[] listeners = this.getListeners(KDSPositionChangeListener.class);
        KDSPositionChangeEvent event = new KDSPositionChangeEvent(this, orientation, viewIndex, oldValue, newValue);
        for (int i = listeners.length - 1; i >= 0; --i) {
            ((KDSPositionChangeListener)listeners[i]).positionChanged(event);
        }
    }

    void setHeaderVisible(boolean isVisible) {
        this.getLayoutInfoManager().setLayoutVisible(0, 0, isVisible);
        this.getLayoutInfoManager().setLayoutVisible(1, 0, isVisible);
    }

    int getHscrollBarValue() {
        return this._scrollBarM.getHScrollBar(this.getHorizonCount() - 1).getValue();
    }

    int getVscrollBarValue() {
        return this._scrollBarM.getVScrollBar(this.getVerticalCount() - 1).getValue();
    }

    void setHscrollBarValue(int value) {
        this._scrollBarM.getHScrollBar(this.getHorizonCount() - 1).setValue(value);
    }

    void setVscrollBarValue(int value) {
        this._scrollBarM.getVScrollBar(this.getVerticalCount() - 1).setValue(value);
    }

    public SpreadAutoTestProxy getAutoTestProxy() {
        if (this._atProxy == null) {
            this._atProxy = new SpreadAutoTestProxy(this);
        }
        return this._atProxy;
    }

    public int getFirstCol() {
        return this.getActiveView().getFirstCol();
    }

    public int getEndCol() {
        return this.getActiveView().getEndCol();
    }

    public int getColumnCount() {
        return this.getEndCol();
    }

    public String getColumnKey(int col) {
        String name = "";
        if (col < this.getColumnCount()) {
            name = Sheet.getColumnName(col, 0, true, false);
        }
        return name;
    }

    private class KDSInnerChangeHandler
    implements SheetChangeListener,
    BookChangeListener,
    SheetPropertyChangeListener,
    BookPropertyChangeListener,
    GraphChangeListener {
        private KDSInnerChangeHandler() {
        }

        @Override
        public void changed(SheetChangeEvent e) {
            if (KDSpread.this.getBook().getActiveSheet() != e.getSheet()) {
                return;
            }
            if (e.hasState(SheetChangeEvent.Changed_Selection | SheetChangeEvent.Changed_SelectionActive)) {
                if (e.hasState(SheetChangeEvent.Changed_SelectionActive)) {
                    KDSpread.this.updateActiveViewAfterSplit();
                }
                this.doPartRepaint(e.getSheet(), e.getChangedBlocks(), e.hasState(SheetChangeEvent.Changed_Selection), e.hasState(SheetChangeEvent.Changed_SelectionActive));
            } else {
                if (e.hasState(SheetChangeEvent.Changed_Delete | SheetChangeEvent.Changed_Insert | SheetChangeEvent.Changed_Resize | SheetChangeEvent.Changed_Sheet_Scale | SheetChangeEvent.Changed_GroupLevel | SheetChangeEvent.Changed_UndoRedo | SheetChangeEvent.Changed_Undo | SheetChangeEvent.Changed_Redo)) {
                    KDSpread.this.autoResize();
                    this.splitChanged(e);
                    return;
                }
                if (e.hasState(SheetChangeEvent.Changed_Style)) {
                    this.splitChanged(e);
                    SortedCellBlockArray sa = new SortedCellBlockArray();
                    sa.insert(CellBlock.getNewCellBlock(0, 0, 1048575, 16383));
                    this.doPartRepaint(e.getSheet(), sa, false, false);
                    return;
                }
                if (e.hasState(SheetChangeEvent.Changed_RangeSelect)) {
                    KDSpread.this.scrollActiveCellVisible();
                }
                if (e.getChangedBlocks() != null) {
                    this.doPartRepaint(e.getSheet(), e.getChangedBlocks(), false, false);
                }
            }
        }

        public void splitChanged(SheetChangeEvent e) {
            Sheet sheet = e.getSheet();
            ViewSplitInfo info = sheet.getSheetOption().getViewSplitInfo();
            if (info != null && info.isFreezed()) {
                int hValue = KDSpread.this.getHscrollBarValue();
                int VValue = KDSpread.this.getVscrollBarValue();
                if (e.getChangedStates() == SheetChangeEvent.Changed_Resize || e.getChangedStates() == (SheetChangeEvent.Changed_Resize | SheetChangeEvent.Changed_UndoRedo)) {
                    this.updateFreeze(sheet, info.getRowSplit(), info.getColSplit());
                } else if (e.getChangedStates() == SheetChangeEvent.Changed_Insert || e.getChangedStates() == (SheetChangeEvent.Changed_Delete | SheetChangeEvent.Changed_Undo) || e.getChangedStates() == (SheetChangeEvent.Changed_Insert | SheetChangeEvent.Changed_Redo)) {
                    this.insertChange(sheet, info, e);
                } else if (e.getChangedStates() == SheetChangeEvent.Changed_Delete || e.getChangedStates() == (SheetChangeEvent.Changed_Insert | SheetChangeEvent.Changed_Undo) || e.getChangedStates() == (SheetChangeEvent.Changed_Delete | SheetChangeEvent.Changed_Redo)) {
                    this.deleteChange(sheet, info, e);
                } else if (e.getChangedStates() == (SheetChangeEvent.Changed_Style | SheetChangeEvent.Changed_Content) || e.getChangedStates() == (SheetChangeEvent.Changed_Style | SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_UndoRedo)) {
                    this.updateFreeze(sheet, info.getRowSplit(), info.getColSplit());
                }
                KDSpread.this.setHscrollBarValue(hValue);
                KDSpread.this.setVscrollBarValue(VValue);
            }
        }

        private void deleteChange(Sheet sheet, ViewSplitInfo info, SheetChangeEvent e) {
            if (e.getChangedBlocks().getBounds().isCol()) {
                int delCount = this.splitOffset(e.getChangedBlocks().toColumnSpans(), info.getColSplit());
                this.updateFreeze(sheet, info.getRowSplit(), info.getColSplit() - delCount);
            } else if (e.getChangedBlocks().getBounds().isRow()) {
                int delCount = this.splitOffset(e.getChangedBlocks().toRowSpans(), info.getRowSplit());
                this.updateFreeze(sheet, info.getRowSplit() - delCount, info.getColSplit());
            }
        }

        private void insertChange(Sheet sheet, ViewSplitInfo info, SheetChangeEvent e) {
            if (e.getChangedBlocks().getBounds().isCol()) {
                int insCount = this.splitOffset(e.getChangedBlocks().toColumnSpans(), info.getColSplit());
                this.updateFreeze(sheet, info.getRowSplit(), info.getColSplit() + insCount);
            } else if (e.getChangedBlocks().getBounds().isRow()) {
                int insCount = this.splitOffset(e.getChangedBlocks().toRowSpans(), info.getRowSplit());
                this.updateFreeze(sheet, info.getRowSplit() + insCount, info.getColSplit());
            }
        }

        private int splitOffset(SortedSpanArray span, int split) {
            int count = 0;
            int l = span.size();
            for (int i = 0; i < l; ++i) {
                int j;
                Span sp = (Span)span.get(i);
                for (j = sp.getStart(); j < split && j <= sp.getEnd(); ++j) {
                }
                count += j - sp.getStart();
            }
            return count;
        }

        private void updateFreeze(Sheet sheet, int activeRow, int activeCol) {
            int ar = sheet.getActiveRow();
            int ac = sheet.getActiveCol();
            SpreadView view = KDSpread.this.getActiveView();
            sheet.getSheetOption().getSelection().setActiveCell(activeRow, activeCol);
            KDSpread.this.unFreeze();
            KDSpread.this.freeze();
            sheet.getSheetOption().getSelection().setActiveCell(ar, ac);
            KDSpread.this.setActiveView(view);
        }

        private void repaintHeaders() {
            int vCount = KDSpread.this.getVerticalCount();
            for (int i = 0; i < vCount; ++i) {
                KDSpread.this.getView(i, 1).repaint();
            }
            int hCount = KDSpread.this.getHorizonCount();
            for (int j = 1; j < hCount; ++j) {
                KDSpread.this.getView(1, j).repaint();
            }
        }

        private void repaintGroupHead() {
            int vCount = KDSpread.this.getVerticalCount();
            for (int i = KDSpread.this.getFixVerticalCount(); i < vCount; ++i) {
                KDSpread.this.getView(i, 0).repaint();
            }
            int hCount = KDSpread.this.getHorizonCount();
            for (int j = KDSpread.this.getFixHorizonCount(); j < hCount; ++j) {
                KDSpread.this.getView(0, j).repaint();
            }
        }

        private void doPartRepaint(Sheet sheet, SortedCellBlockArray blocks, boolean hasSel, boolean hasActive) {
            if (hasSel) {
                this.repaintHeaders();
            }
            this.repaintGroupHead();
            MergeBlocks merger = sheet.getSheetOption().getMerger(false);
            int bsize = blocks.size();
            for (int bi = 0; bi < bsize; ++bi) {
                Rectangle rect;
                int j;
                int hCount;
                int i;
                int vCount;
                CellBlock block = blocks.getBlock(bi);
                if (block.isWholeSheet()) {
                    vCount = KDSpread.this.getVerticalCount();
                    for (i = 1; i < vCount; ++i) {
                        hCount = KDSpread.this.getHorizonCount();
                        for (j = 1; j < hCount; ++j) {
                            KDSpread.this.getView(i, j).repaint();
                        }
                    }
                    return;
                }
                if (hasSel) {
                    rect = SheetBaseMath.getBlockRect(sheet, block, true);
                    rect = SheetBaseMath.bufferRect(rect, -3, -3, 6, 6);
                } else if (hasActive) {
                    CellBlock mb;
                    CellBlock cellBlock = mb = merger == null ? null : merger.searchBlock(block.getRow(), block.getCol());
                    rect = mb == null ? SheetBaseMath.getBlockRect(sheet, block, true) : SheetBaseMath.getBlockRect(sheet, mb, true);
                } else {
                    CellBlock mb = merger == null ? null : merger.searchBlock(block.getRow(), block.getCol());
                    rect = mb == null ? SheetBaseMath.getBlockRect(sheet, block, true) : SheetBaseMath.getBlockRect(sheet, mb, true);
                }
                vCount = KDSpread.this.getVerticalCount();
                for (i = 1; i < vCount; ++i) {
                    hCount = KDSpread.this.getHorizonCount();
                    for (j = 1; j < hCount; ++j) {
                        KDSpread.this.getView(i, j).repaint(rect);
                    }
                }
            }
        }

        @Override
        public void changed(BookChangeEvent e) {
            if (e.isSheetActive() && !e.isGroup()) {
                KDSpread.this.loadViewInfo();
                KDSpread.this._tabbedBar.syncSheetActive();
                KDSpread.this._tabbedBar.repaint();
            }
            if (e.isSheetDeactive()) {
                Sheet sheet = e.getSheet();
                if (sheet == null) {
                    return;
                }
                Selection sel = sheet.getSheetOption().getSelection();
                int activeRow = sel.getActiveRow();
                int activeCol = sel.getActiveCol();
                MessagedValidate mv = sheet.getValidations().getValidate(sheet, activeRow, activeCol);
                if (mv != null && Validate.Type_List.equalsIgnoreCase(mv.getType())) {
                    Rectangle rect = SheetBaseMath.getActualCellRect(sheet, activeRow, activeCol, true);
                    SpreadView view = KDSpread.this.getActiveView();
                    Component com = view.getComponentAt(rect.x + rect.width, rect.y + rect.height - 16);
                    if (com instanceof PopupListButton) {
                        view.remove(com);
                    }
                }
            }
            if (e.isSheetHide() || e.isSheetUnHide() || e.isSheetInsert() || e.isSheetRemove() || e.isSheetCopy()) {
                KDSpread.this._tabbedBar.repaint();
                KDSpread.this._tabbedBar.syncSheetList();
            }
        }

        @Override
        public void changed(SheetPropertyChangeEvent e) {
            if (e.isSheetNameChanged()) {
                KDSpread.this._tabbedBar.repaint();
                KDSpread.this._tabbedBar.syncSheetList();
            }
        }

        @Override
        public void changed(BookPropertyChangeEvent e) {
        }

        @Override
        public void changed(GraphChangedEvent e) {
            if (e.isSelectionChanged()) {
                KDSpread.this.repaint();
            } else {
                EmbedObject[] graphs = e.getChangedGraphs();
                Rectangle rect = new Rectangle();
                int size = graphs.length;
                for (int index = 0; index < size; ++index) {
                    rect = graphs[index].getBounds(rect);
                    SheetBaseMath.bufferRect(rect, -8, -8, 16, 16);
                    int vCount = KDSpread.this.getVerticalCount();
                    for (int i = 1; i < vCount; ++i) {
                        int hCount = KDSpread.this.getHorizonCount();
                        for (int j = 1; j < hCount; ++j) {
                            KDSpread.this.getView(i, j).repaint(rect);
                        }
                    }
                }
            }
        }

        @Override
        public void propertyChanged(GraphPropertyChangedEvent e) {
            if (e.isBoundsChanged()) {
                Rectangle[] olds = (Rectangle[])e.getOldValues();
                Rectangle[] news = (Rectangle[])e.getNewValues();
                int size = olds.length;
                for (int index = 0; index < size; ++index) {
                    Rectangle rect = olds[index];
                    SheetBaseMath.bufferRect(rect, -8, -8, 16, 16);
                    Rectangle rect2 = news[index];
                    SheetBaseMath.bufferRect(rect2, -8, -8, 16, 16);
                    int vCount = KDSpread.this.getVerticalCount();
                    for (int i = 1; i < vCount; ++i) {
                        int hCount = KDSpread.this.getHorizonCount();
                        for (int j = 1; j < hCount; ++j) {
                            KDSpread.this.getView(i, j).repaint(rect);
                            KDSpread.this.getView(i, j).repaint(rect2);
                        }
                    }
                }
            }
        }
    }

    private class KDSPositionChangeHandler
    implements KDSPositionChangeListener {
        private KDSPositionChangeHandler() {
        }

        @Override
        public void positionChanged(KDSPositionChangeEvent e) {
            KDSpread spread = e.getSpread();
            Sheet sheet = spread.getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            if (!sel.isSingleBlock()) {
                return;
            }
            this.repaintSelectionCorner(spread, sheet, sel.getActiveBlock(), e.getOrientation(), e.getViewIndex(), e.getOldValue(), e.getNewValue());
        }

        private void repaintSelectionCorner(KDSpread spread, Sheet sheet, CellBlock cb, int orientation, int index, int oldValue, int newValue) {
            block4: {
                boolean isCol;
                boolean isRow;
                block3: {
                    isRow = cb.isRow();
                    isCol = cb.isCol();
                    if (orientation != 0) break block3;
                    if (!isRow || isCol) break block4;
                    int vCount = spread.getVerticalCount();
                    for (int vIndex = 1; vIndex < vCount; ++vIndex) {
                        SpreadView view = (SpreadView)spread.getView(vIndex, index);
                        int viewX = SheetBaseMath.getColX(sheet, Math.max(oldValue, newValue));
                        int viewY = SheetBaseMath.getRowY(sheet, view.getFirstRow());
                        Rectangle blockRect = SheetBaseMath.getBlockRect(sheet, cb, true);
                        Rectangle cornerRect = SheetBaseMath.getSelectionCornerRect(viewX, viewY, blockRect, isRow, isCol);
                        view.repaint(cornerRect.x - 1, cornerRect.y, cornerRect.width + 2, cornerRect.height);
                    }
                    break block4;
                }
                if (!isRow && isCol) {
                    int hCount = spread.getHorizonCount();
                    for (int hIndex = 1; hIndex < hCount; ++hIndex) {
                        SpreadView view = (SpreadView)spread.getView(index, hIndex);
                        int viewX = SheetBaseMath.getColX(sheet, view.getFirstCol());
                        int viewY = SheetBaseMath.getRowY(sheet, Math.max(oldValue, newValue));
                        Rectangle blockRect = SheetBaseMath.getBlockRect(sheet, cb, true);
                        Rectangle cornerRect = SheetBaseMath.getSelectionCornerRect(viewX, viewY, blockRect, isRow, isCol);
                        view.repaint(cornerRect.x, cornerRect.y - 1, cornerRect.width, cornerRect.width + 2);
                    }
                }
            }
        }
    }

    private class SpreadViewController
    extends MvpViewController {
        private SpreadView[] _table;
        private SpreadView[] _row;
        private SpreadView[] _col;
        private SpreadView[] _corner;
        private SpreadView _groupRowTagBars;
        private SpreadView _groupColTagBars;
        private SpreadView[] _groupRowHeaders;
        private SpreadView[] _groupColHeaders;

        public SpreadViewController(KDSpread spread) {
            super(spread);
            this._table = new SpreadView[4];
            this._row = new SpreadView[2];
            this._col = new SpreadView[2];
            this._corner = new SpreadView[2];
            this._groupRowHeaders = new SpreadView[2];
            this._groupColHeaders = new SpreadView[2];
        }

        @Override
        public int getSplitPosition(int orientation, int index) {
            return this.getSplitPositionImpl(orientation, index, false);
        }

        @Override
        public JComponent getSplitView(int vIndex, int hIndex) {
            return this.getView(vIndex, hIndex);
        }

        @Override
        protected boolean canSplit() {
            return KDSpread.this.getBook().getProtection().allowOperatorWindow();
        }

        @Override
        protected void saveUserData() {
            LayoutCell lc;
            int fix;
            Sheet sheet = KDSpread.this._book.getActiveSheet();
            ViewSplitInfo vs = sheet.getSheetOption().getViewSplitInfo();
            vs.setFreezed(this._isFreezed);
            MvpLayoutInfoManager lim = KDSpread.this.getLayoutInfoManager();
            if (this.isSplited(1)) {
                fix = KDSpread.this.getFixVerticalCount();
                lc = lim.getVertical(fix);
                if (!this._isFreezed) {
                    vs.setRowSplit(lc.getSpan());
                } else if (vs.getRowFixLine() == -1) {
                    int r = ((SpreadView)KDSpread.this.getViewManager().getView(fix, 0)).getFirstRow();
                    int r2 = ((SpreadView)KDSpread.this.getViewManager().getView(fix + 1, 0)).getFirstRow();
                    vs.setRowFixLine(r2 - r);
                    if (sheet.getSpilteActiveRow() != 0) {
                        vs.setRowSplit(sheet.getSpilteActiveRow());
                    } else {
                        vs.setRowSplit(vs.getRowFixLine());
                    }
                }
            } else {
                vs.setRowSplit(0);
                vs.setRowFixLine(-1);
            }
            if (this.isSplited(0)) {
                fix = KDSpread.this.getFixHorizonCount();
                lc = lim.getHorizon(2);
                if (!this._isFreezed) {
                    vs.setColSplit(lc.getSpan());
                } else if (vs.getColFixLine() == -1) {
                    int c = ((SpreadView)KDSpread.this.getViewManager().getView(0, fix)).getFirstCol();
                    int c2 = ((SpreadView)KDSpread.this.getViewManager().getView(0, fix + 1)).getFirstCol();
                    vs.setColFixLine(c2 - c);
                    if (sheet.getSpilteActiveCol() != 0) {
                        vs.setColSplit(sheet.getSpilteActiveCol());
                    } else {
                        vs.setColSplit(vs.getColFixLine());
                    }
                }
            } else {
                vs.setColSplit(0);
                vs.setColFixLine(-1);
            }
            if (this._isFreezed) {
                KDSpread.this.updateActiveViewAfterSplit();
            } else {
                KDSpread.this.setActiveView(KDSpread.this.getVerticalCount() - 1, KDSpread.this.getHorizonCount() - 1);
            }
            KDSpread.this._book.fireSheetChange(sheet, null, SheetChangeEvent.Changed_ViewSplit);
        }

        @Override
        protected int getSplitPositionForFreeze(int orientation, int index) {
            return this.getSplitPositionImpl(orientation, index, true);
        }

        public int getSplitPositionImpl(int orientation, int index, boolean bFreeze) {
            int retPos = 0;
            if (orientation == 1) {
                SpreadView comp;
                int hCount = KDSpread.this.getHorizonCount();
                SpreadView view = comp = this.getView(index, hCount - 1);
                Sheet sheet = KDSpread.this._book.getActiveSheet();
                sheet.setSpilteActiveRow(sheet.getActiveRow());
                retPos = this.checkActiveRowVisible(index) ? SheetBaseMath.getRowY(sheet, sheet.getSpilteActiveRow()) : (bFreeze ? -1 : SheetBaseMath.getRowY(sheet, (view.getFirstRow() + view.getEndRow()) / 2));
            } else {
                SpreadView comp;
                int vCount = KDSpread.this.getVerticalCount();
                SpreadView view = comp = this.getView(vCount - 1, index);
                Sheet sheet = KDSpread.this._book.getActiveSheet();
                sheet.setSpilteActiveCol(sheet.getActiveCol());
                retPos = this.checkActiveColViible(index) ? SheetBaseMath.getColX(sheet, sheet.getSpilteActiveCol()) : (bFreeze ? -1 : SheetBaseMath.getColX(sheet, (view.getFirstCol() + view.getEndCol()) / 2));
            }
            return this.convertPosition(retPos, orientation, bFreeze);
        }

        @Override
        protected JComponent getExtComponent(int orientation, int index, boolean bFreeze) {
            if (orientation == 0) {
                if (index == 2 && !bFreeze) {
                    return KDSpread.this._tabbedBar;
                }
                if (index == 3 && bFreeze) {
                    return KDSpread.this._tabbedBar;
                }
            }
            return null;
        }

        private boolean checkActiveRowVisible(int index) {
            SpreadView comp;
            int hCount = KDSpread.this.getHorizonCount();
            SpreadView view = comp = this.getView(index, hCount - 1);
            Sheet sheet = KDSpread.this._book.getActiveSheet();
            int ar = sheet.getSpilteActiveRow();
            return ar > view.getFirstRow() && ar <= view.getEndRow();
        }

        private boolean checkActiveColViible(int index) {
            SpreadView comp;
            int vCount = KDSpread.this.getVerticalCount();
            SpreadView view = comp = this.getView(vCount - 1, index);
            Sheet sheet = KDSpread.this._book.getActiveSheet();
            int ac = sheet.getSpilteActiveCol();
            return ac > view.getFirstCol() && ac <= view.getEndCol();
        }

        private int convertPosition(int srcPos, int orientation, boolean bFreeze) {
            if (bFreeze && srcPos <= 0) {
                return -1;
            }
            int position = 0;
            if (orientation == 1) {
                int hCount = KDSpread.this.getHorizonCount();
                position = (int)SwingUtilities.convertPoint(KDSpread.this.getViewManager().getView(this._mvp.getFixVerticalCount(), hCount - 1), 0, srcPos, KDSpread.this.getViewManager().getViewport(this._mvp.getFixVerticalCount(), hCount - 1)).getY();
            } else {
                int vCount = KDSpread.this.getVerticalCount();
                position = (int)SwingUtilities.convertPoint(KDSpread.this.getViewManager().getView(vCount - 1, this._mvp.getFixHorizonCount()), srcPos, 0, KDSpread.this.getViewManager().getViewport(vCount - 1, this._mvp.getFixHorizonCount())).getX();
            }
            return position;
        }

        SpreadView getView(int vIndex, int hIndex) {
            if (vIndex == 0) {
                if (hIndex == 0) {
                    return this.getCorner(0);
                }
                if (hIndex == 1) {
                    return this.getGroupColTagBar();
                }
                if (hIndex > 1) {
                    return this.getGroupColHeader(hIndex - 2);
                }
            } else if (vIndex == 1) {
                if (hIndex == 0) {
                    return this.getGroupRowTagBar();
                }
                if (hIndex == 1) {
                    return this.getCorner(1);
                }
                if (hIndex > 1) {
                    return this.getColumnHeader(hIndex - 2);
                }
            } else if (vIndex > 1) {
                if (hIndex == 0) {
                    return this.getGroupRowHeader(vIndex - 2);
                }
                if (hIndex == 1) {
                    return this.getRowHeader(vIndex - 2);
                }
                if (hIndex > 1) {
                    return this.getTable(KDSpread.this.convertToPaneIndex(vIndex, hIndex));
                }
            }
            return null;
        }

        SpreadView getCorner(int index) {
            if (this._corner[index] == null) {
                this._corner[index] = index == 0 ? new OutlineGroupCorner(KDSpread.this) : new Corner(KDSpread.this);
            }
            return this._corner[index];
        }

        SpreadView getGroupRowHeader(int index) {
            if (this._groupRowHeaders[index] == null) {
                this._groupRowHeaders[index] = new OutlineGroupRowHeader(KDSpread.this);
            }
            return this._groupRowHeaders[index];
        }

        SpreadView getGroupColHeader(int index) {
            if (this._groupColHeaders[index] == null) {
                this._groupColHeaders[index] = new OutlineGroupColHeader(KDSpread.this);
            }
            return this._groupColHeaders[index];
        }

        SpreadView getGroupRowTagBar() {
            if (this._groupRowTagBars == null) {
                this._groupRowTagBars = new OutlineGroupRowTagBar(KDSpread.this);
            }
            return this._groupRowTagBars;
        }

        SpreadView getGroupColTagBar() {
            if (this._groupColTagBars == null) {
                this._groupColTagBars = new OutlineGroupColTagBar(KDSpread.this);
            }
            return this._groupColTagBars;
        }

        SpreadView getTable(int index) {
            if (this._table[index] == null) {
                this._table[index] = new Table(KDSpread.this);
            }
            return this._table[index];
        }

        SpreadView getRowHeader(int index) {
            if (this._row[index] == null) {
                this._row[index] = new RowHeader(KDSpread.this);
            }
            return this._row[index];
        }

        SpreadView getColumnHeader(int index) {
            if (this._col[index] == null) {
                this._col[index] = new ColHeader(KDSpread.this);
            }
            return this._col[index];
        }
    }
}

