/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.core;

import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.frame.MultiViewPane;
import com.kingdee.bos.ctrl.excel.frame.MvpChildView;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.util.IntMarkEntry;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import javax.swing.JViewport;

public abstract class SpreadView
extends MvpChildView {
    private static final int PREFERRED_SIZE_ROW = 3;
    private static final int PREFERRED_SIZE_COL = 3;
    protected KDSpread _spread;

    protected static SpreadView scrollerDispatchCol(SpreadView srcView, int col) {
        int hIndex = MultiViewPane.getComponentIndex(srcView, "HViewIndex");
        int vIndex = MultiViewPane.getComponentIndex(srcView, "VViewIndex");
        int newHindex = hIndex;
        int fix = srcView.getSpread().getFixHorizonCount();
        if (hIndex == fix && srcView.getSpread().isFreezed(0)) {
            if (col > srcView.getEndCol()) {
                newHindex = fix + 1;
            } else {
                return srcView;
            }
        }
        if (newHindex != hIndex) {
            return (SpreadView)srcView.getSpread().getView(vIndex, newHindex);
        }
        return srcView;
    }

    protected static SpreadView scrollerDispatchRow(SpreadView srcView, int row) {
        int vIndex;
        int hIndex = MultiViewPane.getComponentIndex(srcView, "HViewIndex");
        int newVindex = vIndex = MultiViewPane.getComponentIndex(srcView, "VViewIndex");
        int fix = srcView.getSpread().getFixVerticalCount();
        if (vIndex == fix && srcView.getSpread().isFreezed(1)) {
            if (row > srcView.getEndRow()) {
                newVindex = fix + 1;
            } else {
                return srcView;
            }
        }
        if (newVindex != vIndex) {
            return (SpreadView)srcView.getSpread().getView(newVindex, hIndex);
        }
        return srcView;
    }

    public KDSpread getSpread() {
        return this._spread;
    }

    public int getFirstRow() {
        int vIndex = MultiViewPane.getComponentIndex(this, "VViewIndex");
        ViewSplitInfo vs = this.getSpread().getBook().getActiveSheet().getSheetOption().getViewSplitInfo();
        int row = vIndex <= this.getSpread().getFixVerticalCount() ? vs.getFirstRow() : vs.getFirstRow2();
        return row;
    }

    public int getFirstCol() {
        int hIndex = MultiViewPane.getComponentIndex(this, "HViewIndex");
        ViewSplitInfo vs = this.getSpread().getBook().getActiveSheet().getSheetOption().getViewSplitInfo();
        int col = hIndex <= this.getSpread().getFixHorizonCount() ? vs.getFirstCol() : vs.getFirstCol2();
        return col;
    }

    public int getEndRow() {
        Rectangle viewRect = this.getVisibleRect();
        int x2 = viewRect.width + viewRect.x - 1;
        int y2 = viewRect.height + viewRect.y - 1;
        Point downRight = new Point(x2, y2);
        int endRow = SheetBaseMath.rowAtPoint(this.getSpread().getBook().getActiveSheet(), downRight);
        return SheetBaseMath.dealInvalidRow(endRow);
    }

    public int getEndCol() {
        Rectangle viewRect = this.getVisibleRect();
        int x2 = viewRect.width + viewRect.x - 1;
        int y2 = viewRect.height + viewRect.y - 1;
        Point downRight = new Point(x2, y2);
        int endCol = SheetBaseMath.colAtPoint(this.getSpread().getBook().getActiveSheet(), downRight);
        return SheetBaseMath.dealInvalidCol(endCol);
    }

    public final int calcFirstRowByVisibleRow(int row) {
        int firstRow;
        if (row < 0) {
            row = 0;
        } else if (row > 1048575) {
            row = 1048575;
        }
        int newFRow = firstRow = this.getFirstRow();
        if (row < firstRow) {
            newFRow = row;
        } else {
            int endRow = this.getEndRow();
            if (endRow < 1048575 && row >= endRow && endRow > firstRow && (newFRow = this.calcFirstRowByEndRow(row)) == firstRow) {
                ++newFRow;
            }
        }
        return newFRow;
    }

    public final int calcFirstColByVisibleCol(int col) {
        int firstCol;
        if (col < 0) {
            col = 0;
        } else if (col > 16383) {
            col = 16383;
        }
        int newFCol = firstCol = this.getFirstCol();
        if (col < firstCol) {
            newFCol = col;
        } else {
            int endCol = this.getEndCol();
            if (endCol < 16383 && col >= endCol && endCol > firstCol && (newFCol = this.calcFirstColByEndCol(col)) == firstCol) {
                ++newFCol;
            }
        }
        return newFCol;
    }

    public final int calcFirstRowByEndRow(int endRow) {
        int firstRow;
        Rectangle viewRect = this.getVisibleRect();
        for (firstRow = endRow++; firstRow >= 0 && (double)SheetBaseMath.getRowInterval(this.getSpread().getBook().getActiveSheet(), firstRow, endRow) < ((RectangularShape)viewRect).getHeight(); --firstRow) {
        }
        if (++firstRow > 1048575) {
            firstRow = 1048575;
        }
        return firstRow;
    }

    public final int calcFirstColByEndCol(int endCol) {
        int firstCol;
        Rectangle viewRect = this.getVisibleRect();
        for (firstCol = endCol++; firstCol >= 0 && (double)SheetBaseMath.getColInterval(this.getSpread().getBook().getActiveSheet(), firstCol, endCol) < ((RectangularShape)viewRect).getWidth(); --firstCol) {
        }
        if (++firstCol > 16383) {
            firstCol = 16383;
        }
        return firstCol;
    }

    public final int getPreferredWidth() {
        JViewport parent = (JViewport)this.getParent();
        int firstCol = 16383;
        int w = SheetBaseMath.getColX(this.getSpread().getBook().getActiveSheet(), firstCol) + parent.getWidth();
        return w;
    }

    public final int getPreferredHeight() {
        JViewport parent = (JViewport)this.getParent();
        int firstRow = 1048575;
        int h = SheetBaseMath.getRowY(this.getSpread().getBook().getActiveSheet(), firstRow) + parent.getHeight();
        return h;
    }

    @Override
    public int getMaxVisibleWidth(int value) {
        Sheet sheet = this.getSpread().getBook().getActiveSheet();
        int visibleW = this.getParent().getWidth();
        int firstCol = this.calcFirstColByVisibleCol(sheet.getMaxColIndex());
        return visibleW + Math.max(value, SheetBaseMath.getColX(sheet, Math.max(firstCol, 3)));
    }

    @Override
    public int getMaxVisibleHeight(int value) {
        Sheet sheet = this.getSpread().getBook().getActiveSheet();
        int visibleH = this.getParent().getHeight();
        int firstRow = this.calcFirstRowByVisibleRow(sheet.getMaxRowIndex());
        return visibleH + Math.max(value, SheetBaseMath.getRowY(sheet, Math.max(firstRow, 3)));
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            if (direction > 0) {
                return SheetBaseMath.getRowInterval(this.getSpread().getBook().getActiveSheet(), this.getFirstRow(), this.getEndRow());
            }
            return SheetBaseMath.getRowInterval(this.getSpread().getBook().getActiveSheet(), this.calcFirstRowByEndRow(this.getFirstRow()), this.getFirstRow());
        }
        if (direction > 0) {
            return SheetBaseMath.getColInterval(this.getSpread().getBook().getActiveSheet(), this.getFirstCol(), this.getEndCol());
        }
        return SheetBaseMath.getColInterval(this.getSpread().getBook().getActiveSheet(), this.calcFirstColByEndCol(this.getFirstCol()), this.getFirstCol());
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            Sheet sheet = this.getSpread().getBook().getActiveSheet();
            int fr = this.getFirstRow();
            boolean b = SheetBaseMath.isHideRow(sheet, fr);
            if (direction > 0) {
                int nr = b ? SheetBaseMath.getRowInterval(sheet, fr, SheetBaseMath.getNextVisibleRow(sheet, SheetBaseMath.getNextVisibleRow(sheet, fr))) : SheetBaseMath.getRowInterval(sheet, fr, SheetBaseMath.getNextVisibleRow(sheet, fr));
                return nr;
            }
            int nr = b ? SheetBaseMath.getRowInterval(sheet, fr, SheetBaseMath.getLastVisibleRow(sheet, SheetBaseMath.getLastVisibleRow(sheet, fr))) : SheetBaseMath.getRowInterval(sheet, fr, SheetBaseMath.getLastVisibleRow(sheet, fr));
            return -nr;
        }
        Sheet sheet = this.getSpread().getBook().getActiveSheet();
        int fc = this.getFirstCol();
        boolean b = SheetBaseMath.isHideCol(sheet, fc);
        if (direction > 0) {
            int nc = b ? SheetBaseMath.getColInterval(sheet, fc, SheetBaseMath.getNextVisibleCol(sheet, SheetBaseMath.getNextVisibleCol(sheet, fc))) : SheetBaseMath.getColInterval(sheet, fc, SheetBaseMath.getNextVisibleCol(sheet, fc));
            return nc;
        }
        int nc = b ? SheetBaseMath.getColInterval(sheet, fc, SheetBaseMath.getLastVisibleCol(sheet, SheetBaseMath.getLastVisibleCol(sheet, fc))) : SheetBaseMath.getColInterval(sheet, fc, SheetBaseMath.getLastVisibleCol(sheet, fc));
        return -nc;
    }

    @Override
    public boolean isOpaque() {
        return true;
    }

    public IMouseController getMouseController() {
        return this._spread.getMouseController(this.getViewType());
    }

    public IExtRender getExtRender() {
        return this._spread.getExtRender(this.getViewType());
    }

    public abstract void scrollCellVisible(int var1, int var2);

    public abstract int getViewType();

    public final RowBuffer[] getRowBuffers(int rStart, int rEnd) {
        RowBuffer[] rbs;
        int defRowHeight = this.getSpread().getBook().getActiveSheet().getDefRowHeight();
        int start = rStart == -1 ? this.getFirstRow() : rStart;
        int end = rEnd == -1 ? this.getEndRow() : rEnd;
        Sheet sheet = this.getSpread().getBook().getActiveSheet();
        int firstY = rStart == -1 ? -this.getLocation().y : SheetBaseMath.getRowY(sheet, start);
        Span[] spans = sheet.getRowSpans().getSpans(start, end);
        if (spans == null) {
            int sizeOfRows = end - start + 1;
            if (sizeOfRows < 0) {
                sizeOfRows = 0;
            }
            rbs = new RowBuffer[sizeOfRows];
            for (int i = 0; i < sizeOfRows; ++i) {
                rbs[i] = new RowBuffer();
                rbs[i].setRow(start + i);
                rbs[i].setRowHeight(defRowHeight);
            }
            IntMarkEntry[] tempRowObjs = sheet.getRows().subset(start, end);
            if (tempRowObjs != null) {
                int tempLen = tempRowObjs.length;
                int tempIndex = 0;
                for (int i = 0; i < sizeOfRows; ++i) {
                    Row rowObj = (Row)tempRowObjs[tempIndex];
                    int tempRow = rowObj.getRow();
                    int row = rbs[i].getRow();
                    if (row < tempRow) continue;
                    rbs[i].setRowObj(rowObj);
                    if (++tempIndex == tempLen) break;
                }
            }
            rbs[0].setRowY(firstY);
            for (int i = 1; i < sizeOfRows; ++i) {
                rbs[i].setRowY(rbs[i - 1].getRowY() + defRowHeight + 1);
            }
        } else {
            int i;
            int size = spans.length;
            ArrayList<Span> alSpans = new ArrayList<Span>();
            ArrayList<Integer> alRows = new ArrayList<Integer>();
            int spanIndex = start < spans[0].getStart() ? -1 : 0;
            for (i = start; i <= end; ++i) {
                Span tempSpan;
                if (spanIndex < 0) {
                    if (-(spanIndex + 1) > size - 1) {
                        while (i <= end) {
                            alRows.add(new Integer(i));
                            alSpans.add(null);
                            ++i;
                        }
                        continue;
                    }
                    tempSpan = spans[-(spanIndex + 1)];
                    int tempL = tempSpan.getStart();
                    while (i < tempL) {
                        alRows.add(new Integer(i));
                        alSpans.add(null);
                        ++i;
                    }
                    --i;
                    spanIndex = -(spanIndex + 1);
                    continue;
                }
                tempSpan = (SortedAttributeSpanArray.AttributeSpan)spans[spanIndex];
                if (((SortedAttributeSpanArray.AttributeSpan)tempSpan).isVisible()) {
                    int tempEnd = tempSpan.getEnd();
                    tempEnd = Math.min(tempEnd, end);
                    while (i <= tempEnd) {
                        alRows.add(new Integer(i));
                        alSpans.add(tempSpan);
                        ++i;
                    }
                } else {
                    i = tempSpan.getEnd() + 1;
                }
                spanIndex = spanIndex == size - 1 ? -(size + 1) : (i < spans[spanIndex + 1].getStart() ? -(spanIndex + 2) : spanIndex + 1);
                --i;
            }
            int sizeOfRows = alRows.size();
            if (sizeOfRows > 0) {
                rbs = new RowBuffer[sizeOfRows];
                for (i = 0; i < sizeOfRows; ++i) {
                    rbs[i] = new RowBuffer();
                    rbs[i].setRow((Integer)alRows.get(i));
                    SortedAttributeSpanArray.AttributeSpan rs = (SortedAttributeSpanArray.AttributeSpan)alSpans.get(i);
                    rbs[i].setRowHeight(rs == null ? defRowHeight : rs.getLength());
                }
                IntMarkEntry[] tempRowObjs = sheet.getRows().subset(start, end);
                if (tempRowObjs != null) {
                    int tempLen = tempRowObjs.length;
                    int tempIndex = 0;
                    for (int i2 = 0; i2 < sizeOfRows; ++i2) {
                        Row rowObj = (Row)tempRowObjs[tempIndex];
                        int tempRow = rowObj.getRow();
                        int row = rbs[i2].getRow();
                        if (row < tempRow) continue;
                        if (row == tempRow) {
                            rbs[i2].setRowObj(rowObj);
                            ++tempIndex;
                        } else {
                            --i2;
                            ++tempIndex;
                        }
                        if (tempIndex == tempLen) break;
                    }
                }
                rbs[0].setRowY(firstY);
                for (int i3 = 1; i3 < sizeOfRows; ++i3) {
                    int h = rbs[i3 - 1].getRowHeight();
                    rbs[i3].setRowY(rbs[i3 - 1].getRowY() + h + 1);
                }
            } else {
                rbs = null;
            }
        }
        return rbs;
    }

    public final ColBuffer[] getColBuffers(int cStart, int cEnd) {
        ColBuffer[] cbs;
        Sheet sheet = this.getSpread().getBook().getActiveSheet();
        int start = cStart == -1 ? this.getFirstCol() : cStart;
        int end = cEnd == -1 ? this.getEndCol() : cEnd;
        int firstX = cStart == -1 ? -this.getLocation().x : SheetBaseMath.getColX(sheet, start);
        int defColWidth = sheet.getDefColWidth();
        Span[] spans = sheet.getColSpans().getSpans(start, end);
        if (spans == null) {
            int i;
            int sizeOfCols = end - start + 1;
            cbs = new ColBuffer[sizeOfCols];
            for (i = 0; i < sizeOfCols; ++i) {
                cbs[i] = new ColBuffer();
                cbs[i].setCol(start + i);
                cbs[i].setColWidth(defColWidth);
            }
            cbs[0].setColX(firstX);
            for (i = 1; i < sizeOfCols; ++i) {
                cbs[i].setColX(cbs[i - 1].getColX() + defColWidth + 1);
            }
        } else {
            int i;
            int size = spans.length;
            ArrayList<Span> alSpans = new ArrayList<Span>();
            ArrayList<Integer> alCols = new ArrayList<Integer>();
            int spanIndex = start < spans[0].getStart() ? -1 : 0;
            for (i = start; i <= end; ++i) {
                Span tempSpan;
                if (spanIndex < 0) {
                    if (-(spanIndex + 1) > size - 1) {
                        while (i <= end) {
                            alCols.add(new Integer(i));
                            alSpans.add(null);
                            ++i;
                        }
                        continue;
                    }
                    tempSpan = spans[-(spanIndex + 1)];
                    int tempL = tempSpan.getStart();
                    while (i < tempL) {
                        alCols.add(new Integer(i));
                        alSpans.add(null);
                        ++i;
                    }
                    --i;
                    spanIndex = -(spanIndex + 1);
                    continue;
                }
                tempSpan = (SortedAttributeSpanArray.AttributeSpan)spans[spanIndex];
                if (((SortedAttributeSpanArray.AttributeSpan)tempSpan).isVisible()) {
                    int tempEnd = tempSpan.getEnd();
                    tempEnd = Math.min(tempEnd, end);
                    while (i <= tempEnd) {
                        alCols.add(new Integer(i));
                        alSpans.add(tempSpan);
                        ++i;
                    }
                } else {
                    i = tempSpan.getEnd() + 1;
                }
                spanIndex = spanIndex == size - 1 ? -(size + 1) : (i < spans[spanIndex + 1].getStart() ? -(spanIndex + 2) : spanIndex + 1);
                --i;
            }
            int sizeOfCols = alCols.size();
            if (sizeOfCols > 0) {
                cbs = new ColBuffer[sizeOfCols];
                for (i = 0; i < sizeOfCols; ++i) {
                    cbs[i] = new ColBuffer();
                    cbs[i].setCol((Integer)alCols.get(i));
                    SortedAttributeSpanArray.AttributeSpan rs = (SortedAttributeSpanArray.AttributeSpan)alSpans.get(i);
                    cbs[i].setColWidth(rs == null ? defColWidth : rs.getLength());
                }
                cbs[0].setColX(firstX);
                for (i = 1; i < sizeOfCols; ++i) {
                    int h = cbs[i - 1].getColWidth();
                    cbs[i].setColX(cbs[i - 1].getColX() + h + 1);
                }
            } else {
                cbs = null;
            }
        }
        return cbs;
    }

    public class ColBuffer {
        private int _vCol;
        private int _vColWidth;
        private int _vColX;

        public int getCol() {
            return this._vCol;
        }

        public int getColWidth() {
            return this._vColWidth;
        }

        public int getColX() {
            return this._vColX;
        }

        public void setCol(int col) {
            this._vCol = col;
        }

        public void setColWidth(int colW) {
            this._vColWidth = colW;
        }

        public void setColX(int colX) {
            this._vColX = colX;
        }
    }

    public class RowBuffer {
        private int _vRow;
        private Row _vRowObj;
        private int _vRowHeight;
        private int _vRowY;

        public int getRow() {
            return this._vRow;
        }

        public Row getRowObj() {
            return this._vRowObj;
        }

        public int getRowHeight() {
            return this._vRowHeight;
        }

        public int getRowY() {
            return this._vRowY;
        }

        public void setRow(int row) {
            this._vRow = row;
        }

        public void setRowObj(Row rowObj) {
            this._vRowObj = rowObj;
        }

        public void setRowHeight(int rowHeight) {
            this._vRowHeight = rowHeight;
        }

        public void setRowY(int rowY) {
            this._vRowY = rowY;
        }
    }
}

