/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.data;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class DataConvert {
    private static final IDataConvert[] ConvertArray = new IDataConvert[10];

    public static IDataConvert[] getConvertArray(ExtDataSet ds) {
        SortedObjectArray cols = ds.getColumns();
        IDataConvert[] convert = new IDataConvert[cols.size()];
        for (int i = 0; i < convert.length; ++i) {
            ExtColumn col = (ExtColumn)cols.get(i);
            int colIndex = (Integer)col.getIndex().getValue();
            convert[colIndex] = ConvertArray[col.getDataType()];
        }
        return convert;
    }

    static {
        DataConvert.ConvertArray[0] = new BYTE_Convert();
        DataConvert.ConvertArray[1] = new SHORT_Convert();
        DataConvert.ConvertArray[2] = new INT_Convert();
        DataConvert.ConvertArray[3] = new LONG_Convert();
        DataConvert.ConvertArray[4] = new DOUBLE_Convert();
        DataConvert.ConvertArray[5] = new DECIMAL_Convert();
        DataConvert.ConvertArray[6] = new DATE_Convert();
        DataConvert.ConvertArray[7] = new BOOLEAN_Convert();
        DataConvert.ConvertArray[8] = new OBJECT_Convert();
        DataConvert.ConvertArray[9] = new OBJECT_String();
    }

    public static class OBJECT_String
    extends BASE_Convert {
        @Override
        Variant _convertString(String data) {
            return Variant.getBufferedVariant((Variant)new Variant((Object)data, 11));
        }

        @Override
        Variant _convertObject(Object data) {
            return Variant.getBufferedVariant((Variant)new Variant(data, 11));
        }
    }

    public static class OBJECT_Convert
    extends BASE_Convert {
        @Override
        Variant _convertString(String data) {
            return Variant.getBufferedVariant((Variant)new Variant((Object)data, 11));
        }

        @Override
        Variant _convertObject(Object data) {
            return Variant.getBufferedVariant((Variant)new Variant(data, 17));
        }
    }

    public static class BOOLEAN_Convert
    extends BASE_Convert {
        @Override
        Variant _convertString(String data) {
            return Boolean.valueOf(data) != false ? Variant.trueVariant : Variant.falseVariant;
        }

        @Override
        Variant _convertObject(Object data) {
            return (Boolean)data != false ? Variant.trueVariant : Variant.falseVariant;
        }
    }

    public static class DATE_Convert
    extends BASE_Convert {
        private static SimpleDateFormat _fmt = new SimpleDateFormat("yyyy-MM-dd");

        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant((Object)_fmt.parse(data), 12);
            }
            catch (ParseException e) {
                var = Variant.nullVariant;
            }
            return Variant.getBufferedVariant((Variant)var);
        }

        @Override
        Variant _convertObject(Object data) {
            return Variant.getBufferedVariant((Variant)new Variant(data, 12));
        }
    }

    public static class DECIMAL_Convert
    extends BASE_Convert {
        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant((Object)new BigDecimal(data), 10);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return Variant.getBufferedVariant((Variant)var);
        }

        @Override
        Variant _convertObject(Object data) {
            return Variant.getBufferedVariant((Variant)new Variant(data, 10));
        }
    }

    public static class DOUBLE_Convert
    extends BASE_Convert {
        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant(Double.parseDouble(data));
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return Variant.getBufferedVariant((Variant)var);
        }

        @Override
        Variant _convertObject(Object data) {
            return Variant.getBufferedVariant((Variant)new Variant(data, 6));
        }
    }

    public static class LONG_Convert
    extends BASE_Convert {
        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant((Object)Long.valueOf(data), 4);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return Variant.getBufferedVariant((Variant)var);
        }

        @Override
        Variant _convertObject(Object data) {
            return Variant.getBufferedVariant((Variant)new Variant(data, 4));
        }
    }

    public static class INT_Convert
    extends BASE_Convert {
        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant((Object)Integer.valueOf(data), 3);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return Variant.getBufferedVariant((Variant)var);
        }

        @Override
        Variant _convertObject(Object data) {
            return Variant.getBufferedVariant((Variant)new Variant(data, 3));
        }
    }

    public static class SHORT_Convert
    extends BASE_Convert {
        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant((Object)Short.valueOf(data), 2);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return Variant.getBufferedVariant((Variant)var);
        }

        @Override
        Variant _convertObject(Object data) {
            return Variant.getBufferedVariant((Variant)new Variant(data, 2));
        }
    }

    public static class BYTE_Convert
    extends BASE_Convert {
        @Override
        Variant _convertString(String data) {
            Variant var;
            try {
                var = new Variant((Object)Byte.valueOf(data), 1);
            }
            catch (NumberFormatException e) {
                var = Variant.nullVariant;
            }
            return Variant.getBufferedVariant((Variant)var);
        }

        @Override
        Variant _convertObject(Object data) {
            return Variant.getBufferedVariant((Variant)new Variant(data, 1));
        }
    }

    public static abstract class BASE_Convert
    implements IDataConvert {
        abstract Variant _convertString(String var1);

        abstract Variant _convertObject(Object var1);

        @Override
        public Variant convertString(String data) {
            if (data == null) {
                return Variant.nullVariant;
            }
            return this._convertString(data);
        }

        @Override
        public Variant convertObject(Object data) {
            if (data == null) {
                return Variant.nullVariant;
            }
            return this._convertObject(data);
        }
    }

    public static interface IDataConvert {
        public Variant convertString(String var1);

        public Variant convertObject(Object var1);
    }
}

