/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.expans.model.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.exec.ExecutionContext;
import com.kingdee.bos.ctrl.excel.expans.model.ExtProps;
import com.kingdee.bos.ctrl.excel.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSetFactory;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprExpressionParam;
import com.kingdee.bos.ctrl.excel.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.excel.model.expr.ExprParamPos;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.util.ObjectStack;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;

public class ExtDataSetManager {
    private Sheet _sheet;
    private SortedObjectArray _array;
    private ExtDataSetFactory extDataSetFactory = new ExtDataSetFactory();
    private ExecutionContext _ctx;

    public ExtDataSetFactory getExtDataSetFactory() {
        return this.extDataSetFactory;
    }

    public ExtDataSetManager(Sheet sheet) {
        this._sheet = sheet;
        this._array = new SortedObjectArray();
    }

    public int size() {
        return this._array.size();
    }

    public ExtDataSet getAt(int index) {
        return (ExtDataSet)this._array.get(index);
    }

    public String checkAlias(String alias, boolean isDataset, boolean isColumn) {
        String errorMsg;
        block7: {
            block8: {
                errorMsg = null;
                alias = alias.toUpperCase();
                if (!isDataset && !isColumn || this._array.search((Object)alias) < 0) break block8;
                errorMsg = "\u4e0e\u5df2\u6709\u6570\u636e\u96c6\u540d\u51b2\u7a81";
                break block7;
            }
            if (isDataset) {
                for (int i = this._array.size() - 1; i >= 0; --i) {
                    SortedObjectArray cols = ((ExtDataSet)this._array.get(i)).getColumns();
                    if (cols.search((Object)alias) < 0) continue;
                    errorMsg = "\u4e0e\u5df2\u6709\u5217\u540d\u51b2\u7a81";
                    break block7;
                }
            }
            if (!isDataset && !isColumn) break block7;
            NamedObjectNode no = this._sheet.getNamedObject(alias, false);
            if (no != null && !no.isUndefined()) {
                errorMsg = "\u5df2\u6709\u540c\u540d\u547d\u540d\u5bf9\u8c61";
            } else {
                try {
                    String localPrefix = this._sheet.getSyntaxName() + '!';
                    Range rg = this._sheet.getRange(0, 0);
                    if (!rg.setName(localPrefix + alias, null)) {
                        errorMsg = alias + "\u547d\u540d\u975e\u6cd5";
                        break block7;
                    }
                    no = this._sheet.getNamedObject(alias, false);
                    no.setVisible(false);
                }
                catch (SyntaxErrorException e) {
                    errorMsg = alias + "\u547d\u540d\u975e\u6cd5";
                }
            }
        }
        return errorMsg;
    }

    public String addDataSet(ExtDataSet ds) {
        String dst;
        String errorMsg;
        block3: {
            errorMsg = null;
            dst = null;
            String alias = ds.getAlias();
            errorMsg = this.checkAlias(alias, true, false);
            if (errorMsg != null) {
                dst = alias;
            } else {
                SortedObjectArray cols = ds.getColumns();
                for (int i = cols.size() - 1; i >= 0; --i) {
                    alias = ((ExtColumn)cols.get(i)).getAlias();
                    errorMsg = this.checkAlias(alias, false, true);
                    if (errorMsg == null) continue;
                    dst = alias;
                    break block3;
                }
                this._array.insert((Object)ds);
            }
        }
        return errorMsg == null ? null : dst + errorMsg;
    }

    public void removeDataSet(ExtDataSet ds) {
        this._array.remove((Object)ds);
    }

    public void removeAll() {
        this._array.clear();
    }

    public void updateDataSet() {
        for (int i = this._array.size() - 1; i >= 0; --i) {
            ExtDataSet ds = (ExtDataSet)this._array.removeByPos(i);
            SortedObjectArray cols = ds.getColumns();
            Object[] oldCols = cols.toArray();
            cols.clear();
            if (!this.getExtDataSetFactory().updateDataSet(ds, this.getExecutionContext())) continue;
            ds.matchColumnAlias(oldCols);
            if (!StringUtil.isEmptyString((String)this.addDataSet(ds))) continue;
            this.replaceDS_ExprNode(ds);
        }
        ObjectStack stack = new ObjectStack();
        for (int i = this._array.size() - 1; i >= 0; --i) {
            this.replaceField_ExprNode(stack, (ExtDataSet)this._array.get(i));
        }
    }

    private void replaceField_ExprNode(ObjectStack stack, ExtDataSet ds) {
        NamedObjectNode no = this._sheet.getNames().searchByName(ds.getAlias());
        if (no != null && no.isUndefined()) {
            Object refs = no.getRefs();
            if (refs instanceof ICalculable) {
                this.replaceField_ExprNode(stack, (ICalculable)refs, ds);
            } else if (refs instanceof SortedObjectArray) {
                SortedObjectArray sa = (SortedObjectArray)refs;
                for (int i = sa.size() - 1; i >= 0; --i) {
                    this.replaceField_ExprNode(stack, (ICalculable)sa.get(i), ds);
                }
            }
        }
    }

    private void replaceField_ExprNode(ObjectStack stack, ICalculable owner, ExtDataSet ds) {
        SortedExtPropFormulasArray sa;
        ExtProps ep;
        this.replaceField_ExprNode(stack, owner.getExpr(), ds);
        stack.clear();
        if (owner instanceof Cell && (ep = ((Cell)owner).getExtProps(false)) != null && (sa = ep.getFormulas(false)) != null) {
            for (int i = sa.size() - 1; i >= 0; --i) {
                Expr expr = ((SortedExtPropFormulasArray.Node)sa.get(i)).getExpr();
                this.replaceField_ExprNode(stack, expr, ds);
                stack.clear();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void replaceField_ExprNode(ObjectStack stack, Expr expr, ExtDataSet ds) {
        IExprNode[] nodes = expr.getExprOps().getNodes();
        IExprNode[] params = expr.getParameters();
        SortedObjectArray cols = ds.getColumns();
        int i = 0;
        while (i < nodes.length) {
            IExprNode node = nodes[i];
            block0 : switch (node.getExprType()) {
                case 131072: {
                    int pos = ((ExprParamPos)node).getPos();
                    IExprNode param = params[pos];
                    switch (param.getExprType()) {
                        case 8: {
                            if (stack.isEmpty() || stack.getTop() != ds) break;
                            int p = cols.search((Object)((NamedObjectNode)param).getName());
                            if (p < 0) break block0;
                            params[pos] = (ExtColumn)cols.get(p);
                            break block0;
                        }
                        case 524288: {
                            stack.push(param);
                            break block0;
                        }
                        case 65536: {
                            this.replaceField_ExprNode(stack, ((ExprExpressionParam)param).getExpr(), ds);
                        }
                    }
                    break;
                }
                case 256: {
                    if (!((ExprMethod)node).isExtDataSetMethod()) break;
                    stack.pop();
                    break;
                }
            }
            ++i;
        }
        return;
    }

    private void replaceDS_ExprNode(ExtDataSet ds) {
        NamedObjectNode no = this._sheet.getNames().searchByName(ds.getAlias());
        if (no != null) {
            Object refs = no.getRefs();
            if (refs instanceof ICalculable) {
                this.replaceDS_ExprNode((ICalculable)refs, no, ds);
            } else if (refs instanceof SortedObjectArray) {
                SortedObjectArray sa = (SortedObjectArray)refs;
                for (int i = sa.size() - 1; i >= 0; --i) {
                    this.replaceDS_ExprNode((ICalculable)sa.get(i), no, ds);
                }
            }
        }
    }

    private void replaceDS_ExprNode(ICalculable owner, NamedObjectNode no, ExtDataSet ds) {
        SortedExtPropFormulasArray sa;
        ExtProps ep;
        this.replaceDS_ExprNode(owner.getExpr(), no, ds);
        if (owner instanceof Cell && (ep = ((Cell)owner).getExtProps(false)) != null && (sa = ep.getFormulas(false)) != null) {
            for (int i = sa.size() - 1; i >= 0; --i) {
                Expr expr = ((SortedExtPropFormulasArray.Node)sa.get(i)).getExpr();
                this.replaceDS_ExprNode(expr, no, ds);
            }
        }
    }

    private void replaceDS_ExprNode(Expr expr, NamedObjectNode no, ExtDataSet ds) {
        IExprNode[] params = expr.getParameters();
        for (int i = 0; i < params.length; ++i) {
            IExprNode param = params[i];
            if (param == no) {
                params[i] = ds;
                continue;
            }
            if (!(param instanceof ExprExpressionParam)) continue;
            this.replaceDS_ExprNode(((ExprExpressionParam)param).getExpr(), no, ds);
        }
    }

    public void resetCurrent() {
        for (int i = this._array.size() - 1; i >= 0; --i) {
            ExtDataSet ds = this.getAt(i);
            ds.setCurrentGroup(null);
            ds.setCurrentRow(null);
        }
    }

    public void fillDefaultCurrent() {
        for (int i = this._array.size() - 1; i >= 0; --i) {
            ExtDataSet ds = this.getAt(i);
            if (ds.getCurrentGroup() != null) continue;
            ds.setCurrentGroup(ds.getDefaultGroup());
        }
    }

    public ExecutionContext getExecutionContext() {
        if (this._ctx == null && this._sheet.getSheetType() == 1) {
            this._ctx = new ExecutionContext(this._sheet);
        }
        return this._ctx;
    }
}

