/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl;

import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.RangeSelectState;
import com.kingdee.bos.ctrl.excel.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Position;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;

public final class SelectionAdapter {
    private int _realRow = -1;
    private int _realCol = -1;
    private Position _resuePos = new Position();
    private SpreadContext _context;

    SelectionAdapter(SpreadContext context) {
        this._context = context;
    }

    public boolean changeSelection(CellBlock block, int changeMode, boolean calcMerger) {
        Selection sel = this.getSelectionData();
        return sel.changeSelection(block, changeMode, calcMerger);
    }

    public boolean changeSelection(CellBlock block, int changeMode) {
        return this.changeSelection(block, changeMode, true);
    }

    public void jumpActiveCellToRight() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        if (this.isBaseUnit()) {
            int activeRow = this.getActiveRow();
            int activeCol = this.getActiveCol();
            this._resuePos = this.getRightPosition(sheet, activeRow, activeCol);
            this.jumpSelectionTo(sheet, this._resuePos);
        } else {
            this.moveActiveCell(true, false);
            spread.getActiveView().scrollCellVisible(this.getActiveRow(), this.getActiveCol());
        }
    }

    public void jumpActiveCellToLeft() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        if (this.isBaseUnit()) {
            int activeRow = this.getActiveRow();
            int activeCol = this.getActiveCol();
            this._resuePos = this.getLeftPosition(sheet, activeRow, activeCol);
            this.jumpSelectionTo(sheet, this._resuePos);
        } else {
            this.moveActiveCell(false, false);
            spread.getActiveView().scrollCellVisible(this.getActiveRow(), this.getActiveCol());
        }
    }

    public void jumpActiveCellToUp() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        if (this.isBaseUnit()) {
            int activeRow = this.getActiveRow();
            int activeCol = this.getActiveCol();
            this._resuePos = this.getUpPosition(sheet, activeRow, activeCol);
            this.jumpSelectionTo(sheet, this._resuePos);
        } else {
            this.moveActiveCell(false, true);
            spread.getActiveView().scrollCellVisible(this.getActiveRow(), this.getActiveCol());
        }
    }

    public void jumpActiveCellToDown() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        if (this.isBaseUnit()) {
            int activeRow = this.getActiveRow();
            int activeCol = this.getActiveCol();
            this._resuePos = this.getDownPosition(sheet, activeRow, activeCol);
            this.jumpSelectionTo(sheet, this._resuePos);
        } else {
            this.moveActiveCell(true, true);
            spread.getActiveView().scrollCellVisible(this.getActiveRow(), this.getActiveCol());
        }
    }

    public void jumpSelectionToRight() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        this._resuePos = this.getRightPosition(sheet, activeRow, activeCol);
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToLeft() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        this._resuePos = this.getLeftPosition(sheet, activeRow, activeCol);
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToUp() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        this._resuePos = this.getUpPosition(sheet, activeRow, activeCol);
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToDown() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        this._resuePos = this.getDownPosition(sheet, activeRow, activeCol);
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToHome() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        this._resuePos.setRowCol(activeRow, SheetBaseMath.getVisibleStartCol(sheet));
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToEnd() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        this._resuePos.setRowCol(activeRow, SheetBaseMath.getVisibleEndCol(sheet));
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToUpleft() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        this._resuePos.setRowCol(SheetBaseMath.getVisibleStartRow(sheet), SheetBaseMath.getVisibleStartCol(sheet));
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToDownright() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        Sheet.ICellsIterator ici = sheet.getCellsIterator(0, 0, SheetBaseMath.getVisibleEndRow(sheet), SheetBaseMath.getVisibleEndCol(sheet), true, false);
        if (ici.hasNext()) {
            Cell cell = ici.next();
            this._resuePos.setRowCol(cell.getRow(), cell.getCol());
        } else {
            this._resuePos.setRowCol(0, 0);
        }
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToRightData() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        this._resuePos = SheetBaseMath.getRightDataPosition(sheet, activeRow, activeCol, this._resuePos);
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToLeftData() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        this._resuePos = SheetBaseMath.getLeftDataPosition(sheet, activeRow, activeCol, this._resuePos);
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToUpData() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        this._resuePos = SheetBaseMath.getUpDataPosition(sheet, activeRow, activeCol, this._resuePos);
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void jumpSelectionToDownData() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        this._resuePos = SheetBaseMath.getDownDataPosition(sheet, activeRow, activeCol, this._resuePos);
        this.jumpSelectionTo(sheet, this._resuePos);
    }

    public void nextPage(boolean toExtend) {
        KDSpread spread = this._context.getSpread();
        SpreadView view = spread.getActiveView();
        int oldEndRow = view.getEndRow();
        if (oldEndRow >= 1048575) {
            return;
        }
        spread.setViewRow(view, oldEndRow);
        int firstRow = oldEndRow;
        int endRow = view.getEndRow();
        int activeRow = this.getActiveRow();
        if ((activeRow += endRow - firstRow) < firstRow || activeRow > endRow) {
            activeRow = firstRow;
        }
        if (toExtend) {
            CellBlock activeB = this.getActiveBlock();
            CellBlock newBlock = CellBlock.getNewCellBlock(activeB.getRow(), activeB.getCol(), activeRow, activeB.getCol2());
            this.changeSelection(newBlock, 2);
        } else {
            CellBlock newBlock = CellBlock.getNewCellBlock(activeRow, this.getActiveCol(), activeRow, this.getActiveCol());
            this.changeSelection(newBlock, 2);
        }
    }

    public void lastPage(boolean toExtend) {
        KDSpread spread = this._context.getSpread();
        SpreadView view = spread.getActiveView();
        view.getSpread().setViewRow(view, view.calcFirstRowByEndRow(view.getFirstRow()));
        int firstRow = view.getFirstRow();
        int endRow = view.getEndRow();
        int activeRow = this.getActiveRow();
        if ((activeRow += firstRow - endRow + 1) < firstRow || activeRow > endRow) {
            activeRow = firstRow;
        }
        if (toExtend) {
            CellBlock activeB = this.getActiveBlock();
            CellBlock newBlock = CellBlock.getNewCellBlock(activeRow, activeB.getCol(), activeB.getRow2(), activeB.getCol2());
            this.changeSelection(newBlock, 2);
        } else {
            CellBlock newBlock = CellBlock.getNewCellBlock(activeRow, this.getActiveCol(), activeRow, this.getActiveCol());
            this.changeSelection(newBlock, 2);
        }
    }

    public void selectAll() {
        CellBlock newBlock = CellBlock.getNewCellBlock(0, 0, 1048575, 16383);
        this.changeSelection(newBlock, 3, false);
    }

    public void extendToDownright() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        SpreadView view = spread.getActiveView();
        CellBlock activeB = this.getActiveBlock();
        int row = SheetBaseMath.getVisibleEndRow(sheet);
        int col = SheetBaseMath.getVisibleEndCol(sheet);
        CellBlock newBlock = CellBlock.getNewCellBlock(activeB.getRow(), activeB.getCol(), row, col);
        if (this.changeSelection(newBlock, 3)) {
            view.scrollCellVisible(row, col);
        }
    }

    public void extendToUpleft() {
        int col;
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        SpreadView view = spread.getActiveView();
        CellBlock activeB = this.getActiveBlock();
        int row = SheetBaseMath.getVisibleStartRow(sheet);
        CellBlock newBlock = CellBlock.getNewCellBlock(row, col = SheetBaseMath.getVisibleStartCol(sheet), activeB.getRow2(), activeB.getCol2());
        if (this.changeSelection(newBlock, 3)) {
            view.scrollCellVisible(row, col);
        }
    }

    public void extendToHome() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        SpreadView view = spread.getActiveView();
        CellBlock activeB = this.getActiveBlock();
        int activeRow = this.getActiveRow();
        int col = SheetBaseMath.getVisibleStartCol(sheet);
        CellBlock newBlock = CellBlock.getNewCellBlock(activeB.getRow(), col, activeB.getRow2(), activeB.getCol2());
        if (this.changeSelection(newBlock, 3)) {
            view.scrollCellVisible(activeRow, col);
        }
    }

    public void extendToEnd() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        SpreadView view = spread.getActiveView();
        CellBlock activeB = this.getActiveBlock();
        int activeRow = this.getActiveRow();
        int col = SheetBaseMath.getVisibleEndCol(sheet);
        CellBlock newBlock = CellBlock.getNewCellBlock(activeB.getRow(), activeB.getCol(), activeB.getRow2(), col);
        if (this.changeSelection(newBlock, 3)) {
            view.scrollCellVisible(activeRow, col);
        }
    }

    public void extendToRight(boolean toData) {
        int scrollToCol;
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        SpreadView view = spread.getActiveView();
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock activeB = this.getActiveBlock();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        CellBlock newBlock = null;
        this._resuePos = toData ? SheetBaseMath.getRightDataPosition(sheet, activeRow, activeB.getCol(), this._resuePos) : this.getRightPosition(sheet, activeRow, activeB.getCol());
        if (this._resuePos.getCol() > activeCol) {
            newBlock = CellBlock.getNewCellBlock(activeB.getRow(), activeCol, activeB.getRow2(), Math.max(this._resuePos.getCol(), activeB.getCol2()));
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToCol = newBlock.getCol2();
        } else {
            newBlock = CellBlock.getNewCellBlock(activeB.getRow(), Math.min(this._resuePos.getCol(), activeCol), activeB.getRow2(), activeB.getCol2());
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToCol = newBlock.getCol();
        }
        if (newBlock.equals(activeB)) {
            this._resuePos = toData ? SheetBaseMath.getRightDataPosition(sheet, activeRow, activeB.getCol2(), this._resuePos) : this.getRightPosition(sheet, activeRow, activeB.getCol2());
            newBlock.setRowCol(activeB.getRow(), activeB.getCol(), activeB.getRow2(), this._resuePos.getCol());
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToCol = newBlock.getCol2();
        }
        if (this.changeSelection(newBlock, 3)) {
            view.scrollCellVisible(activeRow, scrollToCol);
        }
    }

    public void extendToLeft(boolean toData) {
        int scrollToCol;
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        SpreadView view = spread.getActiveView();
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock activeB = this.getActiveBlock();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        CellBlock newBlock = null;
        this._resuePos = toData ? SheetBaseMath.getLeftDataPosition(sheet, activeRow, activeB.getCol2(), this._resuePos) : this.getLeftPosition(sheet, activeRow, activeB.getCol2());
        if (this._resuePos.getCol() < activeCol) {
            newBlock = CellBlock.getNewCellBlock(activeB.getRow(), Math.min(this._resuePos.getCol(), activeB.getCol()), activeB.getRow2(), activeCol);
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToCol = newBlock.getCol();
        } else {
            newBlock = CellBlock.getNewCellBlock(activeB.getRow(), activeB.getCol(), activeB.getRow2(), Math.max(this._resuePos.getCol(), activeCol));
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToCol = newBlock.getCol2();
        }
        if (newBlock.equals(activeB)) {
            this._resuePos = toData ? SheetBaseMath.getLeftDataPosition(sheet, activeRow, activeB.getCol(), this._resuePos) : this.getLeftPosition(sheet, activeRow, activeB.getCol());
            newBlock.setRowCol(activeB.getRow(), this._resuePos.getCol(), activeB.getRow2(), activeB.getCol2());
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToCol = newBlock.getCol();
        }
        if (this.changeSelection(newBlock, 3)) {
            view.scrollCellVisible(activeRow, scrollToCol);
        }
    }

    public void extendToDown(boolean toData) {
        int scrollToRow;
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        SpreadView view = spread.getActiveView();
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock activeB = this.getActiveBlock();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        CellBlock newBlock = null;
        this._resuePos = toData ? SheetBaseMath.getDownDataPosition(sheet, activeB.getRow(), activeCol, this._resuePos) : this.getDownPosition(sheet, activeB.getRow(), activeCol);
        if (this._resuePos.getRow() > activeRow) {
            newBlock = CellBlock.getNewCellBlock(activeRow, activeB.getCol(), Math.max(this._resuePos.getRow(), activeB.getRow2()), activeB.getCol2());
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToRow = newBlock.getRow2();
        } else {
            newBlock = CellBlock.getNewCellBlock(Math.min(this._resuePos.getRow(), activeRow), activeB.getCol(), activeB.getRow2(), activeB.getCol2());
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToRow = newBlock.getRow();
        }
        if (newBlock.equals(activeB)) {
            this._resuePos = toData ? SheetBaseMath.getDownDataPosition(sheet, activeB.getRow2(), activeCol, this._resuePos) : this.getDownPosition(sheet, activeB.getRow2(), activeCol);
            newBlock.setRowCol(activeB.getRow(), activeB.getCol(), this._resuePos.getRow(), activeB.getCol2());
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToRow = newBlock.getRow2();
        }
        if (this.changeSelection(newBlock, 3)) {
            view.scrollCellVisible(scrollToRow, activeCol);
        }
    }

    public void extendToUp(boolean toData) {
        int scrollToRow;
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        SpreadView view = spread.getActiveView();
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock activeB = this.getActiveBlock();
        int activeRow = this.getActiveRow();
        int activeCol = this.getActiveCol();
        CellBlock newBlock = null;
        this._resuePos = toData ? SheetBaseMath.getUpDataPosition(sheet, activeB.getRow2(), activeCol, this._resuePos) : this.getUpPosition(sheet, activeB.getRow2(), activeCol);
        if (this._resuePos.getRow() < activeRow) {
            newBlock = CellBlock.getNewCellBlock(Math.min(this._resuePos.getRow(), activeB.getRow()), activeB.getCol(), activeRow, activeB.getCol2());
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToRow = newBlock.getRow();
        } else {
            newBlock = CellBlock.getNewCellBlock(activeB.getRow(), activeB.getCol(), Math.max(activeRow, this._resuePos.getRow()), activeB.getCol2());
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToRow = newBlock.getRow2();
        }
        if (newBlock.equals(activeB)) {
            this._resuePos = toData ? SheetBaseMath.getUpDataPosition(sheet, activeB.getRow(), activeCol, this._resuePos) : this.getUpPosition(sheet, activeB.getRow(), activeCol);
            newBlock.setRowCol(this._resuePos.getRow(), activeB.getCol(), activeB.getRow2(), activeB.getCol2());
            if (merger != null) {
                newBlock = merger.calActualBlock(newBlock);
            }
            scrollToRow = newBlock.getRow();
        }
        if (this.changeSelection(newBlock, 3)) {
            view.scrollCellVisible(scrollToRow, activeCol);
        }
    }

    public Selection getSelectionData() {
        if (this.isRangeSelectMode()) {
            return ((RangeSelectState)this._context.getStateManager().getCurrentState2(SpreadStateManager.Key_Range_Select)).getSelection();
        }
        return this._context.getBook().getActiveSheet().getSheetOption().getSelection();
    }

    private void jumpSelectionTo(Sheet sheet, Position pos) {
        this.jumpSelectionTo(sheet, pos.getRow(), pos.getCol());
    }

    private void jumpSelectionTo(Sheet sheet, int row, int col) {
        CellBlock sb = CellBlock.getNewCellBlock(row, col, row, col);
        this._realRow = row;
        this._realCol = col;
        if (this.changeSelection(sb, 2)) {
            KDSpread spread = this._context.getSpread();
            spread.getActiveView().scrollCellVisible(row, col);
        }
    }

    private boolean isRangeSelectMode() {
        return this._context.getStateManager().isState2(SpreadStateManager.Key_Range_Select);
    }

    private void moveActiveCell(boolean bAscend, boolean bUpright) {
        if (this.isRangeSelectMode()) {
            return;
        }
        Selection sel = this.getSelectionData();
        sel.moveActiveCell(bAscend, bUpright);
    }

    private boolean isBaseUnit() {
        Selection sel = this.getSelectionData();
        return sel.isBaseUnit();
    }

    private int getActiveCol() {
        Selection sel = this.getSelectionData();
        return sel.getActiveCol();
    }

    private int getActiveRow() {
        Selection sel = this.getSelectionData();
        return sel.getActiveRow();
    }

    private CellBlock getActiveBlock() {
        Selection sel = this.getSelectionData();
        return sel.getActiveBlock();
    }

    private Position getRightPosition(Sheet sheet, int row, int col) {
        CellBlock mb;
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock cellBlock = mb = merger == null ? null : merger.searchBlock(row, col);
        if (mb != null) {
            col = mb.getCol2();
            if (mb.contains(this._realRow, this._realCol)) {
                row = this._realRow;
            }
        }
        col = SheetBaseMath.getNextVisibleCol(sheet, col);
        this._resuePos.setRowCol(row, col);
        return this._resuePos;
    }

    private Position getLeftPosition(Sheet sheet, int row, int col) {
        CellBlock mergeBlock;
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock cellBlock = mergeBlock = merger == null ? null : merger.searchBlock(row, col);
        if (mergeBlock != null) {
            col = mergeBlock.getCol();
            if (mergeBlock.contains(this._realRow, this._realCol)) {
                row = this._realRow;
            }
        }
        col = SheetBaseMath.getLastVisibleCol(sheet, col);
        this._resuePos.setRowCol(row, col);
        return this._resuePos;
    }

    private Position getDownPosition(Sheet sheet, int row, int col) {
        CellBlock mergeBlock;
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock cellBlock = mergeBlock = merger == null ? null : merger.searchBlock(row, col);
        if (mergeBlock != null) {
            row = mergeBlock.getRow2();
            if (mergeBlock.contains(this._realRow, this._realCol)) {
                col = this._realCol;
            }
        }
        row = SheetBaseMath.getNextVisibleRow(sheet, row);
        this._resuePos.setRowCol(row, col);
        return this._resuePos;
    }

    private Position getUpPosition(Sheet sheet, int row, int col) {
        CellBlock mergeBlock;
        MergeBlocks merger = sheet.getSheetOption().getMerger(false);
        CellBlock cellBlock = mergeBlock = merger == null ? null : merger.searchBlock(row, col);
        if (mergeBlock != null) {
            row = mergeBlock.getRow();
            if (mergeBlock.contains(this._realRow, this._realCol)) {
                col = this._realCol;
            }
        }
        row = SheetBaseMath.getLastVisibleRow(sheet, row);
        this._resuePos.setRowCol(row, col);
        return this._resuePos;
    }
}

