/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade;

import com.kingdee.bos.ctrl.common.CompositePane;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.CellTextEditor;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.impl.facade.flex.FlexTextArea;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.impl.state.EditingState;
import com.kingdee.bos.ctrl.excel.impl.state.RangeSelectState;
import com.kingdee.bos.ctrl.excel.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PromptPanel
extends CompositePane {
    public PromptPanel(SpreadContext context) {
        this(context, null);
    }

    public PromptPanel(SpreadContext context, JComponent extComp) {
        super(0);
        this.setRightComponent(extComp);
        this._firstComp = new LeftPromptPanel(context);
        this.add((Component)this._firstComp);
        this.validate();
    }

    public void setRightComponent(JComponent comp) {
        this.setSecondComponent(comp);
    }

    public JComponent getRightComponent() {
        return this._secondComp;
    }

    public LeftPromptPanel getLeftPane() {
        return (LeftPromptPanel)((Object)this._firstComp);
    }

    public void setFormula(String text) {
        this.getLeftPane().setFormula(text);
    }

    public void setEditing(boolean b) {
        this.getLeftPane()._syncing = true;
        this.getLeftPane().setEditBtnVisible(b);
        this.getLeftPane().syncBase();
        this.getLeftPane()._syncing = false;
    }

    public class LeftPromptPanel
    extends KDPanel
    implements SheetChangeListener,
    BookChangeListener,
    SheetPropertyChangeListener,
    GraphChangeListener {
        private boolean _syncing;
        private SpreadContext _context;
        private KDComboBox _cmbLocalizer;
        private KDButton _btnCancel;
        private KDButton _btnOk;
        private KDButton _btnFunc;
        private FlexTextArea _txtFormula;
        private Set _managingFocusForwardTraversalKeys;
        private Set _managingFocusBackwardTraversalKeys;
        private boolean _syncEnabled = true;

        public LeftPromptPanel(SpreadContext context) {
            this._context = context;
            this.setLayout(null);
            this.initComponents();
            this.initListeners();
        }

        public void doLayout() {
            int w = this.getWidth();
            int h = this.getHeight();
            Insets insets = this.getInsets();
            int left = insets.left;
            int right = insets.right;
            int top = insets.top;
            int bottom = insets.bottom;
            int compH = h - top - bottom;
            int x = left;
            int y = top;
            this._cmbLocalizer.setBounds(x, y, 108, compH);
            this._btnCancel.setBounds(x += 108, y, compH + 2, compH);
            this._btnOk.setBounds(x += compH + 2, y, compH + 2, compH);
            this._btnFunc.setBounds(x += compH + 2, y, compH + 2, compH);
            this._txtFormula.setLocation(x += compH + 2, y);
            this._txtFormula.setSize(w - x - right, compH);
            this._txtFormula.setDefWidth(w - x - right);
            this._txtFormula.setDefHeight(compH);
        }

        public boolean isSyncEnabled() {
            return this._syncEnabled;
        }

        public void setSyncEnabled(boolean syncEnabled) {
            this._syncEnabled = syncEnabled;
        }

        public boolean focusEditor() {
            if (!this._txtFormula.isFocusOwner()) {
                return this._txtFormula.requestFocusInWindow();
            }
            return true;
        }

        public void setCaretPosition(int dot) {
            this._txtFormula.getCaret().setDot(dot);
        }

        private void setFormula(String text) {
            this._txtFormula.setText(text);
        }

        private Set getForwardKeys() {
            if (this._managingFocusForwardTraversalKeys == null) {
                this._managingFocusForwardTraversalKeys = new HashSet();
                this._managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 2));
                this._managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
            }
            return this._managingFocusForwardTraversalKeys;
        }

        private Set getBackwardKeys() {
            if (this._managingFocusBackwardTraversalKeys == null) {
                this._managingFocusBackwardTraversalKeys = new HashSet();
                this._managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
                this._managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 3));
            }
            return this._managingFocusBackwardTraversalKeys;
        }

        private void setEditBtnVisible(boolean b) {
            this._btnOk.setVisible(b);
            this._btnCancel.setVisible(b);
        }

        private void setLocalizerText(String text) {
            this._cmbLocalizer.removeAllItems();
            Book book = this._context.getBook();
            if (book != null) {
                SortedNamedObjectNodeArray names = book.getNames();
                int size = names.size();
                for (int i = 0; i < size; ++i) {
                    Object obj = names.get(i);
                    if (!(obj instanceof NamedObjectNode) || obj == NamedObjectNode.True || obj == NamedObjectNode.False || obj == NamedObjectNode.Null) continue;
                    this._cmbLocalizer.addItem((Object)((NamedObjectNode)obj).getFullName());
                }
                Sheet sheet = book.getActiveSheet();
                if (sheet != null) {
                    names = sheet.getNames();
                    int size2 = names.size();
                    for (int i = 0; i < size2; ++i) {
                        Object obj = names.get(i);
                        if (!(obj instanceof NamedObjectNode) || obj == NamedObjectNode.True || obj == NamedObjectNode.False || obj == NamedObjectNode.Null) continue;
                        this._cmbLocalizer.addItem((Object)((NamedObjectNode)obj).getFullName());
                    }
                }
            }
            this._cmbLocalizer.setSelectedItem((Object)text);
        }

        private void initComponents() {
            this._cmbLocalizer = new KDComboBox();
            this._cmbLocalizer.setEditable(true);
            this._cmbLocalizer.setBorder(null);
            this._btnCancel = new KDButton();
            this._btnCancel.setLimitedSize(false);
            this._btnCancel.setOpaque(false);
            this._btnCancel.setBorder(null);
            this._btnCancel.setIcon((Icon)ResourceManager.getImageIcon("tbtn_delete.gif"));
            this._btnCancel.setVisible(false);
            this._btnOk = new KDButton();
            this._btnOk.setLimitedSize(false);
            this._btnOk.setOpaque(false);
            this._btnOk.setBorder(null);
            this._btnOk.setIcon((Icon)ResourceManager.getImageIcon("toolbar_line.gif"));
            this._btnOk.setVisible(false);
            this._btnFunc = new KDButton();
            this._btnFunc.setLimitedSize(false);
            this._btnFunc.setOpaque(false);
            this._btnFunc.setBorder(null);
            this._btnFunc.setIcon((Icon)ResourceManager.getImageIcon("tbtn_formulaguide.gif"));
            this._txtFormula = new FlexTextArea();
            this._txtFormula.setLineWrap(true);
            this._txtFormula.setWrapStyleWord(false);
            this._txtFormula.setOpaque(true);
            this._txtFormula.setBorder(null);
            this._txtFormula.setDelegated(false);
            this.add((Component)this._cmbLocalizer);
            this.add((Component)this._btnCancel);
            this.add((Component)this._btnOk);
            this.add((Component)this._btnFunc);
            this.add((Component)((Object)this._txtFormula));
        }

        private void initListeners() {
            this._cmbLocalizer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!LeftPromptPanel.this._syncing) {
                        Range rg;
                        EmbedObject gr;
                        String name = (String)LeftPromptPanel.this._cmbLocalizer.getSelectedItem();
                        boolean bEmptyName = StringUtil.isEmptyString((String)name);
                        Sheet sheet = LeftPromptPanel.this._context.getBook().getActiveSheet();
                        EmbedhLayer gl = sheet.getEmbedments(false);
                        if (!bEmptyName && gl != null && (gr = gl.findEmbed(name)) != null) {
                            Protection pro = sheet.getSheetOption().getProtection(false);
                            if (pro == null || pro.allowEditObjects()) {
                                gl.selectEmbed(gr, 2);
                            }
                            return;
                        }
                        if (!bEmptyName && (rg = LeftPromptPanel.this._context.getRangeManager().findRangeInBook(name, true)) != null) {
                            if (gl != null) {
                                gl.cancelSelectedEmbeds();
                            }
                            rg.select();
                            return;
                        }
                        if (!bEmptyName && gl != null && gl.selectionSize() == 1) {
                            gl.getSelectionRange().setName(name);
                            LeftPromptPanel.this._context.requestFocusInWindow();
                        } else {
                            Selection sel = sheet.getSheetOption().getSelection();
                            if (!sel.isOverlapped()) {
                                Range rg2 = LeftPromptPanel.this._context.getRangeManager().getActiveCellRange();
                                try {
                                    String referto = sheet.getSyntaxName() + '!' + Sheet.getBlocksName(sel.toSortedBlocks(), sheet.getBook().getDeps().isA1Style(), true);
                                    rg2.setName(name, referto);
                                }
                                catch (Exception ee) {
                                    rg2.select();
                                }
                            }
                        }
                    }
                }
            });
            this._btnFunc.addActionListener((ActionListener)new ActionWrapper(this._context.getActionManager().getAction("Show_Formula_Wizzard")));
            this._btnOk.addActionListener((ActionListener)new ActionWrapper(this._context.getActionManager().getAction("inner_StopEditing")));
            this._btnCancel.addActionListener((ActionListener)new ActionWrapper(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LeftPromptPanel.this._context.getStateManager().isState2(SpreadStateManager.Key_Edit)) {
                        LeftPromptPanel.this._context.getStateManager().cancel();
                    }
                }
            }));
            this._txtFormula.getDocument().addDocumentListener(new DocumentListener(){

                private void sync() {
                    EditingState es;
                    ICellEditor editor;
                    SpreadStateManager sm;
                    if (!LeftPromptPanel.this._syncEnabled) {
                        return;
                    }
                    if (LeftPromptPanel.this._txtFormula.isFocusOwner() && (sm = LeftPromptPanel.this._context.getStateManager()).isState2(SpreadStateManager.Key_Edit) && (editor = (es = (EditingState)sm.getCurrentState2(SpreadStateManager.Key_Edit)).getCurrentEditor()) instanceof CellTextEditor) {
                        CellTextEditor textEditor = (CellTextEditor)editor;
                        textEditor.setSyncEnabled(false);
                        textEditor.setText(LeftPromptPanel.this._txtFormula.getText());
                        textEditor.setSyncEnabled(true);
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.sync();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.sync();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.sync();
                }
            });
            this._txtFormula.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    EditingState es;
                    ICellEditor editor;
                    SpreadStateManager sm;
                    if (!LeftPromptPanel.this._syncEnabled) {
                        return;
                    }
                    if (LeftPromptPanel.this._txtFormula.isFocusOwner() && (sm = LeftPromptPanel.this._context.getStateManager()).isState2(SpreadStateManager.Key_Edit) && (editor = (es = (EditingState)sm.getCurrentState2(SpreadStateManager.Key_Edit)).getCurrentEditor()) instanceof CellTextEditor) {
                        CellTextEditor textEditor = (CellTextEditor)editor;
                        textEditor.setSyncEnabled(false);
                        textEditor.setCaretPosition(textEditor.getText().length());
                        textEditor.setSyncEnabled(true);
                    }
                }
            });
            this._txtFormula.addFocusListener(new FocusAdapter(){
                boolean cancelOnce = false;

                @Override
                public void focusLost(FocusEvent e) {
                    this.cancelOnce = e.isTemporary();
                }

                @Override
                public void focusGained(FocusEvent e) {
                    if (this.cancelOnce) {
                        return;
                    }
                    SpreadStateManager sm = LeftPromptPanel.this._context.getStateManager();
                    if (!sm.isState2(SpreadStateManager.Key_Edit) && sm.addState(sm.createEditState(null))) {
                        LeftPromptPanel.this._txtFormula.requestFocus();
                    }
                    if (sm.isState2(SpreadStateManager.Key_Range_Select)) {
                        ((RangeSelectState)sm.getCurrentState2(SpreadStateManager.Key_Range_Select)).setFocusInGrid(false);
                    }
                }
            });
            this._txtFormula.setFocusTraversalKeysEnabled(false);
            this._txtFormula.setFocusTraversalKeys(0, this.getForwardKeys());
            this._txtFormula.setFocusTraversalKeys(1, this.getBackwardKeys());
            InputMap inputMap = this._txtFormula.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "JUMP_ACTIVE_CELL_DOWN");
            inputMap.put(KeyStroke.getKeyStroke(10, 64), "JUMP_ACTIVE_CELL_UP");
            inputMap.put(KeyStroke.getKeyStroke(9, 0), "JUMP_ACTIVE_CELL_RIGHT");
            inputMap.put(KeyStroke.getKeyStroke(9, 64), "JUMP_ACTIVE_CELL_LEFT");
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "inner_CancelEditing");
            ActionManager amg = this._context.getActionManager();
            ActionMap am = this._txtFormula.getActionMap();
            am.put("JUMP_ACTIVE_CELL_DOWN", amg.getAction("JUMP_ACTIVE_CELL_DOWN"));
            am.put("JUMP_ACTIVE_CELL_UP", amg.getAction("JUMP_ACTIVE_CELL_UP"));
            am.put("JUMP_ACTIVE_CELL_RIGHT", amg.getAction("JUMP_ACTIVE_CELL_RIGHT"));
            am.put("JUMP_ACTIVE_CELL_LEFT", amg.getAction("JUMP_ACTIVE_CELL_LEFT"));
            am.put("inner_CancelEditing", amg.getAction("inner_CancelEditing"));
        }

        private void syncBase() {
            String formula = "";
            String localText = "";
            Book book = this._context.getBook();
            if (book != null) {
                Sheet sheet = book.getActiveSheet();
                EmbedhLayer gl = sheet.getEmbedments(false);
                if (gl != null && gl.hasSelection()) {
                    if (gl.selectionSize() == 1) {
                        localText = gl.getActiveSelectedEmbed().getName();
                    }
                } else {
                    Cell cell = sheet.getActiveCell();
                    if (cell != null) {
                        formula = cell.getDisplayFormula();
                    }
                    if ((localText = this._context.getRangeManager().getSelectionRange().getName(false, false, true)) == null) {
                        localText = Sheet.getBlockName(sheet.getActiveRow(), sheet.getActiveCol(), book.getDeps().isA1Style(), false, false);
                    }
                }
            }
            this.setLocalizerText(localText);
            this.setFormula(formula);
        }

        @Override
        public void changed(SheetChangeEvent e) {
            if (this._context.getStateManager().isState2(SpreadStateManager.Key_Range_Select)) {
                return;
            }
            this._syncing = true;
            if (e.hasState(SheetChangeEvent.Changed_RangeSelect | SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Merge | SheetChangeEvent.Changed_Selection | SheetChangeEvent.Changed_SelectionActive | SheetChangeEvent.Changed_Delete | SheetChangeEvent.Changed_Insert | SheetChangeEvent.Changed_Named)) {
                this.syncBase();
            }
            this._syncing = false;
        }

        @Override
        public void changed(BookChangeEvent e) {
            if (this._context.getStateManager().isState2(SpreadStateManager.Key_Range_Select)) {
                return;
            }
            this._syncing = true;
            if (!e.isSheetDeactive()) {
                this.syncBase();
            }
            this._syncing = false;
        }

        @Override
        public void changed(SheetPropertyChangeEvent e) {
        }

        @Override
        public void changed(GraphChangedEvent e) {
            this._syncing = true;
            if (e.isSelectionChanged()) {
                this.syncBase();
            }
            this._syncing = false;
        }

        @Override
        public void propertyChanged(GraphPropertyChangedEvent e) {
            this._syncing = true;
            if (e.isNameChanged()) {
                this.syncBase();
            }
            this._syncing = false;
        }

        private class ActionWrapper
        extends AbstractAction {
            Action _action;

            public ActionWrapper(Action action) {
                this._action = action;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this._action == null) {
                    MessageDialog.show(null, (Object)MultiLanguageKeys.getLocalText("notImplemented", "\u672a\u5b9e\u73b0"));
                } else {
                    this._action.actionPerformed(e);
                }
            }
        }
    }
}

