/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.editor;

import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;

public abstract class AbstractCellEditor
implements ICellEditor {
    protected int _rowIndex;
    protected int _colIndex;
    protected Object _condition;
    protected SpreadContext _context;
    protected KDSpread _spread;
    protected SpreadView _view;
    protected Sheet _sheet;

    @Override
    public ICellEditor.ResultType startEditing(SpreadContext context, int row, int col, Object condition) {
        if (!this.isEditable(condition)) {
            return FAILED;
        }
        this.setConition(condition);
        this.setContext(context);
        this.calcRealPosition(row, col);
        if (!this.allowEditCell()) {
            return FAILED;
        }
        this._view.scrollCellVisible(this._rowIndex, this._colIndex);
        return this.startEditing();
    }

    protected void calcRealPosition(int row, int col) {
        CellBlock mb;
        MergeBlocks merger = this._sheet.getSheetOption().getMerger(false);
        CellBlock cellBlock = mb = merger == null ? null : merger.searchBlock(row, col);
        if (mb != null) {
            this._rowIndex = mb.getRow();
            this._colIndex = mb.getCol();
        } else {
            this._rowIndex = row;
            this._colIndex = col;
        }
    }

    protected void setConition(Object condition) {
        this._condition = condition;
    }

    protected void reset() {
        this._sheet = null;
        this._context = null;
        this._spread = null;
        this._view = null;
        this._rowIndex = -1;
        this._colIndex = -1;
    }

    protected boolean allowEditCell() {
        if (SheetBaseMath.isOutBoundCell(this._rowIndex, this._colIndex)) {
            return false;
        }
        Range rg = this._context.getRangeManager().getRange(this._sheet, this._rowIndex, this._colIndex);
        return !rg.isProtected(rg.getEditProtectState());
    }

    protected void setContext(SpreadContext context) {
        this._context = context;
        this._spread = context.getSpread();
        this._view = this._spread.getActiveView();
        this._sheet = this._spread.getBook().getActiveSheet();
    }

    protected abstract ICellEditor.ResultType startEditing();

    protected abstract boolean isEditable(Object var1);
}

