/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.IWizzardComment;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public final class WizzardComment
extends KDDialog
implements IWizzardComment {
    private SpreadContext _context;
    private KDLabel _authorLb;
    private KDLabel _textLb;
    private KDTextField _authorTF;
    private KDTextArea _textTA;
    private KDButton _okBtn;
    private KDButton _cancelBtn;
    private KDButton _delBtn;
    private Comment _comment;
    private boolean _isCancel;
    private int _mode;

    public WizzardComment(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.setSize(250, 220);
        this.setResizable(false);
        this.initComponents();
        this.initListeners();
    }

    public WizzardComment(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.setSize(250, 220);
        this.setResizable(false);
        this.initComponents();
        this.initListeners();
    }

    @Override
    public void setMode(int mode) {
        this._mode = mode;
        String secretCode = "KEY_COMMENT";
        if (this._mode == 1) {
            secretCode = "KEY_SHEET_COMMENT";
        } else if (this._mode == 2) {
            secretCode = "KEY_BOOK_COMMENT";
        }
        this.setTitle(MultiLanguageKeys.getLocalText(secretCode));
    }

    @Override
    public void commit() {
        if (!this.isCancel()) {
            this._context.getStateManager().stop();
            Sheet sheet = this._context.getBook().getActiveSheet();
            Comment nc = this.getComment();
            if (this._mode == 2) {
                this._context.getBook().setComment(nc);
            } else if (this._mode == 1) {
                sheet.setComment(nc);
            } else {
                this._context.getRangeManager().getActiveCellRange().setComment(nc);
            }
        }
    }

    @Override
    public boolean prepare() {
        this._context.getStateManager().stop();
        Comment comment = this._mode == 2 ? this._context.getBook().getComment() : (this._mode == 1 ? this._context.getBook().getActiveSheet().getComment() : this._context.getRangeManager().getActiveCellRange().getComment());
        if (comment != null) {
            comment = comment.getCopy();
        }
        this.setComment(comment);
        return true;
    }

    private void setComment(Comment comment) {
        this._comment = comment;
        this.updateComps();
    }

    private boolean isCancel() {
        return this._isCancel;
    }

    private Comment getComment() {
        return this._comment;
    }

    private void initComponents() {
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.createTextPanel(), "Center");
        cp.add((Component)this.createCtrlPanel(), "South");
    }

    private KDPanel createTextPanel() {
        this._authorLb = new KDLabel(MultiLanguageKeys.getLocalText("KEY_AUTHOR", "\u4f5c\u8005"));
        this._authorTF = new KDTextField();
        this._textLb = new KDLabel(MultiLanguageKeys.getLocalText("KEY_COMMENT", "\u6279\u6ce8"));
        this._textTA = new KDTextArea();
        KDScrollPane sp = new KDScrollPane((Component)this._textTA);
        KDPanel panel = new KDPanel();
        panel.setLayout(null);
        panel.add((Component)this._authorLb);
        panel.add((Component)this._authorTF);
        panel.add((Component)this._textLb);
        panel.add((Component)sp);
        this._authorLb.setBounds(5, 5, 230, 20);
        this._authorTF.setBounds(5, 30, 230, 20);
        this._textLb.setBounds(5, 55, 230, 20);
        sp.setBounds(5, 80, 230, 80);
        return panel;
    }

    private KDPanel createCtrlPanel() {
        this._delBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_DELETE"));
        this._okBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._cancelBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new FlowLayout());
        panel.add((Component)this._delBtn);
        panel.add((Component)this._okBtn);
        panel.add((Component)this._cancelBtn);
        return panel;
    }

    private void initListeners() {
        this._delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardComment.this._comment = null;
                WizzardComment.this._authorTF.setText("");
                WizzardComment.this._textTA.setText("");
            }
        });
        this._cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardComment.this._isCancel = true;
                WizzardComment.this.closeDialog();
            }
        });
        this._okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardComment.this.updateComments();
                WizzardComment.this._isCancel = false;
                WizzardComment.this.closeDialog();
            }
        });
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void updateComments() {
        boolean b;
        String at = this._authorTF.getText();
        String tt = this._textTA.getText();
        boolean bl = b = StringUtil.isEmptyString((String)at) && StringUtil.isEmptyString((String)tt);
        if (b) {
            if (this._comment != null) {
                this._comment = null;
            }
        } else {
            if (this._comment == null) {
                this._comment = new Comment();
            }
            this._comment.setAuthor(at);
            this._comment.setText(tt);
        }
    }

    private void updateComps() {
        if (this._comment == null) {
            this._authorTF.setText(this._context.getUserName());
            this._textTA.setText("");
        } else {
            this._authorTF.setText(this._comment.getAuthor());
            this._textTA.setText(this._comment.getText());
        }
    }
}

