/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class WizzardDelGroup
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDLabel label;
    private KDSeparator separator;
    private KDRadioButton makeRowGroup;
    private KDRadioButton makeColGroup;
    private KDButton submit;
    private KDButton cancel;

    public WizzardDelGroup(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    public WizzardDelGroup(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    private void initComps() {
        this.label = new KDLabel(MultiLanguageKeys.getLocalText("KEY_GROUP_DELETE", "\u53d6\u6d88\u7ec4\u5408"));
        this.separator = new KDSeparator();
        this.makeRowGroup = new KDRadioButton(MultiLanguageKeys.getLocalText("KEY_GROUP_ROW", "\u884c(R)"));
        this.makeRowGroup.setSelected(true);
        this.makeColGroup = new KDRadioButton(MultiLanguageKeys.getLocalText("KEY_GROUP_COLUMN", "\u5217(C)"));
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.makeRowGroup);
        bg.add((AbstractButton)this.makeColGroup);
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.makeRowGroup, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusBackwardTraversalKeys((JComponent)this.makeRowGroup, (KeyStroke)KeyStroke.getKeyStroke(10, 1));
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.makeColGroup, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        CtrlSwingUtilities.removeManagingFocusBackwardTraversalKeys((JComponent)this.makeColGroup, (KeyStroke)KeyStroke.getKeyStroke(10, 1));
        this.submit = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
        this.cancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
    }

    private void layoutComps() {
        Container c = this.getContentPane();
        c.setLayout(null);
        this.setSize(170, 115);
        this.label.setBounds(5, 5, 50, 15);
        this.separator.setBounds(60, 15, 100, 5);
        this.makeRowGroup.setBounds(15, 25, 60, 15);
        this.makeColGroup.setBounds(15, 45, 60, 15);
        this.submit.setBounds(5, 65, 55, 20);
        this.cancel.setBounds(85, 65, 55, 20);
        c.add((Component)this.label);
        c.add((Component)this.separator);
        c.add((Component)this.makeRowGroup);
        c.add((Component)this.makeColGroup);
        c.add((Component)this.submit);
        c.add((Component)this.cancel);
    }

    private void initListeners() {
        this.submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CellBlock cb = WizzardDelGroup.this._context.getSpread().getBook().getActiveSheet().getSelectionRange().getBlock(0);
                if (WizzardDelGroup.this.makeRowGroup.isSelected()) {
                    WizzardDelGroup.delGroup(WizzardDelGroup.this._context, cb.getRow(), cb.getRow2(), true);
                } else {
                    WizzardDelGroup.delGroup(WizzardDelGroup.this._context, cb.getCol(), cb.getCol2(), false);
                }
                WizzardDelGroup.this.setVisible(false);
                WizzardDelGroup.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardDelGroup.this.setVisible(false);
                WizzardDelGroup.this.dispose();
            }
        });
        JRootPane rootPane = this.getRootPane();
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(82, 8), "focusRow");
        rootPane.getActionMap().put("focusRow", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardDelGroup.this.makeRowGroup.requestFocusInWindow();
                WizzardDelGroup.this.makeRowGroup.setSelected(true);
            }
        });
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(67, 8), "focusCol");
        rootPane.getActionMap().put("focusCol", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardDelGroup.this.makeColGroup.requestFocusInWindow();
                WizzardDelGroup.this.makeColGroup.setSelected(true);
            }
        });
        rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "submit");
        rootPane.getActionMap().put("submit", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardDelGroup.this.submit.doClick();
            }
        });
    }

    public static void delGroup(SpreadContext _context, int id1, int id2, boolean isRow) {
        Book book = _context.getSpread().getBook();
        book.getUndoManager().startGroup();
        Sheet sheet = book.getActiveSheet();
        if (isRow) {
            SortedAttributeSpanArray sasa = sheet.getRowSpans();
            ArrayList spans = sasa.getContinuousSpanList(id1, id2);
            for (Span span : spans) {
                Range range = sheet.getRowRange(span.getStart(), span.getEnd());
                int level = range.getOutlineGroupLevel();
                if (level == 0) continue;
                range.setRowOutlineGroupLevel(level - 1);
            }
            sasa.merge(id1, id2, true);
        } else {
            SortedAttributeSpanArray sasa = sheet.getColSpans();
            ArrayList spans = sasa.getContinuousSpanList(id1, id2);
            for (Span span : spans) {
                Range range = sheet.getColRange(span.getStart(), span.getEnd());
                int level = range.getOutlineGroupLevel();
                if (level == 0) continue;
                range.setColumnOutlineGroupLevel(level - 1);
            }
            sasa.merge(id1, id2, true);
        }
        book.getUndoManager().endGroup();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Range range = this._context.getSpread().getBook().getActiveSheet().getSelectionRange();
        if (range.size() > 1) {
            WindowUtil.msgboxInfo((Object)MultiLanguageKeys.getLocalText("KEY_GROUP_DELETE_MSG", "\u4e0d\u80fd\u5bf9\u591a\u91cd\u9009\u5b9a\u533a\u57df\u4f7f\u7528\u6b64\u547d\u4ee4\u3002"), (String)MultiLanguageKeys.getLocalText("KEY_SPREAD_TITLE", "\u4fe1\u606f\u63d0\u793a"), (Component)((Object)this._context));
            return false;
        }
        CellBlock cb = range.getBlock(0);
        if (cb.isRow()) {
            WizzardDelGroup.delGroup(this._context, cb.getRow(), cb.getRow2(), true);
            return false;
        }
        if (cb.isCol()) {
            WizzardDelGroup.delGroup(this._context, cb.getCol(), cb.getCol2(), false);
            return false;
        }
        this.makeRowGroup.setSelected(true);
        return true;
    }
}

