/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.WizzardCellInsDel;
import com.kingdee.bos.ctrl.excel.impl.state.CopyState;
import com.kingdee.bos.ctrl.excel.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.KDClipboard;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import java.awt.Dialog;
import java.awt.Frame;

public class WizzardInsertPaste
extends WizzardCellInsDel {
    public WizzardInsertPaste(Dialog d, SpreadContext context) {
        super(d, context);
    }

    public WizzardInsertPaste(Frame f, SpreadContext context) {
        super(f, context);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this._btn3.setSelected(true);
    }

    @Override
    public void commit() {
        this.doAction(this.getReturnValue());
    }

    @Override
    public boolean prepare() {
        SheetOption so = this._context.getBook().getActiveSheet().getSheetOption();
        Protection pro = so.getProtection(false);
        if (pro != null && pro.isProtected()) {
            this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_ERROR_EDIT_ON_PROTECTED_OBJECT"), 0);
            return false;
        }
        Selection sel = so.getSelection();
        boolean bRow = sel.isRowBlocks();
        boolean bCol = sel.isColBlocks();
        if (bRow || bCol) {
            this.doAction(bRow ? 2 : 3);
            return false;
        }
        return true;
    }

    private void doAction(int value) {
        if (value == -1) {
            return;
        }
        Sheet activeSheet = this._context.getBook().getActiveSheet();
        SheetOption so = activeSheet.getSheetOption();
        CopyState cps = (CopyState)this._context.getStateManager().getCurrentState();
        boolean bCut = cps.getKey() == SpreadStateManager.Key_Cut;
        SortedCellBlockArray srcBlocks = new SortedCellBlockArray();
        srcBlocks.copyFrom(cps.getSrcBlocks());
        CellBlock cb = CellBlock.getNewCellBlock(0, 0);
        SortedCellBlockArray pasteBlocks = so.getSelection().toSortedBlocks();
        if (Range.makePasteBlocks(srcBlocks, pasteBlocks, cb)) {
            this._context.getBook().getUndoManager().startGroup();
            boolean needDelete = false;
            boolean isRow = srcBlocks.isRowBlocks();
            boolean isCol = srcBlocks.isColBlocks();
            if (bCut) {
                if (KDClipboard.getSourceSheets() != null && KDClipboard.getSourceSheets().getSheet(0) != activeSheet) {
                    KDClipboard.getSourceSheets().getSheet(0).getRange(srcBlocks).clear(true, true, true, true, new String[0]);
                } else if (!isRow && !isCol) {
                    this._context.getRangeManager().getRangeInBook(srcBlocks).clear(true, true, true, true, new String[0]);
                } else {
                    needDelete = true;
                    if (isRow) {
                        if (srcBlocks.getBlock(0).getRow() > pasteBlocks.getBlock(0).getRow()) {
                            this._context.getBook().getActiveSheet().getRange(srcBlocks).delete();
                            needDelete = false;
                        }
                    } else if (isCol && srcBlocks.getBlock(0).getCol() > pasteBlocks.getBlock(0).getCol()) {
                        this._context.getBook().getActiveSheet().getRange(srcBlocks).delete();
                        needDelete = false;
                    }
                }
            }
            Range destRange = this._context.getRangeManager().getRangeInBook(pasteBlocks);
            if (value == 2) {
                this._context.getRangeManager().getCompoundRangeInBook(pasteBlocks.toRowSpans(), true).insert();
            } else if (value == 3) {
                this._context.getRangeManager().getCompoundRangeInBook(pasteBlocks.toColumnSpans(), false).insert();
            } else if (value == 1) {
                destRange.insert(true);
            } else {
                destRange.insert(false);
            }
            destRange.paste(PasteMode.ALL, new String[0]);
            if (bCut) {
                if (needDelete) {
                    this._context.getRangeManager().getRangeInBook(srcBlocks).delete();
                }
                this._context.getStateManager().stop();
            }
            this._context.getBook().getUndoManager().endGroup();
        }
    }
}

