/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.state.util;

import com.kingdee.bos.ctrl.excel.impl.state.util.IState;
import com.kingdee.bos.ctrl.excel.impl.state.util.Rule;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import java.util.Stack;

public class StateManager {
    private Rule _compareRule = new Rule(0, 0, 0);
    private SortedObjectArray _rules = new SortedObjectArray();
    protected Stack _states = new Stack();

    public int removeRule(int firstKey, int secondKey) {
        this._compareRule.setKey(firstKey, secondKey);
        Object o = this._rules.remove((Object)this._compareRule);
        if (o != null) {
            return ((Rule)o).getRule();
        }
        return 0;
    }

    public int addRule(int firstKey, int secondKey, int rule) {
        if (firstKey < 0 || secondKey < 0) {
            return 0;
        }
        Object o = this._rules.insert((Object)new Rule(firstKey, secondKey, rule));
        if (o != null) {
            return ((Rule)o).getRule();
        }
        return 0;
    }

    public int getRule(int firstKey, int secondKey) {
        this._compareRule.setKey(firstKey, secondKey);
        int index = this._rules.search((Object)this._compareRule);
        if (index >= 0) {
            return ((Rule)this._rules.get(index)).getRule();
        }
        return 0;
    }

    public boolean addState(IState state) {
        boolean sus;
        int key;
        int preKey = this.getCurStateKey();
        int rule = this.getRule(preKey, key = state.getKey());
        if (rule == 3) {
            return false;
        }
        if (rule == 1) {
            boolean sus2 = state.start(preKey);
            if (sus2) {
                this._states.push(state);
            }
            return sus2;
        }
        if (rule == 5) {
            return this.stop();
        }
        if (preKey < 0) {
            boolean sus3 = state.start(preKey);
            if (sus3) {
                this._states.push(state);
            }
            return sus3;
        }
        boolean bl = sus = rule == 4 ? this.cancelBySteps(this.getActualSteps(), key) : this.stopBySteps(this.getActualSteps(), key);
        if (!sus) {
            return sus;
        }
        return this.addState(state);
    }

    public int getCurStateKey() {
        if (this._states.isEmpty()) {
            return -1;
        }
        return this.getCurrentState().getKey();
    }

    public boolean stop(int fromKey) {
        int index = -1;
        for (int i = this._states.size() - 1; i >= 0; --i) {
            IState state = (IState)this._states.get(this._states.size() - 1);
            if (state.getKey() != fromKey) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return false;
        }
        return this.stopBySteps(this._states.size() - index, -1);
    }

    public boolean cancel(int fromKey) {
        int index = -1;
        for (int i = this._states.size() - 1; i >= 0; --i) {
            IState state = (IState)this._states.get(this._states.size() - 1);
            if (state.getKey() != fromKey) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return false;
        }
        return this.cancelBySteps(this._states.size() - index, -1);
    }

    public boolean stopAll() {
        return this.stopBySteps(this._states.size(), -1);
    }

    public boolean stop() {
        return this.stopBySteps(this.getActualSteps(), -1);
    }

    public boolean cancelAll() {
        return this.cancelBySteps(this._states.size(), -1);
    }

    public boolean cancel() {
        return this.cancelBySteps(this.getActualSteps(), -1);
    }

    public boolean isState(int key) {
        return this.getCurStateKey() == key;
    }

    public IState getCurrentState() {
        if (this._states.isEmpty()) {
            return null;
        }
        return (IState)this._states.get(this._states.size() - 1);
    }

    private int getActualSteps() {
        int steps = 1;
        return steps;
    }

    private boolean stopBySteps(int steps, int forceKey) {
        int min = Math.min(steps, this._states.size());
        for (int i = 0; i < min; ++i) {
            IState state = this.getCurrentState();
            boolean b = state.stop(forceKey);
            if (!b) {
                return b;
            }
            this._states.pop();
        }
        return true;
    }

    private boolean cancelBySteps(int steps, int forceKey) {
        int min = Math.min(steps, this._states.size());
        for (int i = 0; i < min; ++i) {
            IState state = this.getCurrentState();
            boolean b = state.cancel(forceKey);
            if (!b) {
                return b;
            }
            this._states.pop();
        }
        return true;
    }
}

