/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kds;

import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.kds.KDSConstants;
import com.kingdee.bos.ctrl.excel.io.kds.SectionJarInputStream;
import com.kingdee.bos.ctrl.excel.io.kds.SectionJarUtil;
import com.kingdee.bos.ctrl.excel.io.kds.archives.kds10.KDSAreaReader10;
import com.kingdee.bos.ctrl.excel.io.kds.archives.kds540.KDSAreaReader540;
import com.kingdee.bos.ctrl.excel.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class KDSAreaReader
extends KDSConstants {
    private int fileVersion;
    private static final char EXCLAMATION_MARK = '!';
    private static final char DOLLAR_SYMBOL = '$';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadValues(String file, HashMap cells) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.loadValues(fis, cells);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fis});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    public void loadValues(InputStream is, HashMap cells) {
        this.loadValuesImpl(new KDSDataInputStream(is), cells);
    }

    private void loadValuesImpl(KDSDataInputStream is, HashMap cells) {
        HashSet outputSheet = this.getOutputSheetNames(cells);
        if (outputSheet.size() <= 0) {
            return;
        }
        try {
            byte[] sections = StreamUtil.readInputStream((InputStream)is);
            SectionJarInputStream sis = new SectionJarInputStream(sections);
            this.fileVersion = sis.getFileVersion();
            if (this.fileVersion >= 20000) {
                this.loadValuesImpl(sis, cells, outputSheet);
            } else if (this.fileVersion < 10000) {
                new KDSAreaReader540().loadValuesImpl(sis, cells, outputSheet);
            } else {
                new KDSAreaReader10().loadValuesImpl(sis, cells, outputSheet);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadValuesImpl(SectionJarInputStream sis, HashMap cells, HashSet outputSheet) {
        this.fileVersion = sis.getFileVersion();
        if (KDSAreaReader.isHigherVersion(this.fileVersion)) {
            throw new IllegalArgumentException("Attempt to read kds files with a higher version ID.");
        }
        if (this.fileVersion < 10000) {
            new KDSAreaReader540().loadValuesImpl(sis, cells, outputSheet);
            return;
        }
        if (this.fileVersion < 20000) {
            new KDSAreaReader10().loadValuesImpl(sis, cells, outputSheet);
            return;
        }
        try {
            String[] sheetNames = this.getSheetNames(new KDSDataInputStream(sis.getSection(0)));
            int size = sis.size();
            if (size < 1) {
                throw new IllegalArgumentException("bytes is illegal");
            }
            for (int i = 1; i < size; ++i) {
                if (!outputSheet.contains(sheetNames[i - 1].toUpperCase())) continue;
                this.readSheet(sheetNames[i - 1], cells, new KDSDataInputStream((InputStream)SectionJarUtil.unzip(sis.getByteSection(i))));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HashSet getOutputSheetNames(HashMap cells) {
        HashSet<String> set = new HashSet<String>();
        for (String cell : cells.keySet()) {
            int pos = cell.indexOf(33);
            if (pos <= 0) continue;
            set.add(cell.substring(0, pos).toUpperCase());
        }
        return set;
    }

    private String[] getSheetNames(KDSDataInputStream is) throws IOException {
        is.readString();
        int count = is.readInt();
        is.readInt();
        ArrayList<String> sheetNames = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            is.readString();
            String sheetName = is.readString();
            sheetNames.add(sheetName);
            is.readByte();
            is.readInt();
            if (this.fileVersion <= 20001) continue;
            is.readInt();
        }
        return sheetNames.toArray(new String[0]);
    }

    private void readSheet(String sheetName, HashMap cells, KDSDataInputStream is) throws IOException {
        is.readByte();
        byte id = is.readByte();
        if (id == 5) {
            this.readStyles(is);
        }
        is.readInt();
        block7: while (true) {
            id = is.readByte();
            switch (id) {
                case 1: {
                    this.readRow(sheetName, cells, is);
                    continue block7;
                }
                case 3: {
                    this.readSheetExtends(is);
                    continue block7;
                }
                case 4: {
                    this.readSheetOption(is);
                    continue block7;
                }
                case 2: {
                    this.readCol(is);
                    continue block7;
                }
                case 6: {
                    this.readSheetBorders(is);
                    continue block7;
                }
            }
            break;
        }
    }

    private void readSheetBorders(KDSDataInputStream is) throws IOException {
        block0: while (true) {
            byte id;
            if ((id = is.readByte()) == 1) {
                while (true) {
                    if ((id = is.readByte()) != 0) continue block0;
                    is.readInt();
                    is.readInt();
                    is.readInt();
                    is.readString();
                    is.readByte();
                }
            }
            if (id == 2) {
                this.readBordersRoot(is);
                continue;
            }
            if (id != 3) break;
            this.readBordersRoot(is);
        }
    }

    private void readBordersRoot(KDSDataInputStream is) throws IOException {
        while (is.readByte() == 0) {
            is.readInt();
            is.readInt();
            while (is.readByte() == 0) {
                is.readInt();
                is.readInt();
                is.readInt();
                is.readByte();
            }
        }
    }

    private void readCol(KDSDataInputStream is) throws IOException {
        is.readInt();
        while (is.readByte() == 1) {
            is.readString();
            is.readString();
        }
    }

    private void readSheetOption(KDSDataInputStream is) throws IOException {
        is.readInt();
        is.readInt();
        is.readByte();
        while (true) {
            byte id;
            if ((id = is.readByte()) == 6) {
                this.readPrintSetup(is);
                continue;
            }
            if (id == 1) {
                is.read();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == 2) {
                is.readString();
                is.readString();
                is.readString();
                continue;
            }
            if (id == 4) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == 3) {
                is.readByte();
                is.readInt();
                is.readInt();
                is.readInt();
                is.readInt();
                is.readInt();
                is.readInt();
                is.readInt();
                continue;
            }
            if (id != 5) break;
            is.readString();
        }
    }

    private void readPrintSetup(KDSDataInputStream is) throws IOException {
        is.readByte();
        is.readInt();
        is.readInt();
        is.readInt();
        is.readInt();
        is.readInt();
        is.readInt();
        is.readInt();
        is.readInt();
        is.readInt();
        if (this.fileVersion < 20001) {
            is.readInt();
        } else {
            is.readBoolean();
            is.readInt();
            is.readInt();
            is.readInt();
        }
        is.readInt();
        is.readString();
        is.readInt();
        is.readInt();
        is.readInt();
        is.readString();
        if (this.fileVersion > 20002) {
            is.readString();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readSheetExtends(KDSDataInputStream is) throws IOException {
        block13: while (true) {
            if ((id = is.readByte()) == 5) {
                is.readString();
                is.readString();
                continue;
            }
            if (id == 3) {
                is.readString();
                is.readString();
                continue;
            }
            if (id == 6) {
                this.readValidation(is);
                continue;
            }
            if (id == 4) {
                is.readString();
                is.readString();
                continue;
            }
            if (id == 2 || id == 1) {
                is.readInt();
                is.readInt();
                is.readInt();
                is.readInt();
                is.readByte();
                is.readBoolean();
                is.readBoolean();
                is.readInt();
                is.readBoolean();
                continue;
            }
            if (id == 7) {
                is.readString();
                is.readLengthBytes();
                continue;
            }
            if (id == 8) {
                size = is.readInt();
                i = 0;
                while (true) {
                    if (i >= size) continue block13;
                    valve = is.readInt();
                    is.readString();
                    for (j = 0; j < valve; ++j) {
                        is.readInt();
                        is.readInt();
                        quaIndex = is.readInt();
                        is.readString();
                        if (quaIndex > 1) continue;
                        is.readString();
                    }
                    ++i;
                }
            }
            if (id == 9) {
                isPageView = is.readBoolean();
                if (isPageView) {
                    length = is.readInt();
                    for (i = 0; i < length; ++i) {
                        is.readInt();
                    }
                    length = is.readInt();
                    for (i = 0; i < length; ++i) {
                        is.readInt();
                    }
                }
                if (!is.readBoolean()) continue;
                length = is.readInt();
                for (i = 0; i < length; ++i) {
                    is.readInt();
                }
                length = is.readInt();
                for (i = 0; i < length; ++i) {
                    is.readInt();
                }
                length = is.readInt();
                for (i = 0; i < length; ++i) {
                    is.readInt();
                }
                length = is.readInt();
                i = 0;
                while (true) {
                    if (i >= length) continue block13;
                    is.readInt();
                    ++i;
                }
            }
            if (id == 10) {
                this.readFilters(is);
                continue;
            }
            if (id != 11) break;
            size = is.readInt();
            i = 0;
            while (true) {
                if (i < size) ** break;
                continue block13;
                block23: while (true) {
                    switch (is.readByte()) {
                        case 1: {
                            is.readString();
                            continue block23;
                        }
                        case 2: {
                            is.readString();
                            continue block23;
                        }
                        case 3: {
                            is.readString();
                            continue block23;
                        }
                        case 4: {
                            cols = is.readInt();
                            c = 0;
                            while (true) {
                                if (c >= cols) continue block23;
                                block25: while (true) {
                                    switch (is.readByte()) {
                                        case 1: {
                                            is.readString();
                                            continue block25;
                                        }
                                        case 2: {
                                            is.readString();
                                            continue block25;
                                        }
                                        case 3: {
                                            is.readInt();
                                            continue block25;
                                        }
                                        case 4: {
                                            is.readInt();
                                            continue block25;
                                        }
                                    }
                                    break;
                                }
                                ++c;
                            }
                        }
                        case 5: {
                            continue block23;
                        }
                    }
                    break;
                }
                ++i;
            }
            break;
        }
    }

    private void readFilters(KDSDataInputStream is) throws IOException {
        byte b = is.readByte();
        if (b == 0) {
            is.readInt();
            is.readInt();
            is.readInt();
            is.readInt();
            int count = is.readInt();
            block9: for (int i = 0; i < count; ++i) {
                int id = is.readInt();
                is.readInt();
                switch (id) {
                    case 0: {
                        is.readInt();
                        is.readBoolean();
                        is.readBoolean();
                        continue block9;
                    }
                    case 1: {
                        is.readByte();
                        this.readVariant(is);
                        is.readString();
                        continue block9;
                    }
                    case 2: {
                        continue block9;
                    }
                    case 3: {
                        continue block9;
                    }
                    case 4: {
                        int afcount = is.readInt();
                        for (int index = 0; index < afcount; ++index) {
                            byte readByte = is.readByte();
                            if (readByte == 4) {
                                this.readVariant(is);
                            }
                            if (readByte == 0) {
                                is.readByte();
                                continue;
                            }
                            is.readString();
                        }
                        continue block9;
                    }
                    case 5: {
                        is.readByte();
                        is.readString();
                        is.readByte();
                        is.readByte();
                        is.readString();
                        continue block9;
                    }
                    case 6: {
                        is.readByte();
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("\u9519\u8bef\u7684\u7b5b\u9009\u5668\u6807\u8bc6!");
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u7b5b\u9009\u5668\u6807\u8bc6!");
        }
    }

    private void readVariant(KDSDataInputStream is) throws IOException {
        byte type = is.readByte();
        if (1 == type) {
            is.readString();
        } else if (4 == type) {
            is.readString();
        } else if (8 == type) {
            is.readString();
        } else if (2 == type) {
            is.readBoolean();
        }
    }

    private void readValidation(KDSDataInputStream is) throws IOException {
        is.readInt();
        int quaIndex = is.readInt();
        is.readString();
        is.readByte();
        is.readByte();
        is.readString();
        if (quaIndex <= 1) {
            is.readString();
        }
        is.readString();
        is.readString();
        is.readString();
        is.readString();
        is.readString();
    }

    private void readRow(String sheetName, HashMap cells, KDSDataInputStream is) throws IOException {
        int rowIndex = is.readInt();
        int cursor = 0;
        while (true) {
            byte id;
            if ((id = is.readByte()) == 1) {
                is.readString();
                is.readString();
                continue;
            }
            if (id != 2) break;
            cursor = this.readCell(sheetName, cells, is, rowIndex, cursor);
        }
    }

    private int readCell(String sheetName, HashMap cells, KDSDataInputStream is, int rowIndex, int cellIndex) throws IOException {
        int id = is.readByte();
        if (id == 1) {
            cellIndex = is.readInt();
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 2) {
            is.readInt();
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 3) {
            is.readString();
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 4) {
            Variant var;
            String valueString;
            byte type = is.readByte();
            if (1 == type) {
                valueString = is.readString();
                var = new Variant((Object)valueString, 11);
            } else if (4 == type) {
                valueString = is.readString();
                var = new Variant((Object)new BigDecimal(valueString), 10);
            } else if (8 == type) {
                long lTime;
                valueString = is.readString();
                try {
                    lTime = Long.parseLong(valueString);
                }
                catch (NumberFormatException e) {
                    lTime = 0L;
                }
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(lTime);
                var = new Variant((Object)cal, 13);
            } else {
                var = 2 == type ? new Variant((Object)is.readBoolean(), 8) : Variant.nullVariant;
            }
            List<String> positions = this.getCellPosition(sheetName, rowIndex, cellIndex);
            for (String position : positions) {
                if (!cells.containsKey(position)) continue;
                cells.put(position, var.getValue());
            }
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 5) {
            is.readString();
            id = -1;
        }
        while (true) {
            if (id == -1) {
                id = is.readByte();
            }
            if (id != 6) break;
            is.readString();
            is.readString();
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 7) {
            is.readString();
            is.readString();
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 8) {
            this.readDiagonal(is);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 9) {
            this.readExtProps(is);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 10) {
            is.readBoolean();
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        return ++cellIndex;
    }

    private List<String> getCellPosition(String sheetName, int rowIndex, int cellIndex) {
        ArrayList<String> positions = new ArrayList<String>();
        sheetName = sheetName.toUpperCase();
        String cellCharacter = Tools.getCharacterFromIndex((int)cellIndex);
        int realRowIndex = rowIndex + 1;
        for (int i = 0; i < 2; ++i) {
            String position = sheetName + '!' + cellCharacter + realRowIndex;
            positions.add(position);
            position = sheetName + '!' + '$' + cellCharacter + realRowIndex;
            positions.add(position);
            position = sheetName + '!' + cellCharacter + '$' + realRowIndex;
            positions.add(position);
            position = sheetName + '!' + '$' + cellCharacter + '$' + realRowIndex;
            positions.add(position);
            sheetName = sheetName.toLowerCase();
            cellCharacter = Tools.getCharacterFromIndex((int)cellIndex, (char)'a');
        }
        return positions;
    }

    private void readExtProps(KDSDataInputStream is) throws IOException {
        while (true) {
            byte id;
            if ((id = is.readByte()) == 1) {
                is.readLong();
                continue;
            }
            if (id == 2) {
                is.readLong();
                continue;
            }
            if (id == 3) {
                is.readInt();
                continue;
            }
            if (id != 4) break;
            is.readString();
            is.readString();
        }
    }

    private void readDiagonal(KDSDataInputStream is) throws IOException {
        int i;
        is.readByte();
        is.readInt();
        is.readInt();
        is.readInt();
        is.readInt();
        String srowoffs = is.readString();
        String scoloffs = is.readString();
        int[] rowOffs = null;
        if (!StringUtil.isEmptyString((String)srowoffs)) {
            String[] strs = srowoffs.split(",");
            rowOffs = new int[strs.length];
            for (int i2 = strs.length - 1; i2 >= 0; --i2) {
                rowOffs[i2] = Integer.parseInt(strs[i2]);
            }
        }
        int[] colOffs = null;
        if (!StringUtil.isEmptyString((String)scoloffs)) {
            String[] strs = scoloffs.split(",");
            colOffs = new int[strs.length];
            for (i = strs.length - 1; i >= 0; --i) {
                colOffs[i] = Integer.parseInt(strs[i]);
            }
        }
        int size = (rowOffs == null ? 0 : rowOffs.length) + (colOffs == null ? 0 : colOffs.length) + 2;
        for (i = 0; i < size; ++i) {
            is.readByte();
            is.readInt();
            is.readString();
        }
    }

    private void readStyles(KDSDataInputStream is) throws IOException {
        byte id;
        while ((id = is.readByte()) == 0) {
            this.readStyle(is);
        }
    }

    private void readStyle(KDSDataInputStream is) throws IOException {
        is.readInt();
        while (true) {
            byte id;
            if ((id = is.readByte()) == 1) {
                is.readString();
                is.readInt();
                is.readInt();
                is.readByte();
                continue;
            }
            if (id == 2) {
                is.readInt();
                is.readInt();
                is.readInt();
                is.readByte();
                continue;
            }
            if (id == 4) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == 5) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == 6) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == 7) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == 8) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == 9) {
                is.readInt();
                is.readInt();
                is.readString();
                continue;
            }
            if (id == 10) {
                is.readInt();
                is.readInt();
                is.readInt();
                continue;
            }
            if (id == 11) {
                is.readString();
                continue;
            }
            if (id != 3) break;
            is.readByte();
        }
    }
}

