/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kds;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.ExtProps;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.IBookFieldFlags;
import com.kingdee.bos.ctrl.excel.io.PrintHelper;
import com.kingdee.bos.ctrl.excel.io.kds.KDSConstants;
import com.kingdee.bos.ctrl.excel.io.kds.SectionJarInputStream;
import com.kingdee.bos.ctrl.excel.io.kds.SectionJarUtil;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookProtection;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.CellPropAction;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.excel.model.struct.IBookProvider;
import com.kingdee.bos.ctrl.excel.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SheetOption;
import com.kingdee.bos.ctrl.excel.model.struct.SheetProxy;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.borders.Border;
import com.kingdee.bos.ctrl.excel.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.excel.model.struct.borders.SortedBordersSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionFormatFurtherList;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.CtrlUserObjectTrans;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.filter.CellValueModel;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetCustomAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetDynamicAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetEmptyAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetFirstNAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetItemAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetMultipleItemAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetNonEmptyAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.node.ConstNamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.ObjectCache;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.bos.ctrl.excel.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.bos.ctrl.print.printjob.table.SheetPlugablePaginationAdvice;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

final class KDSBinaryBook
extends KDSConstants
implements IBookProvider {
    private BookIOController _ctrl;
    private String _bookName;
    private int _sheetCount;
    private int _activeSheetIndex;
    private ArrayList _sheetInfos;
    private KDSDataInputStream _bookInfos;
    private int fileVersion;

    public KDSBinaryBook(SectionJarInputStream sis, BookIOController ctrl) throws IOException {
        this._ctrl = ctrl;
        int size = sis.size();
        if (size < 1) {
            throw new IllegalArgumentException("bytes is illegal");
        }
        this.fileVersion = sis.getFileVersion();
        if (KDSBinaryBook.isHigherVersion(this.fileVersion)) {
            throw new IllegalArgumentException("Attempt to read kds files with a higher version ID.");
        }
        this._bookInfos = new KDSDataInputStream(sis.getSection(0));
        this.initBookBase(this._bookInfos);
        for (int i = 1; i < size; ++i) {
            SheetProxy si = (SheetProxy)this._sheetInfos.get(i - 1);
            si.setZipBytes(sis.getByteSection(i));
        }
    }

    public int fileVersion() {
        return this.fileVersion;
    }

    @Override
    public int getActiveSheetIndex() {
        return this._activeSheetIndex;
    }

    @Override
    public String getBookName() {
        return this._bookName;
    }

    @Override
    public int getSheetCount() {
        return this._sheetCount;
    }

    @Override
    public SheetProxy getSheetProxy(int index) {
        return (SheetProxy)this._sheetInfos.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initBookOptions(Book book) {
        block14: {
            book.setFileVersion(this.fileVersion);
            block6: while (true) {
                try {
                    while (true) {
                        byte id;
                        if ((id = this._bookInfos.readByte()) == 5) {
                            boolean extendMode = this._bookInfos.readBoolean();
                            if (!extendMode) continue;
                            book.getDeps().setExtendMode(extendMode);
                            book.setAutoCalculate(false);
                            continue;
                        }
                        if (id == 1) {
                            BookProtection bp = book.getProtection();
                            bp.setOperations(this._bookInfos.readInt());
                            bp.startWithEncryptedPassword(this._bookInfos.readString());
                            continue;
                        }
                        if (id == 2) {
                            String key = this._bookInfos.readString();
                            String strVal = this._bookInfos.readString();
                            if (this._ctrl != null && !this._ctrl.touchModeFlag(IBookFieldFlags.FLAG_BOOK_USEROBJECT)) continue;
                            Object value = this.getUoTransObject(key, strVal);
                            book.setUserObject(key, value);
                            continue;
                        }
                        if (id == 3) {
                            String author = this._bookInfos.readString();
                            String text = this._bookInfos.readString();
                            if (this._ctrl != null && !this._ctrl.touchModeFlag(IBookFieldFlags.FLAG_CELL_COMMENT)) continue;
                            book.setComment(new Comment(author, text));
                            continue;
                        }
                        if (id == 4) {
                            String name = this._bookInfos.readString();
                            String refersTo = this._bookInfos.readString();
                            NamedObjectNode nod = book.getNames().searchByName(name);
                            if (nod != null) {
                                if (nod instanceof ConstNamedObjectNode) continue;
                                Expr expr = book.getActiveSheet().getExpr(nod, refersTo);
                                nod.setExpr(expr);
                                continue;
                            }
                            Sheet sheet = book.getActiveSheet();
                            nod = NamedObjectNode.createUndefinedNamedObject(name, book, sheet);
                            try {
                                sheet.getRange(0, 0).setName(name, refersTo);
                                continue block6;
                            }
                            catch (SyntaxErrorException e) {
                                e.printStackTrace();
                                continue;
                            }
                        }
                        break block14;
                        break;
                    }
                }
                catch (IOException iOException) {
                    break block14;
                }
            }
            finally {
                this._bookInfos = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSheet(Sheet sheet, byte[] bytes) {
        Book book = sheet.getBook();
        boolean oldCalc = book.setAutoCalculate(false);
        boolean oldEnable = book.getUndoManager().isEnable();
        book.getUndoManager().enable(false);
        boolean oldLoading = book.setLoading(true);
        boolean oldA1Style = book.setA1Style(true);
        try {
            this.readSheet(sheet, new KDSDataInputStream((InputStream)SectionJarUtil.unzip(bytes)));
            if (KDSConstants.isOlderVersion(this.fileVersion)) {
                sheet.getBorders().buildFromSSA();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            book.setAutoCalculate(oldCalc);
            book.getUndoManager().enable(oldEnable);
            book.setLoading(oldLoading);
            book.setA1Style(oldA1Style);
        }
    }

    private void initBookBase(KDSDataInputStream is) throws IOException {
        this._bookName = is.readString();
        this._sheetCount = is.readInt();
        this._activeSheetIndex = is.readInt();
        this._sheetInfos = new ArrayList(this._sheetCount);
        for (int i = 0; i < this._sheetCount; ++i) {
            String sheetId = is.readString();
            String sheetName = is.readString();
            SheetProxy si = new SheetProxy(this, sheetId, sheetName);
            byte flags = is.readByte();
            boolean hide = this.touchFlag(flags, 1);
            boolean selected = this.touchFlag(flags, 2);
            boolean hasData = this.touchFlag(flags, 4);
            Color color = null;
            int rgb = is.readInt();
            if (rgb != 0xFFAFAF) {
                color = new Color(rgb, true);
            }
            if (this.fileVersion > 20001) {
                si.setSheetType(is.readInt());
            }
            si.setHide(hide);
            si.setSelected(selected);
            si.setHasData(hasData);
            si.setTabColor(color);
            this._sheetInfos.add(si);
        }
    }

    private Object getUoTransObject(String key, String strVal) {
        Book.IUserObjectProvider trans = null;
        if (this._ctrl != null) {
            trans = this._ctrl.getKmlUOTrans();
        }
        if (trans != null) {
            return trans.getObject(key, strVal);
        }
        return strVal;
    }

    private void readSheet(Sheet sheet, KDSDataInputStream is) throws IOException {
        ShareStyleAttributes ssa;
        int styleid;
        is.readByte();
        HashMap styles = new HashMap();
        byte id = is.readByte();
        if (id == 5) {
            this.readStyles(is, styles);
        }
        if ((styleid = is.readInt()) != -1 && (ssa = (ShareStyleAttributes)styles.get(new Integer(styleid))) != null) {
            sheet.appendSSA(ssa);
        }
        block7: while (true) {
            id = is.readByte();
            switch (id) {
                case 1: {
                    this.readRow(sheet, is, styles);
                    continue block7;
                }
                case 3: {
                    this.readSheetExtends(sheet, is, styles);
                    continue block7;
                }
                case 4: {
                    this.readSheetOption(sheet, is, styles);
                    continue block7;
                }
                case 2: {
                    this.readCol(sheet, is);
                    continue block7;
                }
                case 6: {
                    this.readSheetBorders(sheet, is);
                    continue block7;
                }
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readSheetExtends(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        block17: while (true) {
            if ((id = is.readByte()) == 5) {
                name = is.readString();
                refersTo = is.readString();
                nod = sheet.getBook().getNames().searchByName(name);
                if (nod != null) {
                    if (nod instanceof ConstNamedObjectNode) continue;
                    sheet.getBook().getNames().remove(nod);
                    sheet.getNames().insert(nod);
                    nod.setSheet(sheet);
                    nod.setRefersTo(refersTo);
                    continue;
                }
                try {
                    sheet.getRange(0, 0).setName(sheet.getSyntaxName() + '!' + name, refersTo);
                }
                catch (SyntaxErrorException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (id == 3) {
                key = is.readString();
                strVal = is.readString();
                if (key.equals("ConditionFormatFurtherList")) {
                    trans = new CtrlUserObjectTrans();
                    value = trans.getObject(key, strVal);
                    sheet.set_conditionFormatFurthers((ConditionFormatFurtherList)value);
                    continue;
                }
                value = this.getUoTransObject(key, strVal);
                sheet.setUserObject(key, value);
                continue;
            }
            if (id == 6) {
                this.readValidation(sheet, is);
                continue;
            }
            if (id == 4) {
                author = is.readString();
                text = is.readString();
                sheet.setComment(new Comment(author, text));
                continue;
            }
            if (id == 2 || id == 1) {
                start = is.readInt();
                extent = is.readInt();
                span = new Span(start, start + extent - 1);
                uid = is.readInt();
                ssa = null;
                if (uid != -1) {
                    ssa = (ShareStyleAttributes)styles.get(new Integer(uid));
                }
                length = is.readInt();
                visible = this.touchFlag(is.readByte(), 1);
                sheet.setAboveOfOutlineGroup(is.readBoolean());
                sheet.setLeftToOutlineGroup(is.readBoolean());
                level = is.readInt();
                collapse = is.readBoolean();
                if (id == 1) {
                    sheet.getColSpans().setSpanAttribute(span, ssa, new Integer(length), (Boolean)visible, new Integer(level), new Boolean(collapse), false);
                    continue;
                }
                sheet.getRowSpans().setSpanAttribute(span, ssa, new Integer(length), (Boolean)visible, new Integer(level), new Boolean(collapse), false);
                continue;
            }
            if (id == 7) {
                className = is.readString();
                data = is.readLengthBytes();
                try {
                    emb = null;
                    clazz = Class.forName(className);
                    con = clazz.getConstructor(new Class[]{Sheet.class});
                    emb = (EmbedObject)con.newInstance(new Sheet[]{sheet});
                    if (emb == null) continue;
                    emb.load(data);
                    sheet.getEmbedments(true).addEmbed(emb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (id == 8) {
                size = is.readInt();
                cfl = sheet.getConditionalFormats();
                i = 0;
                while (true) {
                    if (i >= size) continue block17;
                    cf = new ConditionalFormat();
                    valve = is.readInt();
                    scba = SheetBaseMath.getSortedBlocks(sheet, is.readString(), true);
                    readBlockError = false;
                    if (scba.size() == 0) {
                        readBlockError = true;
                    }
                    cf.setBlocks(scba);
                    ssas = new ShareStyleAttributes[valve];
                    cds = new Condition[valve];
                    for (j = 0; j < valve; ++j) {
                        findex = is.readInt();
                        ssas[j] = findex < 0 ? null : (ShareStyleAttributes)styles.get(new Integer(findex));
                        cds[j] = cd = new Condition();
                        cd.setTypeIndex(is.readInt());
                        quaIndex = is.readInt();
                        cd.setQualifierIndex(quaIndex);
                        min = is.readString();
                        max = null;
                        if (quaIndex <= 1) {
                            max = is.readString();
                        }
                        cd.setMinMax(min, max, sheet);
                        cd.setOwner(cf);
                    }
                    cf.setSSAs(ssas);
                    cf.setConditions(cds);
                    if (!readBlockError) {
                        cfl.addConditionalFormat(cf);
                    }
                    ++i;
                }
            }
            if (id == 9) {
                isPageView = is.readBoolean();
                sheet.setPageView(isPageView);
                if (isPageView) {
                    length = is.readInt();
                    snapshot = new int[length];
                    for (i = 0; i < length; ++i) {
                        snapshot[i] = is.readInt();
                    }
                    sheet.setRowPaginationPointsSnapshot(snapshot);
                    length = is.readInt();
                    snapshot = new int[length];
                    for (i = 0; i < length; ++i) {
                        snapshot[i] = is.readInt();
                    }
                    sheet.setColPaginationPointsSnapshot(snapshot);
                }
                if (!is.readBoolean()) continue;
                ppa = new SheetPlugablePaginationAdvice();
                length = is.readInt();
                array = new SortedObjectArray(length);
                for (i = 0; i < length; ++i) {
                    array.insert((Object)ObjectCache.getInteger((int)is.readInt()));
                }
                ppa.setRowShrinkedBreaks(array);
                length = is.readInt();
                array = new SortedObjectArray(length);
                for (i = 0; i < length; ++i) {
                    array.insert((Object)ObjectCache.getInteger((int)is.readInt()));
                }
                ppa.setRowExtendedBreaks(array);
                length = is.readInt();
                array = new SortedObjectArray(length);
                for (i = 0; i < length; ++i) {
                    array.insert((Object)ObjectCache.getInteger((int)is.readInt()));
                }
                ppa.setColShrinkedBreaks(array);
                length = is.readInt();
                array = new SortedObjectArray(length);
                for (i = 0; i < length; ++i) {
                    array.insert((Object)ObjectCache.getInteger((int)is.readInt()));
                }
                ppa.setColExtendedBreaks(array);
                sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)ppa);
                continue;
            }
            if (id == 10) {
                this.readFilters(sheet, is);
                continue;
            }
            if (id != 11) break;
            dm = sheet.getDataSetManager();
            size = is.readInt();
            i = 0;
            while (true) {
                if (i < size) ** break;
                continue block17;
                name = null;
                alias = null;
                define = null;
                ds = null;
                block27: while (true) {
                    switch (is.readByte()) {
                        case 1: {
                            name = is.readString();
                            continue block27;
                        }
                        case 2: {
                            alias = is.readString();
                            continue block27;
                        }
                        case 3: {
                            define = is.readString();
                            type = ExtDataSetType.getExtDataSetType(define);
                            ds = new ExtDataSet(name, type.trimPrefix(define), type);
                            if (alias == null) continue block27;
                            ds.setAlias(alias);
                            continue block27;
                        }
                        case 4: {
                            cols = is.readInt();
                            c = 0;
                            while (true) {
                                if (c >= cols) continue block27;
                                colName = null;
                                colAlias = null;
                                index = 0;
                                dataType = 0;
                                block29: while (true) {
                                    switch (is.readByte()) {
                                        case 1: {
                                            colName = is.readString();
                                            continue block29;
                                        }
                                        case 2: {
                                            colAlias = is.readString();
                                            continue block29;
                                        }
                                        case 3: {
                                            index = is.readInt();
                                            continue block29;
                                        }
                                        case 4: {
                                            dataType = is.readInt();
                                            col = new ExtColumn(ds, colName, index, 2);
                                            col.setDataType(dataType);
                                            if (colAlias != null) {
                                                col.setAlias(colAlias);
                                            }
                                            if (ds == null) continue block29;
                                            ds.addColumn(col);
                                            continue block29;
                                        }
                                    }
                                    break;
                                }
                                ++c;
                            }
                        }
                        case 5: {
                            continue block27;
                        }
                    }
                    break;
                }
                dm.addDataSet(ds);
                ++i;
            }
            break;
        }
    }

    private void readSheetBorders(Sheet sheet, KDSDataInputStream is) throws IOException {
        Borders bdrs = sheet.getBorders();
        HashMap<Integer, Border> bdMap = new HashMap<Integer, Border>();
        Span spMaster = new Span(0, 0);
        Span spMinor = new Span(0, 0);
        block0: while (true) {
            byte id;
            if ((id = is.readByte()) == 1) {
                while (true) {
                    if ((id = is.readByte()) != 0) continue block0;
                    int uid = is.readInt();
                    LineStyle ls = LineStyle.getLineStyleByBits((int)is.readInt());
                    Color clr = new Color(is.readInt(), true);
                    PenStyle ps = PenStyle.getPenStyle((String)is.readString());
                    is.readByte();
                    bdMap.put(new Integer(uid), Borders.getBorder(ps, ls, clr));
                }
            }
            if (id == 2) {
                this.readBordersRoot(is, bdrs, true, spMaster, spMinor, bdMap);
                continue;
            }
            if (id != 3) break;
            this.readBordersRoot(is, bdrs, false, spMaster, spMinor, bdMap);
        }
    }

    private void readBordersRoot(KDSDataInputStream is, Borders bdrs, boolean vert, Span spMaster, Span spMinor, HashMap bdMap) throws IOException {
        SortedBordersSpanArray root = bdrs.getRoot(vert);
        while (is.readByte() == 0) {
            spMaster.setPos(is.readInt(), is.readInt());
            while (is.readByte() == 0) {
                spMinor.setPos(is.readInt(), is.readInt());
                int uid = is.readInt();
                is.readByte();
                Border bdr = (Border)bdMap.get(new Integer(uid));
                Borders.setOneBorder(root, spMaster, spMinor, bdr, null);
            }
        }
    }

    private void readFilters(Sheet sheet, KDSDataInputStream is) throws IOException {
        byte b = is.readByte();
        if (b == 0) {
            int row = is.readInt();
            int row2 = is.readInt();
            int col = is.readInt();
            int col2 = is.readInt();
            sheet.setAutoFilterArea(CellBlock.getNewCellBlock(row, col, row2, col2));
            List autoFilters = sheet.getAutoFilters();
            int count = is.readInt();
            block9: for (int i = 0; i < count; ++i) {
                int id = is.readInt();
                int colIndex = is.readInt();
                switch (id) {
                    case 0: {
                        int amount = is.readInt();
                        boolean isAsc = is.readBoolean();
                        boolean isPercent = is.readBoolean();
                        autoFilters.add(new SheetFirstNAutoFilter(sheet, colIndex, amount, isAsc, isPercent));
                        continue block9;
                    }
                    case 1: {
                        is.readByte();
                        Variant variant = this.readVariant(is);
                        String text = is.readString();
                        autoFilters.add(new SheetItemAutoFilter(sheet, colIndex, variant, text));
                        continue block9;
                    }
                    case 2: {
                        autoFilters.add(new SheetEmptyAutoFilter(sheet, colIndex));
                        continue block9;
                    }
                    case 3: {
                        autoFilters.add(new SheetNonEmptyAutoFilter(sheet, colIndex));
                        continue block9;
                    }
                    case 4: {
                        int afcount = is.readInt();
                        SheetMultipleItemAutoFilter af = new SheetMultipleItemAutoFilter(sheet, colIndex);
                        for (int index = 0; index < afcount; ++index) {
                            byte readByte = is.readByte();
                            Variant variant = readByte == 4 ? this.readVariant(is) : Variant.emptyVariant;
                            String text = "";
                            if (readByte == 0) {
                                text = "";
                                is.readByte();
                            } else {
                                text = is.readString();
                            }
                            af.addSelectedCellValueModel(new CellValueModel(variant, text));
                        }
                        autoFilters.add(af);
                        continue block9;
                    }
                    case 5: {
                        byte operator1 = is.readByte();
                        String value1 = is.readString();
                        byte link = is.readByte();
                        byte operator2 = is.readByte();
                        String value2 = is.readString();
                        autoFilters.add(new SheetCustomAutoFilter(sheet, colIndex, operator1, value1, link, operator2, value2));
                        continue block9;
                    }
                    case 6: {
                        byte type = is.readByte();
                        autoFilters.add(new SheetDynamicAutoFilter(sheet, colIndex, type));
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("\u9519\u8bef\u7684\u7b5b\u9009\u5668\u6807\u8bc6!");
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u7b5b\u9009\u5668\u6807\u8bc6!");
        }
    }

    private void readValidation(Sheet sheet, KDSDataInputStream is) throws IOException {
        Validation val = new Validation(new MessagedValidate(), null);
        MessagedValidate mv = val.getMessagedValidate();
        mv.setTypeIndex(is.readInt());
        int quaIndex = is.readInt();
        mv.setQualifierIndex(quaIndex);
        val.setBlocks(SheetBaseMath.getSortedBlocks(sheet, is.readString(), true));
        mv.setImeMode(is.readByte());
        byte flags = is.readByte();
        mv.setCellRangeList(this.touchFlag(flags, 1));
        mv.setUseBlank(this.touchFlag(flags, 2));
        mv.setInputHide(this.touchFlag(flags, 4));
        mv.setErrorHide(this.touchFlag(flags, 8));
        String min = is.readString();
        String max = null;
        if (quaIndex <= 1) {
            max = is.readString();
        }
        mv.setMinMax(min, max, sheet);
        mv.setInputTitle(is.readString());
        mv.setInputMessage(is.readString());
        mv.setErrorStyle(is.readString());
        mv.setErrorTitle(is.readString());
        mv.setErrorMessage(is.readString());
        sheet.getValidations().addValidation(val);
    }

    private void readSheetOption(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        SheetOption so = sheet.getSheetOption();
        so.setScale(is.readInt());
        int rgb = is.readInt();
        if (rgb != 0xFFAFAF) {
            so.setGridLineColor(new Color(rgb, true));
        }
        byte flags = is.readByte();
        so.setShowHoriLines(this.touchFlag(flags, 1));
        so.setShowVertLines(this.touchFlag(flags, 2));
        while (true) {
            Protection pro;
            byte id;
            if ((id = is.readByte()) == 6) {
                this.readPrintSetup(sheet, is, styles);
                continue;
            }
            if (id == 1) {
                pro = sheet.getSheetOption().getProtection(true);
                boolean start = is.read() != 0;
                pro.setOperations(is.readInt());
                String str = is.readString();
                if (start) {
                    pro.startWithEncryptedPassword(str);
                    continue;
                }
                pro.setEncryptedPassword(str);
                continue;
            }
            if (id == 2) {
                pro = sheet.getSheetOption().getProtection(true);
                String name = is.readString();
                String pw = is.readString();
                String range = is.readString();
                Protection.EditableArea ea = pro.createEditableArea(name);
                ea.setEncryptedPassword(pw);
                ea.addAll(SheetBaseMath.getSortedBlocks(sheet, range, true));
                pro.addEditableArea(ea);
                continue;
            }
            if (id == 4) {
                this.readSelection(sheet, is);
                continue;
            }
            if (id == 3) {
                this.readSplitInfo(sheet, is);
                continue;
            }
            if (id != 5) break;
            this.readMerge(sheet, is);
        }
    }

    private void readPrintSetup(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(true);
        byte flags = is.readByte();
        ps.setLandScape(this.touchFlag(flags, 32));
        ps.setRowFirst(this.touchFlag(flags, 16));
        ps.setBlackWhite(this.touchFlag(flags, 8));
        ps.setHasGrid(this.touchFlag(flags, 4));
        ps.setHasRowHead(this.touchFlag(flags, 1));
        ps.setHasColHead(this.touchFlag(flags, 2));
        ps.setCenterHorizontal(is.readInt());
        ps.setCenterVertical(is.readInt());
        ps.setTopMargin(Float.intBitsToFloat(is.readInt()));
        ps.setBottomMargin(Float.intBitsToFloat(is.readInt()));
        ps.setLeftMargin(Float.intBitsToFloat(is.readInt()));
        ps.setRightMargin(Float.intBitsToFloat(is.readInt()));
        ps.setPagesizeIndex(is.readInt());
        ps.setPagesizeX(Float.intBitsToFloat(is.readInt()));
        ps.setPagesizeY(Float.intBitsToFloat(is.readInt()));
        if (this.fileVersion < 20001) {
            ps.setScale(is.readInt());
        } else {
            ps.setAutoFit(is.readBoolean());
            ps.setScale(is.readInt());
            ps.setAutoFitWidth(is.readInt());
            ps.setAutoFitHeight(is.readInt());
        }
        ps.setHeadMargin(Float.intBitsToFloat(is.readInt()));
        ps.setHeadData(PrintHelper.genHeaderFootList(is.readString(), styles, true));
        ps.setFootAlign(is.readInt());
        ps.setHeadAlign(is.readInt());
        ps.setFootMargin(Float.intBitsToFloat(is.readInt()));
        ps.setFootData(PrintHelper.genHeaderFootList(is.readString(), styles, true));
        if (this.fileVersion > 20002) {
            String path = is.readString();
            ps.setBackGroundUrl(path);
            if (!StringUtil.isEmptyString((String)path)) {
                ps.setBackGround(KDPrinterUtils.createImageFromFile(null, (File)new File(FilenameUtils.normalize((String)path))));
            }
        }
    }

    private void readSelection(Sheet sheet, KDSDataInputStream is) throws IOException {
        int row = is.readInt();
        int col = is.readInt();
        String range = is.readString();
        Selection sel = sheet.getSheetOption().getSelection();
        ArrayList al = SheetBaseMath.getListBlocks(sheet, range, true);
        if (al != null) {
            sel.setData(al, 0, row, col);
        }
    }

    private void readMerge(Sheet sheet, KDSDataInputStream is) throws IOException {
        String range = is.readString();
        SortedCellBlockArray merges = SheetBaseMath.getSortedBlocks(sheet, range, true);
        sheet.getSheetOption().getMerger(true).addAll(merges);
    }

    private void readSplitInfo(Sheet sheet, KDSDataInputStream is) throws IOException {
        SheetOption so = sheet.getSheetOption();
        ViewSplitInfo vs = so.getViewSplitInfo();
        byte flags = is.readByte();
        so.setHide(this.touchFlag(flags, 1));
        so.setSelected(this.touchFlag(flags, 2));
        vs.setFreezed(this.touchFlag(flags, 4));
        vs.setActivePane(is.readInt());
        vs.setFirstRow(is.readInt());
        vs.setFirstCol(is.readInt());
        vs.setFirstRow2(is.readInt());
        vs.setFirstCol2(is.readInt());
        vs.setRowSplit(is.readInt());
        vs.setColSplit(is.readInt());
    }

    private void readCol(Sheet sheet, KDSDataInputStream is) throws IOException {
        byte id;
        int index = is.readInt();
        Column colObject = sheet.getColumn(index, true);
        while ((id = is.readByte()) == 1) {
            String key = is.readString();
            String strVal = is.readString();
            Object value = this.getUoTransObject(key, strVal);
            colObject.setUserObject(key, value);
        }
    }

    private void readRow(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        int rowIndex = is.readInt();
        int cellIndex = 0;
        Row row = sheet.getRow(rowIndex, true);
        while (true) {
            byte id;
            if ((id = is.readByte()) == 1) {
                String key = is.readString();
                String strVal = is.readString();
                Object value = this.getUoTransObject(key, strVal);
                row.setUserObject(key, value);
                continue;
            }
            if (id != 2) break;
            cellIndex = this.readCell(row, cellIndex, is, styles);
        }
    }

    private int readCell(Row row, int cellIndex, KDSDataInputStream is, HashMap styles) throws IOException {
        Cell _bufCell = null;
        int id = is.readByte();
        if (id == 1) {
            cellIndex = is.readInt();
            _bufCell = row.getCell(cellIndex++, true);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 2) {
            ShareStyleAttributes ssa;
            int styleid = is.readInt();
            if (styleid != -1 && (ssa = (ShareStyleAttributes)styles.get(new Integer(styleid))) != null) {
                if (_bufCell == null) {
                    _bufCell = row.getCell(cellIndex++, true);
                }
                _bufCell.setSSA(ssa);
            }
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 3) {
            String fm = is.readString();
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setFormula(fm);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 4) {
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setValue(this.readVariant(is));
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 5) {
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setHyperLink(new HyperLink("", is.readString()));
            id = -1;
        }
        while (true) {
            if (id == -1) {
                id = is.readByte();
            }
            if (id != 6) break;
            String key = is.readString();
            String strVal = is.readString();
            Object value = this.getUoTransObject(key, strVal);
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setUserObject(key, value);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 7) {
            String author = is.readString();
            String text = is.readString();
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setComment(new Comment(author, text));
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 8) {
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            this.readDiagonal(_bufCell, is, styles);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 9) {
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            this.readExtProps(_bufCell, is);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 10) {
            boolean merge = is.readBoolean();
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setMerged(merge);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (_bufCell == null) {
            _bufCell = row.getCell(cellIndex++, true);
        }
        return cellIndex;
    }

    private Variant readVariant(KDSDataInputStream is) throws IOException {
        Variant var;
        byte type = is.readByte();
        if (1 == type) {
            String valueString = is.readString();
            var = new Variant((Object)valueString, 11);
        } else if (4 == type) {
            String valueString = is.readString();
            var = new Variant((Object)new BigDecimal(valueString), 10);
        } else if (8 == type) {
            long lTime;
            String valueString = is.readString();
            try {
                lTime = Long.parseLong(valueString);
            }
            catch (NumberFormatException e) {
                lTime = 0L;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(lTime);
            var = new Variant((Object)cal, 13);
        } else if (2 == type) {
            var = new Variant((Object)is.readBoolean(), 8);
        } else if (9 == type) {
            String text = is.readString();
            var = new Variant((Object)text, 16);
        } else {
            var = Variant.nullVariant;
        }
        return var;
    }

    private void readDiagonal(Cell cell, KDSDataInputStream is, HashMap styles) throws IOException {
        int i;
        byte pos = is.readByte();
        int row = is.readInt();
        int col = is.readInt();
        int row2 = is.readInt();
        int col2 = is.readInt();
        String srowoffs = is.readString();
        String scoloffs = is.readString();
        DiagonalHeader dh = new DiagonalHeader();
        dh.setSheet(cell.getSheet());
        int[] rowOffs = null;
        if (!StringUtil.isEmptyString((String)srowoffs)) {
            String[] strs = srowoffs.split(",");
            rowOffs = new int[strs.length];
            for (int i2 = strs.length - 1; i2 >= 0; --i2) {
                rowOffs[i2] = Integer.parseInt(strs[i2]);
            }
        }
        int[] colOffs = null;
        if (!StringUtil.isEmptyString((String)scoloffs)) {
            String[] strs = scoloffs.split(",");
            colOffs = new int[strs.length];
            for (i = strs.length - 1; i >= 0; --i) {
                colOffs[i] = Integer.parseInt(strs[i]);
            }
        }
        dh.setRowCol(row, col, row2, col2);
        dh.setSplitInfo(new Integer(pos), rowOffs, colOffs);
        cell.setDiagonalHeader(dh);
        int size = dh.size();
        for (i = 0; i < size; ++i) {
            ShareStyleAttributes ssa;
            byte flags = is.readByte();
            dh.setLean((flags & 1) != 0, i);
            dh.setAutoZoom((flags & 2) != 0, i);
            dh.setDrawBackground((flags & 4) != 0, i);
            int uid = is.readInt();
            if (uid != -1 && (ssa = (ShareStyleAttributes)styles.get(new Integer(uid))) != null) {
                dh.setStyle(Styles.getStyle((ShareStyleAttributes)ssa), i);
            }
            dh.setText(is.readString(), i);
        }
    }

    private void readExtProps(Cell cell, KDSDataInputStream is) throws IOException {
        Sheet sheet = cell.getSheet();
        ExtProps ep = cell.getExtProps(true);
        while (true) {
            int col;
            int row;
            byte id;
            if ((id = is.readByte()) == 1) {
                long l = is.readLong();
                row = (int)(l >> 32);
                col = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                ExtProps leftHead = sheet.getCell(row, col, true).getExtProps(true);
                ep.setHead(leftHead, true);
                continue;
            }
            if (id == 2) {
                long l = is.readLong();
                row = (int)(l >> 32);
                col = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                ExtProps topHead = sheet.getCell(row, col, true).getExtProps(true);
                ep.setHead(topHead, false);
                continue;
            }
            if (id == 3) {
                ep.setExtensible(is.readInt());
                continue;
            }
            if (id != 4) break;
            String strKey = is.readString();
            String formula = is.readString();
            ep.getFormulas(true).insert(CellPropAction.getAction(strKey), formula);
        }
    }

    private void readStyles(KDSDataInputStream is, HashMap styles) throws IOException {
        byte id;
        while ((id = is.readByte()) == 0) {
            this.readStyle(is, styles);
        }
    }

    private void readStyle(KDSDataInputStream is, HashMap styles) throws IOException {
        block31: {
            StyleAttributes _cursa = Styles.getEmptySA();
            _cursa.setUID(is.readInt());
            while (true) {
                int intls;
                byte id;
                if ((id = is.readByte()) == 1) {
                    byte flags;
                    int colorRGB;
                    int size;
                    String fontName = is.readString();
                    if (!StringUtil.isEmptyString((String)fontName)) {
                        _cursa.setFontName(fontName);
                    }
                    if ((size = is.readInt()) != -1) {
                        _cursa.setFontSize(size);
                    }
                    if ((colorRGB = is.readInt()) != 0xFFAFAF) {
                        _cursa.setFontColor(new Color(colorRGB, true));
                    }
                    if (this.touchFlag(flags = is.readByte(), 1)) {
                        _cursa.setUnderline(true);
                    }
                    if (this.touchFlag(flags, 2)) {
                        _cursa.setBold(true);
                    }
                    if (this.touchFlag(flags, 4)) {
                        _cursa.setItalic(true);
                    }
                    if (!this.touchFlag(flags, 8)) continue;
                    _cursa.setStrikeThrough(true);
                    continue;
                }
                if (id == 2) {
                    byte flags;
                    int rotat;
                    int vval;
                    int hval = is.readInt();
                    if (hval != -1) {
                        _cursa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((int)hval));
                    }
                    if ((vval = is.readInt()) != -1) {
                        _cursa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((int)vval));
                    }
                    if ((rotat = is.readInt()) != -1) {
                        _cursa.setRotation(rotat);
                    }
                    if (this.touchFlag(flags = is.readByte(), 1)) {
                        _cursa.setWrapText(true);
                    }
                    if (this.touchFlag(flags, 2)) {
                        _cursa.setShrinkText(true);
                    }
                    if (!this.touchFlag(flags, 4)) continue;
                    _cursa.setVerticalText(true);
                    continue;
                }
                if (id == 4) {
                    String penName;
                    Styles.Position pos = Styles.Position.TOP;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 5) {
                    String penName;
                    Styles.Position pos = Styles.Position.BOTTOM;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 6) {
                    String penName;
                    Styles.Position pos = Styles.Position.LEFT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 7) {
                    String penName;
                    Styles.Position pos = Styles.Position.RIGHT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 8) {
                    String penName;
                    Styles.Position pos = Styles.Position.DIAGONALLEFT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 9) {
                    String penName;
                    Styles.Position pos = Styles.Position.DIAGONALRIGHT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 10) {
                    int pid;
                    int rgb = is.readInt();
                    if (rgb != 0xFFAFAF) {
                        _cursa.setBackground(new Color(rgb, true));
                    }
                    if ((pid = is.readInt()) >= 0) {
                        Pattern p = Pattern.getPattern((int)pid);
                        _cursa.setPattern(p);
                    }
                    if ((rgb = is.readInt()) == 0xFFAFAF) continue;
                    _cursa.setPatternColor(new Color(rgb, true));
                    continue;
                }
                if (id == 11) {
                    String nf = is.readString();
                    _cursa.setNumberFormat(nf);
                    continue;
                }
                if (id != 3) break;
                byte flags = is.readByte();
                if (this.touchFlag(flags, 1)) {
                    _cursa.setHided(this.touchFlag(flags, 2));
                }
                if (!this.touchFlag(flags, 4)) continue;
                _cursa.setLocked(this.touchFlag(flags, 8));
            }
            if (_cursa.isEmpty()) break block31;
            styles.put(new Integer(_cursa.getUID()), _cursa);
        }
    }
}

