/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kml;

import com.kingdee.bos.ctrl.excel.io.kml.AbsElement;
import com.kingdee.bos.ctrl.excel.io.kml.BasicElement;
import com.kingdee.bos.ctrl.excel.io.kml.CfRuleElement;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.kml.KmlUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConditionalFormatElement
extends BasicElement {
    private AbsElement cf;

    private AbsElement getFitParser(String uri, String localName, String qName) {
        String qqname = KmlUtil.getLocalName(qName);
        if ("cfRule".equals(qqname)) {
            if (this.cf == null) {
                this.cf = new CfRuleElement();
            }
            return this.cf;
        }
        return null;
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "conditionalFormatting".equals(KmlUtil.getLocalName(qName));
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (this.isCurrentElement(uri, localName, qName)) {
            String styleID = attributes.getValue("dxfId");
            String[] styleIDs = styleID.split(" ");
            String sqRef = attributes.getValue("sqref");
            ConditionalFormat format = dataCache.getConditionalFormat();
            Sheet sheet = dataCache.getCurSheet();
            format.setBlocks(SheetBaseMath.getSortedBlockNodes(sheet, sqRef, true));
            if (ktb.touchModeFlag(FLAG_STYLE)) {
                ShareStyleAttributes[] ssas = new ShareStyleAttributes[styleIDs.length];
                for (int i = 0; i < styleIDs.length; ++i) {
                    ssas[i] = (ShareStyleAttributes)dataCache.getStyles().get(styleIDs[i]);
                }
                format.setSSAs(ssas);
            }
        } else {
            AbsElement parser = this.getFitParser(uri, localName, qName);
            if (parser != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }
    }

    @Override
    void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
        ConditionalFormat format = dataCache.getConditionalFormat();
        format.setConditions(dataCache.getConditions().toArray(new Condition[0]));
        dataCache.getCurSheet().getConditionalFormats().insertConditionalFormat(format.getConditions(), format.getSSAs(), format.getBlocks());
        dataCache.clearConditions();
        dataCache.clearConditionalFormat();
    }
}

