/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.expr;

import com.codahale.metrics.Timer;
import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtendFuncProvider;
import com.kingdee.bos.ctrl.excel.model.expr.ExcelFuncProvider;
import com.kingdee.bos.ctrl.excel.model.expr.ExceptionHandler;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprNeedExpParam;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.expr.IInnerFuncProvider;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodFillParameter;
import com.kingdee.bos.ctrl.excel.model.struct.INeedSheetInfo;
import com.kingdee.bos.ctrl.excel.model.struct.QueryManager;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.ObjectStack;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ExprMethod
implements IExprNode {
    static final int Flag_Batch = 1;
    static final int Flag_Local = 2;
    static final int Flag_VarietyParams = 4;
    static final int Flag_NeedContext = 8;
    static final int Flag_NeedSheetInfo = 16;
    static final int Flag_FillParameter = 32;
    static final int Flag_SubTotal = 64;
    static final int Flag_NeedExpParam = 128;
    static final int Flag_InnerMethod = 256;
    static final int Flag_ExcelMethod = 512;
    static final int Flag_ExtensibleMethod = 1024;
    static final int Flag_ExtDataSetMethod = 2048;
    public static boolean DEBUG = false;
    private static final HashMap _datasetFuncs = new HashMap();
    private Method _method;
    private Object _thisInst;
    private String _instName;
    private Class[] _paramTypes;
    private int _flags;

    public ExprMethod(String instName, Object thisInst, Method method, boolean batch, boolean local) {
        this._thisInst = thisInst;
        this._instName = instName;
        this._method = method;
        this._paramTypes = method.getParameterTypes();
        this.setFlag(1, batch);
        this.setFlag(2, local);
        if (thisInst instanceof IInnerFuncProvider) {
            this.setFlag(256, true);
            if (thisInst instanceof ExcelFuncProvider) {
                this.setFlag(512, true);
            } else {
                if (thisInst instanceof ExtendFuncProvider) {
                    this.setFlag(1024, true);
                }
                if (_datasetFuncs.containsKey(method.getName())) {
                    this.setFlag(2048, true);
                }
            }
        } else if (thisInst instanceof INeedSheetInfo) {
            this.setFlag(16, true);
        }
        int len = this._paramTypes.length;
        if (len > 0) {
            Class cls;
            int varietyIndex = 0;
            if (ExprContext.class.isAssignableFrom(this._paramTypes[0])) {
                this.setFlag(8, true);
                if (this._paramTypes[0] == ExprNeedExpParam.class) {
                    this.setFlag(128, true);
                }
                varietyIndex = 1;
            }
            if (len > varietyIndex && (cls = this._paramTypes[varietyIndex]).isArray() && cls.getComponentType() == Object.class) {
                this.setFlag(4, true);
                if (thisInst instanceof ExcelFuncProvider && method.getName().equals("SUBTOTAL")) {
                    this.setFlag(64, true);
                }
            }
        }
    }

    private boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    private void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    public String getName() {
        return this._method.getName();
    }

    public Method getMethod() {
        return this._method;
    }

    public Object getProviderInstance() {
        return this._thisInst;
    }

    public String getProviderName() {
        return this._instName;
    }

    public int getParamCount() {
        return this.touchFlag(8) ? this._paramTypes.length - 1 : this._paramTypes.length;
    }

    public boolean isBatchMethod() {
        return this.touchFlag(1);
    }

    public boolean isSubTotal() {
        return this.touchFlag(64);
    }

    public boolean isNeedSheetInfo() {
        return this.touchFlag(16);
    }

    public boolean isInnerMethod() {
        return this.touchFlag(256);
    }

    public boolean isExcelMethod() {
        return this.touchFlag(512);
    }

    public boolean isExtensibleMethod() {
        return this.touchFlag(1024);
    }

    public boolean isExtDataSetMethod() {
        return this.touchFlag(2048);
    }

    public boolean isFillParameter() {
        return this.touchFlag(32);
    }

    public boolean setFillParameter(boolean fill) {
        if (this._thisInst instanceof IMethodFillParameter) {
            this.setFlag(32, fill);
            return true;
        }
        return false;
    }

    public boolean isLocalMethod() {
        return this.touchFlag(2);
    }

    public boolean isVarietyParams() {
        return this.touchFlag(4);
    }

    public boolean isNeedContext() {
        return this.touchFlag(8);
    }

    public boolean isNeedExpParam() {
        return this.touchFlag(128);
    }

    public Object[] getProperArgs(Object[] args) throws SyntaxErrorException {
        if (this.getParamCount() != args.length) {
            ExprErr.goError((long)8L, (Object)"");
        }
        Object[] properArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object param = args[i];
            properArgs[i] = param instanceof Variant ? this.getProperArg((Variant)param, this._paramTypes[i]) : param;
        }
        return properArgs;
    }

    public String toString() {
        return this._method.getName();
    }

    @Override
    public int getExprType() {
        return this.isInnerMethod() ? 256 : 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        Timer timer;
        ObjectStack stack = ctx.getCurrentExprStack();
        boolean invoke = this.touchFlag(2) && !this.touchFlag(1);
        boolean parameterPending = false;
        boolean needContext = this.touchFlag(8);
        Variant uid = invoke ? null : (Variant)stack.pop();
        Object[] args = null;
        if (this._paramTypes.length > 0) {
            int varietyIndex;
            args = new Object[this._paramTypes.length];
            for (int i = this._paramTypes.length - 1; i >= 0; --i) {
                Variant var = (Variant)stack.pop();
                args[i] = var;
                if (parameterPending || !var.getVariant().isPending()) continue;
                parameterPending = true;
            }
            int n = varietyIndex = needContext ? 1 : 0;
            if (this.touchFlag(4)) {
                args[varietyIndex] = ((Variant)args[varietyIndex]).getValue();
            } else if (invoke && !parameterPending) {
                for (int i = this._paramTypes.length - 1; i >= 0; --i) {
                    args[i] = this.getProperArg((Variant)args[i], this._paramTypes[i]);
                }
            }
        }
        Timer.Context timerCxt = null == (timer = BookFormulaHelper.getTimer(this._method.getName())) ? null : timer.time();
        Sheet sheet = exprOwner.getSheet();
        try {
            Object result = null;
            if (!parameterPending) {
                if (invoke) {
                    if (this.isNeedSheetInfo()) {
                        ((INeedSheetInfo)this._thisInst).setSheetName(sheet.getSheetName());
                    }
                    result = this._method.invoke(this._thisInst, args);
                    if (needContext && args != null) {
                        ((ExprContext)args[0]).popExprOwner();
                    }
                } else {
                    QueryManager queryManager = sheet.getDeps().getQueryManager();
                    result = queryManager.getValue(this, args, sheet.getSheetName(), uid, !ctx.isNestCalc());
                }
            }
            if (parameterPending || !invoke && result == null) {
                stack.push(Variant.pendResult);
            } else if (result instanceof Variant) {
                stack.push(result);
            } else if (result instanceof SyntaxErrorException) {
                stack.push(new Variant(result, 16));
            } else {
                stack.push(result == null ? Variant.nullVariant : new Variant(result));
            }
        }
        catch (Exception e) {
            FunctionManager fm;
            Object obj;
            if (DEBUG) {
                e.printStackTrace();
            }
            if (needContext) {
                sheet.getExprContextNode().popExprOwner();
            }
            if ((obj = ExceptionHandler.handleInvokeException(e, fm = sheet.getDeps().getFunctionManager())) instanceof Variant) {
                stack.push(obj);
            } else {
                ExprErr.goError((long)128L, (Object)obj);
            }
        }
        finally {
            if (null != timerCxt) {
                timerCxt.close();
            }
        }
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return this._method.getName();
    }

    private final Object getProperArg(Variant var, Class cls) throws SyntaxErrorException {
        Object obj;
        if (Variant.class.isAssignableFrom(cls)) {
            obj = var.getVariant();
        } else if (var.isNumber() || var.isEmpty()) {
            obj = cls == Integer.TYPE ? new Integer(var.intValue()) : (cls == Long.TYPE ? new Long(var.longValue()) : (cls == Float.TYPE ? new Float(var.floatValue()) : (cls == Double.TYPE ? new Double(var.doubleValue()) : (cls == Character.TYPE ? new Character(var.charValue()) : (cls == Byte.TYPE ? new Byte(var.byteValue()) : (cls == Integer.class ? new Integer(var.intValue()) : (cls == Character.class ? new Character(var.charValue()) : (cls == Short.class ? new Short(var.shortValue()) : (cls == String.class ? (var.isEmpty() || var.isNull() ? "" : var.getValue().toString()) : var.getValue())))))))));
        } else if (var.getVt() == 11) {
            Variant varNumber;
            if (this.isNumericClsType(cls) && var.isNumeric(varNumber = Variant.getNewEmptyVariant())) {
                return this.getProperArg(varNumber, cls);
            }
            obj = var.getValue();
        } else {
            obj = var.isReferences() && cls == String.class ? var.getVariant().toString() : var.getValue();
        }
        return obj;
    }

    private final boolean isNumericClsType(Class cls) {
        return cls.equals(Integer.TYPE) || cls.equals(Long.TYPE) || cls.equals(Float.TYPE) || cls.equals(Double.TYPE) || cls.equals(Character.TYPE) || cls.equals(Byte.TYPE) || cls.equals(Integer.class) || cls.equals(Character.class) || cls.equals(Short.class) || cls.equals(Variant.class);
    }

    static {
        _datasetFuncs.put("FIELD", null);
        _datasetFuncs.put("FIELDS", null);
        _datasetFuncs.put("FIRST", null);
        _datasetFuncs.put("LAST", null);
        _datasetFuncs.put("SELECT1", null);
        _datasetFuncs.put("SELECTEX", null);
        _datasetFuncs.put("SELECT", null);
        _datasetFuncs.put("GROUP", null);
        _datasetFuncs.put("ENUMGROUP", null);
        _datasetFuncs.put("OVERLAP", null);
    }
}

