/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.expr;

import com.kingdee.bos.ctrl.common.variant.ExprErr;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprOperator;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.util.ObjectStack;
import java.util.ArrayList;

abstract class Operator_Comparison
extends ExprOperator {
    Operator_Comparison() {
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) {
        ObjectStack stack = ctx.getCurrentExprStack();
        Variant op2 = (Variant)stack.pop();
        Variant op1 = (Variant)stack.pop();
        Variant result = Variant.getNewEmptyVariant();
        if (this.isCellBlockVariant(op1) && this.isCellBlockVariant(op2)) {
            this.doMultiCellBlockOperator(op1, op2, result);
        } else if (this.isCellBlockVariant(op1) || this.isCellBlockVariant(op2)) {
            this.doSingleCellBlockOperator(op1, op2, result);
        } else {
            this.doSingleOperator(op1, op2, result);
        }
        stack.push(result);
    }

    private void doMultiCellBlockOperator(Variant op1, Variant op2, Variant result) {
        CellBlockNode cbn1 = (CellBlockNode)op1.getValue();
        CellBlockNode cbn2 = (CellBlockNode)op2.getValue();
        ArrayList<Variant> results = new ArrayList<Variant>();
        Sheet.ICellsIterator iter = cbn1.getCellsIterator(false, true);
        Sheet.ICellsIterator iter2 = cbn2.getCellsIterator(false, true);
        while (iter.hasNext()) {
            Cell next = iter.next();
            Variant newResult = Variant.getNewEmptyVariant();
            if (iter2.hasNext()) {
                Cell next2 = iter2.next();
                this.doSingleOperator(next.getValue(), next2.getValue(), newResult);
            } else {
                newResult.setObject((Object)ExprErr.getString((long)524288L), 16);
            }
            results.add(newResult);
        }
        while (iter2.hasNext()) {
            iter2.next();
            Variant newResult = Variant.getNewEmptyVariant();
            newResult.setObject((Object)ExprErr.getString((long)524288L), 16);
            results.add(newResult);
        }
        result.setObject((Object)results.toArray());
    }

    private void doSingleCellBlockOperator(Variant op1, Variant op2, Variant result) {
        boolean isLeftCellBlock = false;
        CellBlockNode cbn = null;
        if (op1.getValue() instanceof CellBlockNode) {
            cbn = (CellBlockNode)op1.getValue();
            isLeftCellBlock = true;
        }
        if (op2.getValue() instanceof CellBlockNode) {
            cbn = (CellBlockNode)op2.getValue();
            isLeftCellBlock = false;
        }
        ArrayList<Variant> results = new ArrayList<Variant>();
        if (cbn != null) {
            Sheet.ICellsIterator iter = cbn.getCellsIterator(false, true);
            while (iter.hasNext()) {
                Cell next = iter.next();
                Variant newResult = Variant.getNewEmptyVariant();
                if (isLeftCellBlock) {
                    this.doSingleOperator(next.getValue(), op2, newResult);
                } else {
                    this.doSingleOperator(op1, next.getValue(), newResult);
                }
                results.add(newResult);
            }
        }
        result.setObject((Object)results.toArray());
    }

    public boolean isCellBlockVariant(Variant var) {
        Object value = var.getValue();
        return value instanceof CellBlockNode && !((CellBlockNode)value).isSingleCell();
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return null;
    }

    abstract void doSingleOperator(Variant var1, Variant var2, Variant var3);

    protected int doEqualForEmptyValue(Variant op1, Variant op2) {
        op1 = op1.getVariant();
        op2 = op2.getVariant();
        boolean isEmptyVal1 = false;
        boolean isEmptyVal2 = false;
        if (op1.isNull() || op1.isEmptyString()) {
            isEmptyVal1 = true;
        }
        if (op2.isNull() || op2.isEmptyString()) {
            isEmptyVal2 = true;
        }
        if (isEmptyVal1) {
            return isEmptyVal2 ? 0 : 1;
        }
        return isEmptyVal2 ? 2 : -1;
    }
}

