/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.digitalstyle.Formats;
import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Util;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.expans.model.ExtProps;
import com.kingdee.bos.ctrl.excel.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtGroup;
import com.kingdee.bos.ctrl.excel.expans.model.data.ExtRow;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.excel.model.expr.ExprUID;
import com.kingdee.bos.ctrl.excel.model.expr.ExprUnknownMethod;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorResultProvider;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.expr.Parser;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Dependents;
import com.kingdee.bos.ctrl.excel.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.PasteMode;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormat;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellValueChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlock3DNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.util.IntMarkEntry;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;

public class Cell
implements Comparable,
Cloneable,
IntMarkEntry,
ICalculable {
    static final String KEY_DIAGONAL = "inner_diagonal";
    static final String KEY_HYPERLINK = "inner_hyperlink";
    static final String KEY_COMMENT = "inner_comment";
    static final ContentType FORMULA = new ContentType();
    static final ContentType VALUE = new ContentType();
    static final ContentType DIAGONAL = new ContentType();
    static final ContentType HYPERLINK = new ContentType();
    static final ContentType COMMENT = new ContentType();
    static final ContentType USEROBJECT = new ContentType();
    static final int Flag_HasValue = 1;
    static final int Flag_Formated = 2;
    static final int Flag_NeedCalc = 4;
    static final int Flag_Calculating = 8;
    static final int Flag_Queued = 16;
    static final int Flag_Deleted = 32;
    static final int Flag_Merge = 64;
    static final int Flag_QueueLast = 128;
    static final java.util.regex.Pattern _pattern = java.util.regex.Pattern.compile("\n");
    public static boolean SHOW_EmptyCellObj = false;
    private static String[] WRONG_NUMBERFORMATS = new String[]{"\uffe5* #,###.00;\uffe5* -#,###.00", "#,###.00;-#,###.00"};
    private static String[] REPLACEMENT_NUMBERFORMATS = new String[]{"\uffe5* #,##0.00;\uffe5* -#,##0.00", "#,##0.00;-#,##0.00"};
    private Row _row;
    private Column _col;
    private int _flags;
    private Object _var;
    private String _text;
    private ShareStyleAttributes _ssa;
    private Style _style;
    private ExtData _extData;
    private ExtProps _extProps;

    static boolean isEmptyCell(Cell cll) {
        return cll == null || cll.getValue2() == Variant.nullVariant;
    }

    static String getCellName(Sheet sheet, int row, int col, boolean bAbs, boolean bEntire) {
        return bEntire ? sheet.getSyntaxName() + "!" + SheetBaseMath.getBlockA1Name(row, col, bAbs, bAbs) : SheetBaseMath.getBlockA1Name(row, col, bAbs, bAbs);
    }

    static StyleAttributes getBubbleSA(ShareStyleAttributes thisSSA, Sheet sheet, int row, int col, CellBlock mergeBlock) {
        StyleAttributes sa;
        block3: {
            block4: {
                Cell cllFirst;
                sa = Styles.getSA((ShareStyleAttributes)thisSSA);
                if (sa.isFull()) break block3;
                if (mergeBlock == null || (cllFirst = sheet.getFirstCell(mergeBlock, false)).getRow() == row && cllFirst.getCol() == col) break block4;
                sa.append(cllFirst.getSSA(), false, ShareStyleAttributes.BEFORE_BORDER);
                if (sa.isFull()) break block3;
            }
            sheet.getBorders().getMergeCellBorders(row, col, sa, mergeBlock);
            if (!sa.isFull()) {
                int bitCount = ShareStyleAttributes.ATTRS_COUNT;
                sa.append(sheet.getRowSSA(row), false, bitCount);
                if (!sa.isFull()) {
                    sa.append(sheet.getColSSA(col), false, bitCount);
                    if (!sa.isFull()) {
                        sa.append(sheet.getSSA(), false, bitCount);
                    }
                }
            }
        }
        return sa;
    }

    public static Cell getNewCell(Row row, Column col) {
        return new Cell(row, col);
    }

    public void cloneVarFrom(Cell cll) {
        this._flags = cll._flags;
        this._var = cll._var;
        this._text = cll._text;
        if (cll.hasFormula()) {
            ExprData src = (ExprData)this._var;
            ExprData newED = new ExprData(src);
            newED.setExpr((Expr)src.getExpr().clone(), null);
            newED.setCalcUID(src.getCalcUID() - 1);
            this._var = newED;
        }
    }

    public static Variant parseValue(String value, String fmt, boolean parseDate) {
        Variant var;
        if (!StringUtil.isEmptyString((String)fmt) && fmt.startsWith("@")) {
            var = new Variant((Object)value, 11);
        } else {
            var = Format.parseData((String)value, (boolean)parseDate);
            Cell.reduceScale(var);
        }
        return var;
    }

    public static Variant parseValue(String value, String fmt, boolean parseDate, CellValueChangeListener event, Cell cell) {
        Variant var;
        if (!StringUtil.isEmptyString((String)fmt) && fmt.startsWith("@")) {
            var = new Variant((Object)value, 11);
        } else {
            var = Format.parseData((String)value, (boolean)parseDate);
            event.change(cell, var, "NUMBER");
        }
        return var;
    }

    private static void reduceScale(Variant var) {
        if (var.getVt() == 10) {
            BigDecimal bd = (BigDecimal)var.getValue();
            if (bd.scale() > 16) {
                bd = bd.setScale(16, 4);
                var.setObject((Object)bd, 10);
            }
            Util.reduceScale((Variant)var);
        }
    }

    private Cell(Row row, Column col) {
        this._row = row;
        this._col = col;
        this._flags = 0;
        this._ssa = Styles.getEmptySSA();
    }

    public HyperLink getHyperLink() {
        Object o = this.getExtObject(KEY_HYPERLINK);
        if (o instanceof HyperLink) {
            return (HyperLink)o;
        }
        return null;
    }

    public DiagonalHeader getDiagonalHeader() {
        Object o = this.getExtObject(KEY_DIAGONAL);
        if (o instanceof DiagonalHeader) {
            return (DiagonalHeader)((Object)o);
        }
        return null;
    }

    public Comment getComment() {
        Object o = this.getExtObject(KEY_COMMENT);
        if (o instanceof Comment) {
            return (Comment)o;
        }
        return null;
    }

    public void setHyperLink(HyperLink link) {
        if (link != null && StringUtil.isEmptyString((String)link.getText())) {
            link.setText(this.getText());
        }
        this.setExtObject(KEY_HYPERLINK, link);
    }

    public void setDiagonalHeader(DiagonalHeader header) {
        this.setExtObject(KEY_DIAGONAL, (Object)header);
    }

    public void setComment(Comment comment) {
        this.setExtObject(KEY_COMMENT, comment);
    }

    public Object getUserObjectValue(String key) {
        UserObject uo;
        if (this._extData != null && this._extData._userObjects != null && (uo = this._extData._userObjects.getUserObject(key)) != null) {
            return uo.getValue();
        }
        return null;
    }

    public UserObject getUserObject(String key) {
        if (this._extData != null && this._extData._userObjects != null) {
            return this._extData._userObjects.getUserObject(key);
        }
        return null;
    }

    public UserObject setUserObject(String key, Object obj) {
        UserObject uo = new UserObject(key, obj);
        if (this._extData == null) {
            this._extData = new ExtData();
        }
        if (this._extData._userObjects == null) {
            this._extData._userObjects = new SortedUserObjectArray();
        }
        return this._extData._userObjects.insertByKey(uo);
    }

    public UserObject removeUserObject(String key) {
        if (this._extData != null && this._extData._userObjects != null) {
            return this._extData._userObjects.removeByKey(key);
        }
        return null;
    }

    public boolean isLocked() {
        return this.getStyle().isLocked();
    }

    public boolean isHidden() {
        Sheet sheet = this.getSheet();
        return SheetBaseMath.isHideRow(sheet, this.getRow()) || SheetBaseMath.isHideCol(sheet, this.getCol());
    }

    public boolean hasSubTotalMethod() {
        Expr expr = this.getExpr();
        return expr == null ? false : expr.hasSubTotalMethod();
    }

    public boolean isEmpty() {
        return this.isEmptyContent() && this.isEmptyAttribute();
    }

    public boolean hasUnknownMethod() {
        if (this._var instanceof ExprData) {
            Expr expr = ((ExprData)this._var).getExpr();
            return expr != null && expr.hasUnknownMethod();
        }
        return false;
    }

    public int getMethodState() {
        Expr expr;
        if (this._var instanceof ExprData && (expr = ((ExprData)this._var).getExpr()) != null) {
            return expr.getExprNodeState();
        }
        return 2;
    }

    public boolean isEmptyContent() {
        return this._var == null && (this._extData == null || this._extData.isEmptyContent()) && this._extProps == null;
    }

    public boolean isEmptyContent2() {
        return this._var == null && (this._extData == null || this._extData.isEmptyContent());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName(false, true) + "[");
        if (this.touchFlag(1)) {
            sb.append("V");
        }
        if (this.touchFlag(2)) {
            sb.append(",F[" + this.getText() + "]");
        }
        if (this.touchFlag(4)) {
            sb.append(",NC");
        }
        if (this.touchFlag(16)) {
            sb.append(",Q");
        }
        if (this.touchFlag(32)) {
            sb.append(",D");
        }
        if (this.touchFlag(64)) {
            sb.append(",M");
        }
        if (this.touchFlag(8)) {
            sb.append(",Cing");
        }
        sb.append("]");
        return sb.toString() + " = " + this.getFormula();
    }

    protected Object clone() {
        Object cll;
        try {
            cll = super.clone();
        }
        catch (CloneNotSupportedException e) {
            cll = null;
        }
        return cll;
    }

    public int compareTo(Object obj) {
        return this.hashCode() - obj.hashCode();
    }

    public int getCalcUID() {
        return this._var instanceof ExprData ? ((ExprData)this._var).getCalcUID() : 0;
    }

    public Style getStyle() {
        if (this._style == null) {
            Sheet sheet = this._row.getSheet();
            CellBlock mergeBlock = this.getMerge(true);
            this._style = Styles.getStyle((ShareStyleAttributes)Cell.getBubbleSA(this._ssa, sheet, this._row.getRow(), this._col.getCol(), mergeBlock));
        }
        return this._style;
    }

    public Style getDisplayStyle() {
        Style extStyle;
        if (!this.touchFlag(2)) {
            this.getText();
        }
        return (extStyle = this.getExtStyle()) != null ? extStyle : this.getStyle();
    }

    public ShareStyleAttributes getSSA() {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this._ssa);
        this.getSheet().getBorders().getCellBorders(this.getRow(), this.getCol(), sa);
        return Styles.getSSA((StyleAttributes)sa);
    }

    public ShareStyleAttributes getSSA2() {
        return this._ssa;
    }

    public boolean setSSA(ShareStyleAttributes ssa) {
        boolean bRet = false;
        if (this._ssa != ssa) {
            if (this._ssa == null) {
                if (!StringUtil.isEmptyString((String)ssa.getNumberFormat())) {
                    this.setFlag(2, false);
                }
            } else if (ssa == null) {
                if (!StringUtil.isEmptyString((String)this._ssa.getNumberFormat())) {
                    this.setFlag(2, false);
                }
            } else if (!StringUtil.equals((String)this._ssa.getNumberFormat(), (String)ssa.getNumberFormat())) {
                this.setFlag(2, false);
            }
            this._ssa = ssa instanceof StyleAttributes ? Styles.getSSA((StyleAttributes)((StyleAttributes)ssa)) : ssa;
            if (this._ssa.hasBordersAttributes()) {
                Span spMaster = new Span(0, 0);
                Span spMinor = new Span(0, 0);
                this.getSheet().getBorders().buildCellBorderFromSSA(this, spMaster, spMinor);
            }
            bRet = true;
        } else if (ssa != null && this._ssa == ssa && ssa.hasBordersAttributes()) {
            Span spMaster = new Span(0, 0);
            Span spMinor = new Span(0, 0);
            this.getSheet().getBorders().buildCellBorderFromSSA(this, spMaster, spMinor);
        }
        this.updateStyle();
        return bRet;
    }

    @Override
    public int getIntMark() {
        return this._col.getIntMark();
    }

    @Override
    public void setIntMark(int col) {
        this._col = this._row.getSheet().getColumn(col, true);
    }

    public int getRow() {
        return this._row.getIntMark();
    }

    public int getCol() {
        return this._col.getIntMark();
    }

    public CellBlock getMerge(boolean search) {
        MergeBlocks merger;
        CellBlock mergeBlock = null;
        if ((search || this.touchFlag(64)) && (merger = this.getSheet().getMerger(false)) != null) {
            mergeBlock = merger.searchBlock(this.getRow(), this.getCol());
        }
        return mergeBlock;
    }

    public String getName(boolean bAbs, boolean bEntire) {
        return Cell.getCellName(this.getSheet(), this.getRow(), this.getCol(), bAbs, bEntire);
    }

    public boolean hasFormula() {
        return this._var instanceof ExprData ? ((ExprData)this._var).getExpr() != null : false;
    }

    public String getDisplayFormula() {
        Protection pro = this.getSheet().getSheetOption().getProtection(false);
        if (pro != null && pro.isProtected() && this.getStyle().isHided()) {
            return "";
        }
        String formula = this.getFormula();
        if (this.hasFormula()) {
            formula = _pattern.matcher(formula).replaceAll("\\\\n");
        }
        return formula;
    }

    public String getFormula() {
        while (true) {
            if (this._var == null) {
                if (!SHOW_EmptyCellObj) {
                    return "";
                }
                if (!this.isEmptyContent()) break;
                return "\u00a4";
            }
            if (this._var instanceof ExprData) {
                return ((ExprData)this._var).getFormula(this.getSheet(), this);
            }
            if (((Variant)this._var).getVt() != 16384) break;
            this.getValue();
        }
        return this._var.toString();
    }

    public Object getVar() {
        return this._var;
    }

    public String getText() {
        String numberformat;
        String replacementFormat;
        if (this.touchFlag(2)) {
            return this._text;
        }
        if (!this.touchFlag(1)) {
            this._text = "";
        }
        if (null != (replacementFormat = this.getReplacementNumberfromat(numberformat = this.getStyle().getNumberFormat()))) {
            this.format(this.getValue(), replacementFormat);
        } else {
            this.format(this.getValue(), numberformat);
        }
        this.setFlag(2, true);
        return this._text;
    }

    StyleAttributes formatWithoutConditionalFormat(Variant value, String format) {
        StyleAttributes sa;
        block22: {
            sa = Styles.getEmptySA();
            this._text = null;
            if (value.isEqualsEmpty() && this._var != null) {
                this._text = "";
                return sa;
            }
            if (Cell.isOldNumberFormat(format)) {
                if (value.isNull()) {
                    this._text = "";
                } else if (format.charAt(0) == '%') {
                    this._text = Tools.format((String)format, (Object)value.getValue());
                } else {
                    format = format.substring(6);
                    String[] formats = format.split(";");
                    try {
                        boolean sign;
                        boolean bl = sign = value.isNumber() && value.toBigDecimal().compareTo(BigDecimal.valueOf(0L)) < 0;
                        if (sign) {
                            this._text = Tools.format((String)formats[0], (Object)value.getValue());
                            sa.setFontColor(Color.red);
                            break block22;
                        }
                        this._text = Tools.format((String)formats[1], (Object)value.getValue());
                    }
                    catch (SyntaxErrorException sign) {}
                }
            } else {
                IErrorResultProvider pvd;
                Object o;
                Style style;
                Format formatObj;
                if (!StringUtil.isEmptyString((String)format) && (formatObj = Formats.getFormat((String)format)) != null) {
                    formatObj.formatStyle(value, sa, false);
                }
                if (!(style = this.getStyle()).hasHorizontalAlign()) {
                    if (this.getSheet().getSheetOption().getCellDisplayMode() != 0 && this.hasFormula()) {
                        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                    } else if (value.isNumber() || value.isDate()) {
                        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    } else if (value.getVt() == 8) {
                        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                    } else {
                        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
                    }
                } else {
                    sa.setHorizontalAlign(style.getHorizontalAlign());
                }
                if (this.getMerge(false) != null && !style.isWrapText() && value.isString() && StringUtil.isWrapString((String)((String)value.getValue()))) {
                    sa.setWrapText(true);
                }
                if (value.isError() && (o = value.getValue()) instanceof SyntaxErrorException && (pvd = this.getDeps().getFunctionManager().getErrorResultProvider()) != null) {
                    this._text = pvd.getText(((SyntaxErrorException)((Object)o)).getErrorCode());
                }
                if (this._text == null) {
                    this._text = this.getMutableFormat(format).format(value, false).toString();
                }
            }
        }
        return sa;
    }

    void format(Variant value, String format) {
        Variant display_value = new Variant(value.getValue());
        if (this.getUserObject("display") != null && display_value.isNumber()) {
            Variant divider;
            String formatPre;
            int indexOf;
            String[] formatArr;
            int scale = 3;
            if (!StringUtil.isEmptyString((String)format) && (formatArr = format.split(";")).length > 0 && (indexOf = (formatPre = formatArr[0]).indexOf(".")) > 0) {
                formatPre = formatPre.substring(indexOf);
                scale = formatPre.length();
            }
            if (this.getUserObject("display").getValue().toString().equals("1") || this.getUserObject("display").getValue().toString().equals("3")) {
                divider = new Variant(1000);
                try {
                    display_value.divide(divider);
                    display_value.setBigDecimal(display_value.toBigDecimal().setScale(scale, RoundingMode.HALF_UP));
                }
                catch (SyntaxErrorException e) {
                    e.printStackTrace();
                }
            } else if (this.getUserObject("display").getValue().toString().equals("2") || this.getUserObject("display").getValue().toString().equals("4")) {
                scale = 1;
                divider = new Variant(10000);
                try {
                    display_value.divide(divider);
                    display_value.setBigDecimal(display_value.toBigDecimal().setScale(scale, RoundingMode.HALF_UP));
                }
                catch (SyntaxErrorException e) {
                    e.printStackTrace();
                }
            }
        }
        Sheet sheet = this.getSheet();
        ConditionalFormat cf = sheet.getConditionalFormats().getConditionalFormat(this.getRow(), this.getCol());
        ShareStyleAttributes styleAttributes = null;
        if (cf != null && cf.getConditions() != null) {
            SortedCellBlockArray blocks = cf.getBlocks();
            int size = blocks.size();
            boolean isFind = false;
            int offset = 0;
            for (int i = 0; i < size; ++i) {
                CellBlock cb;
                Object obj = blocks.get(i);
                if (!(obj instanceof CellBlock) || !(cb = (CellBlock)obj).contains(this.getRow(), this.getCol())) continue;
                offset = this.getRow() - cb.getRow();
                isFind = true;
                break;
            }
            styleAttributes = isFind ? cf.getMergedShareStyleAttributes(cf.isMatchedOffsetFormulas(sheet, value, this, offset)) : cf.getMergedShareStyleAttributes(cf.isMatcheds(sheet, value, this));
        }
        StyleAttributes sa = this.formatWithoutConditionalFormat(display_value, format);
        if (styleAttributes != null) {
            styleAttributes = Styles.getSSA((StyleAttributes)Styles.getSA(styleAttributes));
            sa.replace(styleAttributes);
            if (sa.getPattern() == Pattern.None) {
                sa.setBackground(null);
                sa.setPattern(null);
            }
        }
        if (!sa.isEmpty()) {
            StyleAttributes newSA = Styles.getSA((ShareStyleAttributes)this.getStyle());
            newSA.replace((ShareStyleAttributes)sa);
            this.setExtStyle(Styles.getStyle((ShareStyleAttributes)newSA));
        } else {
            this.setExtStyle(null);
        }
        if (this.getUserObject("display") != null && display_value.isNumber()) {
            if (this.getUserObject("display").getValue().toString().equals("1")) {
                this._text = this._text + "(\u5343\u5143)";
            } else if (this.getUserObject("display").getValue().toString().equals("2")) {
                this._text = this._text + "(\u4e07\u5143)";
            }
        }
        sheet.removeStyleCache(this.getRow(), this.getCol());
    }

    public static boolean isOldNumberFormat(String nFormat) {
        return !StringUtil.isEmptyString((String)nFormat) && (nFormat.startsWith("%") || nFormat.startsWith("#-;[R]"));
    }

    public static boolean isReadOnlyForHyperlink(Cell cell) {
        Variant var = cell.getValue();
        return cell.hasFormula() || !var.isNull() && (var.getVt() == 8 || var.isNumber() || var.isDate());
    }

    public boolean setFormula(String formula) {
        Sheet sheet = this.getSheet();
        if (sheet.isDisposed()) {
            return false;
        }
        Book book = sheet.getBook();
        boolean bChanged = false;
        if (StringUtil.isEmptyString((String)formula)) {
            if (this._var != null) {
                bChanged = true;
                this._var = null;
                this.setTextEmpty();
                this.setFlag(3, true);
            }
        } else if (!this.hasFormula() || !StringUtil.equals((String)this.getFormula(), (String)formula)) {
            bChanged = true;
            this.setTextEmpty();
            this.setFlag(3, false);
            if (formula.length() > 1 || formula.equals("'")) {
                char firstChar = formula.charAt(0);
                if (firstChar == '\'') {
                    Variant value = new Variant((Object)(formula.length() == 1 ? "" : formula.substring(1)), 11);
                    this._var = new ExprData(formula, null, value);
                    this.setFlag(1, true);
                    this.setFlag(4, false);
                } else if (firstChar == '=') {
                    this.setFlag(4, true);
                    this.parseFormula(formula);
                } else {
                    this.setFlag(1, true);
                    this.setFlag(4, false);
                    this._var = new Variant((Object)formula, 16384);
                    if (Cell.checkKoreaChar(formula)) {
                        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this._ssa);
                        sa.setFontName("dialog");
                        this.setSSA(Styles.getSSA((StyleAttributes)sa));
                        this.getSheet().removeStyleCache(this.getRow(), this.getCol());
                    }
                }
            } else {
                this._var = new Variant((Object)formula, 16384);
                this.setFlag(1, true);
                this.setFlag(4, false);
            }
        }
        if (bChanged && book.isCalcCurrentCell() && this.queue(book.getDeps(), book.isAutoCalculate()) > 0) {
            book.calcQueue();
        }
        return bChanged;
    }

    public static boolean checkKoreaChar(String inputStr) {
        for (int i = 0; i < inputStr.length(); ++i) {
            if ((inputStr.charAt(i) <= '\u3130' || inputStr.charAt(i) >= '\u318f') && (inputStr.charAt(i) < '\uac00' || inputStr.charAt(i) > '\ud7a3')) continue;
            return true;
        }
        return false;
    }

    @Override
    public Sheet getSheet() {
        return this._row.getSheet();
    }

    @Override
    public boolean isNeedRecalc() {
        return this.touchFlag(4);
    }

    @Override
    public void setNeedRecalc(boolean bRecalc) {
        this.setFlag(4, bRecalc);
    }

    @Override
    public boolean isCalculating() {
        return this.touchFlag(8);
    }

    @Override
    public void setCalculating(boolean bCalculating) {
        this.setFlag(8, bCalculating);
    }

    public boolean isHasValue() {
        return this.touchFlag(1);
    }

    @Override
    public boolean isQueued() {
        return this.touchFlag(16);
    }

    @Override
    public void setQueued(boolean bQueued) {
        this.setFlag(16, bQueued);
    }

    public boolean isQueueLast() {
        return this.touchFlag(128);
    }

    public void setQueueLast(boolean bQueueLast) {
        this.setFlag(128, bQueueLast);
    }

    @Override
    public void updateFormula() {
        if (this._var instanceof ExprData) {
            ((ExprData)this._var).updateFormula();
        }
    }

    @Override
    public void updateExpr(boolean queue) {
        if (this._var instanceof ExprData) {
            this.parseFormula(this.getFormula());
            if (queue) {
                this.queue();
            }
        }
    }

    @Override
    public Variant getValue() {
        return this.getValue(true);
    }

    public void setValue(Variant value) {
        CellValueChangeListener event = this.getSheet().getBook().getCellValueChangeListener();
        if (this._var instanceof ExprData) {
            String dateFormula;
            ExprData ed = (ExprData)this._var;
            if (event != null) {
                event.change(this, value, "NUMBER");
                ed.setValueWithoutScale(value);
            } else {
                ed.setValue(value);
            }
            if (ed.getExpr() == null && !StringUtil.isEmptyString((String)(dateFormula = Expr.getDateString(value)))) {
                ed.setFormula(dateFormula);
            }
        } else {
            if (event != null) {
                event.change(this, value, "NUMBER");
            } else {
                Cell.reduceScale(value);
            }
            this._var = value;
            String dateFormula = Expr.getDateString(value);
            if (!StringUtil.isEmptyString((String)dateFormula)) {
                this._var = new ExprData(dateFormula, null, value);
            }
        }
        this.setFlag(1, true);
        this.setFlag(2, false);
        Book book = this.getSheet().getBook();
        if (book.isAutoCalculate() && this.queue(book.getDeps(), book.isAutoCalculate()) > 0) {
            book.calcQueue();
        }
    }

    public Variant getValue2() {
        return this.getValue(false);
    }

    private Variant getValue(boolean parseDate) {
        Variant var;
        if (this.touchFlag(32)) {
            var = Variant.badReference;
        } else if (this._var instanceof ExprData) {
            ExprData ed = (ExprData)this._var;
            if (this.touchFlag(1)) {
                var = ed.getValue();
            } else {
                Sheet sheet = this.getSheet();
                if (this.touchFlag(4) && sheet.isEnableCalculation() && sheet.getBook().isAutoCalculate()) {
                    this.setCalculating(true);
                    this.calc(sheet.getDeps().getExprContext());
                    this.setCalculating(false);
                }
                var = ed.getValue();
            }
            if (var == null) {
                var = Variant.nullVariant;
            }
        } else if (this._var == null) {
            var = Variant.nullVariant;
        } else {
            var = (Variant)this._var;
            if (var.getVt() == 16384) {
                CellValueChangeListener event = this.getSheet().getBook().getCellValueChangeListener();
                var = event == null ? Cell.parseValue((String)var.getValue(), this.getStyle().getNumberFormat(), parseDate) : Cell.parseValue((String)var.getValue(), this.getStyle().getNumberFormat(), parseDate, event, this);
                this._var = var;
                String dateFormula = Expr.getDateString(var);
                if (!StringUtil.isEmptyString((String)dateFormula)) {
                    this._var = new ExprData(dateFormula, null, var);
                }
            }
        }
        return var;
    }

    public void updateValueType() {
        String dateFormula;
        Variant var = this.getValue();
        if (var == null || var.getValue() == null) {
            return;
        }
        if (var.getVt() == 13) {
            return;
        }
        CellValueChangeListener event = this.getSheet().getBook().getCellValueChangeListener();
        var = event == null ? Cell.parseValue(String.valueOf(var.getValue()), this.getStyle().getNumberFormat(), true) : Cell.parseValue(String.valueOf(var.getValue()), this.getStyle().getNumberFormat(), true, event, this);
        Expr expr = null;
        if (this._var instanceof ExprData) {
            dateFormula = this.getFormula();
            expr = ((ExprData)this._var).getExpr();
        } else {
            dateFormula = Expr.getDateString(var);
        }
        this._var = !StringUtil.isEmptyString((String)dateFormula) ? (expr != null ? new ExprData(dateFormula, expr, var) : new ExprData(dateFormula, null, var)) : var;
    }

    @Override
    public boolean calc(ExprContext ctx) {
        if (!(this._var instanceof ExprData) || !((ExprData)this._var).canExecute() || this.touchFlag(32)) {
            this.setFlag(20, false);
            return true;
        }
        ExprData exprData = (ExprData)this._var;
        if (exprData.getCalcUID() == ctx.getCalcUID()) {
            return true;
        }
        Sheet sheet = this.getSheet();
        Dependents deps = sheet.getDeps();
        boolean extensible = deps.isExtendMode();
        ExtProps thisProps = null;
        if (extensible && (thisProps = this.getExtProps(false)) != null) {
            try {
                ExtProps head = thisProps.getHead(true, false);
                if (head != null && !head.isCell00()) {
                    deps.calcReferTo(head.getCell());
                }
                if ((head = thisProps.getHead(false, false)) != null && !head.isCell00()) {
                    deps.calcReferTo(head.getCell());
                }
            }
            catch (SyntaxErrorException e) {
                return false;
            }
            ExtDataSetManager dm = sheet.getDataSetManager();
            dm.resetCurrent();
            thisProps.setCurrentGroup();
            dm.fillDefaultCurrent();
        }
        this.setFlag(3, false);
        this.setTextEmpty();
        Expr expr = exprData.getExpr();
        Variant value = expr.execute(ctx, this);
        if (value.isCalcLast()) {
            this.setFlag(128, true);
        }
        if (this.touchFlag(128)) {
            return false;
        }
        exprData.setCalcUID(ctx.getCalcUID());
        this.setFlag(1, true);
        this.setFlag(16, false);
        boolean pending = value.isPending();
        this.setFlag(4, pending);
        CellValueChangeListener event = this.getSheet().getBook().getCellValueChangeListener();
        if (event != null) {
            event.change(this, value, "NUMBER");
            exprData.setValueWithoutScale(value);
        } else {
            exprData.setValue(value);
        }
        if (extensible && !pending) {
            int resultCount = 0;
            extensible = value.isArray();
            if (extensible) {
                resultCount = ((Object[])value.getValue()).length;
                boolean bl = extensible = resultCount > 0;
                if (!extensible) {
                    this.setValue(Variant.nullVariant);
                }
            } else {
                Object var = value.getValue();
                if (var instanceof ExtGroup) {
                    ExtGroup grp = (ExtGroup)var;
                    thisProps.setGroup(grp);
                    resultCount = grp.size();
                    boolean bl = extensible = resultCount > 1;
                    if (!extensible) {
                        ExtRow[] rows = grp.getRows();
                        if (rows.length > 0) {
                            thisProps.setExtRow(rows[0]);
                            this.setValue(grp.getValues()[0]);
                        } else {
                            ExtRow nullRow = grp.getDataSet().getNullRow();
                            thisProps.setExtRow(nullRow);
                            this.setValue(nullRow.getValue());
                        }
                    }
                } else if (var instanceof ExtRow) {
                    ExtRow row = (ExtRow)var;
                    thisProps.setExtRow(row);
                    this.setValue(row.getValue());
                    if (row.isNullRow()) {
                        thisProps.setGroup(row.getDataSet().getNullGroup());
                    }
                }
            }
            if (extensible) {
                boolean yDir = thisProps.getExtensible(true) == 2;
                thisProps.extend(yDir, resultCount);
            }
        }
        return true;
    }

    public void calcFormulaProps(ExprContext ctx) {
        SortedExtPropFormulasArray formulas;
        if (this._extProps == null || (formulas = this._extProps.getFormulas(false)) == null) {
            return;
        }
        ExtDataSetManager dm = this.getSheet().getDataSetManager();
        dm.resetCurrent();
        this._extProps.setCurrentGroup();
        dm.fillDefaultCurrent();
        ctx.pushExprOwner(this);
        int size = formulas.size();
        for (int i = 0; i < size; ++i) {
            SortedExtPropFormulasArray.Node node = (SortedExtPropFormulasArray.Node)formulas.get(i);
            Variant value = node.getExpr().execute(ctx, null);
            Object obj = value.getValue();
            if (obj instanceof ExtRow) {
                value = ((ExtRow)obj).getValue();
            }
            node.getAction().action(this, value);
        }
        ctx.popExprOwner();
    }

    public int getBaseRow() {
        return this.getRow();
    }

    public int getBaseCol() {
        return this.getCol();
    }

    @Override
    public Expr getExpr() {
        Expr expr = null;
        if (this._var instanceof ExprData) {
            expr = ((ExprData)this._var).getExpr();
        }
        return expr;
    }

    public boolean isFirstMergedCell() {
        return this.touchFlag(64);
    }

    public void setMerged(boolean merged) {
        this.setFlag(64, merged);
    }

    void reduceBorder() {
        StyleAttributes bubbleSA;
        StyleAttributes thisSA;
        long sameBits;
        if (!ShareStyleAttributes.isEmptySSA((ShareStyleAttributes)this._ssa) && (sameBits = (thisSA = Styles.getSA((ShareStyleAttributes)this._ssa)).sameBits((ShareStyleAttributes)(bubbleSA = Cell.getBubbleSA(Styles.getEmptySSA(), this.getSheet(), this.getRow(), this.getCol(), this.getMerge(false))), 0, ShareStyleAttributes.ATTRS_COUNT)) > 0L) {
            thisSA.clearAttributes(sameBits);
            thisSA.validateBorderAttributes();
            ShareStyleAttributes newSSA = Styles.getSSA((StyleAttributes)thisSA);
            if (this._ssa != newSSA) {
                this.setSSA(newSSA);
            }
        }
    }

    public SortedUserObjectArray getUserObjects(boolean bCreate) {
        if (this._extData == null) {
            if (!bCreate) {
                return null;
            }
            this._extData = new ExtData();
            this._extData._userObjects = new SortedUserObjectArray();
        }
        if (this._extData._userObjects == null && bCreate) {
            this._extData._userObjects = new SortedUserObjectArray();
        }
        return this._extData._userObjects;
    }

    void setUserObjects(SortedUserObjectArray userObjects) {
        if (userObjects != null) {
            if (this._extData == null) {
                this._extData = new ExtData();
            }
            this._extData._userObjects = userObjects;
        } else if (this._extData != null) {
            this._extData._userObjects = null;
            if (this._extData._extStyle == null && this._extData.isEmptyContent()) {
                this._extData = null;
            }
        }
    }

    SortedUserObjectArray getExtObjects(boolean bCreate) {
        if (this._extData == null) {
            if (!bCreate) {
                return null;
            }
            this._extData = new ExtData();
            this._extData._extObjects = new SortedUserObjectArray();
        }
        if (this._extData._extObjects == null && bCreate) {
            this._extData._extObjects = new SortedUserObjectArray();
        }
        return this._extData._extObjects;
    }

    void setExtObjects(SortedUserObjectArray extObjects) {
        if (extObjects != null) {
            if (this._extData == null) {
                this._extData = new ExtData();
            }
            this._extData._extObjects = extObjects;
        } else if (this._extData != null) {
            this._extData._extObjects = null;
            if (this._extData._extStyle == null && this._extData.isEmptyContent()) {
                this._extData = null;
            }
        }
    }

    void setDeleted(boolean bDelete) {
        this.setFlag(32, bDelete);
    }

    public int queue(Dependents deps, boolean queueRefer) {
        return deps.queue(this, queueRefer, false);
    }

    public int queue() {
        if (this.touchFlag(16)) {
            return 0;
        }
        Book book = this.getSheet().getBook();
        return this.queue(book.getDeps(), book.isAutoCalculate());
    }

    void setExtObject(String key, Object value) {
        this.getExtObjects(true).insertByKey(new UserObject(key, value));
    }

    Object getExtObject(String key) {
        int index;
        SortedUserObjectArray extObjects = this.getExtObjects(false);
        if (extObjects != null && (index = extObjects.searchByKey(key)) >= 0) {
            return extObjects.getUserObject(index).getValue();
        }
        return null;
    }

    void clearExtObject(String key) {
        int index;
        SortedUserObjectArray extObjects = this.getExtObjects(false);
        if (extObjects != null && (index = extObjects.searchByKey(key)) >= 0) {
            extObjects.removeByPos(index);
            if (extObjects.isEmpty()) {
                this.setExtObjects(null);
            }
        }
    }

    UserObject setUserObject(UserObject uo) {
        return this.getUserObjects(true).insertByKey(uo);
    }

    void copyContent(Cell src) {
        this._var = src._var;
        this._flags = src._flags;
        this._text = src._text;
        this.setUserObjects(src.getUserObjects(false));
        this.setExtObjects(src.getExtObjects(false));
    }

    private String[] getKeepKeys() {
        String[] keepKeys = null;
        Book.IUserObjectProvider provider = this.getSheet().getBook().getUserObjectsProvider();
        if (provider != null) {
            keepKeys = provider.getKeepKeys();
        }
        return keepKeys;
    }

    private SortedUserObjectArray getNewUserObjects(SortedUserObjectArray oldUserObjects, String[] userKeys, boolean forclear) {
        String[] keepKeys;
        if (!(oldUserObjects == null || oldUserObjects.isEmpty() || (keepKeys = this.getKeepKeys()) != null && keepKeys.length == 0)) {
            int i;
            SortedUserObjectArray newUserObjects = null;
            if (userKeys.length == 0) {
                if (keepKeys != null) {
                    int size = keepKeys.length;
                    for (i = 0; i < size; ++i) {
                        UserObject uo = oldUserObjects.getUserObject(keepKeys[i]);
                        if (uo == null) continue;
                        if (newUserObjects == null) {
                            newUserObjects = new SortedUserObjectArray();
                        }
                        newUserObjects.insert(uo);
                    }
                }
            } else {
                newUserObjects = this.getCopyUserObjects(oldUserObjects);
                if (keepKeys == null) {
                    for (i = 0; i < userKeys.length; ++i) {
                        newUserObjects.removeByKey(userKeys[i]);
                    }
                } else {
                    for (i = 0; i < userKeys.length; ++i) {
                        int j;
                        for (j = 0; !(j >= keepKeys.length || keepKeys[j] != null && keepKeys[j].equals(userKeys[i])); ++j) {
                        }
                        if (j != keepKeys.length) continue;
                        newUserObjects.removeByKey(userKeys[i]);
                    }
                }
            }
            if (forclear) {
                return newUserObjects;
            }
            if (newUserObjects != null && newUserObjects.size() == oldUserObjects.size()) {
                return null;
            }
            if (newUserObjects == null) {
                return this.getCopyUserObjects(oldUserObjects);
            }
            SortedUserObjectArray newUserObjects2 = this.getCopyUserObjects(oldUserObjects);
            int size = newUserObjects.size();
            for (int i2 = 0; i2 < size; ++i2) {
                newUserObjects2.removeByKey(newUserObjects.getUserObject(i2).getKey());
            }
            return newUserObjects2;
        }
        return null;
    }

    Cell clear(boolean formula, boolean value, boolean style, boolean comment, String[] userKeys) {
        SortedUserObjectArray extObjects;
        SortedUserObjectArray newUserObjects;
        SortedUserObjectArray oldUserObjects;
        Cell changedProps = new Cell(this._row, this._col);
        boolean changed = false;
        if (!(userKeys == null || (oldUserObjects = this.getUserObjects(false)) == null || oldUserObjects.isEmpty() || (newUserObjects = this.getNewUserObjects(oldUserObjects, userKeys, true)) != null && newUserObjects.size() == oldUserObjects.size())) {
            changedProps.setUserObjects(oldUserObjects);
            this.setUserObjects(newUserObjects);
            changed = true;
        }
        if (style && !this._ssa.isEmpty()) {
            changedProps._ssa = this._ssa;
            this._ssa = Styles.getEmptySSA();
            this._style = null;
            this.setFlag(2, false);
            changed = true;
        }
        if ((formula || value) && this._var != null) {
            changedProps._var = this._var;
            changedProps._flags = this._flags;
            changedProps._text = this._text;
            if (formula && value) {
                this._var = null;
                this._text = "";
                this.setFlag(1, false);
                this.setFlag(2, false);
            } else if (formula) {
                if (this._var instanceof ExprData) {
                    this._var = ((ExprData)this._var).getValue();
                }
            } else if (value) {
                if (this.getMethodState() != 2) {
                    String thisFormula = this.getFormula();
                    this._var = null;
                    this._text = "";
                    this.setFlag(1, false);
                    this.setFlag(2, false);
                    this.setFormula(thisFormula);
                }
                this._var = null;
                this._text = "";
                ValidationList validationList = this.getSheet().getValidations();
                if (validationList != null && validationList.getValidate(this.getRow(), this.getCol()) != null) {
                    this._var = null;
                    this._text = "";
                }
            }
            this.queue();
            changed = true;
        }
        if (comment && value) {
            extObjects = this.getExtObjects(false);
            if (extObjects != null) {
                changedProps.setExtObjects(extObjects);
                this.setExtObjects(null);
                changed = true;
            }
        } else if (comment) {
            if (this.getComment() != null) {
                changedProps.getExtObjects(true).insert(this.getExtObjects(false).removeByKey(KEY_COMMENT));
                changed = true;
            }
        } else if (value && (extObjects = this.getExtObjects(false)) != null) {
            UserObject dh;
            SortedUserObjectArray propsExtObjects = changedProps.getExtObjects(true);
            UserObject hl = extObjects.removeByKey(KEY_HYPERLINK);
            if (hl != null) {
                propsExtObjects.insertByKey(hl);
            }
            if ((dh = extObjects.removeByKey(KEY_DIAGONAL)) != null) {
                propsExtObjects.insertByKey(dh);
            }
            changed = true;
        }
        return changed ? changedProps : null;
    }

    void resumeClear(Cell changedProps, boolean formula, boolean value, boolean style, boolean comment, String[] userKeys) {
        SortedUserObjectArray propsExtObjects;
        if (changedProps.getUserObjects(false) != null) {
            this.setUserObjects(changedProps.getUserObjects(false));
        }
        if (style && changedProps._ssa != null) {
            this.setSSA(changedProps._ssa);
        }
        if (formula || value) {
            this._var = changedProps._var;
            this._text = changedProps._text;
            this._flags = changedProps._flags;
        }
        if (comment && value) {
            this.setExtObjects(changedProps.getExtObjects(false));
        } else if (comment) {
            UserObject uo;
            SortedUserObjectArray propsExtObjects2 = changedProps.getExtObjects(false);
            if (propsExtObjects2 != null && (uo = propsExtObjects2.getUserObject(KEY_COMMENT)) != null) {
                this.getExtObjects(true).insert(uo);
            }
        } else if (value && (propsExtObjects = changedProps.getExtObjects(false)) != null) {
            SortedUserObjectArray extObjects = this.getExtObjects(true);
            UserObject hl = propsExtObjects.getUserObject(KEY_HYPERLINK);
            UserObject dh = propsExtObjects.getUserObject(KEY_DIAGONAL);
            if (hl != null) {
                extObjects.insertByKey(hl);
            }
            if (dh != null) {
                extObjects.insertByKey(dh);
            }
        }
        if (value && (this._ssa == null || this._ssa.isEmpty() || this._ssa.getHorizontalAlign() == Styles.HorizontalAlignment.NORMAL)) {
            this.setFlag(2, false);
        }
    }

    private SortedUserObjectArray getCopyUserObjects(SortedUserObjectArray userObjects, boolean bExt) {
        Book.IUserObjectProvider pd = this.getSheet().getBook().getUserObjectsProvider();
        SortedUserObjectArray so = new SortedUserObjectArray();
        int size = userObjects.size();
        for (int i = 0; i < size; ++i) {
            UserObject uo = userObjects.getUserObject(i);
            UserObject nuo = new UserObject(uo.getKey());
            if (bExt || pd == null) {
                nuo.setValue(uo.getValue());
            } else {
                nuo.setValue(pd.getObject(uo.getKey(), pd.getString(uo.getKey(), uo.getValue())));
            }
            so.insert(nuo);
        }
        return so;
    }

    private SortedUserObjectArray getCopyUserObjects(SortedUserObjectArray userObjects) {
        return this.getCopyUserObjects(userObjects, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Cell copyFrom(Cell src, PasteMode mode, boolean needCalc, String[] userKeys, boolean bProtected) {
        Cell changedProps = new Cell(this._row, this._col);
        boolean changed = false;
        this.setExtStyle(null);
        if (userKeys != null) {
            SortedUserObjectArray newUserObjects;
            SortedUserObjectArray userObjects = this.getUserObjects(false);
            changedProps.setUserObjects(userObjects);
            boolean lengthNotZero = userKeys.length > 0;
            SortedUserObjectArray sortedUserObjectArray = newUserObjects = lengthNotZero ? this.getNewUserObjects(src.getUserObjects(false), userKeys, false) : src.getUserObjects(false);
            if (newUserObjects != null && newUserObjects.size() != 0) {
                if (!lengthNotZero) {
                    newUserObjects = this.getCopyUserObjects(src.getUserObjects(false));
                }
                if (userObjects != null && userObjects.size() != 0) {
                    SortedUserObjectArray newUserObjets2 = this.getCopyUserObjects(userObjects);
                    newUserObjets2.insertAll(newUserObjects);
                    this.setUserObjects(newUserObjets2);
                } else {
                    this.setUserObjects(newUserObjects);
                }
            }
        }
        boolean bFormats = mode.touchFlag(PasteMode.Formats);
        boolean bFormula = mode.touchFlag(PasteMode.Formulas);
        boolean bValue = mode.touchFlag(PasteMode.Values);
        boolean bComment = mode.touchFlag(PasteMode.Comments);
        boolean bExt = mode.touchFlag(PasteMode.ExtObjectsExceptComments);
        if (bComment && bExt) {
            SortedUserObjectArray extObjects = this.getExtObjects(false);
            SortedUserObjectArray srcExtObjects = src.getExtObjects(false);
            if (extObjects != null || srcExtObjects != null) {
                changedProps.setExtObjects(extObjects);
                this.setExtObjects(srcExtObjects != null ? this.getCopyUserObjects(srcExtObjects, true) : null);
                changed = true;
            }
        } else if (bComment) {
            Comment comment = this.getComment();
            Comment newcomment = src.getComment();
            if (comment != null || newcomment != null) {
                changedProps.setComment(comment);
                this.setComment(newcomment != null ? newcomment.getCopy() : null);
                changed = true;
            }
        } else if (bExt) {
            // empty if block
        }
        Object srcVar = src._var;
        if (bFormula || bValue) {
            changedProps._var = this._var instanceof ExprData ? ((ExprData)this._var).clone() : this._var;
            changedProps._text = this._text;
            changedProps._flags = this._flags;
            changed = true;
            if (bFormula) {
                if (srcVar instanceof ExprData) {
                    if (needCalc) {
                        this.setFlag(1, false);
                    }
                    Sheet thisSheet = this.getSheet();
                    ExprData srcED = (ExprData)srcVar;
                    Expr srcExpr = srcED.getExpr();
                    if (srcExpr != null && !srcExpr.isSyntaxError()) {
                        boolean noOffset = mode.touchFlag(PasteMode.NoOffset);
                        IExprNode[] nodes = srcExpr.getAllNodesClone();
                        boolean isVLookUP = false;
                        for (int i = nodes.length - 1; i >= 0; --i) {
                            ExprMethod method;
                            IExprNode node = nodes[i];
                            if (node instanceof CellBlockNode) {
                                int offsetY;
                                int offsetX;
                                CellBlockNode newNode;
                                if (node instanceof CellBlock3DNode) {
                                    CellBlock3DNode cb3 = (CellBlock3DNode)node;
                                    newNode = (CellBlock3DNode)cb3.clone();
                                    if (!(noOffset || i == 2 && isVLookUP)) {
                                        offsetX = cb3.isRow() ? 0 : this.getCol() - src.getCol();
                                        offsetY = cb3.isCol() ? 0 : this.getRow() - src.getRow();
                                        newNode.offset(offsetY, offsetX);
                                    }
                                    newNode.setRefs(null);
                                    nodes[i] = newNode.getSheet().setDependent((ICalculable)this, newNode);
                                    continue;
                                }
                                CellBlockNode cb = (CellBlockNode)node;
                                newNode = (CellBlockNode)cb.clone();
                                if (!noOffset) {
                                    offsetX = cb.isRow() ? 0 : this.getCol() - src.getCol();
                                    offsetY = cb.isCol() ? 0 : this.getRow() - src.getRow();
                                    newNode.offset(offsetY, offsetX);
                                }
                                if (thisSheet.getBook().isClipBook()) {
                                    if (cb.getSheet() == src.getSheet()) {
                                        newNode.setSheet(thisSheet);
                                    }
                                } else {
                                    String cbsn = cb.getSheet().getSheetName();
                                    Sheet cbs = thisSheet.getBook().getSheet(cbsn);
                                    if (cbs == null) {
                                        cbs = new Sheet(thisSheet.getBook(), cbsn);
                                    }
                                    newNode.setSheet(cbs);
                                    if (cbsn.equals(src.getSheet().getSheetName())) {
                                        newNode.setSheet(thisSheet);
                                    }
                                }
                                newNode.setRefs(null);
                                nodes[i] = newNode.getSheet().setDependent((ICalculable)this, newNode);
                                continue;
                            }
                            if (node instanceof ExprUID) {
                                nodes[i] = ExprUID.getNewInstance();
                                continue;
                            }
                            if (node instanceof ExprUnknownMethod) {
                                ExprUnknownMethod unknown = (ExprUnknownMethod)node;
                                this.getDeps().getUnknownMethodManager().getUnknownFunction(unknown.getMethodName(), unknown.getParamCount());
                                continue;
                            }
                            if (!(node instanceof ExprMethod) || (method = (ExprMethod)node).getName() == null || !method.getName().equalsIgnoreCase("VLOOKUP")) continue;
                            isVLookUP = true;
                        }
                        Expr newExpr = Expr.getExpr(nodes, srcExpr.getExprNodeState(), 0, nodes.length);
                        this._var = new ExprData(null, newExpr, null);
                    } else if (srcExpr != null && srcExpr.isSyntaxError()) {
                        Dependents deps = this.getSheet().getDeps();
                        Parser psr = deps.getParser();
                        String formula = src.getFormula();
                        Expr expr = null;
                        try {
                            psr.parse(this, formula);
                            expr = psr.getExpr();
                        }
                        finally {
                            deps.recycleParser(psr);
                        }
                        boolean noOffset = mode.touchFlag(PasteMode.NoOffset);
                        IExprNode[] nodes = expr.getNodes();
                        boolean isVLookUP = false;
                        for (int i = nodes.length - 1; i >= 0; --i) {
                            int offsetY;
                            int offsetX;
                            IExprNode node = nodes[i];
                            if (!(node instanceof CellBlockNode)) continue;
                            if (node instanceof CellBlock3DNode) {
                                CellBlock3DNode cb3 = (CellBlock3DNode)node;
                                if (noOffset || i == 2 && isVLookUP) continue;
                                offsetX = cb3.isRow() ? 0 : this.getCol() - src.getCol();
                                offsetY = cb3.isCol() ? 0 : this.getRow() - src.getRow();
                                cb3.offset(offsetY, offsetX);
                                continue;
                            }
                            CellBlockNode cb = (CellBlockNode)node;
                            if (noOffset) continue;
                            offsetX = cb.isRow() ? 0 : this.getCol() - src.getCol();
                            offsetY = cb.isCol() ? 0 : this.getRow() - src.getRow();
                            cb.offset(offsetY, offsetX);
                        }
                        this._var = new ExprData(formula, expr, null);
                    } else {
                        this._var = new ExprData(src.getFormula(), null, null);
                    }
                    if (bValue) {
                        Variant srcValue;
                        Variant variant = srcValue = srcED._value == null ? null : srcED._value.getCopy();
                        if (srcValue != null && !srcValue.isError() && !srcValue.isNull()) {
                            this.setValue(srcValue);
                        }
                    }
                } else if (bValue) {
                    this._var = src._var instanceof Variant ? ((Variant)src._var).getCopy() : src._var;
                    this._text = src._text;
                    this._flags = src._flags;
                }
                if (needCalc) {
                    this.setFlag(4, true);
                    this.setFlag(2, false);
                    this.queue();
                }
            } else {
                this.setValue(src.getValue());
            }
        }
        if (bFormats) {
            Style srcStyle = src.getMerge(false) == null ? src.getStyle() : Styles.getStyle((ShareStyleAttributes)Cell.getBubbleSA(src._ssa, src.getSheet(), src.getRow(), src.getCol(), null));
            this.setFlag(2, false);
            changed |= this.copyStyle(srcStyle, null, mode, changedProps, bProtected) != null;
        }
        return changed ? changedProps : null;
    }

    void resumeCopyFrom(Cell src, PasteMode mode, String[] userKeys) {
        this.setExtStyle(null);
        if (src.getUserObjects(false) != null) {
            this.setUserObjects(src.getUserObjects(false));
        }
        boolean bFormula = mode.touchFlag(PasteMode.Formulas);
        boolean bValue = mode.touchFlag(PasteMode.Values);
        boolean bComment = mode.touchFlag(PasteMode.Comments);
        boolean bExt = mode.touchFlag(PasteMode.ExtObjectsExceptComments);
        if (bComment && bExt) {
            this.setExtObjects(src.getExtObjects(false));
        } else if (bComment) {
            this.setComment(src.getComment());
        } else if (bExt) {
            // empty if block
        }
        if (bFormula || bValue) {
            this._var = src._var;
            this._text = src._text;
            this._flags = src._flags;
        }
        if (mode.touchFlag(PasteMode.Formats) && src._ssa != null) {
            this.setSSA(src._ssa);
            this.setFlag(2, false);
        }
    }

    ShareStyleAttributes copyStyle(Style srcStyle, CellBlock srcMergeBlock, PasteMode mode, Cell changedProps, boolean bProtected) {
        ShareStyleAttributes old = this._ssa;
        StyleAttributes sa = null;
        if (mode.touchFlag(PasteMode.Style)) {
            sa = Styles.getSA((ShareStyleAttributes)srcStyle);
            StyleAttributes saBubble = Cell.getBubbleSA(Styles.getEmptySSA(), this.getSheet(), this.getRow(), this.getCol(), srcMergeBlock);
            if (bProtected) {
                sa.setLocked(false);
            }
            sa.clearAttributes(sa.sameBits((ShareStyleAttributes)saBubble, 0, ShareStyleAttributes.ATTRS_COUNT));
            if (!mode.touchFlag(PasteMode.Borders)) {
                sa.clearBorderAttribures();
            }
        } else if (mode.touchFlag(PasteMode.NumberFormats) && !mode.touchFlag(PasteMode.Borders) && !srcStyle.getNumberFormat().equals(this._ssa.getNumberFormat())) {
            sa = Styles.getSA((ShareStyleAttributes)this._ssa);
            sa.setNumberFormat(srcStyle.getNumberFormat());
        }
        boolean changed = false;
        if (sa != null) {
            ShareStyleAttributes ssa;
            if (changedProps != null) {
                changedProps._ssa = this._ssa;
            }
            if (this._ssa != (ssa = Styles.getSSA((StyleAttributes)sa))) {
                changed = true;
                this.setSSA(ssa);
            }
        }
        return changed ? old : null;
    }

    void updateStyle() {
        this._style = null;
        if (this._extData != null && this._extData._extStyle != null) {
            this.setFlag(2, false);
            this._extData._extStyle = null;
        }
    }

    public void setFormatted(boolean formatted) {
        this.setFlag(2, formatted);
    }

    public Row getRowObject() {
        return this._row;
    }

    void setRowObject(Row row) {
        this._row = row;
    }

    Column getColObject() {
        return this._col;
    }

    void setColObject(Column col) {
        this._col = col;
    }

    void setVar(Object var) {
        this._var = var;
        this.setFlag(2, false);
    }

    int getFlags() {
        return this._flags;
    }

    void setFlags(int flags) {
        this._flags = flags;
    }

    private boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    private Style getExtStyle() {
        return this._extData == null ? null : this._extData._extStyle;
    }

    private void setExtStyle(Style style) {
        if (style != null) {
            if (this._extData == null) {
                this._extData = new ExtData();
            }
            this._extData._extStyle = style;
        } else if (this._extData != null) {
            this._extData._extStyle = null;
            if (this._extData.isEmptyContent()) {
                this._extData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFormula(String formula) {
        Dependents deps = this.getSheet().getDeps();
        Parser psr = deps.getParser();
        try {
            psr.parse(this, formula);
            Expr expr = psr.getExpr();
            if (this._var instanceof ExprData) {
                ((ExprData)this._var).setExpr(expr, formula);
            } else {
                this._var = new ExprData(formula, expr, null);
            }
        }
        finally {
            deps.recycleParser(psr);
        }
    }

    private void setTextEmpty() {
        this._text = "";
    }

    private boolean isEmptyAttribute() {
        return ShareStyleAttributes.isEmptySSA((ShareStyleAttributes)this._ssa) && this.getMerge(false) == null;
    }

    private Format getMutableFormat(String fmt) {
        Variant value;
        if (StringUtil.isEmptyString((String)fmt) && (value = this.getValue()).isDate()) {
            Calendar cal = null;
            try {
                cal = value.toCalendar();
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
            long curMillis = cal.getTimeInMillis();
            long v = curMillis % 86400000L;
            if (v == 0L) {
                return Formats.getFormat((String)"yyyy-m-d");
            }
            if (v == curMillis) {
                return Formats.getFormat((String)"h:mm");
            }
            return Formats.getFormat((String)"yyyy-m-d h:mm");
        }
        return Formats.getFormat((String)fmt);
    }

    private Dependents getDeps() {
        return this.getSheet().getDeps();
    }

    public ExtProps getExtProps(boolean bCreate) {
        if (this._extProps == null && bCreate) {
            this._extProps = new ExtProps(this);
        }
        return this._extProps;
    }

    public ExtProps getExtProps(ExtProps src) {
        if (this._extProps == null) {
            this._extProps = (ExtProps)src.clone();
            this._extProps.setCell(this);
        }
        return this._extProps;
    }

    @Override
    public int getCalculableType() {
        return 4;
    }

    public boolean isUnknownMethod() {
        if (this._var instanceof ExprData) {
            Expr expr = ((ExprData)this._var).getExpr();
            return expr != null && expr.hasUnknownMethod();
        }
        return false;
    }

    private String getReplacementNumberfromat(String plainNumberformat) {
        if (StringUtil.isEmptyString((String)plainNumberformat)) {
            return null;
        }
        for (int i = 0; i < WRONG_NUMBERFORMATS.length; ++i) {
            if (!WRONG_NUMBERFORMATS[i].equals(plainNumberformat)) continue;
            return REPLACEMENT_NUMBERFORMATS[i];
        }
        return null;
    }

    static class ExtData {
        public Style _extStyle;
        public SortedUserObjectArray _extObjects;
        public SortedUserObjectArray _userObjects;

        ExtData() {
        }

        public boolean isEmptyContent() {
            return !(this._extObjects != null && !this._extObjects.isEmpty() || this._userObjects != null && !this._userObjects.isEmpty());
        }
    }

    static class ExprData
    implements Cloneable {
        private String _formula;
        private Expr _expr;
        private Variant _value;
        private int _calcUID;

        public ExprData(String formula, Expr expr, Variant value) {
            this._formula = expr != null && !expr.isSyntaxError() ? null : (formula == null ? null : formula);
            this._expr = expr;
            this.setValue(value);
        }

        public ExprData(ExprData src) {
            this(src._formula, src._expr, src._value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExprData) {
                boolean equals;
                ExprData cmp = (ExprData)obj;
                boolean bl = this._expr == null ? cmp._expr == null : (equals = this._expr.equals(cmp._expr));
                if (equals) {
                    equals = this._value.equals(cmp._value);
                }
                return equals;
            }
            return false;
        }

        public boolean canExecute() {
            return this._expr != null;
        }

        public Expr getExpr() {
            return this._expr;
        }

        public void setExpr(Expr expr, String formula) {
            this._formula = expr != null && !expr.isSyntaxError() ? null : (StringUtil.isEmptyString((String)formula) ? "" : formula);
            this._expr = expr;
        }

        public String getFormula(Sheet sheet, Cell cll) {
            if (this._formula == null && !this._expr.isSyntaxError()) {
                ExprContext ctx = sheet.getDeps().getExprContext();
                this._formula = "=" + this._expr.decode(ctx, cll);
            }
            return this._formula;
        }

        public void setFormula(String formula) {
            this._formula = formula;
        }

        public int getCalcUID() {
            return this._calcUID;
        }

        public void setCalcUID(int calcUID) {
            this._calcUID = calcUID;
        }

        public void updateFormula() {
            if (this._formula != null && this._expr != null && !this._expr.isSyntaxError()) {
                this._formula = null;
            }
        }

        public Variant getValue() {
            return this._value;
        }

        public void setValue(Variant value) {
            if (value != null) {
                Cell.reduceScale(value);
                value = Variant.getBufferedVariant((Variant)value);
            }
            this._value = value;
        }

        public void setValueWithoutScale(Variant value) {
            if (value != null) {
                value = Variant.getBufferedVariant((Variant)value);
            }
            this._value = value;
        }

        public String toString() {
            return this._value == null ? "" : this._value.toString();
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    static class ContentType {
        ContentType() {
        }
    }
}

