/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.util.SizeOf;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;

public class CellBlock
implements Comparable,
Cloneable {
    public static final int POSITION_UNSURE = 65535;
    protected int _row;
    protected int _col;
    protected int _row2;
    protected int _col2;

    protected CellBlock(int row, int col, int row2, int col2) {
        this.setRowCol(row, col, row2, col2);
    }

    public static CellBlock getNewCellBlock(int row, int col, int row2, int col2) {
        return new CellBlock(row, col, row2, col2);
    }

    public static CellBlock getNewCellBlock(int row, int col) {
        return new CellBlock(row, col, row, col);
    }

    public static CellBlock getNewCellBlock(CellBlock cb) {
        return (CellBlock)cb.clone();
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public int hashCode() {
        return (this._row << 8 | this._col) << 16 | (this._row2 << 8 | this._col2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CellBlock) {
            CellBlock a = (CellBlock)obj;
            return this._row == a._row && this._col == a._col && this._row2 == a._row2 && this._col2 == a._col2;
        }
        return false;
    }

    public String toString() {
        return SheetBaseMath.getBlockA1Name(this._row, this._col, this._row2, this._col2, false);
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int cmp = -1;
        if (obj instanceof CellBlock) {
            CellBlock cb = (CellBlock)obj;
            if ((this._row < cb._row ? -1 : (cmp = this._row == cb._row ? 0 : 1)) == 0 && (this._col < cb._col ? -1 : (cmp = this._col == cb._col ? 0 : 1)) == 0 && (this._row2 < cb._row2 ? -1 : (cmp = this._row2 == cb._row2 ? 0 : 1)) == 0) {
                cmp = this._col2 < cb._col2 ? -1 : (this._col2 == cb._col2 ? 0 : 1);
            }
        }
        return cmp;
    }

    public int compareToPos(int row, int col) {
        int cmp = row < this._row ? 1 : (row > this._row2 ? -1 : (col < this._col ? 1 : (col > this._col2 ? -1 : 0)));
        return cmp;
    }

    public int compareToCell(int row, int col) {
        int result = 65535;
        if (row < this._row) {
            if (col <= this._col) {
                result = 1;
            }
        } else if (row > this._row2) {
            if (col >= this._col2) {
                result = -1;
            }
        } else {
            result = col < this._col ? 1 : (col > this._col2 ? -1 : 0);
        }
        return result;
    }

    public void setRowCol(int row, int col, int row2, int col2) {
        if (row <= row2) {
            this._row = row;
            this._row2 = row2;
        } else {
            this._row = row2;
            this._row2 = row;
        }
        if (col <= col2) {
            this._col = col;
            this._col2 = col2;
        } else {
            this._col = col2;
            this._col2 = col;
        }
    }

    public void setRowCol(CellBlock src) {
        this.setRowCol(src._row, src._col, src._row2, src._col2);
    }

    public int getRow() {
        return this._row;
    }

    public void setRow(int row) {
        this._row = row;
    }

    public int getCol() {
        return this._col;
    }

    public void setCol(int col) {
        this._col = col;
    }

    public int getRow2() {
        return this._row2;
    }

    public void setRow2(int row) {
        this._row2 = row;
    }

    public int getCol2() {
        return this._col2;
    }

    public void setCol2(int col) {
        this._col2 = col;
    }

    public void copyFrom(CellBlock src) {
        if (src == null) {
            return;
        }
        this._row = src._row;
        this._col = src._col;
        this._row2 = src._row2;
        this._col2 = src._col2;
    }

    public void union(CellBlock block) {
        if (this._row > block._row) {
            this._row = block._row;
        }
        if (this._col > block._col) {
            this._col = block._col;
        }
        if (this._row2 < block._row2) {
            this._row2 = block._row2;
        }
        if (this._col2 < block._col2) {
            this._col2 = block._col2;
        }
    }

    public CellBlock minus(CellBlock minus) {
        boolean bValid = false;
        int row = this._row;
        int row2 = this._row2;
        int col = this._col;
        int col2 = this._col2;
        if (this.equalsCol(minus)) {
            if (this.getHeight() > minus.getHeight()) {
                if (this._row == minus._row) {
                    bValid = true;
                    row = minus._row2 + 1;
                } else if (this._row2 == minus._row2) {
                    bValid = true;
                    this._row2 = minus._row - 1;
                }
            }
        } else if (this.equalsRow(minus) && this.getWidth() > minus.getWidth()) {
            if (this._col == minus._col) {
                bValid = true;
                col = minus._col2 + 1;
            } else if (this._col2 == minus._col2) {
                bValid = true;
                this._col2 = minus._col - 1;
            }
        }
        return bValid ? new CellBlock(row, col, row2, col2) : null;
    }

    public CellBlock getImpactBlock(CellBlock cb, boolean yDir, boolean bInsert) {
        if (yDir) {
            int r = cb.getRow();
            int r2 = cb.getRow2();
            if (bInsert) {
                int offset = this.getHeight();
                if (this._row <= r) {
                    if (r + offset > 1048575) {
                        cb = null;
                    } else {
                        cb = CellBlock.getNewCellBlock(cb);
                        cb.setRow(r + offset);
                        cb.setRow2(Math.min(r2 + offset, 1048575));
                    }
                } else {
                    cb = CellBlock.getNewCellBlock(cb);
                    cb.setRow2(Math.min(r2 + offset, 1048575));
                }
            } else if (this._row <= r) {
                if (this._row2 >= r2) {
                    cb = null;
                } else if (this._row2 < r) {
                    cb = CellBlock.getNewCellBlock(cb);
                    cb.setRow(r - this.getHeight());
                    cb.setRow2(r2 - this.getHeight());
                } else {
                    cb = CellBlock.getNewCellBlock(cb);
                    cb.setRow(this._row);
                    cb.setRow2(this._row + (r2 - this._row2) - 1);
                }
            } else if (this._row2 >= r2) {
                cb = CellBlock.getNewCellBlock(cb);
                cb.setRow2(this._row - 1);
            } else {
                cb = CellBlock.getNewCellBlock(cb);
                cb.setRow2(this._row + (r2 - this._row2) - 1);
            }
        } else {
            int c = cb.getCol();
            int c2 = cb.getCol2();
            if (bInsert) {
                int offset = this.getWidth();
                if (this._col <= c) {
                    if (c + offset > 16383) {
                        cb = null;
                    } else {
                        cb = CellBlock.getNewCellBlock(cb);
                        cb.setCol(c + offset);
                        cb.setCol2(Math.min(c2 + offset, 16383));
                    }
                } else {
                    cb = CellBlock.getNewCellBlock(cb);
                    cb.setCol2(Math.min(c2 + offset, 16383));
                }
            } else if (this._col <= c) {
                if (this._col2 >= c2) {
                    cb = null;
                } else if (this._col2 < c) {
                    cb = CellBlock.getNewCellBlock(cb);
                    cb.setCol(c - this.getWidth());
                    cb.setCol2(c2 - this.getWidth());
                } else {
                    cb = CellBlock.getNewCellBlock(cb);
                    cb.setCol(this._col);
                    cb.setCol2(this._col + (c2 - this._col2) - 1);
                }
            } else if (this._col2 >= c2) {
                cb = CellBlock.getNewCellBlock(cb);
                cb.setCol2(this._col - 1);
            } else {
                cb = CellBlock.getNewCellBlock(cb);
                cb.setCol2(this._col + (c2 - this._col2) - 1);
            }
        }
        return cb;
    }

    public void offset(int deltRow, int deltCol) {
        this._row += deltRow;
        this._row2 += deltRow;
        this._col += deltCol;
        this._col2 += deltCol;
    }

    public void offset(int deltRow, int deltCol, int deltRow2, int deltCol2) {
        this._row += deltRow;
        this._row2 += deltRow2;
        this._col += deltCol;
        this._col2 += deltCol2;
    }

    public void inflate(int deltRow, int deltCol) {
        this._row -= deltRow;
        this._row2 += deltRow;
        this._col -= deltCol;
        this._col2 += deltCol;
    }

    public boolean split(CellBlock dst, SortedCellBlockArray result) {
        if (this.contains(dst)) {
            return true;
        }
        if (!dst.isIntersect(this)) {
            result.insert(dst);
            return false;
        }
        this.splitForIntersect(dst, result);
        return true;
    }

    private void splitForIntersect(CellBlock dst, SortedCellBlockArray result) {
        if (this._col <= dst._col && this._row <= dst._row) {
            if (this._col2 < dst._col2) {
                if (this._row2 < dst._row2) {
                    result.insert(CellBlock.getNewCellBlock(dst._row, this._col2 + 1, this._row2, dst._col2));
                    result.insert(CellBlock.getNewCellBlock(this._row2 + 1, dst._col, dst._row2, dst._col2));
                } else {
                    result.insert(CellBlock.getNewCellBlock(dst._row, this._col2 + 1, dst._row2, dst._col2));
                }
            } else {
                result.insert(CellBlock.getNewCellBlock(this._row2 + 1, dst._col, dst._row2, dst._col2));
            }
        } else if (this._row <= dst._row) {
            if (this._col2 < dst._col2) {
                if (this._row2 < dst._row2) {
                    result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row2, this._col - 1));
                    result.insert(CellBlock.getNewCellBlock(dst._row, this._col2 + 1, this._row2, dst._col2));
                    result.insert(CellBlock.getNewCellBlock(this._row2 + 1, dst._col, dst._row2, dst._col2));
                } else {
                    result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, dst._row2, this._col - 1));
                    result.insert(CellBlock.getNewCellBlock(dst._row, this._col2 + 1, dst._row2, dst._col2));
                }
            } else if (this._row2 < dst._row2) {
                result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row2, this._col - 1));
                result.insert(CellBlock.getNewCellBlock(this._row2 + 1, dst._col, dst._row2, dst._col2));
            } else {
                result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, dst._row2, this._col - 1));
            }
        } else if (this._col <= dst._col) {
            if (this._col2 < dst._col2) {
                if (this._row2 < dst._row2) {
                    result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row - 1, dst._col2));
                    result.insert(CellBlock.getNewCellBlock(this._row, this._col2 + 1, this._row2, dst._col2));
                    result.insert(CellBlock.getNewCellBlock(this._row2 + 1, dst._col, dst._row2, dst._col2));
                } else {
                    result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row - 1, dst._col2));
                    result.insert(CellBlock.getNewCellBlock(this._row, this._col2 + 1, dst._row2, dst._col2));
                }
            } else if (this._row2 < dst._row2) {
                result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row - 1, dst._col2));
                result.insert(CellBlock.getNewCellBlock(this._row2 + 1, dst._col, dst._row2, dst._col2));
            } else {
                result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row - 1, dst._col2));
            }
        } else if (this._col2 < dst._col2) {
            if (this._row2 < dst._row2) {
                result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row - 1, dst._col2));
                result.insert(CellBlock.getNewCellBlock(this._row, dst._col, this._row2, this._col - 1));
                result.insert(CellBlock.getNewCellBlock(this._row, this._col2 + 1, this._row2, dst._col2));
                result.insert(CellBlock.getNewCellBlock(this._row2 + 1, dst._col, dst._row2, dst._col2));
            } else {
                result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row - 1, dst._col2));
                result.insert(CellBlock.getNewCellBlock(this._row, dst._col, dst._row2, this._col - 1));
                result.insert(CellBlock.getNewCellBlock(this._row, this._col2 + 1, dst._row2, dst._col2));
            }
        } else if (this._row2 < dst._row2) {
            result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row - 1, dst._col2));
            result.insert(CellBlock.getNewCellBlock(this._row2 + 1, dst._col, dst._row2, dst._col2));
            result.insert(CellBlock.getNewCellBlock(this._row, dst._col, this._row2, this._col - 1));
        } else {
            result.insert(CellBlock.getNewCellBlock(dst._row, dst._col, this._row - 1, dst._col2));
            result.insert(CellBlock.getNewCellBlock(this._row, dst._col, dst._row2, this._col - 1));
        }
    }

    public int getWidth() {
        return this._col2 - this._col + 1;
    }

    public int getHeight() {
        return this._row2 - this._row + 1;
    }

    public Span getRowSpan() {
        return new Span(this._row, this._row2);
    }

    public Span getColSpan() {
        return new Span(this._col, this._col2);
    }

    public boolean isSingleCell() {
        return this._row == this._row2 && this._col == this._col2;
    }

    public boolean isSingleRow() {
        return this._row == this._row2;
    }

    public boolean isSingleCol() {
        return this._col == this._col2;
    }

    public boolean isFirstCell(int row, int col) {
        return this._row == row && this._col == col;
    }

    public boolean isBorderCell(int row, int col) {
        if (row == this._row || row == this._row2) {
            return col >= this._col && col <= this._col2;
        }
        if (col == this._col || col == this._col2) {
            return row >= this._row && row <= this._row2;
        }
        return false;
    }

    public boolean isRow() {
        return this._col == 0 && this._col2 == 16383;
    }

    public boolean isCol() {
        return this._row == 0 && this._row2 == 1048575;
    }

    public boolean isNotRowCol() {
        return !this.isRow() && !this.isCol();
    }

    public boolean isWholeSheet() {
        return this.isRow() && this.isCol();
    }

    public boolean equalsCol(CellBlock cb) {
        return this._col == cb.getCol() && this._col2 == cb.getCol2();
    }

    public boolean equalsRow(CellBlock cb) {
        return this._row == cb.getRow() && this._row2 == cb.getRow2();
    }

    public boolean contains(int row, int col) {
        return row >= this._row && row <= this._row2 && col >= this._col && col <= this._col2;
    }

    public boolean contains(CellBlock block) {
        return block._row >= this._row && block._row2 <= this._row2 && block._col >= this._col && block._col2 <= this._col2;
    }

    public boolean containsRow(int row) {
        return row >= this._row && row <= this._row2;
    }

    public boolean containsRow(CellBlock cb) {
        return this._row <= cb._row && this._row2 >= cb._row2;
    }

    public boolean containsCol(int col) {
        return col >= this._col && col <= this._col2;
    }

    public boolean containsCol(CellBlock cb) {
        return this._col <= cb._col && this._col2 >= cb._col2;
    }

    public boolean isIntersect(CellBlock cb) {
        return this._row <= cb._row2 && this._col <= cb._col2 && this._row2 >= cb._row && this._col2 >= cb._col;
    }

    public boolean isIntersect(int row, int col, int row2, int col2) {
        return this._row <= row2 && this._col <= col2 && this._row2 >= row && this._col2 >= col;
    }

    public boolean intersectRow(CellBlock cb) {
        return this._row <= cb.getRow2() && this._row2 >= cb.getRow();
    }

    public boolean intersectCol(CellBlock cb) {
        return this._col <= cb.getCol2() && this._col2 >= cb.getCol();
    }

    public CellBlock intersection(CellBlock cb) {
        return this.intersection(cb.getRow(), cb.getCol(), cb.getRow2(), cb.getCol2());
    }

    public CellBlock intersection(int row, int col, int row2, int col2) {
        if (!this.isIntersect(row, col, row2, col2)) {
            return null;
        }
        row = this._row > row ? this._row : row;
        col = this._col > col ? this._col : col;
        row2 = this._row2 < row2 ? this._row2 : row2;
        col2 = this._col2 < col2 ? this._col2 : col2;
        return new CellBlock(row, col, row2, col2);
    }

    public CellBlock getJoint(CellBlock cb) {
        CellBlock joints = null;
        int r = cb.getRow();
        int c = cb.getCol();
        int r2 = cb.getRow2();
        int c2 = cb.getCol2();
        if (this._row2 == r - 1 && this._col2 >= c && this._col <= c2) {
            joints = CellBlock.getNewCellBlock(this._row2, Math.max(this._col, c), this._row2, Math.min(this._col2, c2));
        } else if (this._row == r2 + 1 && this._col2 >= c && this._col <= c2) {
            joints = CellBlock.getNewCellBlock(this._row, Math.max(this._col, c), this._row, Math.min(this._col2, c2));
        } else if (this._col2 == c - 1 && this._row2 >= r && this._row <= r2) {
            joints = CellBlock.getNewCellBlock(Math.max(this._row, r), this._col2, Math.min(this._row2, r2), this._col2);
        } else if (this._col == c2 + 1 && this._row2 >= r && this._row <= r2) {
            joints = CellBlock.getNewCellBlock(Math.max(this._row, r), this._col, Math.min(this._row2, r2), this._col);
        }
        return joints;
    }

    public boolean isImpact(CellBlock cb, boolean yDir) {
        if (yDir) {
            return this._row <= cb._row2 && this.containsCol(cb);
        }
        return this._col <= cb._col2 && this.containsRow(cb);
    }

    public boolean isRowColReversed() {
        return this._row > this._row2 || this._col > this._col2;
    }

    public boolean isRowColInvalid() {
        return this._row < 0 || this._row > 1048575 || this._col < 0 || this._col > 16383 || this._row2 < 0 || this._row2 > 1048575 || this._col2 < 0 || this._col2 > 16383;
    }

    public boolean limitRowCol(int row, int col) {
        boolean changed = false;
        if (this._row < row) {
            this._row = row;
            changed = true;
        }
        if (this._col < col) {
            this._col = col;
            changed = true;
        }
        return changed;
    }

    public boolean limitRowCol2(int row2, int col2) {
        boolean changed = false;
        if (this._row2 > row2) {
            this._row2 = row2;
            changed = true;
        }
        if (this._col2 > col2) {
            this._col2 = col2;
            changed = true;
        }
        return changed;
    }

    public static void main(String[] args) {
        CellBlock cb = CellBlock.getNewCellBlock(1, 1, 2, 2);
        CellBlock dst = CellBlock.getNewCellBlock(2, 2);
        SortedCellBlockArray sa = new SortedCellBlockArray();
        SizeOf.startAction();
        for (int i = 0; i < 100000; ++i) {
            cb.split(dst, sa);
        }
        SizeOf.endAction((String)"");
        sa.clear();
    }
}

