/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.io.clipboard.StringWalker;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction;
import com.kingdee.bos.ctrl.excel.model.struct.URState;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.undo.AbstractUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.MessageDialog;

public class SheetAction_StringPaste
extends SheetAction {
    private String _text;

    public SheetAction_StringPaste(Range rg, String text) {
        super(rg, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Resize);
        this._text = text;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        if (StringUtil.isEmptyString((String)this._text)) {
            return;
        }
        StringWalker.SeperateResult sr = StringWalker.separate2Array(this._text);
        int rows = sr.getRowCount();
        int cols = sr.getColCount();
        int row = cb.getRow();
        int col = cb.getCol();
        if (row + rows > 1048575 || col + cols > 16383) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < rows; ++i) {
            Row rowObj = sheet.getRow(row + i, false);
            for (int j = 0; j < cols; ++j) {
                this.setCellString(state, sheet, rowObj, row + i, col + j, col + j, sr.getValueAt(i, j), sb);
            }
        }
        if (sb.length() != 0) {
            sb.append("\u7c98\u8d34\u7684\u503c\u4e0d\u7b26\u5408\u4e0a\u8ff0\u5355\u5143\u683c\u7684\u6709\u6548\u6027\u9a8c\u8bc1\uff0c\u90e8\u5206\u7c98\u8d34\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
            MessageDialog.show(null, (Object)MultiLanguageKeys.getLocalText("PasteValueAreInvalid", sb.toString()), (String)MultiLanguageKeys.getLocalText("warning", "\u8b66\u544a"), (int)-1, (int)2);
        }
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
        if (clls != null) {
            ObjectArray values = (ObjectArray)state.get("CELL_VALUE");
            int size = clls.size();
            for (int i = 0; i < size; ++i) {
                Cell cll = (Cell)clls.get(i);
                cll.setVar(values.get(i));
            }
        }
    }

    private Row setCellString(URState state, Sheet sheet, Row rowObj, int row, int col, int col2, String txt, StringBuilder sb) {
        block12: {
            boolean isEmptyText;
            block11: {
                isEmptyText = StringUtil.isEmptyString((String)txt);
                if (rowObj != null) break block11;
                if (isEmptyText) break block12;
                rowObj = this.getStateRow(state, sheet, row);
                for (int c = col; c <= col2; ++c) {
                    Cell cll = this.getStateCell(state, sheet, rowObj, c);
                    MessagedValidate mv = sheet.getValidations().getValidate(cll.getRow(), cll.getCol());
                    if (mv == null || mv.isValidated(sheet, txt)) {
                        if (Cell.checkKoreaChar(txt)) {
                            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA2());
                            sa.setFontName("dialog");
                            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
                            cll.getSheet().removeStyleCache(cll.getRow(), cll.getCol());
                        }
                        cll.setFormula(txt);
                        continue;
                    }
                    sb.append(cll.getName(false, true) + ",");
                }
                break block12;
            }
            int pos2 = rowObj.getProperPos(col2, true);
            if (isEmptyText) {
                for (int pos = rowObj.getProperPos(col, false); pos <= pos2; ++pos) {
                    Cell cll = rowObj.getAt(pos);
                    this.setCellState(state, cll, cll.getVar(), null);
                    cll.setFormula(txt);
                }
            } else {
                for (int c = col; c <= col2; ++c) {
                    Cell cll = rowObj.getCell(c, false);
                    if (cll != null) {
                        this.setCellState(state, cll, cll.getVar(), null);
                    } else {
                        cll = this.getStateCell(state, sheet, rowObj, c);
                    }
                    MessagedValidate mv = sheet.getValidations().getValidate(cll.getRow(), cll.getCol());
                    if (mv == null || mv.isValidated(sheet, txt)) {
                        if (Cell.checkKoreaChar(txt)) {
                            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA2());
                            sa.setFontName("dialog");
                            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
                            cll.getSheet().removeStyleCache(cll.getRow(), cll.getCol());
                        }
                        cll.setFormula(txt);
                        continue;
                    }
                    sb.append(cll.getName(false, true) + ",");
                }
            }
        }
        return rowObj;
    }

    @Override
    public String getPresentationName() {
        return LanguageManager.getLangMessage((String)"paste", AbstractUndoableEdit.class, (String)"\u7c98\u8d34 ") + super.getPresentationName();
    }
}

