/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;

public class SortedAttributeSpanArray
extends SortedSpanArray {
    private static final long serialVersionUID = -6640583333896668740L;
    private Sheet _sheet;
    private boolean _bRow;
    private int _defaultLength;
    private int _originalDefaultLength;
    private int _defaultGroupLevel;
    private boolean _defaultVisible;
    private boolean _defaultCollapse;
    private boolean is540 = false;

    public SortedAttributeSpanArray(Sheet sheet, boolean bRow) {
        super(bRow ? 1048575 : 16383);
        this._sheet = sheet;
        this._bRow = bRow;
        this._defaultLength = bRow ? sheet.getDefRowHeight() : sheet.getDefColWidth();
        this._originalDefaultLength = bRow ? sheet.getOriginalDefRowHeight() : sheet.getOriginalDefColWidth();
        this._defaultVisible = true;
        this._defaultGroupLevel = 0;
    }

    public AttributeSpan getAttributeSpan(int index) {
        return (AttributeSpan)this._array[index];
    }

    public SortedAttributeSpanArray getSpecifiedAttributeSpansClone(int start, int end) {
        SortedAttributeSpanArray sap = new SortedAttributeSpanArray(this._sheet, this._bRow);
        Object[] spans = this.getSpecifiedSpansClone(start, end);
        sap.setArray(spans);
        return sap;
    }

    public SortedSpanArray setSpanAttribute(Span dst, ShareStyleAttributes ssa, Integer length, Boolean visible, Integer groupLevel, Boolean collapse, boolean bState) {
        SortedSpanArray aChanged = bState ? new SortedSpanArray(this._maxIndex) : null;
        this.setSpanAttribute(dst, ssa, length, visible, groupLevel, collapse, aChanged);
        if (aChanged == null || aChanged.isEmpty()) {
            return null;
        }
        return aChanged;
    }

    public boolean setSpanAttribute(Span dst, ShareStyleAttributes ssa, Integer length, Boolean visible, Integer groupLevel, Boolean collapse, SortedSpanArray aChanged) {
        boolean bState = aChanged != null;
        boolean bDirty = this.isEmpty();
        Span list = this.makeContinuousSpanList(dst);
        int end = list.getEnd();
        for (int i = list.getStart(); i <= end; ++i) {
            AttributeSpan sp = this.getAttributeSpan(i);
            AttributeSpan spCopy = null;
            boolean bChanged = false;
            if (ssa != null && !sp.getSSA().equals((Object)ssa)) {
                spCopy = bState ? (AttributeSpan)sp.clone() : null;
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)sp.getSSA());
                sa.replaceDirty(ssa);
                bChanged = sp.setSSA(Styles.getSSA((StyleAttributes)sa));
            }
            if (length != null) {
                int len = length;
                if (sp.getOriginalLength() != len) {
                    if (bState && spCopy == null) {
                        spCopy = (AttributeSpan)sp.clone();
                    }
                    if (sp.setLength(len)) {
                        bChanged = true;
                    }
                }
                if (sp.setVisible(len > 0)) {
                    bChanged = true;
                }
            }
            if (visible != null) {
                boolean vi = visible;
                if (sp.isVisible() != vi) {
                    if (bState && spCopy == null) {
                        spCopy = (AttributeSpan)sp.clone();
                    }
                    if (sp.setVisible(vi)) {
                        bChanged = true;
                    }
                }
            }
            if (groupLevel != null) {
                int level = groupLevel;
                if (sp.getOutlineGroupLevel() != level) {
                    if (bState && spCopy == null) {
                        spCopy = (AttributeSpan)sp.clone();
                    }
                    if (sp.setOutlineGroupLevel(level)) {
                        bChanged = true;
                    }
                }
            }
            if (collapse != null) {
                boolean c = collapse;
                if (sp.isCollapse() != c) {
                    if (bState && spCopy == null) {
                        spCopy = (AttributeSpan)sp.clone();
                    }
                    if (sp.setCollapse(c)) {
                        bChanged = true;
                    }
                }
            }
            if (!bChanged) continue;
            bDirty = true;
            if (!bState || spCopy == null) continue;
            aChanged.insert(spCopy);
        }
        if (bDirty) {
            this.merge(list, true);
        }
        return bDirty;
    }

    public SortedSpanArray clearStyle(Span span, boolean bState) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setDirty(ShareStyleAttributes.getAllBits());
        Integer len = new Integer(this._bRow ? this._sheet.getDefRowHeight() : this._sheet.getDefColWidth());
        Integer groupLevel = new Integer(0);
        Boolean collapse = Boolean.FALSE;
        SortedSpanArray list = bState ? new SortedSpanArray(this._maxIndex) : null;
        this.setSpanAttribute(span, (ShareStyleAttributes)sa, len, Boolean.TRUE, groupLevel, collapse, list);
        return list;
    }

    @Override
    public boolean isDefault(Span span) {
        ShareStyleAttributes ssa;
        AttributeSpan as;
        int len;
        if (span instanceof AttributeSpan && (len = (as = (AttributeSpan)span).getLength()) == this._defaultLength && (ssa = as.getSSA()) == this._sheet.getSSA()) {
            return as.isVisible() == this._defaultVisible && as.getOutlineGroupLevel() == this._defaultGroupLevel && as.isCollapse() == this._defaultCollapse;
        }
        return false;
    }

    @Override
    public Span createDefaultSpan(Span span) {
        return new AttributeSpan(span, null, this._defaultLength, this._defaultVisible);
    }

    public void set540Flag() {
        this.is540 = true;
    }

    public Integer getLength(Span span) {
        Integer len = null;
        Span[] aas = this.getSpans(span);
        if (aas != null) {
            int len0 = ((AttributeSpan)aas[0]).getLength();
            for (int i = 1; i < aas.length; ++i) {
                if (((AttributeSpan)aas[i]).getLength() == len0) continue;
                return null;
            }
            len = new Integer(len0);
        } else {
            len = new Integer(this._defaultLength);
        }
        return len;
    }

    public Integer getOriginalLength(Span span) {
        Integer len = null;
        Span[] aas = this.getSpans(span);
        if (aas != null) {
            int len0 = ((AttributeSpan)aas[0]).getOriginalLength();
            for (int i = 1; i < aas.length; ++i) {
                if (((AttributeSpan)aas[i]).getOriginalLength() == len0) continue;
                return null;
            }
            len = new Integer(len0);
        } else {
            len = new Integer(this._originalDefaultLength);
        }
        return len;
    }

    public Boolean getHidden(Span span) {
        Boolean hidden = null;
        Span[] aas = this.getSpans(span);
        if (aas != null) {
            boolean v0 = ((AttributeSpan)aas[0]).isVisible();
            for (int i = 1; i < aas.length; ++i) {
                if (((AttributeSpan)aas[i]).isVisible() == v0) continue;
                return null;
            }
            hidden = !v0;
        } else {
            hidden = Boolean.FALSE;
        }
        return hidden;
    }

    public Integer getOutlineGroupLevel(Span span) {
        Integer groupLevel = null;
        Span[] aas = this.getSpans(span);
        if (aas != null) {
            int level0 = ((AttributeSpan)aas[0]).getOutlineGroupLevel();
            for (int i = 1; i < aas.length; ++i) {
                if (((AttributeSpan)aas[i]).getOutlineGroupLevel() == level0) continue;
                return null;
            }
            groupLevel = new Integer(level0);
        } else {
            groupLevel = new Integer(this._defaultGroupLevel);
        }
        return groupLevel;
    }

    public Boolean getOutlineGroupCollapse(Span span) {
        Boolean collapse = null;
        Span[] aas = this.getSpans(span);
        if (aas != null) {
            boolean c0 = ((AttributeSpan)aas[0]).isCollapse();
            for (int i = 1; i < aas.length; ++i) {
                if (((AttributeSpan)aas[i]).isCollapse() == c0) continue;
                return null;
            }
            collapse = !c0;
        } else {
            collapse = Boolean.FALSE;
        }
        return collapse;
    }

    public class AttributeSpan
    extends Span
    implements Cloneable {
        private int _length;
        private boolean _visible;
        private ShareStyleAttributes _ssa;
        private Style _style;
        private int _outlineGroupLevel;
        private boolean _collapse;

        public AttributeSpan(int start, int end, ShareStyleAttributes ssa, int length, boolean visible) {
            super(start, end);
            this._ssa = ssa == null ? Styles.getEmptySSA() : ssa;
            this._length = length;
            this._visible = visible;
        }

        public AttributeSpan(Span span, ShareStyleAttributes ssa, int length, boolean visible) {
            super(span);
            this._ssa = ssa == null ? Styles.getEmptySSA() : ssa;
            this._length = length;
            this._visible = visible;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (super.equals(obj)) {
                if (obj instanceof AttributeSpan) {
                    return this.isSameAttrs((AttributeSpan)obj);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isSameAttrs(Span span) {
            if (span instanceof AttributeSpan) {
                AttributeSpan as = (AttributeSpan)span;
                return this._ssa == as._ssa && this._length == as._length && this._visible == as._visible && this._outlineGroupLevel == as._outlineGroupLevel && this._collapse == as._collapse;
            }
            return false;
        }

        public Style getStyle() {
            if (this._style == null) {
                this._style = Styles.getStyle((ShareStyleAttributes)(ShareStyleAttributes.isEmptySSA((ShareStyleAttributes)this._ssa) ? SortedAttributeSpanArray.this._sheet.getSSA() : this._ssa));
            }
            return this._style;
        }

        public boolean union(AttributeSpan span) {
            if (this.isSameAttrs(span)) {
                return super.union(span);
            }
            return false;
        }

        public ShareStyleAttributes getSSA() {
            return this._ssa;
        }

        public boolean setSSA(ShareStyleAttributes ssa) {
            if (this._ssa != ssa) {
                this._ssa = ssa instanceof StyleAttributes ? Styles.getSSA((StyleAttributes)((StyleAttributes)ssa)) : ssa;
                this._style = null;
                return true;
            }
            return false;
        }

        public int getOriginalLength() {
            return this._length;
        }

        public int getLength() {
            return (int)((float)this._length * SortedAttributeSpanArray.this._sheet.getSheetOption().getScaleNoPercent());
        }

        public boolean setLength(int length) {
            if (this._length != length) {
                this._length = length;
                return true;
            }
            return false;
        }

        public boolean isVisible() {
            return this._visible;
        }

        public boolean setVisible(boolean visible) {
            if (this._visible != visible) {
                this._visible = visible;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return super.toString() + " [SSA]=" + this._ssa.getUID() + " [L]=" + this._length + " [V]=" + this._visible + " [GroupLevel]=" + this._outlineGroupLevel + " [Collapse]=" + this._collapse;
        }

        public int getOutlineGroupLevel() {
            return this._outlineGroupLevel;
        }

        public boolean setOutlineGroupLevel(int groupLevel) {
            if (groupLevel > 7) {
                groupLevel = 7;
            }
            if (this._outlineGroupLevel != groupLevel) {
                this._outlineGroupLevel = groupLevel;
                return true;
            }
            return false;
        }

        public boolean isCollapse() {
            return this._collapse;
        }

        public boolean setCollapse(boolean collapse) {
            if (this._collapse != collapse) {
                this._collapse = collapse;
                return true;
            }
            return false;
        }
    }
}

