/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct;

import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlock3DNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import java.util.ArrayList;

public class SortedSingleCellBlockArray
extends SortedObjectArray {
    private static final long serialVersionUID = 6547769165556647978L;

    public int search(Object obj) {
        if (this.isEmpty()) {
            return -1;
        }
        CellBlockNode cb = (CellBlockNode)obj;
        int low = 0;
        int high = this._count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = this.compareCellBlockNode(this._array[mid], cb);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private int compareCellBlockNode(Object o1, CellBlockNode cb2) {
        int cmp;
        int v2;
        if (o1 == cb2) {
            return 0;
        }
        CellBlockNode cb = (CellBlockNode)o1;
        int v = cb.getRow();
        if ((v == (v2 = cb2.getRow()) ? 0 : (cmp = v < v2 ? -1 : 1)) == 0 && ((v = cb.getCol()) == (v2 = cb2.getCol()) ? 0 : (cmp = v < v2 ? -1 : 1)) == 0) {
            v = cb.getFlags();
            int n = v == (v2 = cb2.getFlags()) ? 0 : (cmp = v < v2 ? -1 : 1);
        }
        if (cmp == 0) {
            boolean is3D1 = false;
            boolean is3D2 = false;
            if (cb instanceof CellBlock3DNode) {
                is3D1 = true;
            }
            if (cb2 instanceof CellBlock3DNode) {
                is3D2 = true;
            }
            if (!(is3D1 && is3D2 || !is3D1 && !is3D2)) {
                cmp = 1;
            }
        }
        return cmp;
    }

    public int search(int row, int col) {
        if (this.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = this._count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = this._array[mid];
            int cmp = this.compare(midVal, row, col);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private int compare(Object obj, int row, int col) {
        int cmp;
        CellBlock cb = (CellBlock)obj;
        int v = cb.getRow();
        if ((v < row ? -1 : (cmp = v == row ? 0 : 1)) == 0) {
            v = cb.getCol();
            cmp = v < col ? -1 : (v == col ? 0 : 1);
        }
        return cmp;
    }

    public int getProperPos(int row, int col, boolean bLater) {
        int pos = this.search(row, col);
        if (pos < 0) {
            pos = -(pos + 1);
            if (bLater) {
                --pos;
            }
        }
        return pos;
    }

    public void removeCoveredBlocks(CellBlock cover, ArrayList al) {
        int pos2;
        int pos = this.getProperPos(cover.getRow(), cover.getCol(), false);
        if (pos <= (pos2 = this.getProperPos(cover.getRow(), cover.getCol(), true))) {
            Object[] objs = this.removeByPos(pos, pos2, true);
            for (int i = 0; i < objs.length; ++i) {
                al.add(objs[i]);
            }
        }
    }
}

