/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.cformat;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.CtrlUserObjectTrans;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.IObjectIterator;
import com.kingdee.bos.ctrl.excel.model.util.ObjectArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.StringUtils;
import java.awt.Color;
import java.util.ArrayList;

public class ConditionFormatFurther {
    public static final int PROCESS = 1;
    public static final int COLOR = 2;
    public static final int PIC = 3;
    private SortedCellBlockArray _blocks;
    private Variant _block_max;
    private Variant _block_min;
    private Color[] processmodel;
    private Color[] colormodel;
    private String[] picmodel;
    private boolean isprocess;
    private boolean iscolor;
    private boolean ispic;

    public SortedCellBlockArray getBlocks() {
        return this._blocks;
    }

    public void setBlocks(SortedCellBlockArray blocks) {
        this._blocks = blocks;
    }

    public Variant get_block_max() {
        return this._block_max;
    }

    public void set_block_max(Variant _block_max) {
        this._block_max = _block_max;
    }

    public Variant get_block_min() {
        return this._block_min;
    }

    public void set_block_min(Variant _block_min) {
        this._block_min = _block_min;
    }

    public boolean isIsprocess() {
        return this.isprocess;
    }

    public void setIsprocess(boolean isprocess) {
        this.isprocess = isprocess;
    }

    public boolean isIscolor() {
        return this.iscolor;
    }

    public void setIscolor(boolean iscolor) {
        this.iscolor = iscolor;
    }

    public boolean isIspic() {
        return this.ispic;
    }

    public void setIspic(boolean ispic) {
        this.ispic = ispic;
    }

    public Color[] getProcessmodel() {
        return this.processmodel;
    }

    public int getType() {
        if (this.iscolor) {
            return 2;
        }
        if (this.ispic) {
            return 3;
        }
        return 1;
    }

    public Object[] getColorModel() {
        if (this.iscolor) {
            return this.colormodel;
        }
        if (this.ispic) {
            return this.picmodel;
        }
        return this.processmodel;
    }

    public void setProcessmodel(Color[] processmodel) {
        this.processmodel = processmodel;
    }

    public Color[] getColormodel() {
        return this.colormodel;
    }

    public void setColormodel(Color[] colormodel) {
        this.colormodel = colormodel;
    }

    public String[] getPicmodel() {
        return this.picmodel;
    }

    public void setPicmodel(String[] picmodel) {
        this.picmodel = picmodel;
    }

    public void reSetMaxMin(Sheet sheet) {
        CellBlock cb = null;
        float max = 0.0f;
        float min = Float.MAX_VALUE;
        for (int i = 0; i < this._blocks.size(); ++i) {
            cb = this._blocks.getBlock(i);
            Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, true);
            while (ci.hasNext()) {
                Cell cl = ci.next();
                try {
                    if (!cl.getValue().isNumber()) continue;
                    if (max < cl.getValue().floatValue()) {
                        max = cl.getValue().floatValue();
                    }
                    if (min > cl.getValue().floatValue()) {
                        min = cl.getValue().floatValue();
                    }
                    cl.setFormatted(false);
                }
                catch (SyntaxErrorException e1) {
                    e1.printStackTrace();
                }
            }
        }
        this.set_block_max(new Variant(max));
        this.set_block_min(new Variant(min));
    }

    public boolean isTypeObjMacth(int type, Object ob) {
        switch (type) {
            case 1: {
                return this.isprocess && ((Color[])ob).equals(this.processmodel);
            }
            case 2: {
                return this.iscolor && ((Color[])ob).equals(this.colormodel);
            }
            case 3: {
                return this.ispic && ((String[])ob).equals(this.picmodel);
            }
        }
        return false;
    }

    public void ChangeFormat(int type, Object ob) {
        switch (type) {
            case 1: {
                this.setIsprocess(true);
                this.setProcessmodel((Color[])ob);
                break;
            }
            case 2: {
                this.setIscolor(true);
                this.setColormodel((Color[])ob);
                break;
            }
            case 3: {
                this.setIspic(true);
                this.setPicmodel((String[])ob);
                break;
            }
        }
    }

    public void fromSerialString(String s) throws Exception {
        ArrayList al;
        IObjectIterator it = CtrlUserObjectTrans.createObjectIterator(s);
        if (it.hasNext()) {
            this.addRange((String)it.nextObject());
        }
        if (it.hasNext()) {
            this._block_max = new Variant((Object)((String)it.nextObject()));
        }
        if (it.hasNext()) {
            this._block_min = new Variant((Object)((String)it.nextObject()));
        }
        if (it.hasNext()) {
            this.processmodel = this.ToColor((ArrayList)it.nextObject());
        }
        if (it.hasNext()) {
            this.colormodel = this.ToColor((ArrayList)it.nextObject());
        }
        if (it.hasNext() && (al = (ArrayList)it.nextObject()) != null && al.size() > 0) {
            this.picmodel = al.toArray(new String[al.size()]);
        }
        if (it.hasNext()) {
            this.isprocess = (Boolean)it.nextObject();
        }
        if (it.hasNext()) {
            this.iscolor = (Boolean)it.nextObject();
        }
        if (it.hasNext()) {
            this.ispic = (Boolean)it.nextObject();
        }
    }

    public void addRange(String s) {
        if (StringUtils.isEmpty((String)s)) {
            return;
        }
        if (this._blocks == null) {
            this._blocks = new SortedCellBlockArray();
        }
        String[] clips = s.split(",");
        for (int i = 0; i < clips.length; ++i) {
            String[] indexs = clips[i].split("@");
            this._blocks.insert(CellBlock.getNewCellBlock(Integer.valueOf(indexs[0]) == -1 ? 0 : Integer.valueOf(indexs[0]), Integer.valueOf(indexs[2]) == -1 ? 0 : Integer.valueOf(indexs[2]), Integer.valueOf(indexs[1]) == -1 ? 65535 : Integer.valueOf(indexs[1]), Integer.valueOf(indexs[3]) == -1 ? 1048 : Integer.valueOf(indexs[3])));
        }
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        StringBuffer temps = new StringBuffer();
        for (int i = 0; i < this._blocks.size(); ++i) {
            if (i != 0) {
                temps.append(',');
            }
            CellBlock block = this._blocks.getBlock(i);
            int r1 = block.getRow();
            int r2 = block.getRow2();
            int c1 = block.getCol();
            int c2 = block.getCol2();
            String blockstring = r1 + "@" + r2 + "@" + c1 + "@" + c2;
            temps.append(blockstring);
        }
        CtrlUserObjectTrans.toString(temps.toString(), sb);
        CtrlUserObjectTrans.toString(this._block_max.toString(), sb);
        CtrlUserObjectTrans.toString(this._block_min.toString(), sb);
        CtrlUserObjectTrans.toString(ConditionFormatFurther.getRGBList(this.processmodel), sb);
        CtrlUserObjectTrans.toString(ConditionFormatFurther.getRGBList(this.colormodel), sb);
        CtrlUserObjectTrans.toString(CtrlUtil.Array.objects2ArrayList((Object[])this.picmodel), sb);
        CtrlUserObjectTrans.toString(this.isprocess, sb);
        CtrlUserObjectTrans.toString(this.iscolor, sb);
        CtrlUserObjectTrans.toString(this.ispic, sb);
        return sb.toString();
    }

    public static ArrayList<Integer> getRGBList(Color[] c) {
        ArrayList<Integer> templist = new ArrayList<Integer>();
        if (c != null && c.length > 0) {
            for (int i = 0; i < c.length; ++i) {
                templist.add(c[i].getRGB());
            }
            return templist;
        }
        return templist;
    }

    private Color[] ToColor(ArrayList<Integer> l) {
        if (l != null && l.size() > 0) {
            int size = l.size();
            ArrayList ac = new ArrayList();
            Color[] c = new Color[size];
            for (int i = 0; i < l.size(); ++i) {
                c[i] = new Color(l.get(i));
            }
            return c;
        }
        return null;
    }

    public ConditionFormatFurther getClippedCopy(int left, int top, int right, int bottom) {
        ObjectArray blocks = new ObjectArray();
        for (int i = 0; i < this._blocks.size(); ++i) {
            CellBlock cb = this._blocks.getBlock(i).intersection(top, left, bottom, right);
            if (cb == null) continue;
            blocks.append((Object)cb);
        }
        if (blocks.size() == 0) {
            return null;
        }
        SortedCellBlockArray scba = new SortedCellBlockArray();
        for (int i = 0; i < blocks.size(); ++i) {
            scba.insert(blocks.get(i));
        }
        ConditionFormatFurther further = new ConditionFormatFurther();
        further.setBlocks(scba);
        further.setPicmodel(this.picmodel);
        further.setColormodel(this.colormodel);
        further.setProcessmodel(this.processmodel);
        further.setIscolor(this.iscolor);
        further.setIsprocess(this.isprocess);
        further.setIspic(this.ispic);
        further.set_block_max(this._block_max);
        further.set_block_min(this._block_min);
        return further;
    }

    public ConditionFormatFurther cloneSelf() {
        SortedCellBlockArray scba = new SortedCellBlockArray();
        for (int i = 0; i < this._blocks.size(); ++i) {
            scba.insert(((CellBlock)this._blocks.get(i)).clone());
        }
        ConditionFormatFurther further = new ConditionFormatFurther();
        further.setBlocks(scba);
        further.setPicmodel(this.picmodel);
        further.setColormodel(this.colormodel);
        further.setProcessmodel(this.processmodel);
        further.setIscolor(this.iscolor);
        further.setIsprocess(this.isprocess);
        further.setIspic(this.ispic);
        further.set_block_max(this._block_max);
        further.set_block_min(this._block_min);
        return further;
    }
}

