/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.embed;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.struct.AbstractCalculable;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.ISerialObject;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.embed.HotSpot;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.excel.util.KDSDataOutputStream;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class EmbedObject
extends AbstractCalculable
implements ISerialObject,
Comparable {
    public static final String EMBEDED_OBJ_VERSION_1_0 = "1.0";
    public static final String EMBEDED_OBJ_VERSION_1_1 = "1.1";
    public static final int ANCHOR_TWO_CELL = 0;
    public static final int ANCHOR_ONE_CELL = 1;
    public static final int ANCHOR_ABSOLUTE = 2;
    private boolean _selected;
    protected Sheet _sheet;
    protected int _x;
    protected int _y;
    protected int _width;
    protected int _height;
    protected String _name;
    protected CellBlockNode anchorBlock;
    protected Point fromOffset = new Point();
    protected Point toOffset = new Point();
    protected int anchorMode = 0;
    private float lastScale;

    public EmbedObject(Sheet sheet) {
        this._sheet = sheet;
        this.anchorBlock = CellBlockNode.getNewBlock(this._sheet, 0, 0, 0, 0, 0);
    }

    public String getName() {
        return this._name;
    }

    void setName(String name) {
        this._name = name;
    }

    public int getAnchorMode() {
        return this.anchorMode;
    }

    public void setAnchorMode(int anchorMode) {
        this.setBounds(this._x, this._y, this._width, this._height);
        this.anchorMode = anchorMode;
    }

    boolean isSelected() {
        return this._selected;
    }

    void setSelected(boolean selected) {
        this._selected = selected;
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void setX(int x) {
        this.setBounds(x, this._y, this._width, this._height);
    }

    public void setY(int y) {
        this.setBounds(this._x, y, this._width, this._height);
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this._width, this._height);
    }

    public void setWidth(int w) {
        this.setBounds(this._x, this._y, w, this._height);
    }

    public void setHeight(int h) {
        this.setBounds(this._x, this._y, this._width, h);
    }

    public void setSize(int w, int h) {
        this.setBounds(this._x, this._y, w, h);
    }

    public void setBounds(Rectangle rect) {
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean setBounds(int x, int y, int w, int h) {
        return this.setBounds(x, y, w, h, true);
    }

    public boolean setBounds(int x, int y, int w, int h, boolean updateAnchor) {
        boolean change = false;
        change = x != this._x || y != this._y || w != this._width || h != this._height;
        int oldx = this._x;
        int oldy = this._y;
        int oldw = this._width;
        int oldh = this._height;
        this._x = x;
        this._y = y;
        this._width = w;
        this._height = h;
        this.lastScale = this._sheet.getSheetOption().getScaleNoPercent();
        if (updateAnchor) {
            Point p = new Point(x, y);
            int row = SheetBaseMath.rowAtPoint(this._sheet, p);
            int col = SheetBaseMath.colAtPoint(this._sheet, p);
            int offsetX = (int)((float)(x - SheetBaseMath.getColX(this._sheet, col)) / this.lastScale);
            int offsetY = (int)((float)(y - SheetBaseMath.getRowY(this._sheet, row)) / this.lastScale);
            this.anchorBlock.setRow(row);
            this.anchorBlock.setCol(col);
            this.fromOffset.x = offsetX;
            this.fromOffset.y = offsetY;
            x = this._x + this._width;
            y = this._y + this._height;
            p = new Point(x, y);
            row = SheetBaseMath.rowAtPoint(this._sheet, p);
            col = SheetBaseMath.colAtPoint(this._sheet, p);
            offsetX = (int)((float)(x - SheetBaseMath.getColX(this._sheet, col)) / this.lastScale);
            offsetY = (int)((float)(y - SheetBaseMath.getRowY(this._sheet, row)) / this.lastScale);
            this.anchorBlock.setRow2(row);
            this.anchorBlock.setCol2(col);
            this.toOffset.x = offsetX;
            this.toOffset.y = offsetY;
            this._sheet.setDependent((ICalculable)this, this.anchorBlock);
        }
        if (change) {
            this.boundsUpdated(oldx, oldy, oldw, oldh);
        }
        return change;
    }

    public void relayout() {
        if (this.anchorBlock.isRowColReversed() || this.anchorBlock.isRowColInvalid() || this._sheet.isDisposed()) {
            this.setBounds(0, 0, 0, 0, false);
            return;
        }
        switch (this.anchorMode) {
            case 2: {
                float factor = this._sheet.getSheetOption().getScaleNoPercent() / this.lastScale;
                this.setBounds((int)((float)this._x * factor), (int)((float)this._y * factor), (int)((float)this._width * factor), (int)((float)this._height * factor), false);
                break;
            }
            case 1: {
                float scale = this._sheet.getSheetOption().getScaleNoPercent();
                int scaledFromColWidth = SheetBaseMath.getColWidth(this._sheet, this.anchorBlock.getCol());
                int scaledFromRowHeight = SheetBaseMath.getRowHeight(this._sheet, this.anchorBlock.getRow());
                int scaledFromOffsetX = (int)((float)this.fromOffset.x * scale);
                int scaledFromOffsetY = (int)((float)this.fromOffset.y * scale);
                int abridgedFromOffsetX = scaledFromColWidth < scaledFromOffsetX ? scaledFromColWidth : scaledFromOffsetX;
                int abridgedFromOffsetY = scaledFromRowHeight < scaledFromOffsetY ? scaledFromRowHeight : scaledFromOffsetY;
                int x = SheetBaseMath.getColX(this._sheet, this.anchorBlock.getCol()) + abridgedFromOffsetX;
                int y = SheetBaseMath.getRowY(this._sheet, this.anchorBlock.getRow()) + abridgedFromOffsetY;
                float factor = scale / this.lastScale;
                this.setBounds(x, y, (int)((float)this._width * factor), (int)((float)this._height * factor), false);
                break;
            }
            case 0: {
                float scale = this._sheet.getSheetOption().getScaleNoPercent();
                int scaledFromColWidth = SheetBaseMath.getColWidth(this._sheet, this.anchorBlock.getCol());
                int scaledFromRowHeight = SheetBaseMath.getRowHeight(this._sheet, this.anchorBlock.getRow());
                int scaledFromOffsetX = (int)((float)this.fromOffset.x * scale);
                int scaledFromOffsetY = (int)((float)this.fromOffset.y * scale);
                int abridgedFromOffsetX = scaledFromColWidth < scaledFromOffsetX ? scaledFromColWidth : scaledFromOffsetX;
                int abridgedFromOffsetY = scaledFromRowHeight < scaledFromOffsetY ? scaledFromRowHeight : scaledFromOffsetY;
                int x = SheetBaseMath.getColX(this._sheet, this.anchorBlock.getCol()) + abridgedFromOffsetX;
                int y = SheetBaseMath.getRowY(this._sheet, this.anchorBlock.getRow()) + abridgedFromOffsetY;
                int scaledToColWidth = SheetBaseMath.getColWidth(this._sheet, this.anchorBlock.getCol2());
                int scaledToRowHeight = SheetBaseMath.getRowHeight(this._sheet, this.anchorBlock.getRow2());
                int scaledToOffsetX = (int)((float)this.toOffset.x * scale);
                int scaledToOffsetY = (int)((float)this.toOffset.y * scale);
                int abridgedToOffsetX = scaledToColWidth < scaledToOffsetX ? scaledToColWidth : scaledToOffsetX;
                int abridgedToOffsetY = scaledToRowHeight < scaledToOffsetY ? scaledToRowHeight : scaledToOffsetY;
                int w = SheetBaseMath.getColX(this._sheet, this.anchorBlock.getCol2()) + abridgedToOffsetX - x;
                int h = SheetBaseMath.getRowY(this._sheet, this.anchorBlock.getRow2()) + abridgedToOffsetY - y;
                this.setBounds(x, y, w, h, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad Embed Object AnchorMode!");
            }
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public Rectangle getBounds(Rectangle rect) {
        if (rect == null) {
            return new Rectangle(this._x, this._y, this._width, this._height);
        }
        rect.setBounds(this._x, this._y, this._width, this._height);
        return rect;
    }

    public boolean contains(Point pt) {
        return this.contains(pt.x, pt.y);
    }

    @Override
    public byte[] save() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            out.writeString(EMBEDED_OBJ_VERSION_1_1);
            if (this.anchorMode != 0) {
                this.setBounds(this._x, this._y, this._width, this._height);
            }
            out.writeInt(this._x);
            out.writeInt(this._y);
            out.writeInt(this._width);
            out.writeInt(this._height);
            out.writeInt(this.anchorMode);
            out.writeString(SheetBaseMath.getBlockA1Name(this.anchorBlock, false));
            out.writeInt(this.fromOffset.x);
            out.writeInt(this.fromOffset.y);
            out.writeInt(this.toOffset.x);
            out.writeInt(this.toOffset.y);
            out.writeString(this._name);
            byte[] cus = this.saveCustom();
            out.writeInt(cus.length);
            out.write(cus);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bs.toByteArray();
    }

    @Override
    public void load(byte[] str) {
        try {
            int y;
            int x;
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            String ver = is.readString();
            if (EMBEDED_OBJ_VERSION_1_0.equals(ver)) {
                x = is.readInt();
                y = is.readInt();
                int w = is.readInt();
                int h = is.readInt();
                this.setBounds(x, y, w, h);
            } else {
                x = is.readInt();
                y = is.readInt();
                int w = is.readInt();
                int h = is.readInt();
                this.setBounds(x, y, w, h, false);
                this.anchorMode = is.readInt();
                this.anchorBlock = (CellBlockNode)SheetBaseMath.getListBlockNodes(this._sheet, is.readString(), true).get(0);
                this.fromOffset.x = is.readInt();
                this.fromOffset.y = is.readInt();
                this.toOffset.x = is.readInt();
                this.toOffset.y = is.readInt();
            }
            this.setName(is.readString());
            int cusLen = is.readInt();
            byte[] cus = new byte[cusLen];
            is.read(cus);
            this.loadCustom(cus);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract HotSpot[] getHotSpots();

    public abstract boolean contains(int var1, int var2);

    public abstract void paintData(Graphics var1);

    public abstract void paintFocus(Graphics var1);

    public abstract Shape getOutLine(HotSpot var1, int var2, int var3);

    protected abstract void boundsUpdated(int var1, int var2, int var3, int var4);

    protected abstract byte[] saveCustom();

    protected abstract void loadCustom(byte[] var1);

    @Override
    public boolean calc(ExprContext ctx) {
        this.relayout();
        return true;
    }

    @Override
    public Sheet getSheet() {
        return this._sheet;
    }

    @Override
    public Variant getValue() {
        return null;
    }

    @Override
    public void updateExpr(boolean queue) {
    }

    @Override
    public void updateFormula() {
    }

    @Override
    public int getCalculableType() {
        return 5;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int cmp = 1;
        if (obj instanceof ICalculable && (cmp = this.getCalculableType() - ((ICalculable)obj).getCalculableType()) != 0) {
            return cmp;
        }
        if (cmp == 0) {
            return this.anchorBlock.compareTo(((EmbedObject)obj).anchorBlock);
        }
        return cmp;
    }
}

