/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.embed;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.excel.io.clipboard.ClipboardTransferHandler;
import com.kingdee.bos.ctrl.excel.model.struct.AbstractBookUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedMath;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.excel.model.struct.embed.HotSpot;
import com.kingdee.bos.ctrl.excel.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.excel.model.struct.undo.AbstractUndoableEdit;
import com.kingdee.bos.ctrl.excel.model.struct.undo.UndoException;
import com.kingdee.bos.ctrl.excel.model.util.SortedSheetArray;
import com.kingdee.bos.ctrl.excel.util.KDSDataOutputStream;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class EmbedRange {
    private EmbedObject[] _graphs;
    private EmbedhLayer _gLayer;

    EmbedRange(EmbedhLayer gl, EmbedObject[] graphs) {
        this._gLayer = gl;
        this._graphs = graphs;
    }

    private boolean hasEmbed() {
        return this._graphs != null && this._graphs.length > 0;
    }

    public Point getUpLeftCorner() {
        return EmbedMath.getUpLeftCorner(this._graphs);
    }

    public boolean copy() {
        Protection pro = this._gLayer.getSheet().getSheetOption().getProtection(false);
        if (pro != null && !pro.allowEditObjects()) {
            return false;
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            for (EmbedObject gr : this._graphs) {
                out.writeString(gr.getClass().getName());
                out.writeLengthBytes(gr.save());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ClipboardTransferHandler.exportGraphsToClipboard(bs.toByteArray());
        return true;
    }

    public boolean setName(String name) {
        Protection pro = this._gLayer.getSheet().getSheetOption().getProtection(false);
        if (pro != null && !pro.allowEditObjects()) {
            return false;
        }
        if (this.hasEmbed() && this._graphs.length == 1) {
            return new EmbedNameActionEdit(this._graphs, "Changed_Name", name).run();
        }
        return false;
    }

    public boolean offsetSelectedGraphs(int hsType, int dx, int dy) {
        Protection pro = this._gLayer.getSheet().getSheetOption().getProtection(false);
        if (pro != null && !pro.allowEditObjects()) {
            return false;
        }
        if (this.hasEmbed() && (dx != 0 || dy != 0)) {
            return new EmbedBoundsActionEdit(this._graphs, "Changed_Bounds", hsType, dx, dy).run();
        }
        return false;
    }

    public boolean offsetSelectedGraphs(HotSpot hs, int dx, int dy) {
        return this.offsetSelectedGraphs(hs == null ? -1 : hs.getType(), dx, dy);
    }

    class EmbedNameActionEdit
    extends EmbedPropActionEdit {
        protected EmbedNameActionEdit(EmbedObject[] graphs, String type, String newName) {
            super(graphs, type);
            this._oldValues = new String[]{graphs[0].getName()};
            this._newValues = new String[]{newName};
        }

        @Override
        protected boolean action(Sheet sheet, boolean redo, boolean withUndo) {
            if (redo) {
                this._graphs[0].setName((String)this._newValues[0]);
            } else {
                this._graphs[0].setName((String)this._oldValues[0]);
            }
            return true;
        }

        @Override
        public String getPresentationName() {
            return LanguageManager.getLangMessage((String)"modifyname", AbstractUndoableEdit.class, (String)"\u8c03\u6574\u5bf9\u8c61\u540d\u79f0 ");
        }
    }

    class EmbedBoundsActionEdit
    extends EmbedPropActionEdit {
        private int _hsType;
        private int _dx;
        private int _dy;

        protected EmbedBoundsActionEdit(EmbedObject[] graphs, String type, int hsType, int dx, int dy) {
            super(graphs, type);
            this._hsType = hsType;
            this._dx = dx;
            this._dy = dy;
        }

        @Override
        protected boolean action(Sheet sheet, boolean redo, boolean withUndo) {
            int dy;
            int dx;
            if (redo) {
                dx = this._dx;
                dy = this._dy;
            } else {
                dx = -this._dx;
                dy = -this._dy;
            }
            this._oldValues = new Rectangle[this._graphs.length];
            this._newValues = new Rectangle[this._graphs.length];
            for (EmbedObject gr : this._graphs) {
                Rectangle rect = EmbedMath.calcOutLineRect(this._hsType, gr.getX(), gr.getY(), gr.getWidth(), gr.getHeight(), dx, dy);
                this._oldValues[i] = gr.getBounds();
                gr.setBounds(rect.x, rect.y, rect.width, rect.height);
                this._newValues[i] = gr.getBounds();
            }
            return true;
        }

        @Override
        public String getPresentationName() {
            return LanguageManager.getLangMessage((String)"modifysize", AbstractUndoableEdit.class, (String)"\u8c03\u6574\u5bf9\u8c61\u5927\u5c0f ");
        }
    }

    abstract class EmbedPropActionEdit
    extends AbstractBookUndoableEdit {
        protected String _type;
        protected EmbedObject[] _graphs;
        protected Object[] _oldValues;
        protected Object[] _newValues;

        protected EmbedPropActionEdit(EmbedObject[] graphs, String type) {
            this._type = type;
            this._graphs = graphs;
        }

        @Override
        public SortedSheetArray getRelatedSheets() {
            SortedSheetArray sheets = new SortedSheetArray();
            sheets.insert(EmbedRange.this._gLayer.getSheet());
            return sheets;
        }

        public boolean run() {
            boolean withUndo = EmbedRange.this._gLayer.getSheet().getBook().getUndoManager().isEnable();
            boolean bAction = this.action(EmbedRange.this._gLayer.getSheet(), true, withUndo);
            if (bAction) {
                this.invalidate();
                if (withUndo) {
                    EmbedRange.this._gLayer.getSheet().getBook().getUndoManager().addEdit(this);
                }
            }
            return bAction;
        }

        @Override
        public void undo() throws UndoException {
            this.unredo(false);
        }

        @Override
        public void redo() throws UndoException {
            this.unredo(true);
        }

        private void unredo(boolean redo) throws UndoException {
            if (redo) {
                super.redo();
            } else {
                super.undo();
            }
            boolean withUndo = EmbedRange.this._gLayer.getSheet().getBook().getUndoManager().isEnable();
            this.action(EmbedRange.this._gLayer.getSheet(), redo, withUndo);
            this.invalidate();
        }

        protected void invalidate() {
            EmbedRange.this._gLayer.getSheet().getBook().fireGraphPropertyChange(new GraphPropertyChangedEvent(EmbedRange.this._gLayer.getSheet(), this._graphs, this._type, this._oldValues, this._newValues));
        }

        protected abstract boolean action(Sheet var1, boolean var2, boolean var3);
    }
}

