/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.struct.node;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.expr.ExprArray;
import com.kingdee.bos.ctrl.excel.model.expr.ExprConst;
import com.kingdee.bos.ctrl.excel.model.expr.ExprContext;
import com.kingdee.bos.ctrl.excel.model.expr.ExprOperator;
import com.kingdee.bos.ctrl.excel.model.expr.IExprNode;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.ICalculable;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlock3DNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.excel.model.struct.node.ConstNamedObjectNode;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import java.util.Locale;

public class NamedObjectNode
implements Comparable,
IExprNode,
ICalculable {
    public static final NamedObjectNode True;
    public static final NamedObjectNode False;
    public static final NamedObjectNode Null;
    protected static final int Flag_NeedCalc = 1;
    protected static final int Flag_HasValue = 2;
    protected static final int Flag_Queued = 4;
    protected static final int Flag_Calculating = 8;
    protected static final int Flag_Hidden = 16;
    protected static final int Flag_DisableRefered = 32;
    private static final Expr _exprUndefined;
    private String _name;
    private String _upperName;
    protected String _refersTo;
    private Expr _expr;
    private Book _book;
    private Sheet _sheet;
    private Object _refs;
    private int _flags;
    protected Variant _var;

    public static Expr getUndefinedExpr() {
        return _exprUndefined;
    }

    public static NamedObjectNode createUndefinedNamedObject(String name, Book book, Sheet sheet) {
        return new NamedObjectNode(name, _exprUndefined, book, sheet);
    }

    public NamedObjectNode(String name, String refersTo, Book book, Sheet sheet) {
        this._book = book;
        this._sheet = sheet;
        this._name = name;
        this._upperName = this._name.toUpperCase();
        this.setRefersTo(refersTo);
    }

    public NamedObjectNode(String name, Expr expr, Book book, Sheet sheet) {
        this._book = book;
        this._sheet = sheet;
        this._name = name;
        this._upperName = this._name.toUpperCase();
        this._expr = expr;
        if (expr != null) {
            this.setFlag(1, true);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this._name + "[");
        if (this.touchFlag(2)) {
            sb.append("V");
        }
        if (this.touchFlag(1)) {
            sb.append(",NC");
        }
        if (this.touchFlag(4)) {
            sb.append(",Q");
        }
        if (this.isUndefined()) {
            sb.append(",Un");
        }
        sb.append("]");
        return sb.toString() + " = " + this.getRefersTo() + (this._var == null ? "" : " " + this._var.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NamedObjectNode) {
            NamedObjectNode no = (NamedObjectNode)obj;
            return this._book == no._book && this._sheet == no._sheet && this._name.equals(no._name) && this.getRefersTo().equals(no.getRefersTo());
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public String getUpperCaseName() {
        return this._upperName;
    }

    public String getFullName() {
        return this._sheet == null ? this._name : this._sheet.getSyntaxName() + '!' + this._name;
    }

    public String getRefersTo() {
        if (StringUtil.isEmptyString((String)this._refersTo) && this._expr != null && !this._expr.isSyntaxError()) {
            this._refersTo = this._expr.decode(this._book.getDeps().getExprContext(), this);
        }
        return this._refersTo;
    }

    @Override
    public Expr getExpr() {
        if (this._expr == null && !StringUtil.isEmptyString((String)this._refersTo)) {
            this._expr = this._sheet == null ? this._book.getActiveSheet().getExpr(this, this._refersTo) : this._sheet.getExpr(this, this._refersTo);
        }
        return this._expr;
    }

    public Expr setExpr(Expr expr) {
        this.setFlag(1, true);
        this.setFlag(2, false);
        this._var = null;
        this._refersTo = null;
        Expr old = this.getExpr();
        this._expr = expr;
        return old;
    }

    public Object getRefs() {
        return this._refs;
    }

    public void setRefs(Object refs) {
        this._refs = refs;
    }

    public boolean isLocal() {
        return this._sheet != null;
    }

    public boolean isVisible() {
        return !this.touchFlag(16);
    }

    public boolean isDisableRefered() {
        return this.touchFlag(32);
    }

    public boolean isEmpty() {
        return !(this._expr != null && !this._expr.isSyntaxError() || !StringUtil.isEmptyString((String)this._refersTo) || this._var != null && !this._var.isNull() && !this._var.isError());
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
    }

    public void setRefersTo(String refersTo) {
        this._refersTo = refersTo;
        this._expr = null;
        this.setFlag(1, true);
    }

    public void setVisible(boolean bVisible) {
        this.setFlag(16, !bVisible);
    }

    public int compareTo(Object obj) {
        int cmp;
        if (obj instanceof ICalculable && (cmp = this.getCalculableType() - ((ICalculable)obj).getCalculableType()) != 0) {
            return cmp;
        }
        cmp = obj instanceof NamedObjectNode ? this._upperName.compareTo(((NamedObjectNode)obj)._upperName) : this._upperName.compareTo(obj.toString().toUpperCase(Locale.ENGLISH));
        return cmp;
    }

    @Override
    public int getExprType() {
        return 8;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        Variant value;
        if (this.isLocal()) {
            this._sheet.setDependent(exprOwner, this);
        } else if (this._book != null) {
            this._book.getNames().setDependent(exprOwner, this);
        }
        if (this._book != null) {
            this._book.getDeps().calcReferTo(this);
        }
        if ((value = this.getValue()).isCircleError()) {
            throw (SyntaxErrorException)((Object)value.getValue());
        }
        ctx.getCurrentExprStack().push(value);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        return this._sheet != exprOwner.getSheet() ? this.getFullName() : this._name;
    }

    public void queue(boolean updateFormula) {
        this.setFlag(1, true);
        this._book.getDeps().queue(this, this._book.isAutoCalculate(), updateFormula);
    }

    @Override
    public Sheet getSheet() {
        return this._sheet != null ? this._sheet : this._book.getActiveSheet();
    }

    public Range getRefersToRange() {
        Range rg = null;
        SortedCellBlockArray sa = this.getRefersToBlocks();
        if (sa != null) {
            CellBlockNode node = (CellBlockNode)sa.get(0);
            boolean is3D = node instanceof CellBlock3DNode;
            Sheet sheet = node.getSheet();
            Sheet sheet2 = is3D ? ((CellBlock3DNode)node).getSheet2() : sheet;
            Sheet sh = null;
            Sheet sh2 = null;
            int size = sa.size();
            for (int i = 1; i < size; ++i) {
                node = (CellBlockNode)sa.get(i);
                sh = null;
                if (is3D) {
                    if (node instanceof CellBlock3DNode) {
                        CellBlock3DNode no3 = (CellBlock3DNode)node;
                        sh = no3.getSheet();
                        sh2 = no3.getSheet2();
                    }
                } else if (!(node instanceof CellBlock3DNode)) {
                    sh = sh2 = node.getSheet();
                }
                if (sh == sheet && sh2 == sheet2) continue;
                sa.clear();
                break;
            }
            if (!sa.isEmpty()) {
                rg = new Range(this._book, this._book.getSheetsArray(sheet, sheet2), sa.toArray());
            }
        }
        return rg;
    }

    private SortedCellBlockArray getRefersToBlocks() {
        SortedCellBlockArray sa = new SortedCellBlockArray();
        if (this.getExpr() != _exprUndefined) {
            IExprNode[] nodes = this.getExpr().getParameters();
            int nodesCount = nodes.length;
            if (nodesCount == 1) {
                IExprNode node = nodes[0];
                if (node instanceof CellBlockNode) {
                    sa.insert(node);
                }
            } else if (nodes[nodesCount - 1] instanceof ExprArray) {
                for (int i = 0; i < nodesCount - 1; ++i) {
                    IExprNode node = nodes[i];
                    if (!(node instanceof CellBlockNode)) {
                        if (node == ExprOperator.COMMA) continue;
                        return null;
                    }
                    sa.insert(node);
                }
            }
        }
        return sa.isEmpty() ? null : sa;
    }

    public boolean isRefersTo(SortedCellBlockArray blocks, Sheet sheet, Sheet sheet2) {
        SortedCellBlockArray sa = this.getRefersToBlocks();
        if (sa != null && sa.size() == blocks.size()) {
            int size = sa.size();
            for (int i = 0; i < size; ++i) {
                if (this.isEquals((CellBlockNode)sa.get(i), blocks.getBlock(i), sheet, sheet2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isEquals(CellBlockNode cb, CellBlock block, Sheet sheet, Sheet sheet2) {
        if (cb.getSheet() == sheet && block.equals(cb)) {
            if (sheet == sheet2) {
                return !(cb instanceof CellBlock3DNode);
            }
            if (cb instanceof CellBlock3DNode) {
                return ((CellBlock3DNode)cb).getSheet2() == sheet2;
            }
        }
        return false;
    }

    @Override
    public void updateExpr(boolean queue) {
        String formula = this.getRefersTo();
        if (!StringUtil.isEmptyString((String)formula)) {
            this.setExpr(this.getSheet().getExpr(this, formula));
            if (queue) {
                this.queue(false);
            }
        }
    }

    public void updateRefsExpr() {
        if (this._refs != null) {
            if (this._refs instanceof ICalculable) {
                ((ICalculable)this._refs).updateExpr(true);
            } else {
                SortedObjectArray list = (SortedObjectArray)this._refs;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    ((ICalculable)list.get(i)).updateExpr(true);
                }
            }
        }
    }

    public boolean isUndefined() {
        return this.getExpr() == _exprUndefined;
    }

    public boolean isExtUsed() {
        return this.isUndefined() && this._var != null && !this._var.isError();
    }

    public boolean isNullExpr() {
        return this.getExpr() == null;
    }

    @Override
    public boolean isNeedRecalc() {
        return this.touchFlag(1);
    }

    @Override
    public void setNeedRecalc(boolean bRecalc) {
        this.setFlag(1, bRecalc);
    }

    @Override
    public boolean isCalculating() {
        return this.touchFlag(8);
    }

    @Override
    public void setCalculating(boolean bCalculating) {
        this.setFlag(8, bCalculating);
    }

    @Override
    public boolean isQueued() {
        return this.touchFlag(4);
    }

    @Override
    public void setQueued(boolean bQueued) {
        this.setFlag(4, bQueued);
    }

    @Override
    public void updateFormula() {
        this._refersTo = null;
    }

    @Override
    public boolean calc(ExprContext ctx) {
        this._var = this.getSheet().isEnableCalculation() ? this.getExpr().execute(ctx, this) : Variant.nullVariant;
        this.setFlag(2, true);
        this.setFlag(5, false);
        boolean pending = this._var.isPending() || this._var.isCalcLast();
        this.setFlag(1, pending);
        return true;
    }

    @Override
    public Variant getValue() {
        Variant var;
        if (this.touchFlag(2)) {
            var = this._var;
        } else if (this.touchFlag(1)) {
            this.calc(this._book.getDeps().getExprContext());
            var = this._var;
        } else {
            var = Variant.nullVariant;
        }
        return var;
    }

    public void setValue(Variant value) {
        this._var = value;
        this.setFlag(2, this._var != null);
        this.setFlag(1, false);
    }

    @Override
    public int getCalculableType() {
        return 3;
    }

    protected void setFlag(int flag, boolean set) {
        this._flags = set ? (this._flags |= flag) : (this._flags &= ~flag);
    }

    private boolean touchFlag(int flag) {
        return (this._flags & flag) != 0;
    }

    static {
        IExprNode[] nodes = new IExprNode[]{ExprConst.BADID};
        _exprUndefined = Expr.getExpr(nodes, 8, 0, 1);
        True = new ConstNamedObjectNode("True", Expr.getExpr(new IExprNode[]{ExprConst.TRUE}, 2, 0, 1), null, null, Variant.trueVariant);
        False = new ConstNamedObjectNode("False", Expr.getExpr(new IExprNode[]{ExprConst.FALSE}, 2, 0, 1), null, null, Variant.falseVariant);
        Null = new ConstNamedObjectNode("Null", Expr.getExpr(new IExprNode[]{ExprConst.NULL}, 2, 0, 1), null, null, Variant.nullVariant);
    }
}

