/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.util;

import com.kingdee.bos.ctrl.excel.util.KDSDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KDSDataInputStream
extends DataInputStream {
    private static final String ENCODING = "UTF-8";
    private static final int BufSize = 1024;
    private byte[] bytes = new byte[1024];

    public KDSDataInputStream(InputStream in) {
        super(in);
    }

    public String readDirectString(int len) throws IOException {
        if (this.bytes != null && len <= this.bytes.length) {
            this.read(this.bytes, 0, len);
            return new String(this.bytes, 0, len, ENCODING);
        }
        byte[] bb = new byte[len];
        this.read(bb, 0, len);
        return new String(bb, 0, len, ENCODING);
    }

    public byte[] readLengthBytes() throws IOException {
        int len = this.readShortOrInt();
        if (len <= 0) {
            return new byte[0];
        }
        byte[] bb = new byte[len];
        this.read(bb, 0, len);
        return bb;
    }

    public String readString() throws IOException {
        int len = this.readShortOrInt();
        if (len <= 0) {
            return "";
        }
        if (this.bytes != null && len <= this.bytes.length) {
            this.read(this.bytes, 0, len);
            return new String(this.bytes, 0, len, ENCODING);
        }
        byte[] bb = new byte[len];
        this.read(bb, 0, len);
        return new String(bb, 0, len, ENCODING);
    }

    public int readShortOrInt() throws IOException {
        int len;
        int s1 = this.readShort();
        if (s1 < 0) {
            short s2 = this.readShort();
            len = (s1 << 16) + (s2 & 0xFFFF);
            len = -len;
        } else {
            len = s1;
        }
        return len;
    }

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        KDSDataOutputStream kos = new KDSDataOutputStream(bos);
        int len = 31767;
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append('0');
        }
        kos.writeString(sb.toString());
    }
}

