/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table;

import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTHorizon;
import com.kingdee.bos.ctrl.kdf.table.KDTLayoutInfo;
import com.kingdee.bos.ctrl.kdf.table.KDTLayoutManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTStyleConstants;
import com.kingdee.bos.ctrl.kdf.table.KDTVertical;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableUI;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class KDTBasicUI
extends KDTableUI {
    protected KeyListener keyListener;
    protected InputMethodListener inputMethodListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    private KDTable table;
    private int vCurrentSplitBar = -1;
    private int hCurrentSplitBar = -1;

    public static ComponentUI createUI(JComponent c) {
        return new KDTBasicUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.table = (KDTable)c;
        super.installUI(this.table);
        this.installDefaults(this.table);
        this.installListeners(this.table);
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(this.table);
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table = null;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.table.getLayoutManager().minimumLayoutSize(null);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.table.getLayoutManager().preferredLayoutSize(null);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    private void installDefaults(KDTable table) {
        this.createDefaultStyle();
        table.applyHeadCellStyle();
    }

    private void createDefaultStyle() {
        Color colorTemp = UIManager.getColor("KDTable.gridLineColor");
        colorTemp = colorTemp != null ? colorTemp : KDTStyleConstants.GRID_LINE_COLOR;
        this.table.setBorder(new LineBorder(colorTemp));
        this.table.setGridLineColor(colorTemp);
        this.table.setHeadGridLineColor(colorTemp);
        colorTemp = UIManager.getColor("KDTable.background");
        colorTemp = colorTemp != null ? colorTemp : KDTStyleConstants.TABLE_BACKGROUND;
        this.table.setBackground(colorTemp);
        Color selectColor = UIManager.getColor("KDTable.selectionBackground");
        selectColor = selectColor != null ? selectColor : KDTStyleConstants.SELECT_COLOR;
        this.table.getSelectManager().setSelectColor(selectColor);
        Color bodyBackColor = UIManager.getColor("KDTable.bodyBackground");
        bodyBackColor = bodyBackColor != null ? bodyBackColor : KDTStyleConstants.BODY_BACKGROUND;
        Color headBackColor = UIManager.getColor("KDTable.headBackground");
        headBackColor = headBackColor != null ? headBackColor : KDTStyleConstants.HEAD_BACKGROUND;
        Color foreColor = UIManager.getColor("KDTable.foreground");
        foreColor = foreColor != null ? foreColor : KDTStyleConstants.TABLE_FOREGROUND;
        Font font = UIManager.getFont("KDTable.font");
        StyleAttributes sa = Styles.getEmptySA();
        if (font != null) {
            sa.setFontName(font.getFontName());
            sa.setFontSize(font.getSize());
            int fontstyle = font.getStyle();
            if (fontstyle == 1) {
                sa.setBold(true);
            } else if (fontstyle == 2) {
                sa.setItalic(true);
            } else if (fontstyle == 3) {
                sa.setBold(true);
                sa.setItalic(true);
            }
        }
        sa.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        sa.setBackground(Styles.getNullColor());
        ShareStyleAttributes ssa = Styles.getSSA((StyleAttributes)sa);
        Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{sa});
        this.table.setSSA(ssa);
        this.table.setStyle(style);
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        sa.setBackground(headBackColor);
        sa.setLocked(true);
        ssa = Styles.getSSA((StyleAttributes)sa);
        style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{sa});
        this.table.setHeadSSA(ssa);
        this.table.setHeadStyle(style);
        Color[] headVergesColor = new Color[5];
        colorTemp = UIManager.getColor("KDTable.headVergeColor1");
        headVergesColor[0] = colorTemp != null ? colorTemp : KDTStyleConstants.HEAD_VERGE1_COLOR;
        colorTemp = UIManager.getColor("KDTable.headVergeColor2");
        headVergesColor[1] = colorTemp != null ? colorTemp : KDTStyleConstants.HEAD_VERGE2_COLOR;
        colorTemp = UIManager.getColor("KDTable.headVergeColor3");
        headVergesColor[2] = colorTemp != null ? colorTemp : KDTStyleConstants.HEAD_VERGE3_COLOR;
        colorTemp = UIManager.getColor("KDTable.headVergeColor4");
        headVergesColor[3] = colorTemp != null ? colorTemp : KDTStyleConstants.HEAD_VERGE4_COLOR;
        colorTemp = UIManager.getColor("KDTable.headVergeColor5");
        headVergesColor[4] = colorTemp != null ? colorTemp : KDTStyleConstants.HEAD_VERGE5_COLOR;
        this.table.setHeadVergesColor(headVergesColor);
        sa = Styles.getEmptySA();
        if (font != null) {
            sa.setFontName(font.getFontName());
            sa.setFontSize(font.getSize());
            int fontstyle = font.getStyle();
            if (fontstyle == 1) {
                sa.setBold(true);
            } else if (fontstyle == 2) {
                sa.setItalic(true);
            } else if (fontstyle == 3) {
                sa.setBold(true);
                sa.setItalic(true);
            }
        }
        colorTemp = (colorTemp = UIManager.getColor("KDTable.indexColBackground")) != null ? colorTemp : KDTStyleConstants.HEAD_BACKGROUND;
        sa.setBackground(colorTemp);
        ssa = Styles.getSSA((StyleAttributes)sa);
        this.table.getIndexColumn().setSsa(ssa);
        colorTemp = UIManager.getColor("KDTable.treeColBackground");
        colorTemp = colorTemp != null ? colorTemp : KDTStyleConstants.HEAD_BACKGROUND;
        sa.setBackground(colorTemp);
        ssa = Styles.getSSA((StyleAttributes)sa);
        this.table.getTreeColumn().setSSA(ssa);
        this.table.getTreeColumn().setStyle(Styles.getStyle((ShareStyleAttributes)ssa));
    }

    private void installListeners(KDTable table) {
        this.inputMethodListener = new IMHandle();
        this.focusListener = new FocusHandler();
        this.mouseInputListener = new MouseHandle();
        table.addInputMethodListener(this.inputMethodListener);
        table.addFocusListener(this.focusListener);
        table.addMouseListener(this.mouseInputListener);
        table.addMouseMotionListener(this.mouseInputListener);
    }

    private void installKeyboardActions() {
        this.table.getKeyControlManager().installAction();
    }

    private void uninstallDefaults() {
    }

    private void uninstallListeners() {
        this.table.removeInputMethodListener(this.inputMethodListener);
        this.table.removeFocusListener(this.focusListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.inputMethodListener = null;
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
    }

    private void uninstallKeyboardActions() {
        this.table.getKeyControlManager().uninstallAction();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.fillBackGround(g);
        this.drawSplitButton(g);
        this.drawSplit(g);
    }

    private void fillBackGround(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.table.getBackground());
        g.fillRect(0, 0, this.table.getWidth(), this.table.getHeight());
        g.setColor(oldColor);
    }

    private void drawSplitButton(Graphics g) {
        this.drawVSplitButton(g, this.table.getLayoutManager().getVSplitButtonRect());
        this.drawHSplitButton(g, this.table.getLayoutManager().getHSplitButtonRect());
    }

    private void drawSplit(Graphics g) {
        this.drawVSplit(g);
        this.drawHSplit(g);
    }

    private void drawVSplit(Graphics g) {
        int vCount = this.table.getVerticalCount();
        if (vCount <= 2) {
            return;
        }
        int hCount = this.table.getHorizonCount();
        KDTLayoutManager lm = this.table.getLayoutManager();
        Rectangle rect = new Rectangle();
        block5: for (int i = 0; i < vCount; ++i) {
            KDTVertical infoV = lm.getVertical(i);
            switch (infoV.getSplitType()) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    for (int j = 0; j < hCount; ++j) {
                        KDTHorizon infoH = lm.getHorizon(j);
                        rect.x = infoH.getStart();
                        rect.y = infoV.getStart() + infoV.getSpan();
                        rect.height = 6;
                        rect.width = infoH.getSpan();
                        if (j == hCount - 1) {
                            rect.width += 17;
                        }
                        if (rect.width == 0) continue;
                        this.drawVSplitBar(g, rect);
                    }
                    continue block5;
                }
                case 2: {
                    int t2;
                    rect.y = infoV.getStart() + infoV.getSpan();
                    rect.height = 1;
                    rect.x = this.table.getInsets().left;
                    rect.width = t2 = this.table.getViewManager().getWidth();
                    this.drawSplitLine(g, rect);
                    continue block5;
                }
            }
        }
    }

    private void drawHSplit(Graphics g) {
        KDTHorizon infoH;
        int hCount = this.table.getHorizonCount();
        if (hCount <= 3) {
            return;
        }
        KDTLayoutManager lm = this.table.getLayoutManager();
        Rectangle rect = new Rectangle();
        block5: for (int i = 0; i < hCount && (infoH = lm.getHorizon(i)) != null; ++i) {
            switch (infoH.getSplitType()) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    KDTVertical infoV;
                    int vCount = this.table.getVerticalCount();
                    for (int j = 0; j < vCount && (infoV = lm.getVertical(j)) != null; ++j) {
                        rect.y = infoV.getStart();
                        rect.x = infoH.getStart() + infoH.getSpan();
                        rect.width = 6;
                        rect.height = infoV.getSpan();
                        if (j == vCount - 1) {
                            rect.height += 17;
                        }
                        if (rect.height == 0) continue;
                        this.drawHSplitBar(g, rect);
                    }
                    continue block5;
                }
                case 2: {
                    rect.x = infoH.getStart() + infoH.getSpan();
                    rect.width = 1;
                    rect.y = this.table.getInsets().top;
                    rect.height = this.table.getViewManager().getHeight();
                    this.drawSplitLine(g, rect);
                    if (!this.table.isHasFoot()) continue block5;
                    KDTVertical info = lm.getVertical(this.table.getVerticalCount() - 1);
                    rect.y = info.getStart();
                    rect.height = info.getSpan();
                    this.drawSplitLine(g, rect);
                }
            }
        }
    }

    private void drawVSplitButton(Graphics g, Rectangle r) {
        if (r.width == 0 || r.height == 0) {
            return;
        }
        int top = r.y;
        int left = r.x;
        int right = left + r.width - 1;
        int bottom = top + r.height - 1;
        g.setColor(UIManager.getColor("KDTable.splitBarColor1"));
        g.drawLine(left, top, left, bottom);
        g.drawLine(right, top, right, bottom);
        g.drawLine(++left, top, --right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor2"));
        g.drawLine(left, ++top, right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor3"));
        g.drawLine(left, ++top, right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor3"));
        g.drawLine(left, ++top, right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor4"));
        g.drawLine(left, ++top, right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor5"));
        g.drawLine(left, ++top, right, top);
    }

    private void drawHSplitButton(Graphics g, Rectangle r) {
        if (r.width == 0 || r.height == 0) {
            return;
        }
        int top = r.y;
        int left = r.x;
        int right = left + r.width - 1;
        int bottom = top + r.height - 1;
        g.setColor(UIManager.getColor("KDTable.splitBarColor1"));
        g.drawLine(left, top, right, top);
        g.drawLine(left, bottom, right, bottom);
        g.drawLine(left, ++top, left, --bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor2"));
        g.drawLine(++left, top, left, bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor3"));
        g.drawLine(++left, top, left, bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor3"));
        g.drawLine(++left, top, left, bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor4"));
        g.drawLine(++left, top, left, bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor5"));
        g.drawLine(++left, top, left, bottom);
    }

    private void drawVSplitBar(Graphics g, Rectangle r) {
        int top = r.y;
        int left = r.x;
        int right = left + r.width;
        g.setColor(UIManager.getColor("KDTable.splitBarColor1"));
        g.drawLine(left, top, right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor2"));
        g.drawLine(left, ++top, right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor3"));
        g.drawLine(left, ++top, right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor3"));
        g.drawLine(left, ++top, right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor4"));
        g.drawLine(left, ++top, right, top);
        g.setColor(UIManager.getColor("KDTable.splitBarColor5"));
        g.drawLine(left, ++top, right, top);
    }

    private void drawHSplitBar(Graphics g, Rectangle r) {
        int top = r.y;
        int left = r.x;
        int bottom = top + r.height;
        g.setColor(UIManager.getColor("KDTable.splitBarColor1"));
        g.drawLine(left, top, left, bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor2"));
        g.drawLine(++left, top, left, bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor3"));
        g.drawLine(++left, top, left, bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor3"));
        g.drawLine(++left, top, left, bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor4"));
        g.drawLine(++left, top, left, bottom);
        g.setColor(UIManager.getColor("KDTable.splitBarColor5"));
        g.drawLine(++left, top, left, bottom);
    }

    private void drawSplitLine(Graphics g, Rectangle r) {
        int top = r.y;
        int left = r.x;
        int right = left + r.width - 1;
        int bottom = top + r.height - 1;
        g.setColor(UIManager.getColor("KDTable.splitLineColor"));
        g.drawLine(left, top, right, bottom);
    }

    class MouseHandle
    implements MouseInputListener {
        protected int status = 0;
        public static final int ACTION_NORMAL = 0;
        public static final int ACTION_ABOVE_VSPLITBUTTON = 1;
        public static final int ACTION_MOVE_VSPLITBUTTON = 2;
        public static final int ACTION_ABOVE_HSPLITBUTTON = 3;
        public static final int ACTION_MOVE_HSPLITBUTTON = 4;
        public static final int ACTION_ABOVE_VSPLITBAR = 5;
        public static final int ACTION_MOVE_VSPLITBAR = 6;
        public static final int ACTION_ABOVE_HSPLITBAR = 7;
        public static final int ACTION_MOVE_HSPLITBAR = 8;

        MouseHandle() {
        }

        protected void setStatus(int status) {
            switch (status) {
                case 0: {
                    KDTBasicUI.this.table.setCursor(new Cursor(0));
                    break;
                }
                case 1: {
                    KDTBasicUI.this.table.setCursor(new Cursor(8));
                    break;
                }
                case 3: {
                    KDTBasicUI.this.table.setCursor(new Cursor(11));
                    break;
                }
                case 5: {
                    KDTBasicUI.this.table.setCursor(new Cursor(8));
                    break;
                }
                case 7: {
                    KDTBasicUI.this.table.setCursor(new Cursor(11));
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 6: {
                    break;
                }
                case 8: {
                    break;
                }
            }
            this.status = status;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            if (e.getClickCount() == 2) {
                if (this.isAboveVSplitButton(p)) {
                    KDTBasicUI.this.table.getViewManager().splitVertical(1);
                } else if (this.isAboveHSplitButton(p)) {
                    int hCount = KDTBasicUI.this.table.getHorizonCount();
                    KDTBasicUI.this.table.getViewManager().splitHorizon(hCount - 1);
                } else {
                    int a = this.isAboveSplitBar(p);
                    if (a == 1) {
                        KDTBasicUI.this.table.getViewManager().mergeVertical(KDTBasicUI.this.vCurrentSplitBar);
                    } else if (a == 2) {
                        KDTBasicUI.this.table.getViewManager().mergeHorizon(KDTBasicUI.this.hCurrentSplitBar);
                    }
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                return;
            }
            Point p = e.getPoint();
            Rectangle rSplitBar = this.getMovingSplitBarRect();
            switch (this.status) {
                case 0: {
                    break;
                }
                case 1: {
                    this.setStatus(2);
                    Rectangle r = KDTBasicUI.this.table.getLayoutManager().getVSplitButtonRect();
                    KDTBasicUI.this.vCurrentSplitBar = 1;
                    rSplitBar.x = 0;
                    rSplitBar.y = KDTBasicUI.this.table.getViewManager().getVerticalMin(KDTBasicUI.this.vCurrentSplitBar);
                    rSplitBar.height = r.height;
                    rSplitBar.width = KDTBasicUI.this.table.getWidth() - r.width;
                    KDTBasicUI.this.table.repaint();
                    break;
                }
                case 3: {
                    this.setStatus(4);
                    Rectangle r1 = KDTBasicUI.this.table.getLayoutManager().getHSplitButtonRect();
                    KDTBasicUI.this.hCurrentSplitBar = KDTBasicUI.this.table.getHorizonCount() - 1;
                    rSplitBar.x = KDTBasicUI.this.table.getViewManager().getHorizonMax(KDTBasicUI.this.hCurrentSplitBar);
                    rSplitBar.y = 0;
                    rSplitBar.width = r1.width;
                    rSplitBar.height = KDTBasicUI.this.table.getHeight() - r1.height;
                    KDTBasicUI.this.table.repaint();
                    break;
                }
                case 5: {
                    this.setStatus(6);
                    Rectangle r2 = KDTBasicUI.this.table.getLayoutManager().getVSplitButtonRect();
                    rSplitBar.x = 0;
                    rSplitBar.y = p.y;
                    rSplitBar.height = r2.height;
                    rSplitBar.width = KDTBasicUI.this.table.getWidth() - r2.width;
                    KDTBasicUI.this.table.repaint();
                    break;
                }
                case 7: {
                    this.setStatus(8);
                    Rectangle r3 = KDTBasicUI.this.table.getLayoutManager().getHSplitButtonRect();
                    rSplitBar.x = p.x;
                    rSplitBar.y = 0;
                    rSplitBar.width = r3.width;
                    rSplitBar.height = KDTBasicUI.this.table.getHeight() - r3.height;
                    KDTBasicUI.this.table.repaint();
                    break;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getClickCount() == 2) {
                return;
            }
            Point p = e.getPoint();
            switch (this.status) {
                case 2: {
                    this.setMovingSplitBarRect(null);
                    this.setStatus(0);
                    int min = KDTBasicUI.this.table.getViewManager().getVerticalMin(KDTBasicUI.this.vCurrentSplitBar);
                    int max = KDTBasicUI.this.table.getViewManager().getVerticalMax(KDTBasicUI.this.vCurrentSplitBar);
                    if (p.y > min && p.y < max) {
                        KDTBasicUI.this.table.getViewManager().splitVertical(KDTBasicUI.this.vCurrentSplitBar, p.y - min);
                        break;
                    }
                    KDTBasicUI.this.table.repaint();
                    break;
                }
                case 4: {
                    this.setMovingSplitBarRect(null);
                    this.setStatus(0);
                    int min = KDTBasicUI.this.table.getViewManager().getHorizonMin(KDTBasicUI.this.hCurrentSplitBar);
                    int max = KDTBasicUI.this.table.getViewManager().getHorizonMax(KDTBasicUI.this.hCurrentSplitBar);
                    if (p.x > min && p.x < max) {
                        KDTBasicUI.this.table.getViewManager().splitHorizon(KDTBasicUI.this.hCurrentSplitBar, p.x - min);
                        break;
                    }
                    KDTBasicUI.this.table.repaint();
                    break;
                }
                case 6: {
                    this.setMovingSplitBarRect(null);
                    this.setStatus(0);
                    int min = KDTBasicUI.this.table.getViewManager().getVerticalMin(KDTBasicUI.this.vCurrentSplitBar);
                    int max = KDTBasicUI.this.table.getViewManager().getVerticalMax(KDTBasicUI.this.vCurrentSplitBar + 1);
                    if (p.y > min && p.y < max) {
                        KDTBasicUI.this.table.getViewManager().resizeVertical(KDTBasicUI.this.vCurrentSplitBar, p.y - min);
                        break;
                    }
                    KDTBasicUI.this.table.getViewManager().mergeVertical(KDTBasicUI.this.vCurrentSplitBar);
                    break;
                }
                case 8: {
                    this.setMovingSplitBarRect(null);
                    this.setStatus(0);
                    int min = KDTBasicUI.this.table.getViewManager().getHorizonMin(KDTBasicUI.this.hCurrentSplitBar);
                    int max = KDTBasicUI.this.table.getViewManager().getHorizonMax(KDTBasicUI.this.hCurrentSplitBar + 1);
                    if (p.x > min && p.x < max) {
                        KDTBasicUI.this.table.getViewManager().resizeHorizon(KDTBasicUI.this.hCurrentSplitBar, p.x - min);
                        break;
                    }
                    KDTBasicUI.this.table.getViewManager().mergeHorizon(KDTBasicUI.this.hCurrentSplitBar);
                    break;
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            switch (this.status) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    this.setStatus(0);
                    break;
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p = e.getPoint();
            Rectangle rSplitBar = this.getMovingSplitBarRect();
            switch (this.status) {
                case 2: {
                    if (rSplitBar == null) break;
                    int minPosition = KDTBasicUI.this.table.getViewManager().getVerticalMin(KDTBasicUI.this.vCurrentSplitBar);
                    int maxPosition = KDTBasicUI.this.table.getViewManager().getVerticalMax(KDTBasicUI.this.vCurrentSplitBar);
                    rSplitBar.y = p.y < minPosition ? minPosition : (p.y > maxPosition ? maxPosition : p.y);
                    KDTBasicUI.this.table.repaint();
                    break;
                }
                case 6: {
                    if (rSplitBar == null) break;
                    int minPosition = KDTBasicUI.this.table.getViewManager().getVerticalMin(KDTBasicUI.this.vCurrentSplitBar);
                    int maxPosition = KDTBasicUI.this.table.getViewManager().getVerticalMax(KDTBasicUI.this.vCurrentSplitBar + 1);
                    rSplitBar.y = p.y < minPosition ? minPosition : (p.y > maxPosition ? maxPosition : p.y);
                    KDTBasicUI.this.table.repaint();
                    break;
                }
                case 4: {
                    if (rSplitBar == null) break;
                    int minPosition = KDTBasicUI.this.table.getViewManager().getHorizonMin(KDTBasicUI.this.hCurrentSplitBar);
                    int maxPosition = KDTBasicUI.this.table.getViewManager().getHorizonMax(KDTBasicUI.this.hCurrentSplitBar);
                    rSplitBar.x = p.x < minPosition ? minPosition : (p.x > maxPosition ? maxPosition : p.x);
                    KDTBasicUI.this.table.repaint();
                    break;
                }
                case 8: {
                    if (rSplitBar == null) break;
                    int minPosition = KDTBasicUI.this.table.getViewManager().getHorizonMin(KDTBasicUI.this.hCurrentSplitBar);
                    int maxPosition = KDTBasicUI.this.table.getViewManager().getHorizonMax(KDTBasicUI.this.hCurrentSplitBar + 1);
                    rSplitBar.x = p.x < minPosition ? minPosition : (p.x > maxPosition ? maxPosition : p.x);
                    KDTBasicUI.this.table.repaint();
                    break;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point p = e.getPoint();
            switch (this.status) {
                case 0: {
                    if (this.isAboveVSplitButton(p)) {
                        this.setStatus(1);
                    } else if (this.isAboveHSplitButton(p)) {
                        this.setStatus(3);
                    }
                    int a = this.isAboveSplitBar(p);
                    if (a == 1) {
                        this.setStatus(5);
                        break;
                    }
                    if (a != 2) break;
                    this.setStatus(7);
                    break;
                }
                case 1: {
                    if (this.isAboveVSplitButton(p)) break;
                    this.setStatus(0);
                    break;
                }
                case 3: {
                    if (this.isAboveHSplitButton(p)) break;
                    this.setStatus(0);
                    break;
                }
                case 5: {
                    if (1 == this.isAboveSplitBar(p)) break;
                    this.setStatus(0);
                    break;
                }
                case 7: {
                    if (2 == this.isAboveSplitBar(p)) break;
                    this.setStatus(0);
                    break;
                }
            }
        }

        Rectangle getMovingSplitBarRect() {
            Rectangle rect = KDTBasicUI.this.table.getLayoutManager().getMovingSplitBarRect();
            if (rect == null) {
                rect = new Rectangle();
                this.setMovingSplitBarRect(rect);
            }
            return rect;
        }

        void setMovingSplitBarRect(Rectangle rect) {
            KDTBasicUI.this.table.getLayoutManager().setMovingSplitBarRect(rect);
        }

        boolean isAboveVSplitButton(Point p) {
            return KDTBasicUI.this.table.getLayoutManager().getVSplitButtonRect().contains(p);
        }

        boolean isAboveHSplitButton(Point p) {
            return KDTBasicUI.this.table.getLayoutManager().getHSplitButtonRect().contains(p);
        }

        boolean isAboveVSplitBar() {
            return KDTBasicUI.this.hCurrentSplitBar == -1 && KDTBasicUI.this.vCurrentSplitBar != -1;
        }

        boolean isAboveHSplitBar() {
            return KDTBasicUI.this.vCurrentSplitBar == -1 && KDTBasicUI.this.hCurrentSplitBar != -1;
        }

        int isAboveSplitBar(Point p) {
            KDTLayoutInfo info;
            int i;
            KDTBasicUI.this.vCurrentSplitBar = -1;
            KDTBasicUI.this.hCurrentSplitBar = -1;
            int vCount = KDTBasicUI.this.table.getVerticalCount();
            int hCount = KDTBasicUI.this.table.getHorizonCount();
            if (vCount <= 2 && hCount <= 3) {
                return 0;
            }
            int x = p.x;
            int y = p.y;
            KDTLayoutManager lm = KDTBasicUI.this.table.getLayoutManager();
            for (i = 0; i < vCount; ++i) {
                info = lm.getVertical(i);
                if (info.getSpan() <= 0) continue;
                if (y < info.getStart()) {
                    KDTBasicUI.this.vCurrentSplitBar = i - 1;
                    if (KDTBasicUI.this.vCurrentSplitBar <= 0 || KDTBasicUI.this.table.getLayoutManager().getVertical(KDTBasicUI.this.vCurrentSplitBar).getSplitType() == 1) break;
                    KDTBasicUI.this.vCurrentSplitBar = -1;
                    break;
                }
                if (y >= info.getStart() + info.getSpan()) continue;
                KDTBasicUI.this.vCurrentSplitBar = -1;
                break;
            }
            for (i = 0; i < hCount; ++i) {
                info = lm.getHorizon(i);
                if (info.getSpan() <= 0) continue;
                if (x < info.getStart()) {
                    KDTBasicUI.this.hCurrentSplitBar = i - 1;
                    if (KDTBasicUI.this.hCurrentSplitBar <= 0 || KDTBasicUI.this.table.getLayoutManager().getHorizon(KDTBasicUI.this.hCurrentSplitBar).getSplitType() == 1) break;
                    KDTBasicUI.this.hCurrentSplitBar = -1;
                    break;
                }
                if (x >= info.getStart() + info.getSpan()) continue;
                KDTBasicUI.this.hCurrentSplitBar = -1;
                break;
            }
            if (this.isAboveVSplitBar()) {
                return 1;
            }
            if (this.isAboveHSplitBar()) {
                return 2;
            }
            return 0;
        }
    }

    class FocusHandler
    implements FocusListener {
        FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            for (Component c = e.getOppositeComponent(); c != null; c = c.getParent()) {
                if (c == KDTBasicUI.this.table) {
                    return;
                }
                if (!(c instanceof Window) && (!(c instanceof Applet) || c.getParent() != null)) continue;
                if (c != SwingUtilities.getRoot(KDTBasicUI.this.table)) break;
                KDTBasicUI.this.table.getEditManager().closeEditor();
                break;
            }
        }
    }

    public class IMHandle
    implements InputMethodListener {
        @Override
        public void caretPositionChanged(InputMethodEvent event) {
        }

        @Override
        public void inputMethodTextChanged(InputMethodEvent event) {
            KDTEditManager em = KDTBasicUI.this.table.getEditManager();
            if (em.isEditing()) {
                return;
            }
            KDTSelectManager sm = KDTBasicUI.this.table.getSelectManager();
            em.editCellAt(sm.getActiveRowIndex(), sm.getActiveColumnIndex(), event);
        }
    }

    class KeyHandle
    implements KeyListener {
        KeyHandle() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

