/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table.print;

import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.print.FrugalPrintJob;
import com.kingdee.bos.ctrl.kdf.table.print.IRetrieveDataListener;
import com.kingdee.bos.ctrl.kdf.table.print.NewPrintManager;
import com.kingdee.bos.ctrl.print.IPrintActionListener;
import com.kingdee.bos.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.bos.ctrl.print.printjob.IPrintJob;
import com.kingdee.bos.ctrl.print.ui.component.HeaderFooter;
import com.kingdee.bos.ctrl.print.util.KDPrinterUtils;
import java.awt.Graphics;
import java.util.ArrayList;
import org.jdom2.Element;

public class FrugalPrintManager
extends NewPrintManager {
    IRetrieveDataListener listener;
    int frugalSpace = 0;
    int blockSpace = 20;
    int tableSpace = 70;
    boolean isFrugal = true;

    public FrugalPrintManager(IRetrieveDataListener listener) {
        super(null);
        this.listener = listener;
        this.listener.setManager(this);
    }

    public FrugalPrintManager(KDTable table, IRetrieveDataListener listener) {
        super(table);
        this.listener = listener;
        this.listener.setManager(this);
    }

    @Override
    protected void resetKDPrinter() {
        super.resetKDPrinter();
        this.printmodel.setUse(false);
        if (this.table != null) {
            // empty if block
        }
    }

    @Override
    protected void clear() {
    }

    @Override
    public void setTable(KDTable table2) {
        this.table = table2;
        if (table2 == null) {
            return;
        }
        HeadFootModel model = HeadFootParser.parseHeadFootPage2Model((Page)this.table.getPrintManager().getHeader());
        float height = HeaderFooter.getActiveHeight((Graphics)this.parent.getGraphics(), null, (HeadFootModel)model);
        this.setTableSpace((int)((double)height + 0.5));
    }

    public void setPreviewWindowType(short type) {
        this.getPrinter().getPrintPreview().setWindowType((int)type);
    }

    @Override
    public IPrintJob newPrintJob() {
        this.printjob = new FrugalPrintJob(this.listener, (PrintConfigModel)this.printmodel, this.pageSetupModeName, this.getPrinter());
        ((FrugalPrintJob)this.printjob).setFrugal(this.isFrugal);
        ((FrugalPrintJob)this.printjob).setBlockSpace(this.blockSpace);
        ((FrugalPrintJob)this.printjob).setTableSpace(this.tableSpace);
        this.printjob.setID(this.table.getID());
        return this.printjob;
    }

    public void setHeaderFooterToConfigUI() {
        ((FrugalPrintJob)this.printjob).setHeaderFooterToConfigUI();
    }

    public void clearHeader() {
    }

    public void addPreviewActionListener(IPrintActionListener l) {
        this.getPrinter().addPreviewActionListener(l);
    }

    public void setBodyTopMargin(float margin) {
        IPrintJob job = this.createPrintJobs();
        job.getConfig().setBodyTopMargin(margin, 100);
    }

    public void setFrugalPrint(boolean isFrugal) {
        this.isFrugal = isFrugal;
        if (this.printjob != null) {
            ((FrugalPrintJob)this.printjob).setFrugal(isFrugal);
        }
    }

    public void setBlockSpace(int space) {
        this.blockSpace = space;
    }

    public void setTableSpace(int space) {
        this.tableSpace = space < 20 ? 20 : space + 10;
        if (this.printjob != null) {
            ((FrugalPrintJob)this.printjob).setTableSpace(this.tableSpace);
        }
    }

    public HeadFootModel parseHeadFootPage2Model(Page page) {
        return HeadFootParser.parseHeadFootPage2Model((Page)page);
    }

    public Page parseModel2HeadFootPage(HeadFootModel model) {
        return HeadFootParser.parseModel2HeadFootPage((HeadFootModel)model);
    }

    public void removePreviewActionListener(IPrintActionListener l) {
        this.getPrinter().removePreviewActionListener((IPrintActionListener)this);
    }

    public ArrayList parseVariantText(String text) {
        return KDPrinterUtils.parseVariantText((String)text);
    }

    @Override
    public void fromXmlElement(Element e) {
        super.fromXmlElement(e);
        HeadFootModel header = HeadFootParser.parseHeadFootPage2Model((Page)this.listener.getTable().getPrintManager().getHeader());
        ((FrugalPrintJob)this.getPrintJob()).setHeader(header);
        HeadFootModel footer = HeadFootParser.parseHeadFootPage2Model((Page)this.listener.getTable().getPrintManager().getFooter());
        ((FrugalPrintJob)this.getPrintJob()).setFooter(footer);
    }
}

