/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.table.print;

import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.print.FrugalPrintManager;
import com.kingdee.bos.ctrl.kdf.table.print.IRequestTableData;
import com.kingdee.bos.ctrl.kdf.table.print.IRetrieveDataListener;
import com.kingdee.bos.ctrl.print.IConfigChangeListener;
import com.kingdee.bos.ctrl.print.ui.component.HeaderFooter;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class MultiPrintModel
implements IRetrieveDataListener,
IConfigChangeListener {
    private Component parentWindow;
    private List miList = new ArrayList();
    private KDTable tbl;
    private boolean firstUse = true;
    private IRequestTableData requestData;
    FrugalPrintManager manager = null;
    boolean isFrugal = false;

    @Override
    public KDTable getTable() {
        return this.tbl;
    }

    public void addVarParser(String name, Map headVarMap) {
        PrintModelItem pm = this.getPrintModelItem(name);
        pm.var = headVarMap;
    }

    @Override
    public void setManager(FrugalPrintManager manager) {
        this.manager = manager;
    }

    @Override
    public FrugalPrintManager getManager() {
        return this.manager;
    }

    public void setTable(KDTable tblMain) {
        this.tbl = tblMain;
        if (this.isFrugal) {
            tblMain.getPrintManager().setBodyTopMargin(100.0f);
        }
        this.manager.setTable(tblMain);
        if (this.firstUse) {
            Element jobE;
            Element e = this.tbl.getPrintManager().toXmlElement();
            if (e != null && (jobE = e.getChild("printjob")) != null) {
                jobE.removeChild("headerfooter");
            }
            this.manager.fromXmlElement(e);
            this.firstUse = false;
        }
        this.manager.setFrugalPrint(this.isFrugal);
    }

    public void addPrintJob(String name, Map headVarMap) {
        PrintModelItem pm = new PrintModelItem();
        pm.name = name;
        HashMap myVar = new HashMap();
        if (headVarMap != null) {
            myVar.putAll(headVarMap);
        }
        this.miList.add(pm);
    }

    public HeadFootModel getFooter(String jobname) {
        HeadFootModel footer = null;
        Page page = this.tbl.getPrintManager().getFooter();
        if (page != null) {
            page = this.parserHeader(jobname, page);
            footer = this.manager.parseHeadFootPage2Model(page);
        }
        return footer;
    }

    public HeadFootModel getHeader(String jobname) {
        HeadFootModel header = null;
        Page page = this.tbl.getPrintManager().getHeader();
        if (page != null) {
            page = this.parserHeader(jobname, page);
            header = this.manager.parseHeadFootPage2Model(page);
        }
        return header;
    }

    @Override
    public Page parserHeader(String jobname, Page page) {
        if (page == null) {
            return null;
        }
        HeadFootModel model = this.manager.parseHeadFootPage2Model(page);
        List rowList = model.getRowList();
        Map parser = this.getPrintModelItem((String)jobname).var;
        if (parser != null) {
            int size = rowList.size();
            for (int i = 0; i < size; ++i) {
                HeadFootRow row = (HeadFootRow)rowList.get(i);
                String text = row.getText();
                ArrayList strList = this.manager.parseVariantText(text);
                StringBuffer sb = new StringBuffer();
                int size2 = strList.size();
                for (int j = 0; j < size2; ++j) {
                    String str = (String)strList.get(j);
                    if (str == null) continue;
                    int len = str.length();
                    if (len > 2 && str.charAt(0) == '&' && str.charAt(1) == '[') {
                        String temp = (String)parser.get(str.substring(2));
                        if (temp != null) {
                            sb.append(temp);
                            continue;
                        }
                        sb.append(str);
                        continue;
                    }
                    sb.append(str);
                }
                row.setText(sb.toString());
            }
        }
        return this.manager.parseModel2HeadFootPage(model);
    }

    private PrintModelItem getPrintModelItem(String name) {
        int n = this.miList.size();
        for (int i = 0; i < n; ++i) {
            PrintModelItem pmi = (PrintModelItem)this.miList.get(i);
            if (!name.equals(pmi.name)) continue;
            return pmi;
        }
        return null;
    }

    public KDTable getTableByName(String name) {
        return this.tbl;
    }

    @Override
    public void fillTableData(String jobID) {
        if (this.requestData != null) {
            try {
                this.requestData.requestTableData(jobID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String[] getTableNames() {
        int size = this.miList.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            PrintModelItem pmi = (PrintModelItem)this.miList.get(i);
            names[i] = pmi.name;
        }
        return names;
    }

    @Override
    public int getTableCount() {
        return this.miList.size();
    }

    @Override
    public String getTableName(int i) {
        return ((PrintModelItem)this.miList.get((int)i)).name;
    }

    public void beginPrint() {
    }

    public void beginPreview() {
    }

    public void setRequestData(IRequestTableData requestData) {
        this.requestData = requestData;
    }

    public void setFrugal(boolean isFrugal) {
        this.isFrugal = isFrugal;
    }

    public Component getParentWindow() {
        return this.parentWindow;
    }

    public void setParentWindow(Component parentWindow) {
        this.parentWindow = parentWindow;
    }

    public void configChanged() {
        Element e = this.manager.toXmlElement();
        this.tbl.getPrintManager().fromXmlElement(e);
        HeadFootModel model = HeadFootParser.parseHeadFootPage2Model((Page)this.tbl.getPrintManager().getHeader());
        float height = HeaderFooter.getActiveHeight((Graphics)this.getParentWindow().getGraphics(), null, (HeadFootModel)model);
        this.manager.setTableSpace((int)((double)height + 0.5));
        this.configOver();
    }

    public void configWillChange() {
        this.manager.setHeaderFooterToConfigUI();
    }

    public void configOver() {
        this.manager.clearHeader();
    }

    class PrintModelItem {
        String name;
        Map var;
        Page header = null;
        Page footer = null;

        PrintModelItem() {
        }

        public String toString() {
            return this.name;
        }
    }
}

