/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class GroupBorder
extends TitledBorder {
    private static final long serialVersionUID = -5752095473774125854L;
    public static final int COMMON_STYLE = 0;
    public static final int SINGLE_LINE_STYLE = 1;
    protected static final int TEXT_INSET_H = 10;
    protected static final int TEXT_INSET_H2 = 0;
    protected static final int TEXT_GAP_H = 5;
    private int style = 0;
    private Color shadow;
    private Color highlight;
    private Color titleColor;
    private Point textLoc = new Point();

    public GroupBorder(String title) {
        super(title);
        this.init();
    }

    public GroupBorder(Border border) {
        super(border);
        this.init();
    }

    public GroupBorder(Border border, String title) {
        super(border, title);
        this.init();
    }

    public GroupBorder(Border border, String title, int titleJustification, int titlePosition) {
        super(border, title, titleJustification, titlePosition);
        this.init();
    }

    public GroupBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont) {
        super(border, title, titleJustification, titlePosition, titleFont);
        this.init();
    }

    public GroupBorder(Border border, String title, int titleJustification, int titlePosition, Font titleFont, Color titleColor) {
        super(border, title, titleJustification, titlePosition, titleFont, titleColor);
        this.init();
    }

    private void init() {
        this.titleColor = UIManager.getColor("GroupBorder.titleColor");
        this.highlight = UIManager.getColor("GroupBorder.highlight");
        this.shadow = UIManager.getColor("GroupBorder.shadow");
    }

    @Override
    public Border getBorder() {
        EtchedBorder b = new EtchedBorder(1, this.highlight, this.shadow);
        return b;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder();
        if (this.getTitle() == null || this.getTitle().equals("")) {
            if (border != null) {
                border.paintBorder(c, g, x, y, width, height);
            }
            return;
        }
        Rectangle grooveRect = new Rectangle(x + 2, y + 2, width - 4, height - 4);
        Font font = g.getFont();
        Color color = g.getColor();
        g.setFont(this.getFont(c));
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int descent = fm.getDescent();
        int ascent = fm.getAscent();
        int stringWidth = fm.stringWidth(this.getTitle());
        Insets insets = border != null ? border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
        int titlePos = this.getTitlePosition();
        switch (titlePos) {
            case 1: {
                int diff = ascent + descent + (Math.max(2, 4) - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - (descent + 2);
                break;
            }
            case 0: 
            case 2: {
                int diff = Math.max(0, ascent / 2 + 2 - 2);
                grooveRect.y += diff;
                grooveRect.height -= diff;
                this.textLoc.y = grooveRect.y - descent + (insets.top + ascent + descent) / 2;
                break;
            }
            case 3: {
                this.textLoc.y = grooveRect.y + insets.top + ascent + 2;
                break;
            }
            case 4: {
                this.textLoc.y = grooveRect.y + grooveRect.height - (insets.bottom + descent + 2);
                break;
            }
            case 5: {
                grooveRect.height -= fontHeight / 2;
                this.textLoc.y = grooveRect.y + grooveRect.height - descent + (ascent + descent - insets.bottom) / 2;
                break;
            }
            case 6: {
                grooveRect.height -= fontHeight;
                this.textLoc.y = grooveRect.y + grooveRect.height + ascent + 2;
            }
        }
        int justification = this.getTitleJustification();
        if (this.isLeftToRight2(c)) {
            if (justification == 4 || justification == 0) {
                justification = 1;
            } else if (justification == 5) {
                justification = 3;
            }
        } else if (justification == 4 || justification == 0) {
            justification = 3;
        } else if (justification == 5) {
            justification = 1;
        }
        switch (justification) {
            case 1: {
                if (this.getStyle() == 0) {
                    this.textLoc.x = grooveRect.x + 10 + insets.left;
                    break;
                }
                if (this.getStyle() != 1) break;
                this.textLoc.x = grooveRect.x + 0 + insets.left;
                break;
            }
            case 3: {
                if (this.getStyle() == 0) {
                    this.textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 10 + insets.right);
                    break;
                }
                if (this.getStyle() != 1) break;
                this.textLoc.x = grooveRect.x + grooveRect.width - (stringWidth + 0 + insets.right);
                break;
            }
            case 2: {
                this.textLoc.x = grooveRect.x + (grooveRect.width - stringWidth) / 2;
            }
        }
        if (border != null) {
            if ((titlePos == 2 || titlePos == 0) && grooveRect.y > this.textLoc.y - ascent || titlePos == 5 && grooveRect.y + grooveRect.height < this.textLoc.y + descent) {
                Rectangle clipRect = new Rectangle();
                Rectangle saveClip = g.getClipBounds();
                if (this.getStyle() == 0) {
                    clipRect.setBounds(saveClip);
                    if (GroupBorder.computeIntersection(clipRect, x, y, this.textLoc.x - 5 - x, height)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                    clipRect.setBounds(saveClip);
                    if (GroupBorder.computeIntersection(clipRect, this.textLoc.x + stringWidth + 5, y, x + width - (this.textLoc.x + stringWidth + 1), height)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                    }
                    if (titlePos == 2 || titlePos == 0) {
                        clipRect.setBounds(saveClip);
                        if (GroupBorder.computeIntersection(clipRect, this.textLoc.x - 5, this.textLoc.y + descent, stringWidth + 10, y + height - this.textLoc.y - descent)) {
                            g.setClip(clipRect);
                            border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                        }
                    } else {
                        clipRect.setBounds(saveClip);
                        if (GroupBorder.computeIntersection(clipRect, this.textLoc.x - 1, y, stringWidth + 2, this.textLoc.y - ascent - y)) {
                            g.setClip(clipRect);
                            border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
                        }
                    }
                } else if (this.getStyle() == 1) {
                    clipRect.setBounds(saveClip);
                    if (GroupBorder.computeIntersection(clipRect, x, y, this.textLoc.x - 5 - x, height)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, 2);
                    }
                    clipRect.setBounds(saveClip);
                    if (GroupBorder.computeIntersection(clipRect, this.textLoc.x + stringWidth + 5, y, x + width - (this.textLoc.x + stringWidth + 1), height)) {
                        g.setClip(clipRect);
                        border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, 2);
                    }
                }
                g.setClip(saveClip);
            } else {
                border.paintBorder(c, g, grooveRect.x, grooveRect.y, grooveRect.width, grooveRect.height);
            }
        }
        g.setColor(this.titleColor);
        g.drawString(this.getTitle(), this.textLoc.x, this.textLoc.y);
        g.setFont(font);
        g.setColor(color);
    }

    private boolean isLeftToRight2(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    private static boolean computeIntersection(Rectangle dest, int rx, int ry, int rw, int rh) {
        int x1 = Math.max(rx, dest.x);
        int x2 = Math.min(rx + rw, dest.x + dest.width);
        int y1 = Math.max(ry, dest.y);
        int y2 = Math.min(ry + rh, dest.y + dest.height);
        dest.x = x1;
        dest.y = y1;
        dest.width = x2 - x1;
        dest.height = y2 - y1;
        return dest.width > 0 && dest.height > 0;
    }
}

