/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.BasicValue;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.BindObjectDialog;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.DesignerSaveEvent;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.DesignerSaveListener;
import com.kingdee.bos.ctrl.report.forapp.bim.tabledesigner.KDTDesignerPanel;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlImageUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;

public class KDTDesignerFrame
extends KDFrame {
    private static final long serialVersionUID = -6891466854660016683L;
    public KDPanel mainPanel = new KDPanel();
    public KDToolBar toolBarFirst = new KDToolBar();
    public KDTDesignerPanel designers;
    public KDPanel rootPanel = new KDPanel();
    public KDPanel footPanel = new KDPanel();
    private KDWorkButton saveButton;
    private String kdtXml;
    private BindObjectDialog bod;
    private EventListenerList listenerList;

    public KDTDesignerFrame() {
        this.init();
    }

    public KDTDesignerFrame(GraphicsConfiguration gc) {
        super(gc);
        this.init();
    }

    public KDTDesignerFrame(String title) {
        super(title);
        this.init();
    }

    public KDTDesignerFrame(String title, GraphicsConfiguration gc) {
        super(title, gc);
        this.init();
    }

    public String getXML() {
        return this.designers.getXML();
    }

    public void setXML(String string) {
        this.designers.setXML(string);
    }

    public void setStream(InputStream input) {
        this.designers.setStream(input);
    }

    public void getStream(OutputStream out) {
        this.designers.getStream(out);
    }

    public void setSchemes(MetaClass[] bss) {
        this.bod.setSchemes(bss);
    }

    public EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    public void addDesignerSaveListener(DesignerSaveListener l) {
        this.getListenerList().add(DesignerSaveListener.class, l);
    }

    public void removeDesignerSaveListener(DesignerSaveListener l) {
        this.getListenerList().remove(DesignerSaveListener.class, l);
    }

    public void addColumns(MetaClass[] mcs) {
        if (mcs != null) {
            for (int i = 0; i < mcs.length; ++i) {
                List mfList = mcs[i].getFields();
                for (int j = 0; j < mfList.size(); ++j) {
                    MetaField column = (MetaField)mfList.get(j);
                    this.designers.addColumn(column.getName(), column.getAliasName(), new BasicValue(mcs[i].getExpr(), column.getName(), mcs[i].getAliasName(), mcs[i].getName()), column.getAliasName());
                }
            }
        }
    }

    public BindObjectDialog getBindObjectDialog() {
        if (this.bod == null) {
            this.bod = new BindObjectDialog((Frame)((Object)this));
        }
        return this.bod;
    }

    public KDToolBar getToolBar() {
        return this.toolBarFirst;
    }

    public KDWorkButton getSaveButton() {
        return this.saveButton;
    }

    public void init() {
        this.designers = new KDTDesignerPanel(this.getBindObjectDialog());
        this.saveButton = new KDWorkButton(LanguageManager.getLangMessage((String)"KDTDesignerFrame.button.save", KDTDesignerFrame.class, (String)""), (Icon)CtrlImageUtilities.getCurrentDirectoryImageIcon(((Object)((Object)this)).getClass(), (String)"../icons/tbtn_save.gif"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTDesignerFrame.this.fireSaveAction(null);
            }
        });
        KDWorkButton addcol = new KDWorkButton(LanguageManager.getLangMessage((String)"KDTDesignerFrame.button.addColumn", KDTDesignerFrame.class, (String)""), (Icon)CtrlImageUtilities.getCurrentDirectoryImageIcon(((Object)((Object)this)).getClass(), (String)"../icons/tbtn_inserttotier.gif"));
        KDWorkButton addcols = new KDWorkButton(LanguageManager.getLangMessage((String)"KDTDesignerFrame.button.addColumns", KDTDesignerFrame.class, (String)""), (Icon)CtrlImageUtilities.getCurrentDirectoryImageIcon(((Object)((Object)this)).getClass(), (String)"../icons/tbtn_inserttotiers.gif"));
        KDWorkButton delcols = new KDWorkButton(LanguageManager.getLangMessage((String)"KDTDesignerFrame.button.deleteColumn", KDTDesignerFrame.class, (String)""), (Icon)CtrlImageUtilities.getCurrentDirectoryImageIcon(((Object)((Object)this)).getClass(), (String)"../icons/tbtn_deletetotier.gif"));
        KDWorkButton moveColumn = new KDWorkButton(LanguageManager.getLangMessage((String)"KDTDesignerFrame.button.moveColum", KDTDesignerFrame.class, (String)""), (Icon)CtrlImageUtilities.getCurrentDirectoryImageIcon(((Object)((Object)this)).getClass(), (String)"../icons/tbtn_movecolumn.gif"));
        KDWorkButton exitButton = new KDWorkButton(LanguageManager.getLangMessage((String)"KDTDesignerFrame.button.exit", KDTDesignerFrame.class, (String)""), (Icon)CtrlImageUtilities.getCurrentDirectoryImageIcon(((Object)((Object)this)).getClass(), (String)"../icons/tbtn_quit.gif"));
        addcol.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                KDTDesignerFrame.this.designers.addColumn();
            }
        });
        addcols.addMouseListener((MouseListener)new MouseAdapter(){
            public KDSpinner spinner;

            @Override
            public void mouseClicked(MouseEvent me) {
                TypicalDialog dlg = new TypicalDialog(){
                    private static final long serialVersionUID = -4116007927616414089L;
                    private KDLabelContainer lbContainer;

                    protected void todoInit() {
                        spinner = new KDSpinner();
                        this.lbContainer = new KDLabelContainer();
                        this.lbContainer.setBoundEditor((JComponent)spinner);
                        this.lbContainer.setBoundLabelText(LanguageManager.getLangMessage((String)"KDTDesignerFrame.label.columnsToInsert", KDTDesignerFrame.class, (String)""));
                        this.lbContainer.setBoundLabelUnderline(true);
                        this.setSize(300, 110);
                    }

                    protected void todoAddControls(Container parent, Cell thisCell) {
                        parent.add((Component)this.lbContainer, thisCell);
                    }
                };
                if (dlg.showDialog()) {
                    int columnNum = (Integer)this.spinner.getValue();
                    KDTDesignerFrame.this.designers.addColumns(columnNum);
                }
            }
        });
        delcols.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                KDTDesignerFrame.this.designers.removeColumn();
            }
        });
        moveColumn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                KDTDesignerFrame.this.designers.moveColumn();
            }
        });
        exitButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                try {
                    KDTDesignerFrame.this.checkFocusAndCommit();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (!KDTDesignerFrame.this.isContentSaved() && WindowUtil.msgboxYesNo((Component)((Object)KDTDesignerFrame.this.designers), (Object)LanguageManager.getLangMessage((String)"KDTDesignerPanel.saveTips", KDTDesignerFrame.class, (String)""), (String)LanguageManager.getLangMessage((String)"KDTDesignerPanel.save", KDTDesignerFrame.class, (String)""))) {
                    KDTDesignerFrame.this.fireSaveAction(null);
                }
                KDTDesignerFrame.this.dispose();
            }
        });
        this.toolBarFirst.add((Component)this.saveButton);
        this.toolBarFirst.addSeparator();
        this.toolBarFirst.add((Component)addcol);
        this.toolBarFirst.add((Component)addcols);
        this.toolBarFirst.add((Component)delcols);
        this.toolBarFirst.add((Component)moveColumn);
        this.toolBarFirst.addSeparator();
        this.toolBarFirst.add((Component)exitButton);
        this.addToolBar((JToolBar)this.toolBarFirst);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)((Object)this.designers), "Center");
        this.footPanel.setLayout((LayoutManager)new FlowLayout(2, 10, 5));
        this.footPanel.setPreferredSize(new Dimension(500, 60));
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    KDTDesignerFrame.this.checkFocusAndCommit();
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
                if (!KDTDesignerFrame.this.isContentSaved() && WindowUtil.msgboxYesNo((Component)((Object)KDTDesignerFrame.this.designers), (Object)LanguageManager.getLangMessage((String)"KDTDesignerPanel.saveTips", KDTDesignerFrame.class, (String)""), (String)LanguageManager.getLangMessage((String)"KDTDesignerPanel.save", KDTDesignerFrame.class, (String)""))) {
                    KDTDesignerFrame.this.fireSaveAction(null);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
    }

    void uninit() {
        this.dispose();
    }

    public String getValue() {
        if (this.kdtXml != null) {
            return this.kdtXml;
        }
        return "";
    }

    public boolean isContentSaved() {
        return !this.designers.isContentChanged();
    }

    public void setContentSaved(boolean contentSaved) {
        this.designers.setContentChanged(!contentSaved);
    }

    protected void fireSaveAction(DesignerSaveEvent e) {
        Object[] listeners = this.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DesignerSaveListener.class) continue;
            try {
                this.checkFocusAndCommit();
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            ((DesignerSaveListener)listeners[i + 1]).savePerformed(e);
        }
        this.setContentSaved(true);
    }

    private void checkFocusAndCommit() throws ParseException {
        Component compCommit = null;
        for (Component comp = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof KDPromptBox) && !(comp instanceof JFormattedTextField) && !(comp instanceof KDDatePicker) && !(comp instanceof KDSpinner) && !(comp instanceof KDTable)) continue;
            compCommit = comp;
        }
        if (compCommit != null) {
            if (compCommit instanceof KDPromptBox) {
                ((KDPromptBox)compCommit).commitEdit();
            } else if (compCommit instanceof JFormattedTextField) {
                ((JFormattedTextField)compCommit).commitEdit();
            } else if (compCommit instanceof KDDatePicker) {
                ((KDDatePicker)compCommit).commitEdit();
            } else if (compCommit instanceof KDSpinner) {
                ((KDSpinner)compCommit).commitEdit();
            } else if (compCommit instanceof KDTable) {
                ((KDTable)compCommit).getEditManager().stopEditing();
            }
        }
    }
}

