/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.NotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;

class NotePrinterConfig {
    private static final Logger log = LogUtil.getLogger(NotePrinterConfig.class);
    private static final String FILENAME = "NotePrinterConfig.data";
    private Properties properties = new Properties();

    public float[] getPrinterOffset(String key) {
        float[] result = new float[2];
        Info info = this.getInfo(key);
        result[0] = info.offsetX;
        result[1] = info.offsetY;
        return result;
    }

    public void setPrinterOffset(String key, float x, float y) {
        Info info = this.getInfo(key);
        info.setOffset(x, y);
        this.setInfo(key, info);
    }

    public void updateDate(String key) {
        Info info = this.getInfo(key);
        info.updateDate();
        this.setInfo(key, info);
    }

    private void removeInfo(String key) {
        this.properties.remove(key);
    }

    public Iterator getIters() {
        Iterator<Object> iter = this.properties.keySet().iterator();
        return iter;
    }

    private void setInfo(String key, Info info) {
        this.properties.setProperty(key, info.toString());
    }

    private Info getInfo(String key) {
        String value = this.properties.getProperty(key);
        return new Info(value);
    }

    public static String createKey(String templatePath, String printer) {
        StringBuffer sb = new StringBuffer();
        sb.append(templatePath);
        sb.append("@");
        sb.append(printer);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotePrinterConfig load(IBizStorage sto) {
        NotePrinterConfig notePrinterConfig = new NotePrinterConfig();
        String configPathText = PathUtil.makeChildPath((String)FILENAME);
        ByteArrayInputStream inputStream = null;
        try {
            byte[] bs = BizStorageUtil.readFile((IBizStorage)sto, (String)configPathText);
            inputStream = new ByteArrayInputStream(bs);
            notePrinterConfig.properties.load(inputStream);
        }
        catch (NotFoundException ex1) {
            log.debug((Object)("\u5957\u6253\u6a21\u677f+\u6253\u5370\u673a\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8fd9\u662f\u9884\u671f\u7684\u5f02\u5e38\u3002" + configPathText));
        }
        catch (Exception ex) {
            log.error((Object)"\u8bfb\u53d6\u5957\u6253\u6a21\u677f+\u6253\u5370\u673a\u914d\u7f6e\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.debug((Object)"\u5173\u95ed\u8f93\u5165\u6d41\u5f02\u5e38\u3002", (Throwable)e);
                }
            }
        }
        return notePrinterConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IBizStorage sto) {
        this.check();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.properties.store(outputStream, null);
            String configPathText = PathUtil.makeChildPath((String)FILENAME);
            if (!sto.isExist(configPathText)) {
                BizStorageUtil.create((IBizStorage)sto, (String)configPathText, (HashMap)BizStorageUtil.SET_FILE_TYPE);
            }
            byte[] bs = outputStream.toByteArray();
            BizStorageUtil.writeFile((IBizStorage)sto, (String)configPathText, (byte[])bs);
            log.debug((Object)("\u4fdd\u5b58\u5957\u6253\u6a21\u677f+\u6253\u5370\u673a\u914d\u7f6e\u6587\u4ef6\u6210\u529f\uff1a\u7f13\u5b58\u8def\u5f84/" + configPathText));
        }
        catch (Exception ex) {
            log.error((Object)"\u4fdd\u5b58\u5957\u6253\u6a21\u677f+\u6253\u5370\u673a\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002", (Throwable)ex);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.debug((Object)"\u5173\u95ed\u8f93\u51fa\u6d41\u5f02\u5e38\u3002", (Throwable)e);
            }
        }
    }

    private void check() {
        Calendar now = Calendar.getInstance();
        String[] keys = this.properties.keySet().toArray(new String[0]);
        for (int i = keys.length - 1; i >= 0; --i) {
            String key = keys[i];
            Info info = this.getInfo(key);
            if (!info.isInvalidate() && !info.isTooOld(now)) continue;
            this.removeInfo(key);
        }
    }

    private static class Info {
        private Calendar calendar;
        private float offsetX;
        private float offsetY;

        public Info(String value) {
            String[] strValues;
            if (value != null && (strValues = value.split(",")).length == 3) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/M/d");
                Date date = null;
                try {
                    date = dateFormat.parse(strValues[0]);
                }
                catch (ParseException e) {
                    return;
                }
                this.calendar = Calendar.getInstance();
                this.calendar.setTime(date);
                this.offsetX = Float.parseFloat(strValues[1]);
                this.offsetY = Float.parseFloat(strValues[2]);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.calendar.get(1));
            sb.append("/");
            sb.append(this.calendar.get(2) + 1);
            sb.append("/");
            sb.append(this.calendar.get(5));
            sb.append(",");
            sb.append(this.offsetX);
            sb.append(",");
            sb.append(this.offsetY);
            return sb.toString();
        }

        public boolean isInvalidate() {
            return this.calendar == null || this.offsetX == 0.0f && this.offsetY == 0.0f;
        }

        public boolean isTooOld(Calendar now) {
            int year = this.calendar.get(1);
            int yearNow = now.get(1);
            int day = this.calendar.get(6);
            int dayNow = now.get(6);
            long days = (yearNow - year) * 365 + dayNow - day;
            return days > 400L;
        }

        public void setOffset(float x, float y) {
            this.offsetX = x;
            this.offsetY = y;
            this.updateDate();
        }

        public void updateDate() {
            this.calendar = Calendar.getInstance();
        }
    }
}

