/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.client.actions;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.AbstractResActionHandler;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.ui.OverwritePromptDialog;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.actions.AbstractStorageResActionHandler;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.ui.importexport.ProgressBar;
import com.kingdee.bos.ctrl.reportone.kdrs.Path;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorageUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.IStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FSStorage;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ActionExport
extends AbstractStorageResActionHandler {
    private boolean _overwriteYesAll = false;

    protected boolean onAction() throws Exception {
        KDFileChooser chooser = new KDFileChooser(System.getProperty("User.dir"));
        chooser.setDialogTitle(MultiLanguageUtil.getMLS("actions.ActionExport.exportTitle"));
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showOpenDialog((Component)this.getTreeUI());
        if (returnVal != 0) {
            return false;
        }
        System.setProperty("User.dir", chooser.getSelectedFile().toString());
        String toFilePath = chooser.getSelectedFile().getPath();
        if (!chooser.getSelectedFile().exists()) {
            WindowUtil.msgboxError((Object)(MultiLanguageUtil.getMLS("actions.ActionExport.exportPrompt") + toFilePath), (String)MultiLanguageUtil.getMLS("actions.ActionExport.exportObject"), (Component)this.getTreeUI());
            return false;
        }
        FSStorage fss = new FSStorage(toFilePath, true);
        fss.refresh(Path.ROOT, false);
        BizStorage toSto = new BizStorage((IStorage)fss);
        this.copyWithUI(this.getBizContent(), (IBizStorage)toSto, super.getTree().getSelectionPaths());
        return false;
    }

    public IBizContent getBizContent() {
        return (IBizContent)this.getBizStorage();
    }

    void copyWithUI(final IBizContent fromSto, final IBizStorage toSto, final TreePath[] fromPaths) {
        final ProgressBar bar = (ProgressBar)WindowUtil.createWindow(ProgressBar.class, (Component)this.getTreeUI());
        bar.setTitle(MultiLanguageUtil.getMLS("actions.ActionExport.exportObject"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                Creater creater = new Creater();
                ActionExport.this._overwriteYesAll = false;
                try {
                    for (int ps = 0; ps < fromPaths.length; ++ps) {
                        Object[] nodes = fromPaths[ps].getPath();
                        for (int ns = 1; ns < nodes.length; ++ns) {
                            TreeUINode node = (TreeUINode)nodes[ns];
                            String fromPathText = ActionExport.this.getBizStorageTreeCtrl().makePathText(new TreePath(node.getPath()));
                            String toPathText = TreeUtil.makePathText((TreeNode[])node.getPath());
                            bar.addLine(toPathText);
                            if (ns == nodes.length - 1 && node.getAllowsChildren()) {
                                try {
                                    BizStorageUtil.create((IBizStorage)fromSto, (String)fromPathText, (IBizStorage)toSto, (String)toPathText, (int)16);
                                }
                                catch (AlreadyExistsException alreadyExistsException) {
                                    // empty catch block
                                }
                                ActionExport.copyFolder((IBizStorage)fromSto, fromPathText, toSto, toPathText, creater, bar);
                                continue;
                            }
                            creater.create((IBizStorage)fromSto, fromPathText, toSto, toPathText);
                        }
                    }
                }
                catch (KDRSException ex) {
                    AbstractResActionHandler.log.error((Object)MultiLanguageUtil.getMLS("actions.ActionExport.exportFailed"), (Throwable)ex);
                    WindowUtil.showException((String)MultiLanguageUtil.getMLS("actions.ActionExport.exportFailed"), (Throwable)ex, (String)MultiLanguageUtil.getMLS("actions.ActionExport.exportObject"), (Component)ActionExport.this.getTreeUI());
                }
                catch (UserCancelException userCancelException) {
                    // empty catch block
                }
                bar.finished();
            }
        }).start();
        bar.show();
    }

    static void copyFolder(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath, BizStorageUtil.IResourceCreator creator, ProgressBar bar) throws KDRSException {
        HashMap rv = fromSto.list(fromPath, BizStorageUtil.LIST_NAME);
        String[] names = (String[])rv.get("name");
        for (int i = 0; i < names.length; ++i) {
            String childName = names[i];
            String fromChild = PathUtil.makeChildPath((String)fromPath, (String)childName);
            String toChild = PathUtil.makeChildPath((String)toPath, (String)childName);
            bar.addLine(toChild);
            HashMap atts = creator.create(fromSto, fromChild, toSto, toChild);
            if (atts == null) continue;
            ActionExport.copyFolder(fromSto, fromChild, toSto, toChild, creator, bar);
        }
    }

    static HashMap createTemplate(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath, int createPolicy) throws KDRSException {
        HashMap atts = fromSto.getAttributes(fromPath, null);
        atts.put("type", StorageCategory.FILE.getName());
        atts.remove("name");
        atts.remove("size");
        atts.remove("time");
        atts.remove("creator");
        atts.remove("last-access");
        atts.remove("last-modified");
        atts.remove("eas-report-id");
        atts.remove("eas-menu-pk");
        atts.remove("user_enabled_users");
        atts.remove("write_enabled_users");
        if (1 != createPolicy) {
            atts.put("create_policy", new Integer(createPolicy));
        }
        toSto.create(toPath, atts);
        return atts;
    }

    private class Creater
    implements BizStorageUtil.IResourceCreator {
        private Creater() {
        }

        public HashMap create(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath) throws KDRSException {
            IBizContent fromCnt = (IBizContent)fromSto;
            HashMap attrs = fromCnt.getAttributes(fromPath, new String[]{"category"});
            String catogory = (String)attrs.get("category");
            if (StringUtil.equals((String)"kdrs-form", (String)catogory) || StringUtil.equals((String)"r1-print", (String)catogory)) {
                attrs = null;
                try {
                    ActionExport.createTemplate((IBizStorage)fromCnt, fromPath, toSto, toPath, ActionExport.this._overwriteYesAll ? 16 : 1);
                }
                catch (AlreadyExistsException ex) {
                    switch (this.isOverwrite(toPath)) {
                        case 2: {
                            ActionExport.this._overwriteYesAll = true;
                        }
                        case 1: {
                            break;
                        }
                        case 3: {
                            return null;
                        }
                        case 0: {
                            throw new UserCancelException();
                        }
                    }
                    ActionExport.createTemplate((IBizStorage)fromCnt, fromPath, toSto, toPath, 16);
                }
                toSto.writeFile(toPath, -1, fromCnt.readTemplate(fromPath));
            } else if ("bos-query".equals(catogory) || "note-dynquery".equals(catogory)) {
                attrs = null;
                try {
                    BizStorageUtil.create((IBizStorage)fromCnt, (String)fromPath, (IBizStorage)toSto, (String)toPath, (int)(ActionExport.this._overwriteYesAll ? 16 : 1));
                }
                catch (AlreadyExistsException ex) {
                    switch (this.isOverwrite(toPath)) {
                        case 2: {
                            ActionExport.this._overwriteYesAll = true;
                        }
                        case 1: {
                            break;
                        }
                        case 3: {
                            return null;
                        }
                        case 0: {
                            throw new UserCancelException();
                        }
                    }
                    BizStorageUtil.create((IBizStorage)fromCnt, (String)fromPath, (IBizStorage)toSto, (String)toPath, (int)16);
                }
                toSto.writeFile(toPath, -1, fromCnt.readTemplate(fromPath));
            } else if (StringUtil.equals((String)"folder", (String)catogory)) {
                try {
                    attrs = BizStorageUtil.create((IBizStorage)fromCnt, (String)fromPath, (IBizStorage)toSto, (String)toPath, (int)(ActionExport.this._overwriteYesAll ? 16 : 1));
                }
                catch (AlreadyExistsException ex) {
                    attrs = BizStorageUtil.create((IBizStorage)fromCnt, (String)fromPath, (IBizStorage)toSto, (String)toPath, (int)16);
                }
            } else {
                attrs = null;
            }
            return attrs;
        }

        private int isOverwrite(String pathText) {
            return OverwritePromptDialog.show((Component)ActionExport.this.getTreeUI(), pathText + "  " + MultiLanguageUtil.getMLS("actions.ActionExport.overWritePrompt"), MultiLanguageUtil.getMLS("actions.ActionExport.overWriteTitle"));
        }
    }
}

