/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.forapp.kdnote.webserver;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.IContextProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.webserver.KDNoteWebServerHelper;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.IBizContext;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class KDNoteServerHelperUtils {
    private static final Logger logger = LogUtil.getLogger(KDNoteServerHelperUtils.class);

    public static IBizContext getBizContext() {
        IBizContext bizCtx = null;
        try {
            KDNoteWebServerHelper nodeWeb = new KDNoteWebServerHelper();
            final Context context = ConfigMDUtil.getContext();
            nodeWeb.setContextProvider(new IContextProvider(){

                @Override
                public IBizContext getBizContext(Context bosCtx) {
                    IBizContext ctx = null;
                    try {
                        ctx = KDNoteHelper.makeContext(context);
                    }
                    catch (ConnectException e) {
                        logger.error((Object)"get page data error!", (Throwable)e);
                        return null;
                    }
                    return ctx;
                }
            });
            nodeWeb.setBosContext(context);
            bizCtx = nodeWeb.getThisBizContext();
            return bizCtx;
        }
        catch (Exception e) {
            logger.error((Object)"get bizCtx error!", (Throwable)e);
            return null;
        }
    }

    public static Map getAttributes(String templatePath) throws KDRSException {
        HashMap attributes = KDNoteServerHelperUtils.getBizContext().getBizContent().getAttributes(PathUtil.makeChildPath((String)"/EAS_Note.kdrs", (String)templatePath), new String[]{"isselected", "prttimes"});
        return attributes;
    }
}

