/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryCondition;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryEntityNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryFieldNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryLinkType;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.query.JoinCollection;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinItemCollection;
import com.kingdee.bos.metadata.query.JoinItemInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.util.BOSObjectType;

public class NoteDynQueryUtil {
    public static EntityObjectInfo getEntity(String bosObjectId) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BOSObjectType objectType = BOSObjectType.create((String)bosObjectId);
        return loader.getEntity(objectType);
    }

    static QueryInfo getQueryInfo(String queryName) {
        return NoteDynQueryUtil.getQueryInfo(null, queryName);
    }

    private static QueryInfo getQueryInfo(Context ctx, String queryName) {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        return loader.getQuery((IMetaDataPK)queryPK);
    }

    static NoteDynQueryEntityNode convertRootEntityNode(QueryInfo queryInfo) throws BOSException {
        SubObjectInfo mainInfo = queryInfo.getMainObject();
        NoteDynQueryEntityNode rootEntityNode = NoteDynQueryUtil.convertMetaNode(mainInfo);
        NoteDynQueryUtil.convertChildrenNodes(rootEntityNode, mainInfo);
        return rootEntityNode;
    }

    private static NoteDynQueryEntityNode convertMetaNode(SubObjectInfo subObjectInfo) {
        if (subObjectInfo instanceof SubEntityInfo) {
            return NoteDynQueryUtil.convertEntityNode((SubEntityInfo)subObjectInfo);
        }
        if (subObjectInfo instanceof SubQueryInfo) {
            return NoteDynQueryUtil.convertSubQueryNode((SubQueryInfo)subObjectInfo);
        }
        throw new RuntimeException("Unpredictable type.");
    }

    private static NoteDynQueryEntityNode convertEntityNode(SubEntityInfo subEntityInfo) {
        NoteDynQueryEntityNode entityNode = new NoteDynQueryEntityNode();
        EntityObjectInfo entityObjectInfo = subEntityInfo.getEntityRef();
        entityNode.setBosObjectId(entityObjectInfo.getType().toString());
        entityNode.setEntityName(subEntityInfo.getName());
        entityNode.setEntityAlias(entityObjectInfo.getAlias());
        return entityNode;
    }

    private static NoteDynQueryEntityNode convertSubQueryNode(SubQueryInfo subQueryInfo) {
        NoteDynQueryEntityNode entityNode = new NoteDynQueryEntityNode();
        entityNode.setSubQuery(true);
        entityNode.setBosObjectId(subQueryInfo.getQueryRef().getFullName());
        entityNode.setEntityName(subQueryInfo.getName());
        entityNode.setEntityAlias(subQueryInfo.getAlias());
        return entityNode;
    }

    private static void convertChildrenNodes(NoteDynQueryEntityNode parentEntityNode, SubObjectInfo subObjectInfo) {
        JoinCollection joinCollection = subObjectInfo.getJoinsFromClient();
        int size = joinCollection.size();
        for (int i = 0; i < size; ++i) {
            JoinInfo joinInfo = joinCollection.get(i);
            NoteDynQueryEntityNode entityNode = NoteDynQueryUtil.convertEntityNodeWithJoin(joinInfo);
            parentEntityNode.addChild(entityNode);
            SubObjectInfo rightInfo = joinInfo.getRightObject();
            NoteDynQueryUtil.convertChildrenNodes(entityNode, rightInfo);
        }
    }

    private static NoteDynQueryEntityNode convertEntityNodeWithJoin(JoinInfo joinInfo) {
        SubObjectInfo subObjectInfo = joinInfo.getRightObject();
        NoteDynQueryEntityNode entityNode = NoteDynQueryUtil.convertMetaNode(subObjectInfo);
        JoinType joinType = joinInfo.getJoinType();
        NoteDynQueryLinkType linkType = NoteDynQueryUtil.convertLinkType(joinType);
        entityNode.setLinkType(linkType);
        JoinItemCollection jiColl = joinInfo.getJoinItems();
        for (int i = 0; i < jiColl.size(); ++i) {
            entityNode.addCondition(NoteDynQueryUtil.convertCondition(jiColl.get(i)));
        }
        return entityNode;
    }

    private static NoteDynQueryLinkType convertLinkType(JoinType joinType) {
        if (JoinType.INNERJOIN.getName().equals(joinType.getName())) {
            return NoteDynQueryLinkType.InnerJoin;
        }
        if (JoinType.LEFTJOIN.getName().equals(joinType.getName())) {
            return NoteDynQueryLinkType.LeftJoin;
        }
        if (JoinType.RIGHTJOIN.getName().equals(joinType.getName())) {
            return NoteDynQueryLinkType.RightJoin;
        }
        return NoteDynQueryLinkType.LeftJoin;
    }

    private static NoteDynQueryCondition convertCondition(JoinItemInfo joinItemInfo) {
        PropertyRefInfo info;
        PropertyUnitInfo leftPro = joinItemInfo.getLeftField();
        PropertyUnitInfo rightPro = joinItemInfo.getRightField();
        String leftProName = null;
        String leftProAlias = null;
        String rightProName = null;
        String rightProAlias = null;
        if (leftPro.getPropertyRefs().size() == 1) {
            info = leftPro.getPropertyRefs().get(0);
            if (info.getRefProperty() != null) {
                leftProName = leftPro.getRefPropertyName();
                leftProAlias = info.getRefProperty().getAlias();
            } else if (info.getRefUnit() != null) {
                leftProName = info.getRefUnit().getName();
            }
        }
        if (rightPro.getPropertyRefs().size() == 1) {
            info = rightPro.getPropertyRefs().get(0);
            if (info.getRefProperty() != null) {
                rightProName = rightPro.getRefPropertyName();
                rightProAlias = info.getRefProperty().getAlias();
            } else if (info.getRefUnit() != null) {
                rightProName = info.getRefUnit().getName();
            }
        }
        NoteDynQueryFieldNode left = new NoteDynQueryFieldNode(leftProName, leftProAlias);
        NoteDynQueryFieldNode right = new NoteDynQueryFieldNode(rightProName, rightProAlias);
        CompareType cType = joinItemInfo.getCompareType();
        NoteDynQueryCondition condition = new NoteDynQueryCondition(left, cType, right);
        return condition;
    }
}

