/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.bosmetaselector.BosEntitySelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryCondition;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryEntityNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryFieldNode;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryLinkType;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryModel;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.model.NoteDynQueryUtil;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui.Icons;
import com.kingdee.bos.ctrl.report.impl.r1note.dynquery.ui.NoteDynQueryEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class EntityTabbedUI {
    private static final int COL_LEFT = 0;
    private static final int COL_COMPARE = 1;
    private static final int COL_RIGHT = 2;
    private KDPanel _panAll;
    private KDTree _treEntities;
    private KDTextField _txtParentObject;
    private KDComboBox _cmbLinkType;
    private KDTextField _txtSubObjectName;
    private KDTextField _txtSubObjectNumber;
    private KDTable _kdtJoinConditions;
    private KDComboBox _cmbParentFields;
    private KDComboBox _cmbChildFields;
    private NoteDynQueryEditor.ITabbedSynchronizer _synchronizer;

    public EntityTabbedUI() {
        this.init();
    }

    private void init() {
        this._panAll = new KDPanel();
        this._treEntities = new KDTree();
        this._txtParentObject = new KDTextField();
        this._cmbLinkType = new KDComboBox((Object[])NoteDynQueryLinkType.AllTypes);
        this._txtSubObjectName = new KDTextField();
        this._txtSubObjectNumber = new KDTextField();
        this._kdtJoinConditions = new KDTable();
        this._cmbParentFields = new KDComboBox();
        this._cmbChildFields = new KDComboBox();
        this._txtParentObject.setEnabled(false);
        this._txtSubObjectName.setEnabled(false);
        this._txtSubObjectNumber.setEnabled(false);
        this._treEntities.setShowsRootHandles(true);
        KDTreeView treeView = new KDTreeView(this._treEntities);
        treeView.setMinimumSize(new Dimension(100, 50));
        treeView.setShowButton(false);
        KDWorkButton btnNew = new KDWorkButton((Action)new BtnNewActionHandler());
        KDWorkButton btnDel = new KDWorkButton((Action)new BtnDelActionHandler());
        treeView.getControlPane().add((Component)btnNew);
        treeView.getControlPane().add((Component)btnDel);
        KDLabelContainer lbcParentObject = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtParentObject, (String)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.parentObj"), (int)80);
        KDLabelContainer lbcLinkType = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbLinkType, (String)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.joinType"), (int)80);
        KDLabelContainer lbcSubObjectName = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtSubObjectName, (String)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.childObj"), (int)80);
        KDLabelContainer lbcSubObjectNumber = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtSubObjectNumber, (String)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.childObjNumber"), (int)80);
        TableLayout tl = TableLayout.splitCol((int)2);
        tl.getStyle().setMargin(8);
        tl.colStyle(0).setWidth(-40);
        tl.colStyle(0).setMarginRight(20);
        tl.colStyle(1).setWidth(-60);
        Table col2 = tl.cell(1).splitRow(5);
        col2.rowStyle(0).setHeight(20);
        col2.rowStyle(0).setMarginBottom(3);
        col2.rowStyle(1).setHeight(20);
        col2.rowStyle(1).setMarginBottom(3);
        col2.rowStyle(2).setHeight(20);
        col2.rowStyle(2).setMarginBottom(3);
        col2.rowStyle(3).setHeight(20);
        col2.rowStyle(3).setMarginBottom(10);
        col2.rowStyle(4).setPriY(1);
        this._panAll.setLayout((LayoutManager)tl);
        this._panAll.add((Component)treeView, (Object)tl.cell(0));
        this._panAll.add((Component)lbcParentObject, (Object)col2.cell(0));
        this._panAll.add((Component)lbcLinkType, (Object)col2.cell(1));
        this._panAll.add((Component)lbcSubObjectName, (Object)col2.cell(2));
        this._panAll.add((Component)lbcSubObjectNumber, (Object)col2.cell(3));
        this._panAll.add((Component)this._kdtJoinConditions, (Object)col2.cell(4));
        this.updateCtrl(null);
        this.initTable();
        this.addListener();
    }

    private void initTable() {
        this._kdtJoinConditions.addHeadRow();
        this._kdtJoinConditions.addColumns(3);
        this._kdtJoinConditions.getColumn(0).setWidth(140);
        this._kdtJoinConditions.getColumn(1).setWidth(45);
        this._kdtJoinConditions.getColumn(2).setWidth(140);
        IRow row = this._kdtJoinConditions.getHeadRow(0);
        row.getCell(0).setValue((Object)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.parentsProperties"));
        row.getCell(1).setValue((Object)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.compareOperater"));
        row.getCell(2).setValue((Object)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.childsProperties"));
        KDComboBox cmbCompareType = new KDComboBox(new Object[]{null, CompareType.EQUALS, CompareType.NOTEQUALS, CompareType.GREATER, CompareType.GREATER_EQUALS, CompareType.LESS, CompareType.LESS_EQUALS});
        KDTDefaultCellEditor ceCompare = new KDTDefaultCellEditor((JComboBox)cmbCompareType);
        this._kdtJoinConditions.getColumn(1).setEditor((ICellEditor)ceCompare);
        KDTDefaultCellEditor ceParentFields = new KDTDefaultCellEditor((JComboBox)this._cmbParentFields);
        this._kdtJoinConditions.getColumn(0).setEditor((ICellEditor)ceParentFields);
        KDTDefaultCellEditor ceChildFields = new KDTDefaultCellEditor((JComboBox)this._cmbChildFields);
        this._kdtJoinConditions.getColumn(2).setEditor((ICellEditor)ceChildFields);
        this.clearTableContent();
    }

    private void addListener() {
        this._treEntities.addTreeSelectionListener((TreeSelectionListener)new TreeHandler());
        this._cmbLinkType.addActionListener((ActionListener)new LinkTypeChangeHandler());
        this._kdtJoinConditions.addKDTEditListener((KDTEditListener)new TableEditHandler());
    }

    private void clearTableContent() {
        this._kdtJoinConditions.removeRows();
        this._kdtJoinConditions.addRows(5);
    }

    public JComponent getUI() {
        return this._panAll;
    }

    public void setTabbedSynchronizer(NoteDynQueryEditor.ITabbedSynchronizer synchronizer) {
        this._synchronizer = synchronizer;
    }

    public void updateCtrl(NoteDynQueryModel model) {
        if (model == null) {
            this._treEntities.setModel((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"Error")));
            this._treEntities.setRootVisible(false);
            this._cmbLinkType.setEnabled(false);
            this._kdtJoinConditions.setEnabled(false);
            return;
        }
        NoteDynQueryEntityNode rootEntityNode = model.getRootEntityNode();
        DefaultKingdeeTreeNode rootTreeNode = EntityTabbedUI.buildTree(rootEntityNode);
        this._treEntities.setModel((TreeModel)new KingdeeTreeModel((TreeNode)rootTreeNode));
        this._treEntities.setRootVisible(true);
        this._treEntities.setSelectionNode(rootTreeNode);
    }

    private static DefaultKingdeeTreeNode buildTree(NoteDynQueryEntityNode entityNode) {
        DefaultKingdeeTreeNode treeNode = EntityTabbedUI.createTreeNode(entityNode);
        int c = entityNode.getChildrenCount();
        for (int i = 0; i < c; ++i) {
            NoteDynQueryEntityNode childEntityNode = entityNode.getChild(i);
            DefaultKingdeeTreeNode childTreeNode = EntityTabbedUI.buildTree(childEntityNode);
            treeNode.add((MutableTreeNode)childTreeNode);
        }
        return treeNode;
    }

    static DefaultKingdeeTreeNode createTreeNode(NoteDynQueryEntityNode entityNode) {
        DefaultKingdeeTreeNode treeNode = new DefaultKingdeeTreeNode((Object)entityNode);
        if (entityNode.isSubQuery()) {
            treeNode.setCustomIcon((Icon)Icons.TreeIcon_QUERY);
        } else {
            treeNode.setCustomIcon((Icon)Icons.TreeIcon_ENTITY);
        }
        if (!entityNode.isSystem()) {
            treeNode.setTextColor(Color.BLUE);
        }
        return treeNode;
    }

    private NoteDynQueryEntityNode getCurrentEntityNode() {
        TreePath path = this._treEntities.getSelectionPath();
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        NoteDynQueryEntityNode entityNode = (NoteDynQueryEntityNode)treeNode.getUserObject();
        return entityNode;
    }

    private class TableEditHandler
    extends KDTEditAdapter {
        private TableEditHandler() {
        }

        public void editStopped(KDTEditEvent e) {
            this.acceptConditions();
        }

        private void acceptConditions() {
            NoteDynQueryEntityNode entityNode = EntityTabbedUI.this.getCurrentEntityNode();
            entityNode.removeAllConditions();
            int c = EntityTabbedUI.this._kdtJoinConditions.getRowCount();
            for (int i = 0; i < c; ++i) {
                IRow row = EntityTabbedUI.this._kdtJoinConditions.getRow(i);
                Object left = row.getCell(0).getValue();
                CompareType compare = (CompareType)row.getCell(1).getValue();
                Object right = row.getCell(2).getValue();
                if (compare == null || !(left instanceof NoteDynQueryFieldNode) || !(right instanceof NoteDynQueryFieldNode)) continue;
                NoteDynQueryCondition condition = new NoteDynQueryCondition((NoteDynQueryFieldNode)left, compare, (NoteDynQueryFieldNode)right);
                entityNode.addCondition(condition);
            }
        }
    }

    private class LinkTypeChangeHandler
    implements ActionListener {
        private LinkTypeChangeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NoteDynQueryEntityNode entityNode = EntityTabbedUI.this.getCurrentEntityNode();
            entityNode.setLinkType((NoteDynQueryLinkType)EntityTabbedUI.this._cmbLinkType.getSelectedItem());
        }
    }

    private class BtnDelActionHandler
    extends AbstractAction {
        public BtnDelActionHandler() {
            this.putValue("SmallIcon", Icons.BtnIcon_DEL);
            this.putValue("ShortDescription", MultiLanguageUtil.getMLS("ui.EntityTabbedUI.deleteEntity"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean sure;
            int selectionCount = EntityTabbedUI.this._treEntities.getSelectionCount();
            if (selectionCount != 1) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.del_NonSelectEntityPrompt"), (String)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.deleteEntity"), (Component)EntityTabbedUI.this._panAll);
                return;
            }
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)EntityTabbedUI.this._treEntities.getSelectionPath().getLastPathComponent();
            NoteDynQueryEntityNode entityNode = (NoteDynQueryEntityNode)treeNode.getUserObject();
            if (entityNode.isSystem()) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.del_CannotDeleteSystemPrompt"), (String)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.deleteEntity"), (Component)EntityTabbedUI.this._panAll);
                return;
            }
            StringBuffer prompt = new StringBuffer();
            prompt.append(MultiLanguageUtil.getMLS("ui.EntityTabbedUI.del_AreYouSurePrompt"));
            if (entityNode.getSelectedFieldsCount() > 0) {
                prompt.append(MultiLanguageUtil.getMLS("ui.EntityTabbedUI.del_WithFieldPrompt"));
            }
            if (!(sure = WindowUtil.msgboxYesNo((Component)EntityTabbedUI.this._panAll, (Object)prompt.toString(), (String)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.deleteEntity")))) {
                return;
            }
            DefaultKingdeeTreeNode parentTreeNode = (DefaultKingdeeTreeNode)treeNode.getParent();
            entityNode.getParent().removeChild(entityNode);
            EntityTabbedUI.this._treEntities.removeNodeFromParent((MutableTreeNode)treeNode);
            EntityTabbedUI.this._treEntities.setSelectionNode(parentTreeNode);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("type", "entityChanged");
            EntityTabbedUI.this._synchronizer.announce(params);
        }
    }

    private class BtnNewActionHandler
    extends AbstractAction {
        private BosEntitySelector selector;

        public BtnNewActionHandler() {
            this.putValue("SmallIcon", Icons.BtnIcon_ADD);
            this.putValue("ShortDescription", MultiLanguageUtil.getMLS("ui.EntityTabbedUI.addEntity"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MetaDataBriefInfo mdbf;
            int selectionCount = EntityTabbedUI.this._treEntities.getSelectionCount();
            if (selectionCount == 0) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.nonSelectEntityPrompt"), (String)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.addEntity"), (Component)EntityTabbedUI.this._panAll);
                return;
            }
            if (selectionCount > 1) {
                WindowUtil.msgboxWarning((Object)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.singleSelectEntityPrompt"), (String)MultiLanguageUtil.getMLS("ui.EntityTabbedUI.addEntity"), (Component)EntityTabbedUI.this._panAll);
                return;
            }
            DefaultKingdeeTreeNode parentTreeNode = (DefaultKingdeeTreeNode)EntityTabbedUI.this._treEntities.getSelectionPath().getLastPathComponent();
            NoteDynQueryEntityNode parentEntityNode = (NoteDynQueryEntityNode)parentTreeNode.getUserObject();
            if (this.selector == null) {
                this.selector = new BosEntitySelector();
            }
            if ((mdbf = this.selector.show((JComponent)EntityTabbedUI.this._panAll)) == null) {
                return;
            }
            String bosObjectId = mdbf.getBOType().toString();
            String entityName = NoteDynQueryUtil.getEntity(bosObjectId).getName();
            String uniqueName = this.getUniqueName(entityName);
            NoteDynQueryEntityNode entityNode = new NoteDynQueryEntityNode();
            entityNode.setSystem(false);
            entityNode.setBosObjectId(bosObjectId);
            entityNode.setEntityAlias(mdbf.getAlias());
            entityNode.setEntityName(uniqueName);
            entityNode.setLinkType(NoteDynQueryLinkType.LeftJoin);
            DefaultKingdeeTreeNode treeNode = EntityTabbedUI.createTreeNode(entityNode);
            parentEntityNode.addChild(entityNode);
            EntityTabbedUI.this._treEntities.addNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)parentTreeNode);
            EntityTabbedUI.this._treEntities.setSelectionNode(treeNode);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("type", "entityChanged");
            EntityTabbedUI.this._synchronizer.announce(params);
        }

        private NoteDynQueryEntityNode getRootEntityNode() {
            DefaultKingdeeTreeNode treeRoot = (DefaultKingdeeTreeNode)EntityTabbedUI.this._treEntities.getModel().getRoot();
            return (NoteDynQueryEntityNode)treeRoot.getUserObject();
        }

        private boolean hasSameName(String name, NoteDynQueryEntityNode rootNode) {
            if (StringUtil.equalsIgnoreCase((String)name, (String)rootNode.getEntityName())) {
                return true;
            }
            int c = rootNode.getChildrenCount();
            for (int i = 0; i < c; ++i) {
                NoteDynQueryEntityNode node = rootNode.getChild(i);
                if (!this.hasSameName(name, node)) continue;
                return true;
            }
            return false;
        }

        private String getUniqueName(String entityName) {
            NoteDynQueryEntityNode rootNode = this.getRootEntityNode();
            String number = entityName;
            int postfix = 0;
            boolean loop = true;
            while (loop) {
                loop = this.hasSameName(number, rootNode);
                if (!loop) continue;
                number = entityName + ++postfix;
            }
            return number;
        }
    }

    private class TreeHandler
    implements TreeSelectionListener {
        private TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getNewLeadSelectionPath();
            if (path == null) {
                return;
            }
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            NoteDynQueryEntityNode entityNode = (NoteDynQueryEntityNode)treeNode.getUserObject();
            NoteDynQueryEntityNode parentEntityNode = entityNode.getParent();
            boolean isCustom = !entityNode.isSystem();
            EntityTabbedUI.this._cmbParentFields.removeAllItems();
            EntityTabbedUI.this._cmbChildFields.removeAllItems();
            if (isCustom) {
                EntityTabbedUI.this._cmbParentFields.addItem((Object)"");
                EntityTabbedUI.this._cmbParentFields.addItems((Object[])parentEntityNode.getAllPropertiesForLink());
                EntityTabbedUI.this._cmbChildFields.addItem((Object)"");
                EntityTabbedUI.this._cmbChildFields.addItems((Object[])entityNode.getAllPropertiesForLink());
            }
            EntityTabbedUI.this._cmbLinkType.setSelectedItem((Object)entityNode.getLinkType());
            if (parentEntityNode != null) {
                EntityTabbedUI.this._txtParentObject.setText(parentEntityNode.getEntityName());
            } else {
                EntityTabbedUI.this._txtParentObject.setText(null);
            }
            EntityTabbedUI.this._txtSubObjectName.setText(entityNode.getEntityAlias());
            EntityTabbedUI.this._txtSubObjectNumber.setText(entityNode.getEntityName());
            EntityTabbedUI.this.clearTableContent();
            int c = entityNode.getConditionsCount();
            for (int i = 0; i < c; ++i) {
                NoteDynQueryCondition condition = entityNode.getCondition(i);
                IRow row = EntityTabbedUI.this._kdtJoinConditions.getRow(i);
                row.getCell(0).setValue((Object)condition.getLeftField());
                row.getCell(1).setValue((Object)condition.getCompareType());
                row.getCell(2).setValue((Object)condition.getRightField());
            }
            EntityTabbedUI.this._cmbLinkType.setEnabled(isCustom);
            EntityTabbedUI.this._kdtJoinConditions.setEnabled(isCustom);
        }
    }
}

